package com.arms.api.poc.model;

import lombok.*;
import java.util.Date;
import java.util.List;

@Getter
@Setter
@Builder
@ToString
@NoArgsConstructor
@AllArgsConstructor
public class PocDTO{

    private String id;
    private String c_poc_first_name;
    private String c_poc_last_name;
    private String c_poc_full_name;
    private String c_poc_company_name;
    private String c_poc_company_size;
    private String c_poc_job_title;
    private String c_poc_email_address;
    private String c_poc_country;
    private Long c_poc_country_code;
    private String c_poc_contact_number;
    private String c_poc_inquiry_reason;
    private String c_poc_inquiry_content;
    private Date c_poc_inquiry_date;
    private String c_poc_assignee_id;
    private String c_poc_assignee_username;
    private String c_poc_assignee_name;
    private String c_poc_assignee_email;
    private Long c_poc_assignee_link;
    private String c_poc_status;
    private String c_poc_status_memo;
    private Date c_poc_status_updated;
    private Boolean c_poc_marketing_consent;
    private String c_poc_etc;
    private String c_poc_desc;
    private String c_poc_contents;

    @Builder.Default
    private int size = 10;
    @Builder.Default
    private int page = 0;
    @Builder.Default
    private boolean isPaging = true;
    private List<Object> searchAfter;

    public String getFullName() {
        if (c_poc_full_name != null && !c_poc_full_name.isEmpty()) {
            return c_poc_full_name;
        }
        return c_poc_first_name + " " + c_poc_last_name;
    }

}