package com.arms.api.backoffice.information.timeoff.service;

import com.arms.api.backoffice.information.timeoff.entity.HolidayEntity;
import com.arms.api.backoffice.information.timeoff.model.dto.HolidayDTO;
import com.arms.api.backoffice.information.timeoff.model.dto.HolidayResponseDTO;
import com.arms.api.backoffice.information.timeoff.model.vo.UsersInfoVO;
import com.arms.api.report.fulldata.model.작업자_정보;
import com.arms.api.util.communicate.external.EngineService;
import com.arms.egovframework.javaservice.treeframework.TreeConstant;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.type.StandardBasicTypes;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

@Service
@Slf4j
@AllArgsConstructor
public class TimeoffServiceImpl implements TimeoffService {

    private final EngineService engineService;

    private final HolidayService holidayService;

    @Override
    public List<UsersInfoVO> getUsersInfo(){
        ResponseEntity<List<UsersInfoVO>> listResponseEntity = engineService.getUsersInfo();
        return listResponseEntity.getBody();
    }

    /*@Override
    public List<HolidayEntity> updateHolidayYearInfo(Long year) throws Exception {

        HolidayEntity searchEntity = new HolidayEntity();
        int yearInt = year.intValue();
        Criterion criterion1 =  Restrictions.sqlRestriction("YEAR(this_.c_holiday_date) = ?", yearInt, StandardBasicTypes.INTEGER);
        Criterion criterion2 =  Restrictions.isNull("c_user_id");
        Criterion criterion3 = Restrictions.and(criterion1, criterion2);

        searchEntity.getCriterions().add(criterion3);
        // 저장된 휴일 정보
        List<HolidayEntity> yearDate = holidayService.getNodesWithoutRoot(searchEntity);
        // yearApiData yearDate 비교해서 yearDate에 없는 yearApiData를 저장하고 저장한 값을 리턴 헤줌

        if (yearDate == null || yearDate.isEmpty()) { // 저장된 연간 이슈가 없으면
            List<HolidayEntity> savedData = holidayService.saveYearlyHoliday(year);
            return savedData;
        }else{
            List<HolidayResponseDTO.Response.Body.Items.Item> yearApiData = holidayService.getHolidayListByYear(year).getResponse().getBody().getItems().getItem();

            //  DB에 이미 저장된 날짜들만 추출해서 Set으로 변환
            Set<String> existingDateSet = yearDate.stream()
                    .map(entity -> new SimpleDateFormat("yyyyMMdd").format(entity.getC_holiday_date()))
                    .collect(Collectors.toSet());

            // API에서 받아온 데이터 중 DB에 없는 항목만 추출
            List<HolidayEntity> newHolidayEntities = new ArrayList<>();
            for (HolidayResponseDTO.Response.Body.Items.Item apiItem : yearApiData) {
                String locdate = apiItem.getLocdate(); // yyyyMMdd 형태

                if (!existingDateSet.contains(locdate)) {
                    Date date = new SimpleDateFormat("yyyyMMdd").parse(locdate);

                    HolidayEntity entity = new HolidayEntity();
                    entity.setC_holiday_date(date);
                    entity.setC_desc(apiItem.getDateName());
                    entity.setRef(TreeConstant.First_Node_CID);
                    entity.setC_type(TreeConstant.Leaf_Node_TYPE);

                    holidayService.addNode(entity);
                    newHolidayEntities.add(entity);
                }
            }
            return newHolidayEntities;
        }
    }

    @Override
    public List<HolidayEntity> updateHolidayMonthInfo(Long year ,Long month) throws Exception {

        List<HolidayResponseDTO.Response.Body.Items.Item> monthApiData =holidayService.getHolidayListByMonth(year, month).getResponse().getBody().getItems().getItem();

        HolidayEntity searchEntity = new HolidayEntity();

        Criterion criterion1 =  Restrictions.sqlRestriction("YEAR(this_.c_holiday_date) = ?", year.intValue(), StandardBasicTypes.INTEGER);
        Criterion criterion2 = Restrictions.sqlRestriction("MONTH(this_.c_holiday_date) = ?", month.intValue(), StandardBasicTypes.INTEGER);
        Criterion criterion3 =  Restrictions.isNull("c_user_id");
        Criterion criterion4 = Restrictions.and(criterion1, criterion2, criterion3);

        searchEntity.getCriterions().add(criterion4);
        // 저장된 월 휴일 정보
        List<HolidayEntity> monthData = holidayService.getNodesWithoutRoot(searchEntity);
        if (monthData == null || monthData.isEmpty()) { // 저장된 연간 이슈가 없으면
            List<HolidayEntity> savedData = holidayService.saveMonthlyHoliday(year, month);
            return savedData;
        }else{
            // monthApiData monthData 비교해서 monthData에 없는 monthApiData를 저장하고 저장한 값을 리턴 헤줌
            Set<String> existingDateSet = monthData.stream()
                    .map(entity -> new SimpleDateFormat("yyyyMMdd").format(entity.getC_holiday_date()))
                    .collect(Collectors.toSet());

            List<HolidayEntity> newHolidayEntities = new ArrayList<>();
            for (HolidayResponseDTO.Response.Body.Items.Item apiItem : monthApiData) {
                String locdate = apiItem.getLocdate(); // yyyyMMdd 형태

                if (!existingDateSet.contains(locdate)) {
                    Date date = new SimpleDateFormat("yyyyMMdd").parse(locdate);

                    HolidayEntity entity = new HolidayEntity();
                    entity.setC_holiday_date(date);
                    entity.setC_desc(apiItem.getDateName());
                    entity.setRef(TreeConstant.First_Node_CID);
                    entity.setC_type(TreeConstant.Leaf_Node_TYPE);

                    holidayService.addNode(entity);
                    newHolidayEntities.add(entity);
                }
            }
            return newHolidayEntities;
        }
    }*/
}
