package com.arms.api.backoffice.information.timeoff.service;

import com.arms.api.backoffice.information.timeoff.model.dto.HolidayResponseDTO;
import com.arms.api.backoffice.information.timeoff.entity.HolidayEntity;
import com.arms.egovframework.javaservice.treeframework.TreeConstant;
import com.arms.egovframework.javaservice.treeframework.service.TreeServiceImpl;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.text.SimpleDateFormat;
import java.util.*;

@Slf4j
@AllArgsConstructor
@Service("holidayService")
public class HolidayServiceImpl extends TreeServiceImpl implements HolidayService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());


    /*@Override
    @Transactional
    public List<HolidayEntity> saveYearlyHoliday(Long year) throws Exception {
        logger.info("[HolidayServiceImpl::saveYearlyHoliday] 현재 연도: {}", year);
        // 공공 API 호출 1년 휴일 정보 가져오기
        HolidayResponseDTO holidayResponseDTO = getHolidayListByYear( year);
        if (holidayResponseDTO == null || holidayResponseDTO.getResponse() == null ||
                holidayResponseDTO.getResponse().getBody() == null ||
                holidayResponseDTO.getResponse().getBody().getItems() == null) {
            return Collections.emptyList();
        }
        // 휴일 데이터 저장
        List<HolidayResponseDTO.Response.Body.Items.Item> holidayList =
                holidayResponseDTO.getResponse().getBody().getItems().getItem();
        if (holidayList == null || holidayList.isEmpty()) {
            return Collections.emptyList();
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        List<HolidayEntity> savedHolidays = new ArrayList<>();
        for (HolidayResponseDTO.Response.Body.Items.Item item : holidayList) {
            try {
                Date date = sdf.parse(item.getLocdate());

                HolidayEntity holidayEntity = new HolidayEntity();
                holidayEntity.setC_holiday_date(date);
                holidayEntity.setC_desc(item.getDateName());

                holidayEntity.setRef(TreeConstant.First_Node_CID);
                holidayEntity.setC_type(TreeConstant.Leaf_Node_TYPE);

                HolidayEntity savedNode = this.addNode(holidayEntity);

                savedHolidays.add(savedNode);

            } catch (Exception e) {
                logger.error("[HolidayServiceImpl::saveYearlyHoliday] 휴일 저장 실패 - item: {}", item, e);
                throw new RuntimeException("휴일 저장 중 예외 발생", e);
            }
        }

        return savedHolidays;
    }

    @Override
    @Transactional
    public List<HolidayEntity> saveMonthlyHoliday(Long year, Long month) throws Exception {
        // 공공 API 호출 해당 년 월 휴일 정보 가져오기
        logger.info("[HolidayServiceImpl::saveMonthlyHoliday] 현재 연도: {}, 현재 월: {}", year, month);
        // 공공 API 호출
        HolidayResponseDTO holidayResponseDTO = getHolidayListByMonth(year, month);
        if (holidayResponseDTO == null || holidayResponseDTO.getResponse() == null ||
                holidayResponseDTO.getResponse().getBody() == null ||
                holidayResponseDTO.getResponse().getBody().getItems() == null) {
            logger.warn("[HolidayServiceImpl::saveMonthlyHoliday] 휴일 정보가 비어 있음 - 연도: {}, 월: {}", year, month);
            return Collections.emptyList();
        }

        // 공공 API에서 가져온 휴일 목록
        List<HolidayResponseDTO.Response.Body.Items.Item> holidayList =
                holidayResponseDTO.getResponse().getBody().getItems().getItem();

        if (holidayList == null || holidayList.isEmpty()) {
            logger.warn("[HolidayServiceImpl::saveMonthlyHoliday] 해당 월의 휴일이 존재하지 않습니다.");
            return Collections.emptyList();
        }

        List<HolidayEntity> savedHolidays = new ArrayList<>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        for (HolidayResponseDTO.Response.Body.Items.Item item : holidayList) {
            try {
                Date date = sdf.parse(item.getLocdate());

                HolidayEntity holidayEntity = new HolidayEntity();
                holidayEntity.setC_holiday_date(date);
                holidayEntity.setC_desc(item.getDateName());
                holidayEntity.setRef(TreeConstant.First_Node_CID);
                holidayEntity.setC_type(TreeConstant.Leaf_Node_TYPE);

                HolidayEntity savedNode = this.addNode(holidayEntity);
                savedHolidays.add(savedNode);

            } catch (Exception e) {
                logger.error("[HolidayServiceImpl::saveMonthlyHoliday] 휴일 저장 실패 - item: {}", item, e);
                throw new RuntimeException("월간 휴일 저장 중 예외 발생", e);
            }
        }
        return savedHolidays;
    }*/

}