/*
 * Decompiled with CFR 0.152.
 */
package com.arms.egovframework.javaservice.treeframework.util;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class StringUtils
extends org.apache.commons.lang.StringUtils {
    private static final Logger log = LoggerFactory.getLogger(StringUtils.class);

    public static String removeHtmlTags(String value) {
        String rtnVal = StringEscapeUtils.unescapeHtml4((String)value);
        rtnVal = rtnVal.replaceAll("<[^>]*>", "");
        rtnVal = StringEscapeUtils.escapeHtml4((String)rtnVal);
        return rtnVal;
    }

    public static String getString(String text) {
        if (null == text) {
            return "";
        }
        return text;
    }

    public static String getString(Date text) {
        if (null == text) {
            return "";
        }
        return text.toString();
    }

    public static boolean getBoolean(String text) {
        return StringUtils.equalsIgnoreCase((String)text, (String)"true") || StringUtils.equalsIgnoreCase((String)text, (String)"1");
    }

    public static String getString(int value) {
        return Integer.valueOf(value).toString();
    }

    public static String getString(long value) {
        return Long.valueOf(value).toString();
    }

    public static String getString(boolean flag) {
        if (flag) {
            return "1";
        }
        return "0";
    }

    public static String makeIpv4Cidr(String ip) {
        if (!StringUtils.contains((String)ip, (String)"/")) {
            return ip + "/32";
        }
        return ip;
    }

    public static String[] makeIpv4(String ipMask) {
        if (!StringUtils.contains((String)ipMask, (String)"/")) {
            String[] ips = new String[]{ipMask, "32"};
            return ips;
        }
        return StringUtils.split((String)ipMask, (String)"/");
    }

    public static String[] getTypeForIp(String value) {
        String[] temp;
        String type = "0";
        String mask = "32";
        String ip = value;
        if (StringUtils.contains((String)value, (String)"-")) {
            type = "2";
            temp = StringUtils.split((String)value, (String)"/");
            ip = temp[0];
        } else if (StringUtils.contains((String)value, (String)"/")) {
            type = "1";
            temp = StringUtils.split((String)value, (String)"/");
            ip = temp[0];
            mask = temp[1];
            if (StringUtils.equals((String)mask, (String)"32")) {
                type = "0";
            }
        }
        String[] result = new String[]{ip, type, mask};
        return result;
    }

    public static List<List<String>> diffMembers(List<String> oldMember, List<String> newMember) {
        return StringUtils.diffMembers((String[])oldMember.toArray(new String[oldMember.size()]), (String[])newMember.toArray(new String[newMember.size()]));
    }

    public static List<List<String>> diffMembersLong(List<Long> oldMember, List<Long> newMember) {
        ArrayList<String> newMembers = new ArrayList<String>();
        ArrayList<String> oldMembers = new ArrayList<String>();
        for (Long tempLong : oldMember) {
            oldMembers.add(StringUtils.getString((long)tempLong));
        }
        for (Long tempLong : newMember) {
            newMembers.add(StringUtils.getString((long)tempLong));
        }
        return StringUtils.diffMembers(oldMembers, newMembers);
    }

    public static List<List<String>> diffMembers(String[] oldMember, String[] newMember) {
        LinkedHashMap<String, Integer> oldMap = new LinkedHashMap<String, Integer>();
        ArrayList<String> newMembers = new ArrayList<String>();
        if (null != oldMember) {
            for (String string : oldMember) {
                oldMap.put(string, 0);
            }
        }
        if (null != newMember && newMember.length > 0) {
            for (String string : newMember) {
                if (oldMap.containsKey(string)) {
                    oldMap.put(string, 1);
                    continue;
                }
                newMembers.add(string);
            }
        }
        ArrayList<String> updateMembers = new ArrayList<String>();
        ArrayList<String> deleteMembers = new ArrayList<String>();
        for (Map.Entry entry : oldMap.entrySet()) {
            if ((Integer)entry.getValue() > 0) {
                updateMembers.add((String)entry.getKey());
                continue;
            }
            deleteMembers.add((String)entry.getKey());
        }
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        result.add(deleteMembers);
        result.add(newMembers);
        result.add(updateMembers);
        return result;
    }

    public static String removeMember(String members, String removeMember) {
        String members2 = ";" + members + ";";
        String result = StringUtils.replace((String)members2, (String)(removeMember + ";"), (String)"");
        return StringUtils.substring((String)result, (int)1, (int)(result.length() - 1));
    }

    public static String getFullURL(HttpServletRequest request) {
        String requestURL = request.getRequestURI();
        String queryString = request.getQueryString();
        if (queryString == null) {
            return requestURL.toString();
        }
        return requestURL + "?" + queryString;
    }

    public static String changeApplyIcon(String applyFlag) {
        if (StringUtils.equals((String)applyFlag, (String)"1")) {
            return "<img src=\"/files/image/icon/apply.png\" class=\"imgTop\" />";
        }
        return "";
    }

    public static String substringBeforeLastByte(String str, String encoding, int cutByte) throws UnsupportedEncodingException {
        int subStrByte = str.getBytes(encoding).length - cutByte;
        if (subStrByte <= 0) {
            return "";
        }
        String temp = str;
        while (subStrByte < temp.getBytes(encoding).length) {
            temp = StringUtils.substring((String)temp, (int)0, (int)(temp.length() - 1));
        }
        return temp;
    }

    public static String[] splitStringByNewLineOrTab(String str) {
        return str.split("(\r\n)|\r|\n|\t");
    }

    public static String nvl(String str, String defaultStr) {
        return str == null ? defaultStr : str;
    }

    public static String[] nvl(String[] input) {
        if (input == null) {
            return new String[0];
        }
        return input;
    }

    public static String enterToBr(String str) {
        return (str = StringUtils.replaceString((String)str)) == null ? "" : str.replaceAll("\n", " <br/>");
    }

    public static String enterToNull(String str) {
        return str == null ? "" : str.replaceAll("\n", "");
    }

    public static String decode(String msg, String type) throws UnsupportedEncodingException {
        return URLDecoder.decode(msg, type);
    }

    public static String toString(int value) {
        try {
            return "" + value;
        }
        catch (Exception e) {
            return "";
        }
    }

    public static int toInt(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static long toLong(String value) {
        try {
            return Long.parseLong(value);
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public static String lpad(int value, int length, String prefix) {
        try {
            StringBuilder sb = new StringBuilder();
            String castValue = "" + value;
            for (int i = castValue.length(); i < length; ++i) {
                sb.append(prefix);
            }
            sb.append(castValue);
            return sb.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String rpad(int value, int length, String prefix) {
        try {
            StringBuilder sb = new StringBuilder();
            String castValue = "" + value;
            sb.append(castValue);
            for (int i = castValue.length(); i < length; ++i) {
                sb.append(prefix);
            }
            return sb.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String cutText(String text, int length, String suffix) {
        StringBuffer sb = new StringBuffer();
        if (!text.isEmpty()) {
            if (text.length() > length) {
                sb.append(text.substring(0, length)).append(suffix);
            } else {
                sb.append(text);
            }
        } else {
            sb.append(text);
        }
        return sb.toString();
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static String replaceText(String text, String originTxt, String replaceTxt) {
        return text.replaceAll(originTxt, replaceTxt);
    }

    public static String replaceBrTag(String text) {
        return text.replaceAll("\\n", "<br/>");
    }

    public static String getDatasOfMap(Map map) {
        StringBuffer buf = new StringBuffer();
        buf.append("getDatasOfMap() =>");
        Set set = map.keySet();
        for (String name : set) {
            String value = (String)map.get(name);
            buf.append("[").append(name).append("|").append(value).append("]");
        }
        return buf.toString();
    }

    public static boolean isNullCheck(String str) {
        boolean bool = false;
        if (str != null && !"".equals(str)) {
            bool = true;
        }
        return bool;
    }

    public static String addComma(long data) {
        return new DecimalFormat("#,###").format(data);
    }

    public static String getSource(String uri) {
        String str = null;
        try {
            URL url = new URL(uri);
            URLConnection uc = url.openConnection();
            InputStream in = uc.getInputStream();
            int len = uc.getContentLength();
            byte[] buf = new byte[len];
            in.read(buf, 0, buf.length);
            str = new String(buf);
        }
        catch (Exception e) {
            log.info("StringUtils :: getSource :: Exception -> " + e.getMessage());
        }
        return str;
    }

    public static boolean chkLength(int min, int max, String str) {
        int len = str.length();
        return len < min || len > max;
    }

    public static boolean chkRpt(String str, int cmpCnt) {
        ByteBuffer bf = ByteBuffer.wrap(str.getBytes());
        int rptCnt = 1;
        byte curr = bf.get();
        boolean flag = false;
        int last = bf.capacity();
        for (int i = bf.position(); i < last; ++i) {
            byte tmp = bf.get();
            rptCnt = curr == tmp ? ++rptCnt : 1;
            curr = tmp;
            flag = rptCnt == cmpCnt;
            if (flag) break;
        }
        return flag;
    }

    public static String stringByteCut(String raw, int len, String encoding, String prefix) {
        if (raw == null) {
            return null;
        }
        String[] ary = null;
        Object result = null;
        try {
            int hangul_byte_num;
            byte[] rawBytes = raw.getBytes(encoding);
            int rawLength = rawBytes.length;
            int index = 0;
            int minus_byte_num = 0;
            int offset = 0;
            int n = hangul_byte_num = encoding.equals("UTF-8") ? 3 : 2;
            if (rawLength > len) {
                int aryLength = rawLength / len + (rawLength % len != 0 ? 1 : 0);
                ary = new String[aryLength];
                for (int i = 0; i < aryLength; ++i) {
                    minus_byte_num = 0;
                    offset = len;
                    if (index + offset > rawBytes.length) {
                        offset = rawBytes.length - index;
                    }
                    for (int j = 0; j < offset; ++j) {
                        if ((rawBytes[index + j] & 0x80) == 0) continue;
                        ++minus_byte_num;
                    }
                    if (minus_byte_num % hangul_byte_num != 0) {
                        offset -= minus_byte_num % hangul_byte_num;
                    }
                    ary[i] = new String(rawBytes, index, offset, encoding);
                    index += offset;
                }
                result = ary[0] + prefix;
            } else {
                result = raw;
            }
        }
        catch (Exception e) {
            log.info("StringUtils :: stringByteCut :: Exception -> " + e.getMessage());
        }
        return result;
    }

    public static Boolean regex(String regex, String str) {
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(str);
        return m.find();
    }

    public static boolean NumberChk(String str) {
        str = str.trim();
        int c = 32;
        if (str.length() == 0) {
            return false;
        }
        int loopCnt = str.length();
        for (int i = 0; i < loopCnt; ++i) {
            c = str.charAt(i);
            if (c >= 48 && c <= 57) continue;
            return false;
        }
        return true;
    }

    public static String replaceString(String str) {
        String returnValue = "";
        if (str == null) {
            returnValue = "";
        } else {
            str = str.replaceAll("&", "&amp;");
            str = str.replaceAll("<", "&lt;");
            str = str.replaceAll(">", "&gt;");
            str = str.replaceAll("'", "&apos;");
            returnValue = str = str.replaceAll("\"", "&quot;");
        }
        return returnValue;
    }

    public static boolean adminYn(String str) {
        return Pattern.matches("^[\uac00-\ud7a3]*$", str);
    }

    public static String getClientIp(HttpServletRequest request) {
        String clientIp = StringUtils.nvl((String)request.getHeader("X-Forwarded-For"), (String)"");
        if (clientIp == null || clientIp.length() == 0) {
            clientIp = StringUtils.nvl((String)request.getHeader("WL-Proxy-Client-IP"), (String)"");
        }
        if (clientIp == null || clientIp.length() == 0) {
            clientIp = StringUtils.nvl((String)request.getHeader("Proxy-Client-IP"), (String)"");
        }
        if (clientIp == null || clientIp.length() == 0) {
            clientIp = request.getRemoteAddr();
        }
        return clientIp.trim();
    }

    public static String commaStr(Long num) {
        String commaNum = NumberFormat.getInstance(Locale.US).format(num);
        return commaNum;
    }

    public static String commaStr(int num) {
        String commaNum = NumberFormat.getInstance(Locale.US).format(num);
        return commaNum;
    }

    public static String nullTrim(String str) {
        str = str == null ? "" : str.trim();
        return str;
    }

    public static String[] jsonStringifyConvert(String versionInfo) {
        versionInfo = StringUtils.remove((String)versionInfo, (String)"\"");
        versionInfo = StringUtils.remove((String)versionInfo, (String)"]");
        versionInfo = StringUtils.remove((String)versionInfo, (String)"[");
        return StringUtils.split((String)versionInfo, (String)",");
    }

    public static String removeTrailingSlash(String uri) {
        if (uri == null) {
            return null;
        }
        return uri.endsWith("/") ? uri.substring(0, uri.length() - 1) : uri;
    }
}

