/*
 * Decompiled with CFR 0.152.
 */
package com.arms.egovframework.javaservice.treeframework.util;

import com.arms.egovframework.javaservice.treeframework.util.DateUtils;
import com.arms.egovframework.javaservice.treeframework.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.ServletRequest;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParameterParser {
    private ServletRequest req;
    public Logger logger = LoggerFactory.getLogger(this.getClass());

    public ParameterParser(ServletRequest req) {
        this.req = req;
    }

    public String get(String name) {
        String value = this.req.getParameter(name);
        if (null != value && 0 == value.length()) {
            return null;
        }
        return StringUtils.trim((String)value);
    }

    public String get(String name, String def) {
        String value = this.get(name);
        if (null == value) {
            return def;
        }
        return StringUtils.trim((String)value);
    }

    public boolean getBoolean(String name) {
        String value = this.get(name);
        if (null == value || 0 == value.length()) {
            return false;
        }
        if ((value = value.toLowerCase()).equalsIgnoreCase("true") || value.equalsIgnoreCase("on") || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("1")) {
            return true;
        }
        if (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("off") || value.equalsIgnoreCase("no") || value.equalsIgnoreCase("0")) {
            return false;
        }
        return false;
    }

    public boolean getBoolean(String name, boolean def) {
        String value = this.get(name);
        if (null == value || 0 == value.length()) {
            return def;
        }
        if ((value = value.toLowerCase()).equalsIgnoreCase("true") || value.equalsIgnoreCase("on") || value.equalsIgnoreCase("yes")) {
            return true;
        }
        if (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("off") || value.equalsIgnoreCase("no")) {
            return false;
        }
        return def;
    }

    public int getInt(String name) {
        String value = this.get(name);
        if (null == value || 0 == value.length()) {
            return 0;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public int getInt(String name, int def) {
        String value = this.get(name);
        if (null == value || 0 == value.length()) {
            return def;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            return def;
        }
    }

    public int getCurrency(String name) {
        return this.getCurrency(name, 0);
    }

    public int getCurrency(String name, int def) {
        String value = this.get(name);
        if (null == value) {
            return def;
        }
        int length = value.length();
        char c = '\u0000';
        StringBuffer sbf = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            c = value.charAt(i);
            if ('-' == c || '0' <= c && c <= '9') {
                sbf.append(c);
                continue;
            }
            if (',' == c) continue;
            return def;
        }
        try {
            return Integer.parseInt(sbf.toString());
        }
        catch (Exception e) {
            return def;
        }
    }

    public long getLong(String name) {
        String value = this.get(name);
        if (null == value || 0 == value.length()) {
            return 0L;
        }
        try {
            return Long.parseLong(value);
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public long getKey() {
        String key = this.req.getParameter("key");
        return new Long(key);
    }

    public List<Long> getKeyLong() {
        ArrayList<Long> keys = new ArrayList<Long>();
        String key = this.req.getParameter("key");
        if (!StringUtils.isEmpty((String)key)) {
            keys.add(new Long(key));
        } else {
            String key2;
            for (int i = 0; i < 1000 && !StringUtils.isEmpty((String)(key2 = this.req.getParameter("key[" + i + "]"))); ++i) {
                keys.add(new Long(key2));
            }
        }
        return keys;
    }

    public List<Long> getKeyLong(String keyName) {
        ArrayList<Long> keys = new ArrayList<Long>();
        String key = this.req.getParameter(keyName);
        if (!StringUtils.isEmpty((String)key)) {
            keys.add(new Long(key));
        } else {
            String key2;
            for (int i = 0; i < 1000 && !StringUtils.isEmpty((String)(key2 = this.req.getParameter(keyName + "[" + i + "]"))); ++i) {
                keys.add(new Long(key2));
            }
        }
        return keys;
    }

    public List<Long> getNameLong() {
        ArrayList<Long> keys = new ArrayList<Long>();
        String key = this.req.getParameter("name");
        if (!StringUtils.isEmpty((String)key)) {
            if (StringUtils.contains((String)key, (String)";")) {
                String[] temp;
                for (String string : temp = StringUtils.split((String)key, (String)";")) {
                    keys.add(new Long(string));
                }
            } else {
                keys.add(new Long(key));
            }
        } else {
            String key2;
            for (int i = 0; i < 1000 && !StringUtils.isEmpty((String)(key2 = this.req.getParameter("name[" + i + "]"))); ++i) {
                if (StringUtils.contains((String)key2, (String)";")) {
                    String[] temp;
                    for (String string : temp = StringUtils.split((String)key2, (String)";")) {
                        keys.add(new Long(string));
                    }
                    continue;
                }
                keys.add(new Long(key2));
            }
        }
        return keys;
    }

    public List<String> getKeyString() {
        return this.getKeyString("key");
    }

    public List<String> getKeyString(String keyName) {
        ArrayList<String> keys = new ArrayList<String>();
        String key = this.req.getParameter(keyName);
        if (!StringUtils.isEmpty((String)key)) {
            keys.add(new String(key));
        } else {
            String key2;
            for (int i = 0; i < 1000 && !StringUtils.isEmpty((String)(key2 = this.req.getParameter(keyName + "[" + i + "]"))); ++i) {
                keys.add(new String(key2));
            }
        }
        return keys;
    }

    public boolean isModify() {
        String mode = this.req.getParameter("mode");
        return StringUtils.equalsIgnoreCase((String)mode, (String)"edit");
    }

    public long getLong(String name, long def) {
        String value = this.get(name);
        if (null == value || 0 == value.length()) {
            return def;
        }
        try {
            return Long.parseLong(value);
        }
        catch (Exception e) {
            return def;
        }
    }

    public Date getDate(String name) {
        return this.getDate(name, new Date());
    }

    public Date getEndDate(String name) {
        return DateUtils.addDays((Date)this.getDate(name, new Date()), (int)1);
    }

    public Date getDate(String name, Date def) {
        String temp = this.get(name);
        if (null == temp) {
            return def;
        }
        try {
            return DateUtils.getDateFormat((String)"yyyy-MM-dd").parse(temp);
        }
        catch (Exception e) {
            return def;
        }
    }

    public Date getDateTime(String name) {
        return this.getDateTime(name, new Date());
    }

    public Date getDateTime(String name, Date def) {
        String temp = this.get(name);
        if (null == temp) {
            return def;
        }
        try {
            return DateUtils.getDateFormat((String)"yyyy-MM-dd'T'HH:mm:ss.SSS").parse(temp);
        }
        catch (Exception e) {
            return def;
        }
    }

    public Date getDateSearchDate(int addHour) {
        String date1 = this.get("startDate1");
        if (StringUtils.isEmpty((String)date1)) {
            return org.apache.commons.lang.time.DateUtils.addMonths((Date)new Date(), (int)addHour);
        }
        String date = date1 + " 00:00:00";
        return DateUtils.getDate((String)date);
    }

    public Date getDateStart(int day) {
        String date1 = this.get("startDate1");
        if (StringUtils.isEmpty((String)date1)) {
            Date temp = org.apache.commons.lang.time.DateUtils.addDays((Date)new Date(), (int)day);
            date1 = DateUtils.getDateFormat((String)"yyyy-MM-dd").format(temp);
        }
        String date = date1 + " 00:00:00";
        return DateUtils.getDate((String)date);
    }

    public Date getDateEnd() {
        String date1 = this.get("endDate1");
        if (StringUtils.isEmpty((String)date1)) {
            date1 = DateUtils.getDateFormat((String)"yyyy-MM-dd").format(new Date());
        }
        String date = date1 + " 23:59:59.999";
        return DateUtils.getDate((String)date, (String)"yyyy-MM-dd HH:mm:ss.SSS");
    }

    public Date getDateStartDate(int addHour) {
        String date1 = this.get("startDate1");
        String date2 = this.get("startDate2");
        if (StringUtils.isEmpty((String)date1) || StringUtils.isEmpty((String)date2)) {
            return org.apache.commons.lang.time.DateUtils.addHours((Date)new Date(), (int)addHour);
        }
        String date = date1 + " " + date2;
        return DateUtils.getDate((String)date);
    }

    public Date getDateStartDateMonth(int addMonth) {
        String date1 = this.get("startDate1");
        String date2 = this.get("startDate2");
        if (StringUtils.isEmpty((String)date1) || StringUtils.isEmpty((String)date2)) {
            return org.apache.commons.lang.time.DateUtils.addMonths((Date)new Date(), (int)addMonth);
        }
        String date = date1 + " " + date2;
        return DateUtils.getDate((String)date);
    }

    public Date getDateEndDate() {
        String date1 = this.get("endDate1");
        String date2 = this.get("endDate2");
        if (StringUtils.isEmpty((String)date1) || StringUtils.isEmpty((String)date2)) {
            return new Date();
        }
        String date = date1 + " " + date2;
        return DateUtils.getDate((String)date);
    }

    public Date getDateHour(String name) {
        return this.getDateHour(name, new Date());
    }

    public Date getDateHour(String name, Date def) {
        String temp = this.get(name);
        if (null == temp) {
            return def;
        }
        try {
            return DateUtils.getDateFormat((String)"yyyy-MM-dd HH:mm").parse(temp);
        }
        catch (Exception e) {
            return def;
        }
    }

    public String[] getArray(String name) {
        ArrayList<String> list = new ArrayList<String>();
        String[] tempArray = this.req.getParameterValues(name);
        if (null == tempArray) {
            return null;
        }
        for (int i = 0; i < tempArray.length; ++i) {
            if (null == tempArray[i] || 0 == tempArray[i].length()) continue;
            list.add(tempArray[i]);
        }
        String[] returnArray = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            returnArray[i] = (String)list.get(i);
        }
        return returnArray;
    }

    public String getArrayString(String name, String separator) {
        Object[] temp = this.getArray(name);
        if (null == temp) {
            return "";
        }
        return StringUtils.join((Object[])temp, (String)separator);
    }

    public String getArraySum(String name) {
        int[] temp = this.getIntArray(name);
        if (null == temp || temp.length == 0) {
            return "0";
        }
        int sum = 0;
        for (int i : temp) {
            sum += i;
        }
        return String.valueOf(sum);
    }

    public int[] getIntArray(String name) {
        String[] tempArray = this.req.getParameterValues(name);
        if (null == tempArray) {
            return null;
        }
        int len = tempArray.length;
        int[] result = new int[len];
        int temp = 0;
        for (int i = 0; i < len; ++i) {
            try {
                temp = Integer.parseInt(tempArray[i]);
            }
            catch (Exception e) {
                temp = 0;
            }
            result[i] = temp;
        }
        return result;
    }

    public long[] getLongArray(String name) {
        String[] tempArray = this.req.getParameterValues(name);
        if (null == tempArray) {
            return null;
        }
        int len = tempArray.length;
        long[] result = new long[len];
        long temp = 0L;
        for (int i = 0; i < len; ++i) {
            try {
                temp = Long.parseLong(tempArray[i]);
            }
            catch (Exception e) {
                temp = 0L;
            }
            result[i] = temp;
        }
        return result;
    }

    public List<Long> getListLongArray(String name) {
        String[] tempArray = this.req.getParameterValues(name);
        if (null == tempArray) {
            return new ArrayList<Long>();
        }
        ArrayList<Long> list = new ArrayList<Long>();
        for (String id : tempArray) {
            list.add(Long.parseLong(id));
        }
        return list;
    }

    public List<Long> getStringForDelimeterLong(String name, String delimeter) {
        String[] temp2;
        ArrayList<Long> list = new ArrayList<Long>();
        String temp = this.get(name);
        if (StringUtils.isEmpty((String)temp)) {
            return list;
        }
        for (String value : temp2 = StringUtils.split((String)temp, (String)delimeter)) {
            if (StringUtils.isEmpty((String)value) || !NumberUtils.isDigits((String)value)) continue;
            list.add(NumberUtils.toLong((String)value));
        }
        return list;
    }

    public String toString() {
        StringBuffer sbf = new StringBuffer();
        sbf.append('{');
        Enumeration en = this.req.getParameterNames();
        String name = null;
        String[] value = null;
        int i = 0;
        while (en.hasMoreElements()) {
            name = (String)en.nextElement();
            sbf.append("name= ");
            value = this.req.getParameterValues(name);
            if (null == value || 0 == value.length) {
                sbf.append(';');
                continue;
            }
            if (1 == value.length) {
                sbf.append(value);
            } else {
                sbf.append('[');
                sbf.append(value[0]);
                for (i = 1; i < value.length; ++i) {
                    sbf.append(",");
                    sbf.append(value[i]);
                }
                sbf.append(']');
            }
            sbf.append(';');
        }
        sbf.append('}');
        return sbf.toString();
    }

    public String paramDebug() {
        StringBuffer sbf = new StringBuffer();
        sbf.append('{');
        Enumeration en = this.req.getParameterNames();
        String name = null;
        String[] value = null;
        int i = 0;
        while (en.hasMoreElements()) {
            name = (String)en.nextElement();
            sbf.append(name).append(" : ");
            value = this.req.getParameterValues(name);
            if (null == value || 0 == value.length) {
                sbf.append(';');
                continue;
            }
            if (1 == value.length) {
                sbf.append(value[0]);
            } else {
                sbf.append('[');
                sbf.append(value[0]);
                for (i = 1; i < value.length; ++i) {
                    sbf.append(",");
                    sbf.append(value[i]);
                }
                sbf.append(']');
            }
            sbf.append(';');
        }
        sbf.append('}');
        return sbf.toString();
    }
}

