/*
 * Decompiled with CFR 0.152.
 */
package com.arms.egovframework.javaservice.treeframework.util;

import com.arms.egovframework.javaservice.treeframework.util.EgovFormBasedFileVo;
import com.arms.egovframework.javaservice.treeframework.util.EgovFormBasedUUID;
import com.arms.egovframework.javaservice.treeframework.util.EgovResourceCloseHelper;
import com.arms.egovframework.javaservice.treeframework.util.EgovWebUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.mail.internet.MimeUtility;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.Streams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class EgovFormBasedFileUtil {
    public static final int BUFFER_SIZE = 20480;
    public static final String SEPERATOR = File.separator;
    private static final Logger LOGGER = LoggerFactory.getLogger(EgovFormBasedFileUtil.class);

    public static String getTodayString() {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd", Locale.getDefault());
        return format.format(new Date());
    }

    public static String getPhysicalFileName() {
        return EgovFormBasedUUID.randomUUID().toString().replaceAll("-", "").toUpperCase();
    }

    protected static String convert(String filename) throws Exception {
        return MimeUtility.encodeText((String)filename, (String)"utf-8", (String)"B");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long saveFile(InputStream is, File file) throws IOException {
        if (!file.getParentFile().exists()) {
            if (file.getParentFile().mkdirs()) {
                LOGGER.debug("[file.mkdirs] file : Directory Creation Success");
            } else {
                LOGGER.error("[file.mkdirs] file : Directory Creation Fail");
            }
        }
        FileOutputStream os = null;
        long size = 0L;
        try {
            os = new FileOutputStream(file);
            int bytesRead = 0;
            byte[] buffer = new byte[20480];
            while ((bytesRead = is.read(buffer, 0, 20480)) != -1) {
                size += (long)bytesRead;
                ((OutputStream)os).write(buffer, 0, bytesRead);
            }
        }
        catch (Throwable throwable) {
            EgovResourceCloseHelper.close((Closeable[])new Closeable[]{os});
            throw throwable;
        }
        EgovResourceCloseHelper.close((Closeable[])new Closeable[]{os});
        return size;
    }

    public static List<EgovFormBasedFileVo> uploadFiles(HttpServletRequest request, String where, long maxFileSize) throws Exception {
        ArrayList<EgovFormBasedFileVo> list = new ArrayList<EgovFormBasedFileVo>();
        boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
        if (isMultipart) {
            ServletFileUpload upload = new ServletFileUpload();
            upload.setFileSizeMax(maxFileSize);
            FileItemIterator iter = upload.getItemIterator(request);
            while (iter.hasNext()) {
                FileItemStream item = iter.next();
                String name = item.getFieldName();
                try {
                    InputStream stream = item.openStream();
                    try {
                        if (item.isFormField()) {
                            LOGGER.info("Form field '{}' with value '{}' detected.", (Object)name, (Object)Streams.asString((InputStream)stream));
                            continue;
                        }
                        LOGGER.info("File field '{}' with file name '{}' detected.", (Object)name, (Object)item.getName());
                        if ("".equals(item.getName())) continue;
                        EgovFormBasedFileVo vo = new EgovFormBasedFileVo();
                        String tmp = item.getName();
                        if (tmp.lastIndexOf("\\") >= 0) {
                            tmp = tmp.substring(tmp.lastIndexOf("\\") + 1);
                        }
                        vo.setFileName(tmp);
                        vo.setContentType(item.getContentType());
                        vo.setServerSubPath(EgovFormBasedFileUtil.getTodayString());
                        vo.setPhysicalName(EgovFormBasedFileUtil.getPhysicalFileName());
                        if (tmp.lastIndexOf(".") >= 0) {
                            vo.setPhysicalName(vo.getPhysicalName() + tmp.substring(tmp.lastIndexOf(".")));
                        }
                        long size = EgovFormBasedFileUtil.saveFile((InputStream)stream, (File)new File(EgovWebUtil.filePathBlackList((String)where) + SEPERATOR + vo.getServerSubPath() + SEPERATOR + vo.getPhysicalName()));
                        vo.setSize(size);
                        list.add(vo);
                    }
                    finally {
                        if (stream == null) continue;
                        stream.close();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("EgovFormBasedFileUtil :: uploadFiles :: InputStream IOException");
                }
            }
            return list;
        }
        throw new IOException("form's 'enctype' attribute have to be 'multipart/form-data'");
    }

    public static void downloadFile(HttpServletResponse response, String where, String serverSubPath, String physicalName, String original) throws Exception {
        String contentType = "application/octet-stream";
        EgovFormBasedFileUtil.downloadFile((HttpServletResponse)response, (String)where, (String)serverSubPath, (String)physicalName, (String)contentType, (String)original);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void downloadFile(HttpServletResponse response, String where, String serverSubPath, String physicalName, String contentType, String original) throws Exception {
        BufferedOutputStream outs;
        BufferedInputStream fin;
        block8: {
            String downFileName = where + SEPERATOR + serverSubPath + SEPERATOR + physicalName;
            File file = new File(EgovWebUtil.filePathBlackList((String)downFileName));
            if (!file.exists()) {
                throw new FileNotFoundException(downFileName);
            }
            if (!file.isFile()) {
                throw new FileNotFoundException(downFileName);
            }
            byte[] b = new byte[20480];
            original = original.replaceAll("\r", "").replaceAll("\n", "");
            response.setContentType(contentType);
            response.setHeader("Content-Disposition", "attachment; filename=\"" + EgovFormBasedFileUtil.convert((String)original) + "\";");
            response.setHeader("Content-Transfer-Encoding", "binary");
            response.setHeader("Pragma", "no-cache");
            response.setHeader("Expires", "0");
            fin = null;
            outs = null;
            try {
                int read;
                fin = new BufferedInputStream(new FileInputStream(file));
                outs = new BufferedOutputStream((OutputStream)response.getOutputStream());
                boolean var11 = false;
                while ((read = fin.read(b)) != -1) {
                    outs.write(b, 0, read);
                }
                if (fin == null) break block8;
            }
            catch (IOException e) {
                try {
                    throw new IOException("EgovFormBasedFileUtil :: viewFile : IOException " + String.valueOf(e));
                }
                catch (Throwable throwable) {
                    if (fin != null) {
                        fin.close();
                    }
                    EgovResourceCloseHelper.close((Closeable[])new Closeable[]{outs, fin});
                    throw throwable;
                }
            }
            fin.close();
        }
        EgovResourceCloseHelper.close((Closeable[])new Closeable[]{outs, fin});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void viewFile(HttpServletResponse response, String where, String serverSubPath, String physicalName, String mimeTypeParam) throws Exception {
        BufferedOutputStream outs;
        BufferedInputStream fin;
        block9: {
            String mimeType = mimeTypeParam;
            String downFileName = where + SEPERATOR + serverSubPath + SEPERATOR + physicalName;
            File file = new File(EgovWebUtil.filePathBlackList((String)downFileName));
            if (!file.exists()) {
                throw new FileNotFoundException(downFileName);
            }
            if (!file.isFile()) {
                throw new FileNotFoundException(downFileName);
            }
            byte[] b = new byte[20480];
            if (mimeTypeParam == null) {
                mimeType = "application/octet-stream;";
            }
            response.setContentType(EgovWebUtil.removeCRLF((String)mimeType));
            response.setHeader("Content-Disposition", "filename=image;");
            fin = null;
            outs = null;
            try {
                int read;
                fin = new BufferedInputStream(new FileInputStream(file));
                outs = new BufferedOutputStream((OutputStream)response.getOutputStream());
                boolean var11 = false;
                while ((read = fin.read(b)) != -1) {
                    outs.write(b, 0, read);
                }
                if (fin == null) break block9;
            }
            catch (IOException e) {
                try {
                    throw new IOException("EgovFormBasedFileUtil :: viewFile : IOException " + String.valueOf(e));
                }
                catch (Throwable throwable) {
                    if (fin != null) {
                        fin.close();
                    }
                    EgovResourceCloseHelper.close((Closeable[])new Closeable[]{outs, fin});
                    throw throwable;
                }
            }
            fin.close();
        }
        EgovResourceCloseHelper.close((Closeable[])new Closeable[]{outs, fin});
    }
}

