/*
 * Decompiled with CFR 0.152.
 */
package com.arms.egovframework.javaservice.treeframework.service;

import com.arms.egovframework.javaservice.treeframework.TreeConstant;
import com.arms.egovframework.javaservice.treeframework.dao.TreeDao;
import com.arms.egovframework.javaservice.treeframework.interceptor.RouteTableInterceptor;
import com.arms.egovframework.javaservice.treeframework.model.TreeSearchEntity;
import com.arms.egovframework.javaservice.treeframework.service.TreeService;
import com.arms.egovframework.javaservice.treeframework.util.PaginationInfo;
import com.arms.egovframework.javaservice.treeframework.util.StringUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.persistence.Table;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.collections15.CollectionUtils;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.lang.math.NumberUtils;
import org.hibernate.CacheMode;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.LogicalExpression;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.unitils.util.ReflectionUtils;

@Service(value="treeService")
public class TreeServiceImpl
implements TreeService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource(name="treeDao")
    private TreeDao treeDao;

    @Transactional(readOnly=true)
    public <T extends TreeSearchEntity> T getNode(T treeSearchEntity) throws Exception {
        this.logger.info("CoreServiceImpl :: getNode");
        this.treeDao.setClazz(treeSearchEntity.getClass());
        treeSearchEntity.setWhere("c_id", (Object)treeSearchEntity.getC_id());
        TreeSearchEntity uniqueObj = this.treeDao.getUnique(treeSearchEntity);
        return (T)uniqueObj;
    }

    @Transactional(readOnly=true)
    public <T extends TreeSearchEntity> List<T> getChildNodeWithoutPaging(T treeSearchEntity) throws Exception {
        this.treeDao.setClazz(treeSearchEntity.getClass());
        List list = this.treeDao.getListWithoutPaging(treeSearchEntity);
        return list;
    }

    @Transactional(readOnly=true)
    public <T extends TreeSearchEntity> List<T> getChildNode(T treeSearchEntity) throws Exception {
        this.treeDao.setClazz(treeSearchEntity.getClass());
        treeSearchEntity.setOrder(Order.desc((String)"c_id"));
        List list = this.treeDao.getList(treeSearchEntity);
        return list;
    }

    @Transactional(readOnly=true)
    public <T extends TreeSearchEntity> List<T> getPaginatedChildNode(T treeSearchEntity) throws Exception {
        this.treeDao.setClazz(treeSearchEntity.getClass());
        this.treeDao.getCurrentSession().setCacheMode(CacheMode.IGNORE);
        int totalCount = this.treeDao.getCount(treeSearchEntity);
        double calPageSize = Math.ceil((double)totalCount / (double)treeSearchEntity.getPageUnit());
        int autoPageSize = (int)Math.round(calPageSize);
        PaginationInfo paginationInfo = treeSearchEntity.getPaginationInfo();
        paginationInfo.setTotalRecordCount(totalCount);
        paginationInfo.setCurrentPageNo(treeSearchEntity.getPageIndex());
        paginationInfo.setRecordCountPerPage(treeSearchEntity.getPageUnit());
        paginationInfo.setPageSize(autoPageSize);
        treeSearchEntity.setFirstIndex(paginationInfo.getFirstRecordIndex());
        treeSearchEntity.setLastIndex(paginationInfo.getLastRecordIndex());
        treeSearchEntity.setRecordCountPerPage(paginationInfo.getRecordCountPerPage());
        treeSearchEntity.setOrder(Order.desc((String)"c_id"));
        List list = this.treeDao.getPaginatedList(treeSearchEntity);
        list.stream().forEach(data -> data.getPaginationInfo().setTotalRecordCount(totalCount));
        return list;
    }

    @Transactional(readOnly=true)
    public <T extends TreeSearchEntity> List<T> getNodesWithoutRoot(T treeSearchEntity) throws Exception {
        treeSearchEntity.setOrder(Order.desc((String)"c_id"));
        Criterion criterion = Restrictions.not((Criterion)Restrictions.in((String)"c_id", (Object[])new Object[]{TreeConstant.ROOT_CID, TreeConstant.First_Node_CID}));
        treeSearchEntity.getCriterions().add(criterion);
        List list = this.getChildNode(treeSearchEntity);
        return list;
    }

    @Transactional(readOnly=true)
    public <T extends TreeSearchEntity, K, V> Map<K, V> getNodesWithoutRootMap(T treeSearchEntity, Function<T, K> key, Function<T, V> value) throws Exception {
        return this.getNodesWithoutRoot(treeSearchEntity).stream().collect(Collectors.toMap(key, value));
    }

    public <T extends TreeSearchEntity> List<String> searchNode(T treeSearchEntity) throws Exception {
        this.treeDao.setClazz(treeSearchEntity.getClass());
        this.treeDao.getCurrentSession().setCacheMode(CacheMode.IGNORE);
        treeSearchEntity.setOrder(Order.asc((String)"c_id"));
        List collectionObjects = this.treeDao.getList(treeSearchEntity);
        ArrayList<String> returnList = new ArrayList<String>();
        for (TreeSearchEntity rowObject : collectionObjects) {
            String rowData = "#node_" + rowObject.getC_id();
            returnList.add(rowData);
        }
        return returnList;
    }

    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.SERIALIZABLE, propagation=Propagation.REQUIRED)
    public <T extends TreeSearchEntity> T addNode(T treeSearchEntity) throws Exception {
        this.treeDao.setClazz(treeSearchEntity.getClass());
        this.treeDao.getCurrentSession().setCacheMode(CacheMode.IGNORE);
        if (treeSearchEntity.getRef() < 0L) {
            throw new RuntimeException("ref is minus");
        }
        TreeSearchEntity nodeByRef = this.treeDao.getUnique(Long.valueOf(treeSearchEntity.getRef()));
        if ("default".equals(nodeByRef.getC_type())) {
            throw new RuntimeException("nodeByRef is default Type");
        }
        nodeByRef.setWhere("c_parentid", (Object)nodeByRef.getC_id());
        long lastPosiotionOfNodeByRef = this.treeDao.getCount(nodeByRef);
        treeSearchEntity.setC_position(Long.valueOf(lastPosiotionOfNodeByRef));
        long rightPointFromNodeByRef = nodeByRef.getC_right();
        rightPointFromNodeByRef = Math.max(rightPointFromNodeByRef, 1L);
        long spaceOfTargetNode = 2L;
        this.stretchLeftRightForMyselfFromTree(spaceOfTargetNode, rightPointFromNodeByRef, treeSearchEntity.getCopy(), null, treeSearchEntity);
        long targetNodeLevel = treeSearchEntity.getRef() == 0L ? 0L : nodeByRef.getC_level() + 1L;
        treeSearchEntity.setC_parentid(Long.valueOf(treeSearchEntity.getRef()));
        treeSearchEntity.setC_left(Long.valueOf(rightPointFromNodeByRef));
        treeSearchEntity.setC_right(Long.valueOf(rightPointFromNodeByRef + 1L));
        treeSearchEntity.setC_level(Long.valueOf(targetNodeLevel));
        long insertSeqResult = (Long)this.treeDao.insert(treeSearchEntity);
        if (insertSeqResult <= 0L) {
            throw new RuntimeException("\uc2ec\uac01\ud55c \uc624\ub958 \ubc1c\uc0dd - \uc0bd\uc785 \ub178\ub4dc");
        }
        long SUCCESS = 1L;
        treeSearchEntity.setStatus(1L);
        treeSearchEntity.setId(insertSeqResult);
        return treeSearchEntity;
    }

    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.SERIALIZABLE, propagation=Propagation.REQUIRED)
    public <T extends TreeSearchEntity> int overwriteNode(T toEntity, T fromEntity) throws Exception {
        this.treeDao.setClazz(toEntity.getClass());
        this.treeDao.getCurrentSession().setCacheMode(CacheMode.IGNORE);
        TreeSearchEntity alterTargetNode = this.treeDao.getUnique(toEntity.getC_id());
        for (Field toField : ReflectionUtils.getAllFields(toEntity.getClass())) {
            toField.setAccessible(true);
            Field fromField = ReflectionUtils.getFieldWithName(fromEntity.getClass(), (String)toField.getName(), (boolean)false);
            fromField.setAccessible(true);
            Object fromValue = fromField.get(fromEntity);
            if (ObjectUtils.isEmpty((Object)fromValue)) continue;
            toField.setAccessible(true);
            toField.set(alterTargetNode, fromValue);
        }
        this.treeDao.update(alterTargetNode);
        return 1;
    }

    public <T extends TreeSearchEntity> void stretchLeftRightForMyselfFromTree(long spaceOfTargetNode, long rightPositionFromNodeByRef, long copy, Collection<Long> c_idsByChildNodeFromNodeById, T treeSearchEntity) throws Exception {
        DetachedCriteria detachedLeftCriteria = DetachedCriteria.forClass(treeSearchEntity.getClass());
        this.stretchLeft(spaceOfTargetNode, rightPositionFromNodeByRef, copy, c_idsByChildNodeFromNodeById, detachedLeftCriteria);
        DetachedCriteria detachedRightCriteria = DetachedCriteria.forClass(treeSearchEntity.getClass());
        this.stretchRight(spaceOfTargetNode, rightPositionFromNodeByRef, copy, c_idsByChildNodeFromNodeById, detachedRightCriteria);
    }

    public <T extends TreeSearchEntity> void stretchRight(long spaceOfTargetNode, long rightPositionFromNodeByRef, long copy, Collection<Long> c_idsByChildNodeFromNodeById, DetachedCriteria detachedCriteria) {
        this.logger.info("[ TreeService :: stretchRight ] rightPositionFromNodeByRef : " + rightPositionFromNodeByRef);
        SimpleExpression where = Restrictions.ge((String)"c_right", (Object)rightPositionFromNodeByRef);
        detachedCriteria.add((Criterion)where);
        if (copy == 0L && c_idsByChildNodeFromNodeById != null && c_idsByChildNodeFromNodeById.size() > 0) {
            detachedCriteria.add((Criterion)Restrictions.and((Criterion[])new Criterion[]{Restrictions.not((Criterion)Restrictions.in((String)"c_id", c_idsByChildNodeFromNodeById))}));
        }
        detachedCriteria.addOrder(Order.asc((String)"c_id"));
        List updateTargetList = this.treeDao.getListWithoutPaging(detachedCriteria);
        for (TreeSearchEntity perTreeSearchEntity : updateTargetList) {
            perTreeSearchEntity.setC_right(Long.valueOf(perTreeSearchEntity.getC_right() + spaceOfTargetNode));
            try {
                this.treeDao.update(perTreeSearchEntity);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    public <T extends TreeSearchEntity> void stretchLeft(long spaceOfTargetNode, long rightPositionFromNodeByRef, long copy, Collection<Long> c_idsByChildNodeFromNodeById, DetachedCriteria detachedCriteria) {
        this.logger.info("[ TreeService :: stretchLeft ] rightPositionFromNodeByRef : " + rightPositionFromNodeByRef);
        SimpleExpression where = Restrictions.ge((String)"c_left", (Object)rightPositionFromNodeByRef);
        detachedCriteria.add((Criterion)where);
        if (copy == 0L && c_idsByChildNodeFromNodeById != null && c_idsByChildNodeFromNodeById.size() > 0) {
            detachedCriteria.add((Criterion)Restrictions.and((Criterion[])new Criterion[]{Restrictions.not((Criterion)Restrictions.in((String)"c_id", c_idsByChildNodeFromNodeById))}));
        }
        detachedCriteria.addOrder(Order.asc((String)"c_id"));
        List updateTargetList = this.treeDao.getListWithoutPaging(detachedCriteria);
        for (TreeSearchEntity perTreeSearchEntity : updateTargetList) {
            perTreeSearchEntity.setC_left(Long.valueOf(perTreeSearchEntity.getC_left() + spaceOfTargetNode));
            try {
                this.treeDao.update(perTreeSearchEntity);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    public <T extends TreeSearchEntity> T newInstance(T treeSearchEntity) throws Exception {
        Class<?> target = Class.forName(treeSearchEntity.getClass().getCanonicalName());
        return (T)((TreeSearchEntity)target.newInstance());
    }

    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.SERIALIZABLE, propagation=Propagation.REQUIRED)
    public <T extends TreeSearchEntity> int removeNode(T treeSearchEntity) throws Exception {
        this.treeDao.setClazz(treeSearchEntity.getClass());
        this.treeDao.getCurrentSession().setCacheMode(CacheMode.IGNORE);
        SimpleExpression whereGetNode = Restrictions.eq((String)"c_id", (Object)treeSearchEntity.getC_id());
        TreeSearchEntity removeNode = this.treeDao.getUnique((Criterion)whereGetNode);
        long spaceOfTargetNode = removeNode.getC_right() - removeNode.getC_left() + 1L;
        removeNode.setSpaceOfTargetNode(spaceOfTargetNode);
        DetachedCriteria detachedDeleteCriteria = DetachedCriteria.forClass(treeSearchEntity.getClass());
        LogicalExpression where = Restrictions.and((Criterion)Restrictions.ge((String)"c_left", (Object)removeNode.getC_left()), (Criterion)Restrictions.le((String)"c_right", (Object)removeNode.getC_right()));
        detachedDeleteCriteria.add((Criterion)where);
        detachedDeleteCriteria.addOrder(Order.asc((String)"c_id"));
        try {
            List deleteTargetList = this.treeDao.getListWithoutPaging(detachedDeleteCriteria);
            for (TreeSearchEntity deleteTreeSearchEntity : deleteTargetList) {
                this.treeDao.delete(deleteTreeSearchEntity);
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        DetachedCriteria detachedRemovedAfterLeftFixCriteria = DetachedCriteria.forClass(treeSearchEntity.getClass());
        SimpleExpression whereRemovedAfterLeftFix = Restrictions.gt((String)"c_left", (Object)removeNode.getC_right());
        detachedRemovedAfterLeftFixCriteria.add((Criterion)whereRemovedAfterLeftFix);
        detachedRemovedAfterLeftFixCriteria.addOrder(Order.asc((String)"c_id"));
        List updateRemovedAfterLeftFixtList = this.treeDao.getListWithoutPaging(detachedRemovedAfterLeftFixCriteria);
        for (TreeSearchEntity perLeftFixTreeSearchEntity : updateRemovedAfterLeftFixtList) {
            perLeftFixTreeSearchEntity.setC_left(Long.valueOf(perLeftFixTreeSearchEntity.getC_left() - spaceOfTargetNode));
            this.treeDao.update(perLeftFixTreeSearchEntity);
        }
        DetachedCriteria detachedRemovedAfterRightFixCriteria = DetachedCriteria.forClass(treeSearchEntity.getClass());
        SimpleExpression whereRemovedAfterRightFix = Restrictions.gt((String)"c_right", (Object)removeNode.getC_left());
        detachedRemovedAfterRightFixCriteria.add((Criterion)whereRemovedAfterRightFix);
        detachedRemovedAfterRightFixCriteria.addOrder(Order.asc((String)"c_id"));
        List updateRemovedAfterRightFixtList = this.treeDao.getListWithoutPaging(detachedRemovedAfterRightFixCriteria);
        for (TreeSearchEntity perRightFixTreeSearchEntity : updateRemovedAfterRightFixtList) {
            perRightFixTreeSearchEntity.setC_right(Long.valueOf(perRightFixTreeSearchEntity.getC_right() - spaceOfTargetNode));
            this.treeDao.update(perRightFixTreeSearchEntity);
        }
        DetachedCriteria detachedRemovedAfterPositionFixCriteria = DetachedCriteria.forClass(treeSearchEntity.getClass());
        LogicalExpression whereRemovedAfterPositionFix = Restrictions.and((Criterion)Restrictions.eq((String)"c_parentid", (Object)removeNode.getC_parentid()), (Criterion)Restrictions.gt((String)"c_position", (Object)removeNode.getC_position()));
        detachedRemovedAfterPositionFixCriteria.add((Criterion)whereRemovedAfterPositionFix);
        detachedRemovedAfterPositionFixCriteria.addOrder(Order.asc((String)"c_id"));
        List updateRemovedAfterPositionFixtList = this.treeDao.getListWithoutPaging(detachedRemovedAfterPositionFixCriteria);
        for (TreeSearchEntity perPositionFixTreeSearchEntity : updateRemovedAfterPositionFixtList) {
            perPositionFixTreeSearchEntity.setC_position(Long.valueOf(perPositionFixTreeSearchEntity.getC_position() - 1L));
            this.treeDao.update(perPositionFixTreeSearchEntity);
        }
        return 0;
    }

    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.SERIALIZABLE, propagation=Propagation.REQUIRED)
    public <T extends TreeSearchEntity> int updateNode(T treeSearchEntity) throws Exception {
        HashSet<String> fieldsToAlwaysUpdate = new HashSet<String>(Arrays.asList("c_issue_delete_date", "c_etc", "c_req_state_mapping_link", "reqStateCategoryEntity"));
        this.treeDao.setClazz(treeSearchEntity.getClass());
        this.treeDao.getCurrentSession().setCacheMode(CacheMode.IGNORE);
        TreeSearchEntity alterTargetNode = this.treeDao.getUnique(treeSearchEntity.getC_id());
        for (Field field : ReflectionUtils.getAllFields(treeSearchEntity.getClass())) {
            field.setAccessible(true);
            Object value = field.get(treeSearchEntity);
            if (!fieldsToAlwaysUpdate.contains(field.getName()) && ObjectUtils.isEmpty((Object)value)) continue;
            field.set(alterTargetNode, value);
        }
        this.treeDao.merge(alterTargetNode);
        this.treeDao.update(alterTargetNode);
        return 1;
    }

    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.SERIALIZABLE, propagation=Propagation.REQUIRED)
    public <T extends TreeSearchEntity> int updateField(T treeSearchEntity, String field) throws Exception {
        Assert.hasText((String)field, (String)"Field must not be null or empty.");
        Set allFields = ReflectionUtils.getAllFields(treeSearchEntity.getClass());
        Optional<Field> optionalField = allFields.stream().filter(reflectionField -> field.equals(reflectionField.getName())).findFirst();
        if (optionalField.isPresent()) {
            Field targetField = optionalField.get();
            targetField.setAccessible(true);
            this.treeDao.setClazz(treeSearchEntity.getClass());
            this.treeDao.getCurrentSession().setCacheMode(CacheMode.IGNORE);
            TreeSearchEntity alterTargetNode = this.treeDao.getUnique(treeSearchEntity.getC_id());
            Object value = targetField.get(treeSearchEntity);
            targetField.set(alterTargetNode, value);
            this.treeDao.merge(alterTargetNode);
            this.treeDao.update(alterTargetNode);
            return 1;
        }
        return 0;
    }

    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.SERIALIZABLE, propagation=Propagation.REQUIRED)
    public <T extends TreeSearchEntity> List<T> saveOrUpdateList(List<T> entities) throws Exception {
        ArrayList<TreeSearchEntity> resultHostEntities = new ArrayList<TreeSearchEntity>();
        for (TreeSearchEntity entity : entities) {
            TreeSearchEntity oneBy = this.getNode(entity);
            if (oneBy == null) {
                entity.setRef(2L);
                entity.setC_type("default");
                this.addNode(entity);
            } else {
                this.overwriteNode(oneBy, entity);
            }
            resultHostEntities.add(oneBy);
        }
        return resultHostEntities;
    }

    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.SERIALIZABLE, propagation=Propagation.REQUIRED)
    public <T extends TreeSearchEntity> int alterNode(T treeSearchEntity) throws Exception {
        this.treeDao.setClazz(treeSearchEntity.getClass());
        this.treeDao.getCurrentSession().setCacheMode(CacheMode.IGNORE);
        TreeSearchEntity alterTargetNode = this.treeDao.getUnique(treeSearchEntity.getC_id());
        alterTargetNode.setC_title(treeSearchEntity.getC_title());
        alterTargetNode.setFieldFromNewInstance(treeSearchEntity);
        this.treeDao.update(alterTargetNode);
        return 1;
    }

    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.SERIALIZABLE, propagation=Propagation.REQUIRED)
    public <T extends TreeSearchEntity> int alterNodeType(T treeSearchEntity) throws Exception {
        this.treeDao.setClazz(treeSearchEntity.getClass());
        this.treeDao.getCurrentSession().setCacheMode(CacheMode.IGNORE);
        TreeSearchEntity nodeById = this.treeDao.getUnique(treeSearchEntity.getC_id());
        if (nodeById.getC_type().equals(treeSearchEntity.getC_type())) {
            return 1;
        }
        if ("default".equals(treeSearchEntity.getC_type())) {
            nodeById.setWhere("c_parentid", (Object)nodeById.getC_id());
            List childNodesFromNodeById = this.treeDao.getList(nodeById);
            if (childNodesFromNodeById.size() != 0) {
                throw new RuntimeException("\ud558\uc704\uc5d0 \ub178\ub4dc\uac00 \uc788\ub294\ub370 \ub514\ud3f4\ud2b8\ub85c \ubc14\uafb8\ub824\uace0 \ud568");
            }
            nodeById.setC_type(treeSearchEntity.getC_type());
            this.treeDao.update(nodeById);
        } else if ("folder".equals(treeSearchEntity.getC_type())) {
            nodeById.setC_type(treeSearchEntity.getC_type());
            this.treeDao.update(nodeById);
            return 1;
        }
        return 1;
    }

    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.SERIALIZABLE, propagation=Propagation.REQUIRED)
    public <T extends TreeSearchEntity> T moveNode(T treeSearchEntity, HttpServletRequest request) throws Exception {
        this.treeDao.setClazz(treeSearchEntity.getClass());
        this.treeDao.getCurrentSession().setCacheMode(CacheMode.IGNORE);
        this.logger.debug("[ TreeService :: moveNode ] \uc2dc\uc791 ");
        this.logger.debug("[ TreeService :: getNode ] treeSearchEntity : " + String.valueOf(treeSearchEntity));
        TreeSearchEntity nodeById = this.getNode(treeSearchEntity);
        if (nodeById == null) {
            throw new RuntimeException("nodeById is null");
        }
        Long nodeByIdLeft = nodeById.getC_left();
        this.logger.debug("-----------------------getChildNodeByLeftRight \uc644\ub8cc-----------------------");
        DetachedCriteria getChildNodeByLeftRightCriteria = DetachedCriteria.forClass(treeSearchEntity.getClass());
        LogicalExpression criterion = Restrictions.and((Criterion)Restrictions.ge((String)"c_left", (Object)nodeById.getC_left()), (Criterion)Restrictions.le((String)"c_right", (Object)nodeById.getC_right()));
        getChildNodeByLeftRightCriteria.add((Criterion)criterion);
        getChildNodeByLeftRightCriteria.addOrder(Order.asc((String)"c_id"));
        List childNodesFromNodeById = this.treeDao.getListWithoutPaging(getChildNodeByLeftRightCriteria);
        this.logger.debug("-----------------------position \uac12\uc774 over\ub420\ub54c \ubc29\uc5b4\ucf54\ub4dc-----------------------");
        DetachedCriteria getChildNodeByPositionCriteria = DetachedCriteria.forClass(treeSearchEntity.getClass());
        SimpleExpression position_criterion = Restrictions.eq((String)"c_parentid", (Object)treeSearchEntity.getRef());
        getChildNodeByPositionCriteria.add((Criterion)position_criterion);
        int refChildCount = this.treeDao.getListWithoutPaging(getChildNodeByPositionCriteria).size();
        if (treeSearchEntity.getC_position() > (long)refChildCount) {
            treeSearchEntity.setC_position(Long.valueOf(refChildCount));
        }
        this.logger.debug("-----------------------nodeByRef \uc644\ub8cc-----------------------");
        TreeSearchEntity nodeByRef = this.treeDao.getUnique(Long.valueOf(treeSearchEntity.getRef()));
        if (StringUtils.equals((String)nodeByRef.getC_type(), (String)"default")) {
            throw new RuntimeException("ref is not default type");
        }
        long rightPointFromNodeByRef = nodeByRef.getC_right();
        this.logger.debug("-----------------------childNodesFromNodeByRef \uc644\ub8cc-----------------------");
        DetachedCriteria getNodeByRefCriteria = DetachedCriteria.forClass(treeSearchEntity.getClass());
        SimpleExpression whereNodeByRef = Restrictions.eq((String)"c_parentid", (Object)nodeByRef.getC_id());
        getNodeByRefCriteria.add((Criterion)whereNodeByRef);
        List childNodesFromNodeByRef = this.treeDao.getListWithoutPaging(getNodeByRefCriteria);
        TreeSearchEntity t_ComprehensiveTree = this.newInstance(treeSearchEntity);
        long spaceOfTargetNode = 2L;
        Collection c_idsByChildNodeFromNodeById = null;
        this.logger.debug("-----------------------c_idsByChildNodeFromNodeById \uc644\ub8cc-----------------------");
        c_idsByChildNodeFromNodeById = CollectionUtils.collect((Collection)childNodesFromNodeById, (Transformer)new /* Unavailable Anonymous Inner Class!! */);
        if (c_idsByChildNodeFromNodeById.contains(treeSearchEntity.getRef())) {
            throw new RuntimeException("myself contains already refTargetNode");
        }
        spaceOfTargetNode = nodeById.getC_right() - nodeById.getC_left() + 1L;
        if (!treeSearchEntity.isCopied()) {
            this.logger.debug("-----------------------cutMyself \uc644\ub8cc-----------------------");
            this.cutMyself(nodeById, spaceOfTargetNode, c_idsByChildNodeFromNodeById);
        }
        this.logger.debug("-----------------------calculatePosition \uc644\ub8cc-----------------------");
        Table table = treeSearchEntity.getClass().getAnnotation(Table.class);
        String tableName = table.name();
        tableName = RouteTableInterceptor.setReplaceTableName((HttpServletRequest)request, (String)tableName);
        this.calculatePosition(treeSearchEntity, nodeById, childNodesFromNodeByRef, request, tableName);
        if (rightPointFromNodeByRef < 1L) {
            rightPointFromNodeByRef = 1L;
        }
        if (!treeSearchEntity.isCopied()) {
            this.logger.debug("-----------------------stretchPositionForMyselfFromTree \uc644\ub8cc-----------------------");
            this.stretchPositionForMyselfFromTree(c_idsByChildNodeFromNodeById, treeSearchEntity);
            int selfPosition = nodeById.getC_parentid().longValue() == treeSearchEntity.getRef() && treeSearchEntity.getC_position() > nodeById.getC_position() ? 1 : 0;
            for (TreeSearchEntity child : childNodesFromNodeByRef) {
                if (child.getC_position() - (long)selfPosition != treeSearchEntity.getC_position()) continue;
                rightPointFromNodeByRef = child.getC_left();
                break;
            }
            if (nodeById.getC_left() < rightPointFromNodeByRef) {
                rightPointFromNodeByRef -= spaceOfTargetNode;
            }
        }
        this.logger.debug("-----------------------stretchLeftRightForMyselfFromTree \uc644\ub8cc-----------------------");
        this.stretchLeftRightForMyselfFromTree(spaceOfTargetNode, rightPointFromNodeByRef, treeSearchEntity.getCopy(), c_idsByChildNodeFromNodeById, treeSearchEntity);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(">>>>>>>>>>>>>>>>>>>>" + rightPointFromNodeByRef);
        }
        long targetNodeLevel = nodeById.getC_level() - (nodeByRef.getC_level() + 1L);
        long comparePoint = nodeByIdLeft - rightPointFromNodeByRef;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(">>>>>>>>>>>>>>>>>>>>" + comparePoint);
        }
        if (treeSearchEntity.isCopied()) {
            this.logger.debug("-----------------------pasteMyselfFromTree \uc644\ub8cc-----------------------");
            long insertSeqResult = this.pasteMyselfFromTree(treeSearchEntity.getRef(), comparePoint, spaceOfTargetNode, targetNodeLevel, c_idsByChildNodeFromNodeById, rightPointFromNodeByRef, nodeById);
            t_ComprehensiveTree.setId(insertSeqResult);
            this.logger.debug("-----------------------fixPositionParentIdOfCopyNodes-----------------------");
            this.fixPositionParentIdOfCopyNodes(insertSeqResult, treeSearchEntity.getC_position().longValue(), treeSearchEntity);
        } else {
            this.logger.debug("-----------------------enterMyselfFromTree \uc644\ub8cc-----------------------");
            this.enterMyselfFromTree(treeSearchEntity.getRef(), treeSearchEntity.getC_position().longValue(), treeSearchEntity.getC_id().longValue(), comparePoint, targetNodeLevel, c_idsByChildNodeFromNodeById, treeSearchEntity);
            this.enterMyselfFixLeftRight(comparePoint, targetNodeLevel, c_idsByChildNodeFromNodeById, treeSearchEntity);
        }
        return (T)t_ComprehensiveTree;
    }

    public <T extends TreeSearchEntity> void enterMyselfFromTree(long ref, long c_position, long c_id, long idif, long ldif, Collection<Long> c_idsByChildNodeFromNodeById, T treeSearchEntity) throws Exception {
        this.treeDao.setClazz(treeSearchEntity.getClass());
        this.logger.debug("-----------------------enterMyselfFixPosition-----------------------");
        TreeSearchEntity childEnterMyselfFixPosition = this.treeDao.getUnique(treeSearchEntity.getC_id());
        childEnterMyselfFixPosition.setC_parentid(Long.valueOf(ref));
        childEnterMyselfFixPosition.setC_position(Long.valueOf(c_position));
        this.treeDao.update(childEnterMyselfFixPosition);
    }

    public <T extends TreeSearchEntity> void enterMyselfFixLeftRight(long idif, long ldif, Collection<Long> c_idsByChildNodeFromNodeById, T treeSearchEntity) {
        this.logger.debug("-----------------------enterMyselfFixLeftRight-----------------------");
        DetachedCriteria detachedEnterMyselfFixLeftRightCriteria = DetachedCriteria.forClass(treeSearchEntity.getClass());
        if (c_idsByChildNodeFromNodeById != null && c_idsByChildNodeFromNodeById.size() > 0) {
            Criterion whereEnterMyselfFixLeftRight = Restrictions.in((String)"c_id", c_idsByChildNodeFromNodeById);
            detachedEnterMyselfFixLeftRightCriteria.add(whereEnterMyselfFixLeftRight);
            detachedEnterMyselfFixLeftRightCriteria.addOrder(Order.asc((String)"c_id"));
            List enterMyselfFixLeftRightList = this.treeDao.getListWithoutPaging(detachedEnterMyselfFixLeftRightCriteria);
            for (TreeSearchEntity perEnterMyselfFixLeftRightList : enterMyselfFixLeftRightList) {
                this.logger.debug(perEnterMyselfFixLeftRightList.toString());
                perEnterMyselfFixLeftRightList.setC_left(Long.valueOf(perEnterMyselfFixLeftRightList.getC_left() - idif));
                perEnterMyselfFixLeftRightList.setC_right(Long.valueOf(perEnterMyselfFixLeftRightList.getC_right() - idif));
                perEnterMyselfFixLeftRightList.setC_level(Long.valueOf(perEnterMyselfFixLeftRightList.getC_level() - ldif));
                this.treeDao.update(perEnterMyselfFixLeftRightList);
            }
        }
    }

    public <T extends TreeSearchEntity> void fixPositionParentIdOfCopyNodes(long insertSeqResult, long position, T treeSearchEntity) throws Exception {
        this.treeDao.setClazz(treeSearchEntity.getClass());
        TreeSearchEntity node = this.treeDao.getUnique(Long.valueOf(insertSeqResult));
        this.logger.debug("-----------------------fixPositionParentIdOfCopyNodes \uc644\ub8cc-----------------------");
        DetachedCriteria getChildNodeByLeftRightCriteria = DetachedCriteria.forClass(treeSearchEntity.getClass());
        SimpleExpression whereChildNodeByLeftRight = Restrictions.ge((String)"c_left", (Object)node.getC_left());
        getChildNodeByLeftRightCriteria.add((Criterion)whereChildNodeByLeftRight);
        getChildNodeByLeftRightCriteria.add((Criterion)Restrictions.and((Criterion[])new Criterion[]{Restrictions.le((String)"c_right", (Object)node.getC_right())}));
        getChildNodeByLeftRightCriteria.addOrder(Order.asc((String)"c_id"));
        List children = this.treeDao.getListWithoutPaging(getChildNodeByLeftRightCriteria);
        HashMap<Long, Long> parentIds = new HashMap<Long, Long>();
        for (TreeSearchEntity child : children) {
            for (long i = child.getC_left() + 1L; i < child.getC_right(); ++i) {
                long parentId = child.getC_id();
                parentIds.put(i, parentId);
            }
            if (child.getC_id() == insertSeqResult) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(">>>>>>>>>>>>>>>>> \uae30\uc900\ub178\ub4dc\uac00 \uc7a1\ud614\uc74c.");
                    this.logger.debug("C_TITLE    = " + child.getC_title());
                    this.logger.debug("C_ID       = " + insertSeqResult);
                    this.logger.debug("C_POSITION = " + position);
                }
                node.setC_position(Long.valueOf(position));
                this.treeDao.update(node);
                continue;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(">>>>>>>>>>>>>>>>> \uae30\uc900\ub178\ub4dc \uc544\ub798 \uc788\ub294 \ub140\uc11d\uc784");
                this.logger.debug("C_TITLE    = " + child.getC_title());
                this.logger.debug("C_ID       = " + child.getC_id());
                this.logger.debug("C_POSITION = " + child.getC_position());
                this.logger.debug("C_PARENTID = " + child.getC_parentid());
                this.logger.debug("\ubd80\ubaa8\uc544\uc774\ub514\uac12 = " + String.valueOf(parentIds.get(child.getC_left())));
            }
            child.setFixCopyId(((Long)parentIds.get(child.getC_left())).longValue());
            child.setC_parentid((Long)parentIds.get(child.getC_left()));
            this.treeDao.update(child);
        }
    }

    public <T extends TreeSearchEntity> long pasteMyselfFromTree(long ref, long idif, long spaceOfTargetNode, long ldif, Collection<Long> c_idsByChildNodeFromNodeById, long rightPositionFromNodeByRef, T nodeById) throws Exception {
        this.treeDao.setClazz(nodeById.getClass());
        TreeSearchEntity onlyPasteMyselfFromTree = this.getNode(nodeById);
        onlyPasteMyselfFromTree.setRef(ref);
        onlyPasteMyselfFromTree.setIdif(idif);
        onlyPasteMyselfFromTree.setSpaceOfTargetNode(spaceOfTargetNode);
        onlyPasteMyselfFromTree.setLdif(ldif);
        onlyPasteMyselfFromTree.setC_idsByChildNodeFromNodeById(c_idsByChildNodeFromNodeById);
        onlyPasteMyselfFromTree.setRightPositionFromNodeByRef(rightPositionFromNodeByRef);
        onlyPasteMyselfFromTree.setNodeById(nodeById);
        onlyPasteMyselfFromTree.setIdifLeft(idif + (nodeById.getC_left() >= rightPositionFromNodeByRef ? spaceOfTargetNode : 0L));
        onlyPasteMyselfFromTree.setIdifRight(idif + (nodeById.getC_left() >= rightPositionFromNodeByRef ? spaceOfTargetNode : 0L));
        DetachedCriteria detachedPasteMyselfFromTreeCriteria = DetachedCriteria.forClass(nodeById.getClass());
        if (c_idsByChildNodeFromNodeById != null && c_idsByChildNodeFromNodeById.size() > 0) {
            Criterion wherePasteMyselfFromTree = Restrictions.in((String)"c_id", c_idsByChildNodeFromNodeById);
            detachedPasteMyselfFromTreeCriteria.add(wherePasteMyselfFromTree);
            List pasteMyselfFromTreeList = this.treeDao.getListWithoutPaging(detachedPasteMyselfFromTreeCriteria);
            Iterator iterator = pasteMyselfFromTreeList.iterator();
            if (iterator.hasNext()) {
                TreeSearchEntity perPasteMyselfFromTree = (TreeSearchEntity)iterator.next();
                this.logger.debug("------pasteMyselfFromTree------LOOP---" + perPasteMyselfFromTree.getC_id());
                TreeSearchEntity addTarget = this.newInstance(perPasteMyselfFromTree);
                addTarget.setC_parentid(Long.valueOf(onlyPasteMyselfFromTree.getRef()));
                addTarget.setC_position(perPasteMyselfFromTree.getC_position());
                addTarget.setC_left(Long.valueOf(perPasteMyselfFromTree.getC_left() - onlyPasteMyselfFromTree.getIdifLeft()));
                addTarget.setC_right(Long.valueOf(perPasteMyselfFromTree.getC_right() - onlyPasteMyselfFromTree.getIdifRight()));
                addTarget.setC_level(Long.valueOf(perPasteMyselfFromTree.getC_level() - onlyPasteMyselfFromTree.getLdif()));
                addTarget.setC_title(perPasteMyselfFromTree.getC_title());
                addTarget.setC_type(perPasteMyselfFromTree.getC_type());
                addTarget.setFieldFromNewInstance(perPasteMyselfFromTree);
                this.logger.debug("\uc5ec\uae30\uc5d0 \ucd94\uac00\uc801\uc73c\ub85c \ud655\uc7a5\ud55c \ud544\ub4dc\uc5d0 \ub300\ud55c \ud568\uc218\uac00 \ub4e4\uc5b4\uac00\uc57c \ud55c\ub2e4 \ud328\ud134\uc744 \uc4f0\uc790");
                long insertSeqResult = (Long)this.treeDao.insert(addTarget);
                perPasteMyselfFromTree.setId(insertSeqResult);
                if (insertSeqResult > 0L) {
                    return insertSeqResult;
                }
                throw new RuntimeException("\uc2ec\uac01\ud55c \uc624\ub958 \ubc1c\uc0dd - \uc0bd\uc785 \ub178\ub4dc");
            }
        }
        return 0L;
    }

    public <T extends TreeSearchEntity> void stretchPositionForMyselfFromTree(Collection<Long> c_idsByChildNodeFromNodeById, T treeSearchEntity) throws Exception {
        this.treeDao.setClazz(treeSearchEntity.getClass());
        treeSearchEntity.setC_idsByChildNodeFromNodeById(c_idsByChildNodeFromNodeById);
        DetachedCriteria detachedStretchPositionForMyselfCriteria = DetachedCriteria.forClass(treeSearchEntity.getClass());
        SimpleExpression whereStretchPositionForMyself = Restrictions.eq((String)"c_parentid", (Object)treeSearchEntity.getRef());
        detachedStretchPositionForMyselfCriteria.add((Criterion)whereStretchPositionForMyself);
        detachedStretchPositionForMyselfCriteria.add((Criterion)Restrictions.and((Criterion[])new Criterion[]{Restrictions.ge((String)"c_position", (Object)treeSearchEntity.getC_position())}));
        if (treeSearchEntity.getCopy() == 0L && c_idsByChildNodeFromNodeById != null && c_idsByChildNodeFromNodeById.size() > 0) {
            detachedStretchPositionForMyselfCriteria.add((Criterion)Restrictions.and((Criterion[])new Criterion[]{Restrictions.not((Criterion)Restrictions.in((String)"c_id", c_idsByChildNodeFromNodeById))}));
        }
        detachedStretchPositionForMyselfCriteria.addOrder(Order.asc((String)"c_id"));
        List stretchPositionForMyselfList = this.treeDao.getListWithoutPaging(detachedStretchPositionForMyselfCriteria);
        for (TreeSearchEntity perStretchPositionForMyself : stretchPositionForMyselfList) {
            perStretchPositionForMyself.setC_position(Long.valueOf(perStretchPositionForMyself.getC_position() + 1L));
            this.treeDao.update(perStretchPositionForMyself);
        }
    }

    public <T extends TreeSearchEntity> void calculatePosition(T treeSearchEntity, T nodeById, List<T> childNodesFromNodeByRef, HttpServletRequest request, String tableName) throws Exception {
        boolean isBeyondTheCurrentToMoveNodes;
        HttpSession session = request.getSession();
        boolean isMoveNodeInMyParent = treeSearchEntity.getRef() == nodeById.getC_parentid().longValue();
        boolean isMultiCounterZero = treeSearchEntity.getMultiCounter() == 0L;
        boolean bl = isBeyondTheCurrentToMoveNodes = treeSearchEntity.getC_position() > nodeById.getC_position();
        if (isMoveNodeInMyParent) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(">>>>>>>>>>>>>>>\uc774\ub3d9\ud560 \ub178\ub4dc\uac00 \ub0b4 \ubd80\ubaa8\uc548\uc5d0\uc11c \uc6c0\uc9c1\uc77c\ub54c");
            }
            if (isMultiCounterZero) {
                if (isBeyondTheCurrentToMoveNodes) {
                    boolean isFolderToMoveNodes;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug(">>>>>>>>>>>>>>>\uc774\ub3d9 \ud560 \ub178\ub4dc\uac00 \ud604\uc7ac\ubcf4\ub2e4 \ub4a4\uc77c\ub54c");
                        this.logger.debug("\ub178\ub4dc\uac12=" + nodeById.getC_title());
                        this.logger.debug("\ub178\ub4dc\uc758 \ucd08\uae30 \uc704\uce58\uac12=" + nodeById.getC_position());
                        this.logger.debug("\ub178\ub4dc\uc758 \uc694\uccad\ubc1b\uc740 \uc704\uce58\uac12=" + treeSearchEntity.getC_position());
                        this.logger.debug("\ub178\ub4dc\uc758 \uc694\uccad\ubc1b\uc740 \uba40\ud2f0\uce74\uc6b4\ud130=" + treeSearchEntity.getMultiCounter());
                    }
                    boolean bl2 = isFolderToMoveNodes = treeSearchEntity.getC_position() > (long)childNodesFromNodeByRef.size();
                    if (isFolderToMoveNodes) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("\ub178\ub4dc \uc774\ub3d9\uc2dc \ud3f4\ub354\ub97c \ub300\uc0c1\uc73c\ub85c \ud588\uc744\ub54c \uc0dd\uae30\ub294 \ubc84\uadf8 \ubc1c\uc0dd =" + treeSearchEntity.getC_position());
                        }
                        long childNodesFromNodeByRefCnt = childNodesFromNodeByRef.size();
                        treeSearchEntity.setC_position(Long.valueOf(childNodesFromNodeByRefCnt));
                    } else {
                        treeSearchEntity.setC_position(Long.valueOf(treeSearchEntity.getC_position() - 1L));
                    }
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("\ub178\ub4dc\uc758 \ucd5c\uc885 \uc704\uce58\uac12=" + treeSearchEntity.getC_position());
                }
                session.setAttribute(tableName + "_settedPosition", (Object)treeSearchEntity.getC_position());
            } else {
                boolean isMultiNodeOfPositionsAtZeroThanBehind;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(">>>>>>>>>>>>>>>\uba40\ud2f0 \uce74\uc6b4\ud130\uac00 0 \uc774 \uc544\ub2d0\ub54c");
                    this.logger.debug("\ub178\ub4dc\uac12=" + nodeById.getC_title());
                    this.logger.debug("\ub178\ub4dc\uc758 \ucd08\uae30 \uc704\uce58\uac12=" + nodeById.getC_position());
                    this.logger.debug("\ub178\ub4dc\uc758 \uc694\uccad\ubc1b\uc740 \uc704\uce58\uac12=" + treeSearchEntity.getC_position());
                    this.logger.debug("\ub178\ub4dc\uc758 \uc694\uccad\ubc1b\uc740 \uba40\ud2f0\uce74\uc6b4\ud130=" + treeSearchEntity.getMultiCounter());
                    this.logger.debug("0\ubc88 \ub178\ub4dc\uc758 \uc704\uce58\uac12=" + String.valueOf(session.getAttribute(tableName + "_settedPosition")));
                }
                long increasePosition = 0L;
                boolean bl3 = isMultiNodeOfPositionsAtZeroThanBehind = (long)((Integer)session.getAttribute("settedPosition")).intValue() < nodeById.getC_position();
                if (isMultiNodeOfPositionsAtZeroThanBehind) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug(">>>>>>>>>>>>>>>\uba40\ud2f0 \ub178\ub4dc\uc758 \uc704\uce58\uac00 0\ubc88 \ub178\ub4dc\ubcf4\ub2e4 \ub4a4\uc77c\ub54c");
                    }
                    increasePosition = NumberUtils.toLong((String)session.getAttribute(tableName + "_settedPosition").toString()) + 1L;
                } else {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug(">>>>>>>>>>>>>>>\uba40\ud2f0 \ub178\ub4dc\uc758 \uc704\uce58\uac00 0\ubc88 \ub178\ub4dc\ubcf4\ub2e4 \uc55e\uc77c\ub54c");
                    }
                    increasePosition = treeSearchEntity.isCopied() ? NumberUtils.toLong((String)session.getAttribute(tableName + "_settedPosition").toString()) + 1L : NumberUtils.toLong((String)session.getAttribute(tableName + "_settedPosition").toString());
                }
                session.setAttribute(tableName + "_settedPosition", (Object)increasePosition);
                treeSearchEntity.setC_position(Long.valueOf(increasePosition));
                boolean isSamePosition = nodeById.getC_position().equals(treeSearchEntity.getC_position());
                if (isSamePosition) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug(">>>>>>>>>>>>>>>\uc6d0\ub798 \ub178\ub4dc \uc704\uce58\uac12\uacfc \ucd5c\uc885 \uacc4\uc0b0\ub41c \ub178\ub4dc\uc758 \uc704\uce58\uac12\uc774 \ub3d9\uc77c\ud55c \uacbd\uc6b0");
                    }
                    session.setAttribute(tableName + "_settedPosition", (Object)(increasePosition - 1L));
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("\ub178\ub4dc\uc758 \ucd5c\uc885 \uc704\uce58\uac12=" + treeSearchEntity.getC_position());
                }
            }
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(">>>>>>>>>>>>>>>\uc774\ub3d9\ud560 \ub178\ub4dc\uac00 \ub0b4 \ubd80\ubaa8\ubc16\uc73c\ub85c \uc6c0\uc9c1\uc77c\ub54c");
            }
            if (isMultiCounterZero) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(">>>>>>>>>>>>>>>\uba40\ud2f0 \uce74\uc6b4\ud130\uac00 0 \uc77c\ub54c");
                    this.logger.debug("\ub178\ub4dc\uac12=" + nodeById.getC_title());
                    this.logger.debug("\ub178\ub4dc\uc758 \ucd08\uae30 \uc704\uce58\uac12=" + nodeById.getC_position());
                    this.logger.debug("\ub178\ub4dc\uc758 \uc694\uccad\ubc1b\uc740 \uc704\uce58\uac12=" + treeSearchEntity.getC_position());
                    this.logger.debug("\ub178\ub4dc\uc758 \uc694\uccad\ubc1b\uc740 \uba40\ud2f0\uce74\uc6b4\ud130=" + treeSearchEntity.getMultiCounter());
                    this.logger.debug("\ub178\ub4dc\uc758 \ucd5c\uc885 \uc704\uce58\uac12=" + treeSearchEntity.getC_position());
                }
                session.setAttribute(tableName + "_settedPosition", (Object)treeSearchEntity.getC_position());
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(">>>>>>>>>>>>>>>\uba40\ud2f0 \uce74\uc6b4\ud130\uac00 0 \uc774 \uc544\ub2d0\ub54c");
                    this.logger.debug("\ub178\ub4dc\uac12=" + nodeById.getC_title());
                    this.logger.debug("\ub178\ub4dc\uc758 \ucd08\uae30 \uc704\uce58\uac12=" + nodeById.getC_position());
                    this.logger.debug("\ub178\ub4dc\uc758 \uc694\uccad\ubc1b\uc740 \uc704\uce58\uac12=" + treeSearchEntity.getC_position());
                    this.logger.debug("\ub178\ub4dc\uc758 \uc694\uccad\ubc1b\uc740 \uba40\ud2f0\uce74\uc6b4\ud130=" + treeSearchEntity.getMultiCounter());
                }
                long increasePosition = 0L;
                increasePosition = NumberUtils.toLong((String)session.getAttribute(tableName + "_settedPosition").toString()) + 1L;
                treeSearchEntity.setC_position(Long.valueOf(increasePosition));
                session.setAttribute(tableName + "_settedPosition", (Object)increasePosition);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("\ub178\ub4dc\uc758 \ucd5c\uc885 \uc704\uce58\uac12=" + treeSearchEntity.getC_position());
                }
            }
        }
    }

    public <T extends TreeSearchEntity> void cutMyself(T nodeById, long spaceOfTargetNode, Collection<Long> c_idsByChildNodeFromNodeById) throws Exception {
        this.treeDao.setClazz(nodeById.getClass());
        nodeById.setSpaceOfTargetNode(spaceOfTargetNode);
        nodeById.setC_idsByChildNodeFromNodeById(c_idsByChildNodeFromNodeById);
        this.logger.debug("***********************CutMyself***********************");
        this.logger.debug("-----------------------cutMyselfPositionFix-----------------------");
        DetachedCriteria cutMyselfPositionFixCriteria = DetachedCriteria.forClass(nodeById.getClass());
        SimpleExpression whereCutMyselfPositionFix = Restrictions.eq((String)"c_parentid", (Object)nodeById.getC_parentid());
        cutMyselfPositionFixCriteria.add((Criterion)whereCutMyselfPositionFix);
        cutMyselfPositionFixCriteria.add((Criterion)Restrictions.and((Criterion[])new Criterion[]{Restrictions.gt((String)"c_position", (Object)nodeById.getC_position())}));
        cutMyselfPositionFixCriteria.addOrder(Order.asc((String)"c_id"));
        List childCutMyselfPositionFix = this.treeDao.getListWithoutPaging(cutMyselfPositionFixCriteria);
        for (TreeSearchEntity perNodeById : childCutMyselfPositionFix) {
            perNodeById.setC_position(Long.valueOf(perNodeById.getC_position() - 1L));
            this.treeDao.update(perNodeById);
        }
        this.logger.debug("-----------------------cutMyselfLeftFix-----------------------");
        DetachedCriteria cutMyselfLeftFixCriteria = DetachedCriteria.forClass(nodeById.getClass());
        SimpleExpression whereCutMyselfLeftFix = Restrictions.gt((String)"c_left", (Object)nodeById.getC_right());
        cutMyselfLeftFixCriteria.add((Criterion)whereCutMyselfLeftFix);
        cutMyselfLeftFixCriteria.addOrder(Order.asc((String)"c_id"));
        List childCutMyselfLeftFix = this.treeDao.getListWithoutPaging(cutMyselfLeftFixCriteria);
        for (TreeSearchEntity perCutMyselfLeftFix : childCutMyselfLeftFix) {
            perCutMyselfLeftFix.setC_left(Long.valueOf(perCutMyselfLeftFix.getC_left() - spaceOfTargetNode));
            this.treeDao.update(perCutMyselfLeftFix);
        }
        this.logger.debug("-----------------------cutMyselfRightFix-----------------------");
        DetachedCriteria cutMyselfRightFixCriteria = DetachedCriteria.forClass(nodeById.getClass());
        SimpleExpression whereCutMyselfRightFix = Restrictions.gt((String)"c_right", (Object)nodeById.getC_left());
        cutMyselfRightFixCriteria.add((Criterion)whereCutMyselfRightFix);
        if (c_idsByChildNodeFromNodeById != null && c_idsByChildNodeFromNodeById.size() > 0) {
            cutMyselfRightFixCriteria.add((Criterion)Restrictions.and((Criterion[])new Criterion[]{Restrictions.not((Criterion)Restrictions.in((String)"c_id", c_idsByChildNodeFromNodeById))}));
        }
        cutMyselfRightFixCriteria.addOrder(Order.asc((String)"c_id"));
        List childCutMyselfRightFix = this.treeDao.getListWithoutPaging(cutMyselfRightFixCriteria);
        for (TreeSearchEntity perCutMyselfRightFix : childCutMyselfRightFix) {
            perCutMyselfRightFix.setC_right(Long.valueOf(perCutMyselfRightFix.getC_right() - spaceOfTargetNode));
            this.treeDao.update(perCutMyselfRightFix);
        }
    }
}

