/*
 * Decompiled with CFR 0.152.
 */
package com.arms.egovframework.javaservice.treeframework.interceptor;

import com.arms.egovframework.javaservice.treeframework.interceptor.SessionUtil;
import com.arms.egovframework.javaservice.treeframework.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.hibernate.EmptyInterceptor;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteTableInterceptor
extends EmptyInterceptor {
    private static final Logger log = LoggerFactory.getLogger(RouteTableInterceptor.class);
    private final Map<String, String> reqAddRoute;
    private final Map<String, String> reqStatusRoute;
    private final Map<String, String> reqLinkedIssueRoute;
    private final Map<String, String> costRoute;
    private final Map<String, String> wikiRoute;
    Session session;

    public void setSession(Session session) {
        this.session = session;
    }

    public String onPrepareStatement(String sql) {
        String preparedStatement = super.onPrepareStatement(sql);
        try {
            String route;
            HttpServletRequest httpServletRequest = SessionUtil.getUrl();
            String servletPath = httpServletRequest.getServletPath();
            String lastPathSegment = servletPath.substring(servletPath.lastIndexOf("/") + 1);
            log.info("RouteTableInterceptor :: servletPath -> {}", (Object)servletPath);
            log.debug("RouteTableInterceptor :: onPrepareStatement -> {}", (Object)lastPathSegment);
            if (StringUtils.contains((String)servletPath, (String)"T_ARMS_REQADD_")) {
                String route2 = (String)this.reqAddRoute.get(lastPathSegment);
                if (StringUtils.isNullCheck((String)route2)) {
                    String replaceTableName = (String)SessionUtil.getAttribute((String)route2);
                    preparedStatement = this.replaceStatement(preparedStatement, replaceTableName);
                }
            } else if (StringUtils.contains((String)servletPath, (String)"T_ARMS_REQSTATUS_")) {
                String route3 = (String)this.reqStatusRoute.get(lastPathSegment);
                if (StringUtils.isNullCheck((String)route3)) {
                    String replaceTableName = (String)SessionUtil.getAttribute((String)route3);
                    preparedStatement = this.replaceStatement(preparedStatement, replaceTableName);
                }
            } else if (StringUtils.contains((String)servletPath, (String)"req-linked-issue")) {
                String route4 = (String)this.reqLinkedIssueRoute.get(lastPathSegment);
                if (StringUtils.isNullCheck((String)route4)) {
                    String replaceTableName = (String)SessionUtil.getAttribute((String)route4);
                    preparedStatement = this.replaceStatement(preparedStatement, replaceTableName);
                }
            } else if (StringUtils.contains((String)servletPath, (String)"calculation")) {
                String route5 = (String)this.costRoute.get(lastPathSegment);
                if (StringUtils.isNullCheck((String)route5)) {
                    String replaceTableName = (String)SessionUtil.getAttribute((String)route5);
                    preparedStatement = this.replaceStatement(preparedStatement, replaceTableName);
                }
            } else if (StringUtils.contains((String)servletPath, (String)"T_ARMS_WIKI_") && StringUtils.isNullCheck((String)(route = (String)this.wikiRoute.get(lastPathSegment)))) {
                String replaceTableName = (String)SessionUtil.getAttribute((String)route);
                preparedStatement = this.replaceStatement(preparedStatement, replaceTableName);
            }
        }
        catch (Exception e) {
            log.info("RouteTableInterceptor :: onPrepareStatement :: Exception -> " + e.getMessage());
        }
        return preparedStatement;
    }

    private String replaceStatement(String preparedStatement, String replaceTableName) {
        log.debug("RouteTableInterceptor :: preparedStatement - before =>" + preparedStatement);
        log.info("RouteTableInterceptor :: replaceTableName =>" + replaceTableName);
        if (StringUtils.isNotEmpty((String)replaceTableName)) {
            if (StringUtils.contains((String)replaceTableName, (String)"T_ARMS_REQADD")) {
                preparedStatement = preparedStatement.replaceAll("T_ARMS_REQADD", replaceTableName);
            } else if (StringUtils.contains((String)replaceTableName, (String)"T_ARMS_REQSTATUS")) {
                preparedStatement = preparedStatement.replaceAll("T_ARMS_REQSTATUS", replaceTableName);
            } else if (StringUtils.contains((String)replaceTableName, (String)"T_ARMS_WIKI")) {
                preparedStatement = preparedStatement.replaceAll("T_ARMS_WIKI", replaceTableName);
            } else {
                log.info("RouteTableInterceptor :: replaceTableName - notFound =>" + replaceTableName);
            }
            log.debug("RouteTableInterceptor :: preparedStatement - after =>" + preparedStatement);
        } else {
            log.info("RouteTableInterceptor :: replaceTableName - empty");
        }
        return preparedStatement;
    }

    public static String setReplaceTableName(HttpServletRequest request, String tableName) throws Exception {
        String servletPath = request.getServletPath();
        if (StringUtils.equals((String)tableName, (String)"T_ARMS_REQADD")) {
            if (StringUtils.contains((String)servletPath, (String)"T_ARMS_REQADD_") && StringUtils.contains((String)servletPath, (String)"moveNode.do")) {
                tableName = (String)SessionUtil.getAttribute((String)"moveNode");
            }
        } else if (StringUtils.equals((String)tableName, (String)"T_ARMS_REQSTATUS")) {
            if (StringUtils.contains((String)servletPath, (String)"T_ARMS_REQSTATUS_") && StringUtils.contains((String)servletPath, (String)"moveNode.do")) {
                tableName = (String)SessionUtil.getAttribute((String)"moveNode");
            }
        } else if (StringUtils.equals((String)tableName, (String)"T_ARMS_WIKI_") && StringUtils.contains((String)servletPath, (String)"T_ARMS_WIKI_") && StringUtils.contains((String)servletPath, (String)"moveNode.do")) {
            tableName = (String)SessionUtil.getAttribute((String)"moveNode");
        }
        log.info("RouteTableInterceptor :: setReplaceTableName -> " + servletPath);
        log.info("RouteTableInterceptor :: setReplaceTableName -> " + tableName);
        return tableName;
    }

    public RouteTableInterceptor(Map<String, String> reqAddRoute, Map<String, String> reqStatusRoute, Map<String, String> reqLinkedIssueRoute, Map<String, String> costRoute, Map<String, String> wikiRoute) {
        this.reqAddRoute = reqAddRoute;
        this.reqStatusRoute = reqStatusRoute;
        this.reqLinkedIssueRoute = reqLinkedIssueRoute;
        this.costRoute = costRoute;
        this.wikiRoute = wikiRoute;
    }
}

