/*
 * Decompiled with CFR 0.152.
 */
package com.arms.egovframework.javaservice.treeframework.excel;

import com.arms.egovframework.javaservice.treeframework.excel.CellTemplate;
import com.arms.egovframework.javaservice.treeframework.excel.ExcelUtilsBase;
import com.arms.egovframework.javaservice.treeframework.excel.ExcelUtilsXlsx;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelUtilsXlsx
extends ExcelUtilsBase {
    public static final String SHEET_\uc5f0\ubd09\uc785\ub825_\uc608\uc2dc = "Sheet1";
    public static final String SHEET_\uc5f0\ubd09\uc785\ub825 = "Sheet2";

    public ExcelUtilsXlsx(InputStream inputStream) {
        super(inputStream);
    }

    public ExcelUtilsXlsx(OutputStream outputStream) {
        super(outputStream);
    }

    protected Workbook createBlankNewWorkbook() {
        return new XSSFWorkbook();
    }

    protected Workbook getWorkbook() throws IOException {
        try (InputStream inputStream = this.inputStream;){
            XSSFWorkbook xSSFWorkbook = new XSSFWorkbook(inputStream);
            return xSSFWorkbook;
        }
    }

    public <T> void fillWorkBook(Workbook workbook, String sheetName, List<CellTemplate> templateList, List<T> srcContent) throws IllegalArgumentException, IllegalAccessException, ClassNotFoundException {
        XSSFSheet sheet = ((XSSFWorkbook)workbook).createSheet(sheetName);
        this.createHeaderRow(templateList, srcContent, sheet);
        this.createBodyRows(templateList, srcContent, sheet);
        this.createTitleRow(templateList, srcContent, sheet);
    }

    private <T> void createHeaderRow(List<CellTemplate> templateList, List<T> srcContent, XSSFSheet sheet) {
        int headerTotalRowSize = this.getHeaderTotalRowSize(srcContent.get(0).getClass());
        int headerTitleRowSize = this.getHeaderTitleRowSize(srcContent.get(0).getClass());
        MergeHeaderBox mergeHeaderBox = new MergeHeaderBox(templateList, headerTitleRowSize);
        IntStream.range(headerTitleRowSize, headerTotalRowSize).forEach(index -> {
            XSSFRow mergeHeaderRow = sheet.createRow(index);
            for (CellTemplate template : templateList) {
                template.createHeaderCell((Row)mergeHeaderRow);
            }
        });
        mergeHeaderBox.setMergeRegions(sheet);
    }

    private <T> void createTitleRow(List<CellTemplate> templateList, List<T> srcContent, XSSFSheet sheet) {
        String sheetName = sheet.getSheetName();
        XSSFRow row = sheet.createRow(0);
        for (CellTemplate template : templateList) {
            template.createTitleCell((Row)row, this.getHeaderTitleName(srcContent.get(0).getClass()));
        }
        if (sheetName.equals(SHEET_\uc5f0\ubd09\uc785\ub825_\uc608\uc2dc)) {
            sheet.setColumnWidth(0, 3000);
            sheet.setColumnWidth(1, 10000);
            sheet.setColumnWidth(2, 17000);
            sheet.setColumnWidth(3, 10000);
            sheet.setColumnWidth(4, 10000);
        }
        if (sheetName.equals(SHEET_\uc5f0\ubd09\uc785\ub825)) {
            sheet.setColumnWidth(0, 10000);
            sheet.setColumnWidth(1, 10000);
            sheet.setColumnWidth(2, 10000);
        }
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, templateList.size() - 1));
    }

    private <T> void createBodyRows(List<CellTemplate> templateList, List<T> srcContent, XSSFSheet sheet) throws IllegalAccessException, ClassNotFoundException {
        int rowNum = this.getHeaderTotalRowSize(srcContent.get(0).getClass());
        for (T item : srcContent) {
            XSSFRow row = sheet.createRow(rowNum++);
            for (CellTemplate template : templateList) {
                template.createCell((Row)row, item);
            }
        }
    }
}

