/*
 * Decompiled with CFR 0.152.
 */
package com.arms.egovframework.javaservice.treeframework.excel;

import com.arms.egovframework.javaservice.treeframework.excel.CellTemplate;
import com.arms.egovframework.javaservice.treeframework.excel.ExcelClassAnnotation;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public abstract class ExcelUtilsBase {
    protected InputStream inputStream;
    protected OutputStream outputStream;

    public ExcelUtilsBase(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public ExcelUtilsBase(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> void create(List<List<?>> srcContent) throws IOException {
        Workbook workbook = null;
        try {
            workbook = this.createOrGetWorkBook(true);
            for (List<?> lists : srcContent) {
                if (lists.size() <= 0) continue;
                String sheetName = this.getExportSheetName(lists.get(0).getClass());
                List templateList = this.getExportableFields(lists.get(0).getClass());
                this.fillWorkBook(workbook, sheetName, templateList, lists);
            }
            workbook.write(this.outputStream);
        }
        catch (ClassNotFoundException e) {
            try {
                throw new RuntimeException(e);
                catch (IllegalAccessException e2) {
                    throw new RuntimeException(e2);
                }
            }
            catch (Throwable throwable) {
                this.close(new Closeable[]{workbook, this.outputStream});
                throw throwable;
            }
        }
        this.close(new Closeable[]{workbook, this.outputStream});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> read(Class<T> cls) throws Exception {
        List list;
        Workbook workbook = null;
        try {
            workbook = this.createOrGetWorkBook(false);
            Sheet sheet = this.readSheet(cls, workbook);
            list = this.readContent(sheet, cls);
        }
        catch (Throwable throwable) {
            this.close(new Closeable[]{workbook});
            throw throwable;
        }
        this.close(new Closeable[]{workbook});
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<List<?>> read(List<Class<?>> list) throws Exception {
        List list2;
        Workbook workbook = null;
        try {
            workbook = this.createOrGetWorkBook(false);
            list2 = this.readSheets(list, workbook);
        }
        catch (Throwable throwable) {
            this.close(new Closeable[]{workbook});
            throw throwable;
        }
        this.close(new Closeable[]{workbook});
        return list2;
    }

    protected abstract Workbook createBlankNewWorkbook();

    protected abstract Workbook getWorkbook() throws IOException;

    protected abstract <T> void fillWorkBook(Workbook var1, String var2, List<CellTemplate> var3, List<T> var4) throws IllegalArgumentException, IllegalAccessException, ClassNotFoundException;

    private <T> Workbook createOrGetWorkBook(boolean createNewIfNotFound) throws IOException {
        if (this.inputStream != null) {
            return this.getWorkbook();
        }
        if (this.outputStream != null) {
            return this.createBlankNewWorkbook();
        }
        return this.createBlankNewWorkbook();
    }

    private Sheet getSheetBySheetName(Workbook workbook, String sheetName) {
        Iterator iterator = workbook.sheetIterator();
        while (iterator.hasNext()) {
            Sheet sheet = (Sheet)iterator.next();
            if (!sheet.getSheetName().equals(sheetName)) continue;
            return sheet;
        }
        throw new RuntimeException("Can't find sheet " + sheetName);
    }

    private <T> Sheet readSheet(Class<T> cls, Workbook workbook) {
        String sheetName = this.getExportSheetName(cls);
        return this.getSheetBySheetName(workbook, sheetName);
    }

    private List<List<?>> readSheets(List<Class<?>> classList, Workbook workbook) {
        ArrayList sheets = new ArrayList();
        classList.forEach(cls -> {
            Annotation[] annotations;
            for (Annotation annotation : annotations = cls.getAnnotations()) {
                if (!(annotation instanceof ExcelClassAnnotation)) continue;
                Sheet sheetBySheetName = this.getSheetBySheetName(workbook, ((ExcelClassAnnotation)annotation).sheetName());
                try {
                    sheets.add(this.readContent(sheetBySheetName, cls));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        return sheets;
    }

    private <T> List<T> readContent(Sheet sheet, Class<T> cls) throws Exception {
        ArrayList<Object> result = new ArrayList<Object>();
        List templateList = this.getExportableFields(cls);
        Iterator rows = sheet.rowIterator();
        IntStream.range(0, this.getHeaderTotalRowSize(cls)).forEach(i -> this.skipExcelHeader(rows));
        while (rows.hasNext()) {
            Row row = (Row)rows.next();
            Object item = this.readRow(cls, templateList, row);
            result.add(item);
        }
        return result;
    }

    public void skipExcelHeader(Iterator<Row> rows) {
        rows.next();
    }

    private <T> T readRow(Class<T> cls, List<CellTemplate> templateList, Row row) throws Exception {
        T item = cls.getConstructor(new Class[0]).newInstance(new Object[0]);
        int cellLength = row.getLastCellNum();
        int columnIndex = 0;
        for (int i = 0; i < cellLength; ++i) {
            Cell cell = row.getCell(i);
            templateList.get(columnIndex).invokeObjectProperty(cell, item);
            ++columnIndex;
        }
        return item;
    }

    private <T> String getExportSheetName(Class<T> cls) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = cls.getAnnotations()) {
            if (!(annotation instanceof ExcelClassAnnotation)) continue;
            return ((ExcelClassAnnotation)annotation).sheetName();
        }
        throw new IllegalArgumentException(String.valueOf(cls) + "is not exportable.");
    }

    public <T> int getHeaderRowSize(Class<T> cls) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = cls.getAnnotations()) {
            if (!(annotation instanceof ExcelClassAnnotation)) continue;
            return ((ExcelClassAnnotation)annotation).headerRowSize();
        }
        throw new IllegalArgumentException(String.valueOf(cls) + "is not exportable.");
    }

    public <T> int getHeaderTitleRowSize(Class<T> cls) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = cls.getAnnotations()) {
            if (!(annotation instanceof ExcelClassAnnotation)) continue;
            return ((ExcelClassAnnotation)annotation).headerTitleRowSize();
        }
        throw new IllegalArgumentException(String.valueOf(cls) + "is not exportable.");
    }

    public <T> String getHeaderTitleName(Class<T> cls) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = cls.getAnnotations()) {
            if (!(annotation instanceof ExcelClassAnnotation)) continue;
            return ((ExcelClassAnnotation)annotation).headerTitleName();
        }
        throw new IllegalArgumentException(String.valueOf(cls) + "is not exportable.");
    }

    public <T> int getHeaderTotalRowSize(Class<T> cls) {
        return this.getHeaderRowSize(cls) + this.getHeaderTitleRowSize(cls);
    }

    private <T> List<CellTemplate> getExportableFields(Class<T> cls) {
        Field[] declaredFields;
        ArrayList<CellTemplate> templateList = new ArrayList<CellTemplate>();
        for (Field field : declaredFields = cls.getDeclaredFields()) {
            CellTemplate template = CellTemplate.getInstance((Field)field);
            if (template == null) continue;
            templateList.add(template);
        }
        Collections.sort(templateList);
        return templateList;
    }

    protected void close(Closeable ... itemsToClose) throws IOException {
        if (itemsToClose != null) {
            for (Closeable closeable : itemsToClose) {
                if (closeable == null) continue;
                closeable.close();
            }
        }
    }
}

