/*
 * Decompiled with CFR 0.152.
 */
package com.arms.egovframework.javaservice.treeframework.excel;

import com.arms.egovframework.javaservice.treeframework.excel.ExcelFieldAnnotation;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CellTemplate
implements Comparable<CellTemplate> {
    private static final Logger log = LoggerFactory.getLogger(CellTemplate.class);
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:ss:mm");
    private Field field;
    private String annotation_headerName;
    private int annotation_columnIndex;
    private String annotation_formatting;
    private CellStyle cellRowStyle;

    public static CellTemplate getInstance(Field field) {
        CellTemplate mappingCell = new CellTemplate();
        Annotation[] annotations = field.getAnnotations();
        if (annotations == null || annotations.length == 0) {
            return null;
        }
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof ExcelFieldAnnotation)) continue;
            ExcelFieldAnnotation res = (ExcelFieldAnnotation)annotation;
            mappingCell.field = field;
            mappingCell.annotation_columnIndex = res.columnIndex();
            mappingCell.annotation_headerName = res.headerName();
            mappingCell.annotation_formatting = res.formatting();
            if (mappingCell.annotation_headerName == null || mappingCell.annotation_headerName.trim().length() == 0) {
                mappingCell.annotation_headerName = field.getName();
            }
            return mappingCell;
        }
        return null;
    }

    public void createCell(Row row, Object obj) throws IllegalArgumentException, IllegalAccessException, ClassNotFoundException {
        Cell cell = row.createCell(this.annotation_columnIndex);
        boolean isAccessible = this.field.canAccess(obj);
        this.field.setAccessible(true);
        Class<?> fieldClass = this.field.getType();
        Class<?> aClass = Class.forName(this.field.getType().getName());
        if (this.field.get(obj) == null) {
            cell.setCellValue("");
        } else if (fieldClass == Integer.TYPE) {
            int value = this.field.getInt(obj);
            cell.setCellValue((double)value);
        } else if (fieldClass == Integer.class) {
            cell.setCellValue((double)((Integer)this.field.get(obj)).intValue());
        } else if (fieldClass == Short.class || fieldClass == Short.TYPE) {
            short value = this.field.getShort(obj);
            cell.setCellValue((double)value);
        } else if (fieldClass == Long.class || fieldClass == Long.TYPE) {
            Object value = this.field.get(obj);
            if (value != null) {
                long longValue = (Long)value;
                cell.setCellValue((double)longValue);
            } else {
                cell.setCellValue(0.0);
            }
        } else if (fieldClass == String.class) {
            String value = Optional.ofNullable(this.field.get(obj)).map(Object::toString).orElse(null);
            cell.setCellValue(value);
        } else if (fieldClass == Double.class || fieldClass == Double.TYPE) {
            double value = this.field.getDouble(obj);
            cell.setCellValue(value);
        } else if (fieldClass == Float.class || fieldClass == Float.TYPE) {
            float value = this.field.getFloat(obj);
            cell.setCellValue((double)value);
        } else if (fieldClass == Byte.class || fieldClass == Byte.TYPE) {
            byte value = this.field.getByte(obj);
            cell.setCellValue((double)value);
        } else if (fieldClass == Character.class || fieldClass == Character.TYPE) {
            char value = this.field.getChar(obj);
            cell.setCellValue((double)value);
        } else if (fieldClass == Boolean.class) {
            boolean value = this.field.getBoolean(obj);
            cell.setCellValue(value);
        } else if (fieldClass == Date.class) {
            String value = this.dateFormat.format((Date)this.field.get(obj));
            cell.setCellValue(value);
        } else if (aClass.isEnum()) {
            cell.setCellValue(String.valueOf(this.field.get(obj)));
        } else {
            cell.setCellValue("");
        }
        this.field.setAccessible(isAccessible);
    }

    public void createHeaderCell(Row row) {
        Workbook workbook = row.getSheet().getWorkbook();
        Font font = workbook.createFont();
        font.setBold(true);
        CellStyle cellHeaderStyle = workbook.createCellStyle();
        cellHeaderStyle.setBorderTop(BorderStyle.THIN);
        cellHeaderStyle.setBorderBottom(BorderStyle.THIN);
        cellHeaderStyle.setBorderLeft(BorderStyle.THIN);
        cellHeaderStyle.setBorderRight(BorderStyle.THIN);
        cellHeaderStyle.setAlignment(HorizontalAlignment.CENTER);
        cellHeaderStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellHeaderStyle.setFont(font);
        Cell cell = row.createCell(this.annotation_columnIndex);
        String[] splitHeader = this.annotation_headerName.split("\u00b6");
        if (splitHeader.length > 1) {
            cell.setCellValue(splitHeader[splitHeader.length - 1]);
        } else {
            cell.setCellValue(splitHeader[0]);
        }
        cell.setCellStyle(cellHeaderStyle);
    }

    public void createTitleCell(Row row, String titleName) {
        Workbook workbook = row.getSheet().getWorkbook();
        Font font = workbook.createFont();
        font.setBold(true);
        font.setFontHeight((short)400);
        CellStyle cellHeaderStyle = workbook.createCellStyle();
        cellHeaderStyle.setBorderTop(BorderStyle.THIN);
        cellHeaderStyle.setBorderBottom(BorderStyle.THIN);
        cellHeaderStyle.setBorderLeft(BorderStyle.THIN);
        cellHeaderStyle.setBorderRight(BorderStyle.THIN);
        cellHeaderStyle.setAlignment(HorizontalAlignment.CENTER);
        cellHeaderStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellHeaderStyle.setFont(font);
        cellHeaderStyle.setFillForegroundColor(IndexedColors.LIGHT_GREEN.getIndex());
        cellHeaderStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        Cell cell = row.createCell(0);
        cell.setCellValue(titleName);
        cell.setCellStyle(cellHeaderStyle);
    }

    public void invokeObjectProperty(Cell cell, Object obj) throws Exception {
        boolean isAccessible = this.field.canAccess(obj);
        this.field.setAccessible(true);
        Class<?> fieldClass = this.field.getType();
        if (cell == null) {
            Class<?> aClass = Class.forName(this.field.getType().getName());
            if (aClass.isEnum()) {
                this.field.set(obj, null);
            } else {
                this.field.set(obj, "");
            }
        } else if (fieldClass == Integer.class || fieldClass == Integer.TYPE) {
            int value = (int)cell.getNumericCellValue();
            this.field.set(obj, value);
        } else if (fieldClass == Short.class || fieldClass == Short.TYPE) {
            short value = (short)cell.getNumericCellValue();
            this.field.set(obj, value);
        } else if (fieldClass == Long.class || fieldClass == Long.TYPE) {
            long value = (long)cell.getNumericCellValue();
            this.field.set(obj, value);
        } else if (fieldClass == String.class) {
            String value = CellType.NUMERIC.equals((Object)cell.getCellType()) ? String.format(this.annotation_formatting, cell.getNumericCellValue()) : cell.getStringCellValue();
            this.field.set(obj, value);
        } else if (fieldClass == Double.class || fieldClass == Double.TYPE) {
            double value = cell.getNumericCellValue();
            this.field.set(obj, value);
        } else if (fieldClass == Float.class || fieldClass == Float.TYPE) {
            float value = (float)cell.getNumericCellValue();
            this.field.set(obj, Float.valueOf(value));
        } else if (fieldClass == Byte.class || fieldClass == Byte.TYPE) {
            byte value = (byte)cell.getNumericCellValue();
            this.field.set(obj, value);
        } else if (fieldClass == Character.class || fieldClass == Character.TYPE) {
            char value = (char)cell.getNumericCellValue();
            this.field.set(obj, Character.valueOf(value));
        } else if (fieldClass == Boolean.class) {
            Boolean value = cell.getBooleanCellValue();
            this.field.set(obj, value);
        } else if (fieldClass == Date.class) {
            Date value = this.dateFormat.parse(cell.getStringCellValue());
            this.field.set(obj, value);
        } else if (cell.getCellType() == CellType.STRING) {
            Class<?> aClass = Class.forName(this.field.getType().getName());
            if (aClass.isEnum()) {
                this.enumAssign(cell, obj, aClass);
            } else {
                this.field.set(obj, cell.getStringCellValue());
            }
        } else if (cell.getCellType() != CellType.BLANK) {
            throw new RuntimeException(String.valueOf(fieldClass) + " is not supported.");
        }
        this.field.setAccessible(isAccessible);
    }

    private void enumAssign(Cell cell, Object obj, Class<?> aClass) {
        ?[] enumConstants = aClass.getEnumConstants();
        Stream.of(enumConstants).filter(str -> String.valueOf(str).equals(cell.getStringCellValue())).findFirst().ifPresent(str -> {
            try {
                Field declaredField = aClass.getDeclaredField(String.valueOf(str));
                this.field.set(obj, declaredField.get(aClass));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public int compareTo(CellTemplate obj) {
        if (this.annotation_columnIndex == obj.annotation_columnIndex) {
            return 0;
        }
        return this.annotation_columnIndex > obj.annotation_columnIndex ? 1 : -1;
    }

    public String getAnnotation_headerName() {
        return this.annotation_headerName;
    }

    public int getAnnotation_columnIndex() {
        return this.annotation_columnIndex;
    }

    public String getAnnotation_formatting() {
        return this.annotation_formatting;
    }
}

