/*
 * Decompiled with CFR 0.152.
 */
package com.arms.egovframework.javaservice.treeframework.errors.response;

import com.arms.api.util.slack.SlackNotificationService;
import com.arms.api.util.slack.SlackProperty;
import com.arms.egovframework.javaservice.treeframework.controller.CommonResponse;
import com.arms.egovframework.javaservice.treeframework.errors.exception.BaseException;
import com.arms.egovframework.javaservice.treeframework.errors.exception.InvalidParamException;
import com.arms.egovframework.javaservice.treeframework.errors.response.ErrorCode;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.catalina.connector.ClientAbortException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.NestedExceptionUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice
public class ErrorControllerAdvice {
    private static final Logger log = LoggerFactory.getLogger(ErrorControllerAdvice.class);
    private static final List<ErrorCode> SPECIFIC_ALERT_TARGET_ERROR_CODE_LIST = new ArrayList();
    private final SlackNotificationService slackNotificationService;

    private ResponseEntity<CommonResponse.ApiResult<?>> newResponse(Throwable throwable, HttpStatus status) {
        return this.newResponse(throwable.getMessage(), status);
    }

    private ResponseEntity<CommonResponse.ApiResult<?>> newResponse(String message, HttpStatus status) {
        HttpHeaders headers = this.getHttpHeaders();
        return new ResponseEntity((Object)CommonResponse.error((String)message, (HttpStatus)status), (MultiValueMap)headers, status);
    }

    private ResponseEntity<CommonResponse.ApiResult<?>> newResponse(ErrorCode errorCode, HttpStatus status) {
        HttpHeaders headers = this.getHttpHeaders();
        return new ResponseEntity((Object)CommonResponse.error((ErrorCode)errorCode, (HttpStatus)status), (MultiValueMap)headers, status);
    }

    private ResponseEntity<CommonResponse.ApiResult<?>> newResponse(String message, ErrorCode errorCode, HttpStatus status) {
        HttpHeaders headers = this.getHttpHeaders();
        return new ResponseEntity((Object)CommonResponse.error((String)message, (ErrorCode)errorCode, (HttpStatus)status), (MultiValueMap)headers, status);
    }

    private HttpHeaders getHttpHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        return headers;
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<CommonResponse.ApiResult<?>> onException(Exception e) {
        log.error("[Exception], cause = {}, errorMsg = {}", (Object)NestedExceptionUtils.getMostSpecificCause((Throwable)e), (Object)NestedExceptionUtils.getMostSpecificCause((Throwable)e).getMessage());
        return this.newResponse(e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={BaseException.class})
    public ResponseEntity<?> onBaseException(BaseException e) {
        this.slackNotificationService.sendMessageToChannel(SlackProperty.Channel.backend, (Exception)e);
        if (SPECIFIC_ALERT_TARGET_ERROR_CODE_LIST.contains(e.getErrorCode())) {
            log.error("[BaseException] ,cause = {}, errorMsg = {}", (Object)NestedExceptionUtils.getMostSpecificCause((Throwable)e), (Object)NestedExceptionUtils.getMostSpecificCause((Throwable)e).getMessage());
        } else {
            log.warn("[BaseException] ,cause = {}, errorMsg = {}", (Object)NestedExceptionUtils.getMostSpecificCause((Throwable)e), (Object)NestedExceptionUtils.getMostSpecificCause((Throwable)e).getMessage());
        }
        return this.newResponse(e.getMessage(), e.getErrorCode(), HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={ClientAbortException.class})
    public ResponseEntity<?> skipException(Exception e) {
        log.warn("[skipException] , cause = {}, errorMsg = {}", (Object)NestedExceptionUtils.getMostSpecificCause((Throwable)e), (Object)NestedExceptionUtils.getMostSpecificCause((Throwable)e).getMessage());
        return this.newResponse(ErrorCode.COMMON_SYSTEM_ERROR, HttpStatus.OK);
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResponseEntity<?> methodArgumentNotValidException(MethodArgumentNotValidException e) {
        log.warn("[BaseException] ,errorMsg = {}", (Object)NestedExceptionUtils.getMostSpecificCause((Throwable)e).getMessage());
        BindingResult bindingResult = e.getBindingResult();
        FieldError fe = bindingResult.getFieldError();
        if (fe != null) {
            String message = "Request Error " + fe.getField() + "=" + String.valueOf(fe.getRejectedValue()) + " (" + fe.getDefaultMessage() + ")";
            return this.newResponse(message, ErrorCode.COMMON_INVALID_PARAMETER, HttpStatus.BAD_REQUEST);
        }
        return this.newResponse(ErrorCode.COMMON_INVALID_PARAMETER, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={BindException.class})
    public ResponseEntity<?> bindException(BindException e) {
        log.warn("[BindException] ,errorMsg = {}", (Object)NestedExceptionUtils.getMostSpecificCause((Throwable)e).getMessage());
        BindingResult bindingResult = e.getBindingResult();
        if (bindingResult.getErrorCount() > 0) {
            String message = bindingResult.getAllErrors().stream().map(a -> Optional.ofNullable(a.getDefaultMessage()).orElse("\uc54c\ub824\uc9c0\uc9c0 \uc54a\uc740 \uc5d0\ub7ec")).findFirst().orElseThrow(InvalidParamException::new);
            return this.newResponse(message, ErrorCode.COMMON_INVALID_PARAMETER, HttpStatus.BAD_REQUEST);
        }
        return this.newResponse(ErrorCode.COMMON_INVALID_PARAMETER, HttpStatus.BAD_REQUEST);
    }

    public ErrorControllerAdvice(SlackNotificationService slackNotificationService) {
        this.slackNotificationService = slackNotificationService;
    }
}

