/*
 * Decompiled with CFR 0.152.
 */
package com.arms.egovframework.javaservice.treeframework.dao;

import com.arms.egovframework.javaservice.treeframework.errors.exception.TreeDaoException;
import com.arms.egovframework.javaservice.treeframework.model.TreeSearchEntity;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.beanutils.BeanUtils;
import org.hibernate.CacheMode;
import org.hibernate.Criteria;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.orm.hibernate5.HibernateTemplate;
import org.springframework.orm.hibernate5.support.HibernateDaoSupport;

public abstract class TreeAbstractDao<T extends TreeSearchEntity, ID extends Serializable>
extends HibernateDaoSupport {
    private static final String REFRESH_GET_HIBERNATE_TEMPLATE_IS_NULL = "TreeAbstractDao :: refresh - getHibernateTemplate is null";
    private static final String GET_LIST_WITHOUT_PAGING_GET_HIBERNATE_TEMPLATE_IS_NULL = "TreeAbstractDao :: getListWithoutPaging - getHibernateTemplate is null";
    private static final String GET_COUNT_GET_HIBERNATE_TEMPLATE_IS_NULL = "TreeAbstractDao :: getCount - getHibernateTemplate is null";
    private static final String GET_LIST_GET_HIBERNATE_TEMPLATE_IS_NULL = "TreeAbstractDao :: getList - getHibernateTemplate is null";
    private static final String GET_UNIQUE_GET_HIBERNATE_TEMPLATE_IS_NULL = "TreeAbstractDao :: getUnique - getHibernateTemplate is null";
    private static final String GET_UNIQUE_FIND_BY_CRITERIA_RESULT_IS_NULL = "TreeAbstractDao :: getUnique - findByCriteria result is null";

    @Resource(name="sessionFactory")
    public void init(SessionFactory sessionFactory) {
        this.setSessionFactory(sessionFactory);
    }

    protected abstract Class<T> getEntityClass();

    public Session getCurrentSession() {
        HibernateTemplate template = this.getHibernateTemplate();
        if (template == null) {
            throw new TreeDaoException("TreeAbstractDao :: getCurrentSession - template is null");
        }
        SessionFactory factory = template.getSessionFactory();
        if (factory == null) {
            throw new TreeDaoException("TreeAbstractDao :: getCurrentSession - factory is null");
        }
        Session session = factory.getCurrentSession();
        if (session == null) {
            throw new TreeDaoException("TreeAbstractDao :: getCurrentSession - session is null");
        }
        return session;
    }

    public DetachedCriteria createDetachedCriteria(Class<?> clazz) {
        return DetachedCriteria.forClass(clazz);
    }

    public DetachedCriteria createDetachedCriteria() {
        return DetachedCriteria.forClass((Class)this.getEntityClass());
    }

    private DetachedCriteria getCriteria(T treeSearchEntity) {
        DetachedCriteria criteria = DetachedCriteria.forClass((Class)this.getEntityClass());
        for (Criterion criterion : treeSearchEntity.getCriterions()) {
            criteria.add(criterion);
        }
        return criteria;
    }

    public T getUnique(Long id) {
        HibernateTemplate template = this.getHibernateTemplate();
        if (template == null) {
            throw new TreeDaoException(GET_UNIQUE_GET_HIBERNATE_TEMPLATE_IS_NULL);
        }
        TreeSearchEntity returnObj = (TreeSearchEntity)template.get(this.getEntityClass(), (Serializable)id);
        if (returnObj == null) {
            throw new TreeDaoException("TreeAbstractDao :: getUnique : returnObj is null");
        }
        return (T)returnObj;
    }

    public T getUnique(Criterion criterion) {
        DetachedCriteria detachedCriteria = this.createDetachedCriteria();
        detachedCriteria.add(criterion);
        HibernateTemplate template = this.getHibernateTemplate();
        if (template == null) {
            throw new TreeDaoException(GET_UNIQUE_GET_HIBERNATE_TEMPLATE_IS_NULL);
        }
        List list = template.findByCriteria(detachedCriteria);
        if (list.isEmpty()) {
            throw new TreeDaoException(GET_UNIQUE_FIND_BY_CRITERIA_RESULT_IS_NULL);
        }
        return (T)((TreeSearchEntity)list.get(0));
    }

    public T getUnique(T treeSearchEntity) {
        HibernateTemplate template = this.getHibernateTemplate();
        if (template == null) {
            throw new TreeDaoException(GET_UNIQUE_GET_HIBERNATE_TEMPLATE_IS_NULL);
        }
        DetachedCriteria detachedCriteria = this.createDetachedCriteria();
        for (Criterion c : treeSearchEntity.getCriterions()) {
            detachedCriteria.add(c);
        }
        List list = template.findByCriteria(detachedCriteria);
        if (list.isEmpty()) {
            return null;
        }
        return (T)((TreeSearchEntity)list.get(0));
    }

    public T getUnique(Criterion ... criterions) {
        HibernateTemplate template = this.getHibernateTemplate();
        if (template == null) {
            throw new TreeDaoException(GET_UNIQUE_GET_HIBERNATE_TEMPLATE_IS_NULL);
        }
        DetachedCriteria detachedCriteria = this.createDetachedCriteria();
        for (Criterion c : criterions) {
            detachedCriteria.add(c);
        }
        List list = template.findByCriteria(detachedCriteria);
        if (list.isEmpty()) {
            throw new TreeDaoException(GET_UNIQUE_FIND_BY_CRITERIA_RESULT_IS_NULL);
        }
        return (T)((TreeSearchEntity)list.get(0));
    }

    public T getUnique(List<Criterion> criterion) {
        HibernateTemplate template = this.getHibernateTemplate();
        if (template == null) {
            throw new TreeDaoException(GET_UNIQUE_GET_HIBERNATE_TEMPLATE_IS_NULL);
        }
        DetachedCriteria detachedCriteria = this.createDetachedCriteria();
        for (Criterion c : criterion) {
            detachedCriteria.add(c);
        }
        List list = template.findByCriteria(detachedCriteria);
        if (list.isEmpty()) {
            throw new TreeDaoException(GET_UNIQUE_FIND_BY_CRITERIA_RESULT_IS_NULL);
        }
        return (T)((TreeSearchEntity)list.get(0));
    }

    public List<T> getList() {
        HibernateTemplate template = this.getHibernateTemplate();
        if (template == null) {
            throw new TreeDaoException(GET_LIST_GET_HIBERNATE_TEMPLATE_IS_NULL);
        }
        DetachedCriteria criteria = DetachedCriteria.forClass((Class)this.getEntityClass());
        List list = template.findByCriteria(criteria);
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        return list;
    }

    public List<T> getList(DetachedCriteria detachedCriteria, int limit, int offset) {
        HibernateTemplate template = this.getHibernateTemplate();
        if (template == null) {
            throw new TreeDaoException(GET_LIST_GET_HIBERNATE_TEMPLATE_IS_NULL);
        }
        List list = template.findByCriteria(detachedCriteria, offset, limit);
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        return list;
    }

    public List<T> getList(T treeSearchEntity) {
        HibernateTemplate template = this.getHibernateTemplate();
        if (template == null) {
            throw new TreeDaoException(GET_LIST_GET_HIBERNATE_TEMPLATE_IS_NULL);
        }
        DetachedCriteria detachedCriteria = this.createDetachedCriteria();
        for (Order order : treeSearchEntity.getOrder()) {
            detachedCriteria.addOrder(order);
        }
        for (Criterion criterion : treeSearchEntity.getCriterions()) {
            detachedCriteria.add(criterion);
        }
        List list = template.findByCriteria(detachedCriteria, treeSearchEntity.getFirstIndex(), treeSearchEntity.getLastIndex());
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        return list;
    }

    public List<T> getPaginatedList(T treeSearchEntity) {
        HibernateTemplate template = this.getHibernateTemplate();
        if (template == null) {
            throw new TreeDaoException(GET_LIST_GET_HIBERNATE_TEMPLATE_IS_NULL);
        }
        DetachedCriteria detachedCriteria = this.createDetachedCriteria();
        for (Order order : treeSearchEntity.getOrder()) {
            detachedCriteria.addOrder(order);
        }
        for (Criterion criterion : treeSearchEntity.getCriterions()) {
            detachedCriteria.add(criterion);
        }
        List list = template.findByCriteria(detachedCriteria, treeSearchEntity.getFirstIndex(), treeSearchEntity.getRecordCountPerPage());
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        return list;
    }

    public List<T> getList(T treeSearchEntity, Criterion ... criterion) {
        HibernateTemplate template = this.getHibernateTemplate();
        if (template == null) {
            throw new TreeDaoException(GET_LIST_GET_HIBERNATE_TEMPLATE_IS_NULL);
        }
        DetachedCriteria detachedCriteria = this.createDetachedCriteria();
        for (Criterion c : criterion) {
            detachedCriteria.add(c);
        }
        for (Order order : treeSearchEntity.getOrder()) {
            detachedCriteria.addOrder(order);
        }
        List list = template.findByCriteria(detachedCriteria, treeSearchEntity.getFirstIndex(), treeSearchEntity.getLastIndex());
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        return list;
    }

    public List<T> getList(Criterion ... criterions) {
        HibernateTemplate template = this.getHibernateTemplate();
        if (template == null) {
            throw new TreeDaoException(GET_LIST_GET_HIBERNATE_TEMPLATE_IS_NULL);
        }
        DetachedCriteria criteria = this.createDetachedCriteria();
        for (Criterion criterion : criterions) {
            criteria.add(criterion);
        }
        List list = template.findByCriteria(criteria);
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        return list;
    }

    public List<T> getList(List<Criterion> criterions, List<Order> orders) {
        HibernateTemplate template = this.getHibernateTemplate();
        if (template == null) {
            throw new TreeDaoException(GET_LIST_GET_HIBERNATE_TEMPLATE_IS_NULL);
        }
        DetachedCriteria criteria = this.createDetachedCriteria();
        for (Criterion criterion : criterions) {
            criteria.add(criterion);
        }
        for (Order order : orders) {
            criteria.addOrder(order);
        }
        List list = template.findByCriteria(criteria);
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        return list;
    }

    public List<T> getGroupByList(T treeSearchEntity, String target) {
        HibernateTemplate template = this.getHibernateTemplate();
        if (template == null) {
            throw new TreeDaoException("TreeAbstractDao :: getGroupByList - getHibernateTemplate is null");
        }
        DetachedCriteria detachedCriteria = this.createDetachedCriteria();
        for (Order order : treeSearchEntity.getOrder()) {
            detachedCriteria.addOrder(order);
        }
        for (Criterion criterion : treeSearchEntity.getCriterions()) {
            detachedCriteria.add(criterion);
        }
        ProjectionList projectList = Projections.projectionList();
        projectList.add((Projection)Projections.groupProperty((String)target));
        detachedCriteria.setProjection((Projection)projectList);
        List list = template.findByCriteria(detachedCriteria, treeSearchEntity.getFirstIndex(), treeSearchEntity.getLastIndex());
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        return list;
    }

    public Map<String, Long> getGroupByList(T treeSearchEntity, String groupProperty, String sumProperty) {
        HibernateTemplate template = this.getHibernateTemplate();
        if (template == null) {
            throw new TreeDaoException("TreeAbstractDao :: getGroupByList - getHibernateTemplate is null");
        }
        DetachedCriteria detachedCriteria = this.createDetachedCriteria();
        HashMap<String, Long> result = new HashMap<String, Long>();
        for (Criterion criterion : treeSearchEntity.getCriterions()) {
            detachedCriteria.add(criterion);
        }
        ProjectionList projectList = Projections.projectionList();
        projectList.add((Projection)Projections.property((String)groupProperty));
        projectList.add((Projection)Projections.sum((String)sumProperty));
        projectList.add((Projection)Projections.groupProperty((String)groupProperty));
        detachedCriteria.setProjection((Projection)projectList);
        List list = template.findByCriteria(detachedCriteria);
        detachedCriteria.setProjection(null);
        if (list.isEmpty()) {
            return result;
        }
        for (Object[] objects : list) {
            result.put((String)objects[0], (Long)objects[1]);
        }
        return result;
    }

    public int getGroupByCount(T treeSearchEntity, String tagert) {
        HibernateTemplate template = this.getHibernateTemplate();
        if (template == null) {
            throw new TreeDaoException("TreeAbstractDao :: getGroupByCount - getHibernateTemplate is null");
        }
        DetachedCriteria detachedCriteria = this.createDetachedCriteria();
        for (Criterion criterion : treeSearchEntity.getCriterions()) {
            detachedCriteria.add(criterion);
        }
        ProjectionList projectList = Projections.projectionList();
        projectList.add((Projection)Projections.groupProperty((String)tagert));
        detachedCriteria.setProjection((Projection)projectList);
        List list = template.findByCriteria(detachedCriteria);
        detachedCriteria.setProjection(null);
        if (list.isEmpty()) {
            return 0;
        }
        return list.size();
    }

    public List<T> getListWithoutPaging(Order order) {
        HibernateTemplate template = this.getHibernateTemplate();
        if (template == null) {
            throw new TreeDaoException(GET_LIST_WITHOUT_PAGING_GET_HIBERNATE_TEMPLATE_IS_NULL);
        }
        DetachedCriteria detachedCriteria = this.createDetachedCriteria();
        detachedCriteria.addOrder(order);
        List list = template.findByCriteria(detachedCriteria);
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        return list;
    }

    public List<T> getListWithoutPaging(T treeSearchEntity) {
        HibernateTemplate template = this.getHibernateTemplate();
        if (template == null) {
            throw new TreeDaoException(GET_LIST_WITHOUT_PAGING_GET_HIBERNATE_TEMPLATE_IS_NULL);
        }
        DetachedCriteria detachedCriteria = this.createDetachedCriteria();
        for (Order order : treeSearchEntity.getOrder()) {
            detachedCriteria.addOrder(order);
        }
        for (Criterion criterion : treeSearchEntity.getCriterions()) {
            detachedCriteria.add(criterion);
        }
        List list = template.findByCriteria(detachedCriteria);
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        return list;
    }

    public List<T> getListWithoutPaging(Order order, Criterion ... criterion) {
        HibernateTemplate template = this.getHibernateTemplate();
        if (template == null) {
            throw new TreeDaoException(GET_LIST_WITHOUT_PAGING_GET_HIBERNATE_TEMPLATE_IS_NULL);
        }
        DetachedCriteria detachedCriteria = this.createDetachedCriteria();
        for (Criterion c : criterion) {
            detachedCriteria.add(c);
        }
        detachedCriteria.addOrder(order);
        List list = template.findByCriteria(detachedCriteria);
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        return list;
    }

    public List<T> getListWithoutPaging(DetachedCriteria detachedCriteria) {
        HibernateTemplate template = this.getHibernateTemplate();
        if (template == null) {
            throw new TreeDaoException(GET_LIST_WITHOUT_PAGING_GET_HIBERNATE_TEMPLATE_IS_NULL);
        }
        List list = template.findByCriteria(detachedCriteria);
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        return list;
    }

    public int getCount(Criterion ... criterions) {
        HibernateTemplate template = this.getHibernateTemplate();
        if (template == null) {
            throw new TreeDaoException(GET_COUNT_GET_HIBERNATE_TEMPLATE_IS_NULL);
        }
        DetachedCriteria detachedCriteria = this.createDetachedCriteria();
        for (Criterion c : criterions) {
            detachedCriteria.add(c);
        }
        detachedCriteria.setProjection(Projections.rowCount());
        List list = template.findByCriteria(detachedCriteria);
        if (list.isEmpty()) {
            return 0;
        }
        Long total = (Long)list.get(0);
        detachedCriteria.setProjection(null);
        return total.intValue();
    }

    public int getCount(T treeSearchEntity) {
        HibernateTemplate template = this.getHibernateTemplate();
        if (template == null) {
            throw new TreeDaoException(GET_COUNT_GET_HIBERNATE_TEMPLATE_IS_NULL);
        }
        DetachedCriteria detachedCriteria = this.createDetachedCriteria();
        for (Criterion c : treeSearchEntity.getCriterions()) {
            detachedCriteria.add(c);
        }
        detachedCriteria.setProjection(Projections.rowCount());
        List list = template.findByCriteria(detachedCriteria);
        if (list.isEmpty()) {
            return 0;
        }
        Long total = (Long)list.get(0);
        detachedCriteria.setProjection(null);
        return total.intValue();
    }

    public int getCount(List<Criterion> criterions) {
        HibernateTemplate template = this.getHibernateTemplate();
        if (template == null) {
            throw new TreeDaoException(GET_COUNT_GET_HIBERNATE_TEMPLATE_IS_NULL);
        }
        DetachedCriteria detachedCriteria = this.createDetachedCriteria();
        for (Criterion c : criterions) {
            detachedCriteria.add(c);
        }
        detachedCriteria.setProjection(Projections.rowCount());
        List list = template.findByCriteria(detachedCriteria);
        if (list.isEmpty()) {
            return 0;
        }
        Long total = (Long)list.get(0);
        detachedCriteria.setProjection(null);
        return total.intValue();
    }

    public int getSum(List<Criterion> criterions, String propertyName) {
        HibernateTemplate template = this.getHibernateTemplate();
        if (template == null) {
            throw new TreeDaoException("TreeAbstractDao :: getSum - getHibernateTemplate is null");
        }
        DetachedCriteria detachedCriteria = this.createDetachedCriteria();
        detachedCriteria.add(Restrictions.isNotNull((String)propertyName));
        for (Criterion c : criterions) {
            detachedCriteria.add(c);
        }
        detachedCriteria.setProjection((Projection)Projections.sum((String)propertyName));
        List list = template.findByCriteria(detachedCriteria);
        if (list.isEmpty()) {
            return 0;
        }
        Long sum = (Long)list.get(0);
        detachedCriteria.setProjection(null);
        return sum != null ? sum.intValue() : 0;
    }

    public int getSum(T treeSearchEntity, String propertyName) {
        HibernateTemplate template = this.getHibernateTemplate();
        if (template == null) {
            throw new TreeDaoException("TreeAbstractDao :: getSum - getHibernateTemplate is null");
        }
        DetachedCriteria criteria = this.getCriteria(treeSearchEntity);
        criteria.add(Restrictions.isNotNull((String)propertyName));
        criteria.setProjection((Projection)Projections.sum((String)propertyName));
        List list = template.findByCriteria(criteria);
        if (list.isEmpty()) {
            return 0;
        }
        Long total = (Long)list.get(0);
        criteria.setProjection(null);
        return total != null ? total.intValue() : 0;
    }

    public T find(ID id, LockMode lockMode) {
        HibernateTemplate template = this.getHibernateTemplate();
        if (template == null) {
            throw new TreeDaoException("TreeAbstractDao :: find - getHibernateTemplate is null");
        }
        return (T)((TreeSearchEntity)template.get(this.getEntityClass(), id, lockMode));
    }

    public T find(ID id, LockMode lockMode, boolean enableCache) {
        HibernateTemplate template = this.getHibernateTemplate();
        if (template == null) {
            throw new TreeDaoException("TreeAbstractDao :: find - getHibernateTemplate is null");
        }
        Object obj = template.get(this.getEntityClass(), id, lockMode);
        if (null != obj && !enableCache) {
            template.refresh(obj);
        }
        return (T)((TreeSearchEntity)obj);
    }

    public void refresh(Object entity) {
        HibernateTemplate template = this.getHibernateTemplate();
        if (template == null) {
            throw new TreeDaoException(REFRESH_GET_HIBERNATE_TEMPLATE_IS_NULL);
        }
        template.refresh(entity);
    }

    public ID store(T newInstance) {
        HibernateTemplate template = this.getHibernateTemplate();
        if (template == null) {
            throw new TreeDaoException(REFRESH_GET_HIBERNATE_TEMPLATE_IS_NULL);
        }
        return (ID)template.save(newInstance);
    }

    public void storeOrUpdate(T newInstance) {
        HibernateTemplate template = this.getHibernateTemplate();
        if (template == null) {
            throw new TreeDaoException(REFRESH_GET_HIBERNATE_TEMPLATE_IS_NULL);
        }
        template.saveOrUpdate(newInstance);
    }

    public void update(T treeSearchEntity) {
        HibernateTemplate template = this.getHibernateTemplate();
        if (template == null) {
            throw new TreeDaoException(REFRESH_GET_HIBERNATE_TEMPLATE_IS_NULL);
        }
        template.update(treeSearchEntity);
        template.flush();
        template.clear();
    }

    public void merge(T treeSearchEntity) {
        HibernateTemplate template = this.getHibernateTemplate();
        if (template == null) {
            throw new TreeDaoException(REFRESH_GET_HIBERNATE_TEMPLATE_IS_NULL);
        }
        template.merge(treeSearchEntity);
    }

    public int bulkUpdate(String queryString, Object ... value) {
        HibernateTemplate template = this.getHibernateTemplate();
        if (template == null) {
            throw new TreeDaoException(REFRESH_GET_HIBERNATE_TEMPLATE_IS_NULL);
        }
        return template.bulkUpdate(queryString, value);
    }

    public void delete(T treeSearchEntity) {
        HibernateTemplate template = this.getHibernateTemplate();
        if (template == null) {
            throw new TreeDaoException(REFRESH_GET_HIBERNATE_TEMPLATE_IS_NULL);
        }
        template.delete(treeSearchEntity);
        template.flush();
        template.clear();
    }

    public void deleteAll(Collection<T> entities) {
        HibernateTemplate template = this.getHibernateTemplate();
        if (template == null) {
            throw new TreeDaoException(REFRESH_GET_HIBERNATE_TEMPLATE_IS_NULL);
        }
        template.deleteAll(entities);
    }

    public void bulkInsert(Collection<T> entities) {
        Session session = this.getCurrentSession();
        session.setCacheMode(CacheMode.IGNORE);
        Transaction tx = session.beginTransaction();
        int i = 0;
        for (TreeSearchEntity t : entities) {
            session.save((Object)t);
            if (i % 50 == 0) {
                session.flush();
                session.clear();
            }
            ++i;
        }
        tx.commit();
        session.close();
    }

    public T excute(HibernateCallback<T> callback) {
        HibernateTemplate template = this.getHibernateTemplate();
        if (template == null) {
            throw new TreeDaoException("TreeAbstractDao :: excute - getHibernateTemplate is null");
        }
        return (T)((TreeSearchEntity)template.execute(callback));
    }

    private Long getId(Object object) {
        String value = "";
        try {
            value = BeanUtils.getProperty((Object)object, (String)"id");
        }
        catch (Exception e) {
            this.logger.error((Object)"no search instance class id");
        }
        if (null == value) {
            throw new TreeDaoException("getId value is null");
        }
        return Long.parseLong(value);
    }

    private Long getId(Object object, String columId) {
        String value = "";
        try {
            value = BeanUtils.getProperty((Object)object, (String)columId);
        }
        catch (Exception e) {
            this.logger.error((Object)"no search instance class id");
        }
        if (null == value) {
            throw new TreeDaoException("getId value is null");
        }
        return Long.parseLong(value);
    }

    public T getByID(ID id) {
        return (T)((TreeSearchEntity)this.getCurrentSession().get(this.getEntityClass(), id));
    }

    public List search(Map<String, Object> parameterMap) {
        Criteria criteria = this.getCurrentSession().createCriteria(this.getEntityClass());
        for (Map.Entry<String, Object> entry : parameterMap.entrySet()) {
            criteria.add(Restrictions.ilike((String)entry.getKey(), (Object)entry.getValue()));
        }
        return criteria.list();
    }

    public ID insert(T entity) {
        return (ID)this.store(entity);
    }

    public void deleteById(ID id) {
        if (null == this.getByID(id)) {
            throw new TreeDaoException("getByID(id) is null");
        }
        this.delete(this.getByID(id));
    }
}

