/*
 * Decompiled with CFR 0.152.
 */
package com.arms.config;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@RefreshScope
public class WebConfig
implements WebMvcConfigurer {
    private static final Logger log = LoggerFactory.getLogger(WebConfig.class);
    @Value(value="${cors.allowed-origins}")
    private String allowedOrigins;

    public void addCorsMappings(CorsRegistry registry) {
        String[] origins;
        for (String origin : origins = this.allowedOrigins.split(",")) {
            log.info("CORS Allowed Origin: {}", (Object)origin);
        }
        registry.addMapping("/**").allowedOrigins(origins).allowedMethods(new String[]{HttpMethod.GET.name(), HttpMethod.HEAD.name(), HttpMethod.POST.name(), HttpMethod.PUT.name(), HttpMethod.DELETE.name()});
    }
}

