/*
 * Decompiled with CFR 0.152.
 */
package com.arms.config;

import javax.servlet.Servlet;
import org.directwebremoting.servlet.DwrServlet;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.PathMatchConfigurer;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.util.UrlPathHelper;

@Configuration
public class DwrConfig
implements WebMvcConfigurer {
    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/dwr/**"}).addResourceLocations(new String[]{"/dwr/"});
    }

    public void addViewControllers(ViewControllerRegistry registry) {
        registry.addViewController("/dwr").setViewName("forward:/dwr/index.html");
    }

    public void configurePathMatch(PathMatchConfigurer configurer) {
        UrlPathHelper urlPathHelper = new UrlPathHelper();
        urlPathHelper.setRemoveSemicolonContent(false);
        configurer.setUrlPathHelper(urlPathHelper);
    }

    @Bean
    public ServletRegistrationBean<DwrServlet> dwrServletRegistration() {
        DwrServlet servlet = new DwrServlet();
        ServletRegistrationBean registration = new ServletRegistrationBean((Servlet)servlet, new String[]{"/dwr/*"});
        registration.setName("dwr");
        registration.addInitParameter("debug", "true");
        registration.addInitParameter("pollAndCometEnabled", "true");
        registration.addInitParameter("activeReverseAjaxEnabled", "true");
        registration.addInitParameter("initApplicationScopeCreatorsAtStartup", "false");
        registration.addInitParameter("jsonpEnabled", "false");
        registration.addInitParameter("org.directwebremoting.extend.ScriptSessionManager", "com.arms.egovframework.javaservice.treeframework.remote.ScriptSessionManager");
        registration.addInitParameter("allowScriptTagRemoting", "true");
        registration.addInitParameter("maxWaitAfterWrite", "60");
        return registration;
    }
}

