/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.wiki.controller;

import com.arms.api.util.aspect.MailSendAlarm;
import com.arms.api.util.communicate.external.EngineService;
import com.arms.api.wiki.model.WikiContentsDTO;
import com.arms.api.wiki.model.WikiDTO;
import com.arms.api.wiki.model.WikiEntity;
import com.arms.api.wiki.service.WikiService;
import com.arms.egovframework.javaservice.treeframework.TreeConstant;
import com.arms.egovframework.javaservice.treeframework.controller.CommonResponse;
import com.arms.egovframework.javaservice.treeframework.controller.TreeAbstractController;
import com.arms.egovframework.javaservice.treeframework.interceptor.SessionUtil;
import com.arms.egovframework.javaservice.treeframework.model.TreeSearchEntity;
import com.arms.egovframework.javaservice.treeframework.util.ParameterParser;
import com.arms.egovframework.javaservice.treeframework.util.Util_TitleChecker;
import com.arms.egovframework.javaservice.treeframework.validation.group.AddNode;
import com.arms.egovframework.javaservice.treeframework.validation.group.AlterNode;
import com.arms.egovframework.javaservice.treeframework.validation.group.AlterNodeType;
import com.arms.egovframework.javaservice.treeframework.validation.group.MoveNode;
import com.arms.egovframework.javaservice.treeframework.validation.group.RemoveNode;
import com.arms.egovframework.javaservice.treeframework.validation.group.UpdateNode;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ui.ModelMap;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/arms/wiki"})
public class WikiController
extends TreeAbstractController<WikiService, WikiDTO, WikiEntity> {
    private static final Logger log = LoggerFactory.getLogger(WikiController.class);
    private final WikiService wikiService;
    private final EngineService engineService;

    @ResponseBody
    @RequestMapping(value={"/{changeReqTableName}/getNode.do"}, method={RequestMethod.GET})
    public ModelAndView getNode(@PathVariable(value="changeReqTableName") String changeReqTableName, WikiDTO wikiDTO, HttpServletRequest request) throws Exception {
        log.info("WikiController :: getNode");
        WikiEntity wikiEntity = (WikiEntity)this.modelMapper.map((Object)wikiDTO, WikiEntity.class);
        ParameterParser parser = new ParameterParser((ServletRequest)request);
        if (parser.getInt("c_id") <= 0) {
            throw new RuntimeException("c_id is minus value");
        }
        SessionUtil.setAttribute((String)"getNode", (Object)changeReqTableName);
        WikiEntity wiki = (WikiEntity)this.wikiService.getNode((TreeSearchEntity)wikiEntity);
        SessionUtil.removeAttribute((String)"getNode");
        ModelAndView modelAndView = new ModelAndView("jsonView");
        modelAndView.addObject("result", (Object)wiki);
        return modelAndView;
    }

    @ResponseBody
    @RequestMapping(value={"/{wikiId}/getWiki.do"}, method={RequestMethod.GET})
    public ModelAndView getWiki(@PathVariable(value="wikiId") String wikiId, HttpServletRequest request) throws Exception {
        log.info("WikiController :: getWiki");
        WikiContentsDTO wikiContentsDTO = (WikiContentsDTO)Optional.ofNullable((CommonResponse.ApiResult)this.engineService.getWiki(wikiId).getBody()).orElse(new CommonResponse.ApiResult()).getResponse();
        ModelAndView modelAndView = new ModelAndView("jsonView");
        modelAndView.addObject("result", (Object)wikiContentsDTO);
        return modelAndView;
    }

    @ResponseBody
    @RequestMapping(value={"/{wikiId}/{version}/getWiki.do"}, method={RequestMethod.GET})
    public ModelAndView getWiki(@PathVariable(value="wikiId") String wikiId, @PathVariable(value="version") Long version, HttpServletRequest request) throws Exception {
        log.info("WikiController :: getWiki");
        WikiContentsDTO wikiContentsDTO = (WikiContentsDTO)Optional.ofNullable((CommonResponse.ApiResult)this.engineService.getWiki(wikiId, version).getBody()).orElse(new CommonResponse.ApiResult()).getResponse();
        ModelAndView modelAndView = new ModelAndView("jsonView");
        modelAndView.addObject("result", (Object)wikiContentsDTO);
        return modelAndView;
    }

    @ResponseBody
    @GetMapping(value={"/{wikiId}/getWikiVersions.do"})
    public ModelAndView getWikiVersions(@PathVariable(value="wikiId") String wikiId, @RequestParam(value="size") int size, @RequestParam(value="page") int page, HttpServletRequest request) throws Exception {
        log.info("WikiController :: getWikiVersions");
        ModelAndView modelAndView = new ModelAndView("jsonView");
        modelAndView.addObject("result", (Object)this.engineService.getWikiVersions(wikiId, size, page));
        return modelAndView;
    }

    @ResponseBody
    @RequestMapping(value={"/{changeReqTableName}/getChildNode.do"}, method={RequestMethod.GET})
    public ModelAndView getChildNode(@PathVariable(value="changeReqTableName") String changeReqTableName, WikiDTO wikiDTO, HttpServletRequest request) throws Exception {
        log.info("WikiController :: getChildNode");
        WikiEntity wikiEntity = (WikiEntity)this.modelMapper.map((Object)wikiDTO, WikiEntity.class);
        ParameterParser parser = new ParameterParser((ServletRequest)request);
        if (parser.getInt("c_id") <= 0) {
            throw new RuntimeException("c_id is minus value");
        }
        SessionUtil.setAttribute((String)"getChildNode", (Object)changeReqTableName);
        wikiEntity.setWhere("c_parentid", (Object)Long.valueOf(parser.get("c_id")));
        wikiEntity.setOrder(Order.asc((String)"c_position"));
        List wikiList = this.wikiService.getChildNode((TreeSearchEntity)wikiEntity);
        SessionUtil.removeAttribute((String)"getChildNode");
        ModelAndView modelAndView = new ModelAndView("jsonView");
        modelAndView.addObject("result", (Object)wikiList);
        return modelAndView;
    }

    @ResponseBody
    @RequestMapping(value={"/{changeReqTableName}/getNodesWithoutRoot.do"}, method={RequestMethod.GET})
    public ModelAndView getNodesWithoutRoot(@PathVariable(value="changeReqTableName") String changeReqTableName, WikiDTO wikiDTO) throws Exception {
        log.info("WikiController :: getNodesWithoutRoot");
        WikiEntity wikiEntity = (WikiEntity)this.modelMapper.map((Object)wikiDTO, WikiEntity.class);
        SessionUtil.setAttribute((String)"getNodesWithoutRoot", (Object)changeReqTableName);
        wikiEntity.setOrder(Order.asc((String)"c_position"));
        Criterion criterion = Restrictions.not((Criterion)Restrictions.in((String)"c_id", (Object[])new Object[]{TreeConstant.ROOT_CID, TreeConstant.First_Node_CID}));
        wikiEntity.getCriterions().add(criterion);
        List wikiList = this.wikiService.getChildNode((TreeSearchEntity)wikiEntity);
        SessionUtil.removeAttribute((String)"getNodesWithoutRoot");
        ModelAndView modelAndView = new ModelAndView("jsonView");
        HashMap resultMap = Maps.newHashMap();
        resultMap.put("paginationInfo", wikiEntity.getPaginationInfo());
        resultMap.put("result", wikiList);
        modelAndView.addObject("result", (Object)resultMap);
        return modelAndView;
    }

    @ResponseBody
    @RequestMapping(value={"/{changeReqTableName}/getPaginatedChildNode.do"}, method={RequestMethod.GET})
    public ModelAndView getPaginatedChildNode(@PathVariable(value="changeReqTableName") String changeReqTableName, WikiDTO wikiDTO, ModelMap model, HttpServletRequest request) throws Exception {
        log.info("WikiController :: getPaginatedChildNode");
        WikiEntity wikiEntity = (WikiEntity)this.modelMapper.map((Object)wikiDTO, WikiEntity.class);
        SessionUtil.setAttribute((String)"getPaginatedChildNode", (Object)changeReqTableName);
        if (wikiEntity.getC_id() <= 0L || wikiEntity.getPageIndex() <= 0 || wikiEntity.getPageUnit() <= 0 || wikiEntity.getPageSize() <= 0) {
            throw new RuntimeException();
        }
        wikiEntity.setWhere("c_parentid", (Object)wikiEntity.getC_id());
        List wikiList = this.wikiService.getPaginatedChildNode((TreeSearchEntity)wikiEntity);
        wikiEntity.getPaginationInfo().setTotalRecordCount(wikiList.size());
        SessionUtil.removeAttribute((String)"getPaginatedChildNode");
        ModelAndView modelAndView = new ModelAndView("jsonView");
        HashMap resultMap = Maps.newHashMap();
        resultMap.put("paginationInfo", wikiEntity.getPaginationInfo());
        resultMap.put("result", wikiList);
        modelAndView.addObject("result", (Object)resultMap);
        return modelAndView;
    }

    @ResponseBody
    @RequestMapping(value={"/{changeReqTableName}/searchNode.do"}, method={RequestMethod.GET})
    public ModelAndView searchNode(@PathVariable(value="changeReqTableName") String changeReqTableName, WikiDTO wikiDTO, ModelMap model, HttpServletRequest request) throws Exception {
        log.info("WikiController :: searchNode");
        WikiEntity wikiEntity = (WikiEntity)this.modelMapper.map((Object)wikiDTO, WikiEntity.class);
        ParameterParser parser = new ParameterParser((ServletRequest)request);
        if (!StringUtils.hasText((String)request.getParameter("searchString"))) {
            throw new RuntimeException("searchString is null");
        }
        SessionUtil.setAttribute((String)"searchNode", (Object)changeReqTableName);
        wikiEntity.setWhereLike("c_title", parser.get("parser"));
        ModelAndView modelAndView = new ModelAndView("jsonView");
        modelAndView.addObject("result", (Object)this.wikiService.searchNode((TreeSearchEntity)wikiEntity));
        SessionUtil.removeAttribute((String)"searchNode");
        return modelAndView;
    }

    @ResponseBody
    @RequestMapping(value={"/{changeReqTableName}/addNode.do"}, method={RequestMethod.POST})
    @MailSendAlarm(subject="\ubb38\uc11c \ub4f1\ub85d", content="\ubb38\uc11c\uac00 \ub4f1\ub85d \ub418\uc5c8\uc2b5\ub2c8\ub2e4.")
    public ModelAndView addNode(@PathVariable(value="changeReqTableName") String changeReqTableName, @Validated(value={AddNode.class}) WikiDTO wikiDTO, BindingResult bindingResult, ModelMap model) throws Exception {
        log.info("WikiController :: addNode");
        WikiEntity wikiEntity = (WikiEntity)this.modelMapper.map((Object)wikiDTO, WikiEntity.class);
        SessionUtil.setAttribute((String)"addNode", (Object)changeReqTableName);
        wikiEntity.setC_title(Util_TitleChecker.StringReplace((String)wikiEntity.getC_title()));
        WikiEntity newWiki = (WikiEntity)this.wikiService.addNode((TreeSearchEntity)wikiEntity);
        ModelAndView modelAndView = new ModelAndView("jsonView");
        modelAndView.addObject("result", (Object)newWiki);
        String wikiIdPrefix = changeReqTableName.replace("T_ARMS_", "");
        WikiContentsDTO wikiContentsDTO = WikiContentsDTO.builder().wikiId(wikiIdPrefix + "_" + newWiki.getC_id()).pdServiceId(wikiIdPrefix.replaceAll("[^0-9]", "")).build();
        this.engineService.createWiki(wikiContentsDTO);
        SessionUtil.removeAttribute((String)"addNode");
        return modelAndView;
    }

    @ResponseBody
    @RequestMapping(value={"/{changeReqTableName}/removeNode.do"}, method={RequestMethod.DELETE})
    public ModelAndView removeNode(@PathVariable(value="changeReqTableName") String changeReqTableName, @Validated(value={RemoveNode.class}) WikiDTO wikiDTO, BindingResult bindingResult, ModelMap model) throws Exception {
        log.info("WikiController :: removeNode");
        WikiEntity wikiEntity = (WikiEntity)this.modelMapper.map((Object)wikiDTO, WikiEntity.class);
        SessionUtil.setAttribute((String)"removeNode", (Object)changeReqTableName);
        wikiEntity.setStatus((long)this.wikiService.removeNode((TreeSearchEntity)wikiEntity));
        this.setJsonDefaultSetting((TreeSearchEntity)wikiEntity);
        SessionUtil.removeAttribute((String)"removeNode");
        String wikiId = changeReqTableName.replace("T_ARMS_", "") + "_" + wikiDTO.getC_id();
        this.engineService.deleteWiki(wikiId);
        ModelAndView modelAndView = new ModelAndView("jsonView");
        modelAndView.addObject("result", (Object)wikiEntity);
        return modelAndView;
    }

    @ResponseBody
    @RequestMapping(value={"/{changeReqTableName}/updateNode.do"}, method={RequestMethod.PUT})
    public ModelAndView updateNode(@PathVariable(value="changeReqTableName") String changeReqTableName, @Validated(value={UpdateNode.class}) WikiDTO wikiDTO, BindingResult bindingResult, HttpServletRequest request, ModelMap model) throws Exception {
        log.info("WikiController :: updateNode");
        WikiEntity wikiEntity = (WikiEntity)this.modelMapper.map((Object)wikiDTO, WikiEntity.class);
        SessionUtil.setAttribute((String)"updateNode", (Object)changeReqTableName);
        ModelAndView modelAndView = new ModelAndView("jsonView");
        modelAndView.addObject("result", (Object)this.wikiService.updateNode((TreeSearchEntity)wikiEntity));
        SessionUtil.removeAttribute((String)"updateNode");
        return modelAndView;
    }

    @ResponseBody
    @RequestMapping(value={"/updateWiki.do"}, method={RequestMethod.PUT})
    @MailSendAlarm(subject="\ubb38\uc11c \uc218\uc815", content="\ubb38\uc11c\uac00 \uc218\uc815 \ub418\uc5c8\uc2b5\ub2c8\ub2e4.")
    public ModelAndView updateWiki(@RequestBody WikiContentsDTO wikiContentsDTO, HttpServletRequest request) throws Exception {
        log.info("WikiController :: updateWiki");
        ModelAndView modelAndView = new ModelAndView("jsonView");
        modelAndView.addObject("result", (Object)this.engineService.updateWiki(wikiContentsDTO));
        return modelAndView;
    }

    @ResponseBody
    @RequestMapping(value={"/changeRecent.do"}, method={RequestMethod.PUT})
    public ModelAndView changeRecent(@RequestBody WikiContentsDTO wikiContentsDTO, HttpServletRequest request) throws Exception {
        log.info("WikiController :: changeRecent");
        ModelAndView modelAndView = new ModelAndView("jsonView");
        modelAndView.addObject("result", (Object)this.engineService.changeRecent(wikiContentsDTO));
        return modelAndView;
    }

    @ResponseBody
    @RequestMapping(value={"/{changeReqTableName}/alterNode.do"}, method={RequestMethod.PUT})
    public ModelAndView alterNode(@PathVariable(value="changeReqTableName") String changeReqTableName, @Validated(value={AlterNode.class}) WikiDTO wikiDTO, BindingResult bindingResult, ModelMap model) throws Exception {
        log.info("WikiController :: alterNode");
        WikiEntity wikiEntity = (WikiEntity)this.modelMapper.map((Object)wikiDTO, WikiEntity.class);
        SessionUtil.setAttribute((String)"alterNode", (Object)changeReqTableName);
        wikiEntity.setC_title(Util_TitleChecker.StringReplace((String)wikiEntity.getC_title()));
        wikiEntity.setStatus((long)this.wikiService.alterNode((TreeSearchEntity)wikiEntity));
        this.setJsonDefaultSetting((TreeSearchEntity)wikiEntity);
        SessionUtil.removeAttribute((String)"alterNode");
        ModelAndView modelAndView = new ModelAndView("jsonView");
        modelAndView.addObject("result", (Object)wikiEntity);
        return modelAndView;
    }

    @ResponseBody
    @RequestMapping(value={"/{changeReqTableName}/alterNodeType.do"}, method={RequestMethod.PUT})
    public ModelAndView alterNodeType(@PathVariable(value="changeReqTableName") String changeReqTableName, @Validated(value={AlterNodeType.class}) WikiDTO wikiDTO, BindingResult bindingResult, ModelMap model) throws Exception {
        log.info("WikiController :: alterNodeType");
        SessionUtil.setAttribute((String)"alterNodeType", (Object)changeReqTableName);
        WikiEntity wikiEntity = (WikiEntity)this.modelMapper.map((Object)wikiDTO, WikiEntity.class);
        this.wikiService.alterNodeType((TreeSearchEntity)wikiEntity);
        this.setJsonDefaultSetting((TreeSearchEntity)wikiEntity);
        SessionUtil.removeAttribute((String)"alterNodeType");
        ModelAndView modelAndView = new ModelAndView("jsonView");
        modelAndView.addObject("result", (Object)wikiEntity);
        return modelAndView;
    }

    @ResponseBody
    @RequestMapping(value={"/{changeReqTableName}/moveNode.do"}, method={RequestMethod.POST})
    public ModelAndView moveNode(@PathVariable(value="changeReqTableName") String changeReqTableName, @Validated(value={MoveNode.class}) WikiDTO wikiDTO, BindingResult bindingResult, ModelMap model, HttpServletRequest request) throws Exception {
        log.info("WikiController :: moveNode");
        SessionUtil.setAttribute((String)"moveNode", (Object)changeReqTableName);
        WikiEntity wikiEntity = (WikiEntity)this.modelMapper.map((Object)wikiDTO, WikiEntity.class);
        this.wikiService.moveNode((TreeSearchEntity)wikiEntity, request);
        this.setJsonDefaultSetting((TreeSearchEntity)wikiEntity);
        SessionUtil.removeAttribute((String)"moveNode");
        ModelAndView modelAndView = new ModelAndView("jsonView");
        modelAndView.addObject("result", (Object)wikiEntity);
        return modelAndView;
    }

    @ResponseBody
    @RequestMapping(value={"/{changeReqTableName}/getMonitor.do"}, method={RequestMethod.GET})
    public ModelAndView getMonitor(@PathVariable(value="changeReqTableName") String changeReqTableName, WikiDTO wikiDTO, ModelMap model, HttpServletRequest request) throws Exception {
        log.info("WikiController :: getMonitor");
        SessionUtil.setAttribute((String)"getMonitor", (Object)changeReqTableName);
        WikiEntity wikiEntity = (WikiEntity)this.modelMapper.map((Object)wikiDTO, WikiEntity.class);
        wikiEntity.setOrder(Order.asc((String)"c_position"));
        List wikiList = this.wikiService.getChildNode((TreeSearchEntity)wikiEntity);
        SessionUtil.removeAttribute((String)"getMonitor");
        ModelAndView modelAndView = new ModelAndView("jsonView");
        modelAndView.addObject("result", (Object)wikiList);
        return modelAndView;
    }

    @ResponseBody
    @RequestMapping(value={"/imageUpload.do"}, method={RequestMethod.POST})
    public ModelAndView imageUpload(MultipartHttpServletRequest multiRequest) {
        ModelAndView modelAndView = new ModelAndView("jsonView");
        modelAndView.addObject("result", (Object)this.wikiService.imageUpload(multiRequest));
        return modelAndView;
    }

    public WikiController(WikiService wikiService, EngineService engineService) {
        this.wikiService = wikiService;
        this.engineService = engineService;
    }
}

