/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.util.filerepository.service;

import com.arms.api.globaltreemap.model.GlobalContentsTreeMapEntity;
import com.arms.api.globaltreemap.model.GlobalTreeMapEntity;
import com.arms.api.globaltreemap.service.GlobalContentsTreeMapService;
import com.arms.api.globaltreemap.service.GlobalTreeMapService;
import com.arms.api.util.filerepository.model.FileRepositoryEntity;
import com.arms.api.util.filerepository.service.FileRepository;
import com.arms.egovframework.javaservice.treeframework.model.TreeSearchEntity;
import com.arms.egovframework.javaservice.treeframework.service.TreeServiceImpl;
import com.arms.egovframework.javaservice.treeframework.util.ParameterParser;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="fileRepository")
public class FileRepositoryImpl
extends TreeServiceImpl
implements FileRepository {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private GlobalTreeMapService globalTreeMapService;
    @Autowired
    private GlobalContentsTreeMapService globalContentsTreeMapService;

    @Transactional
    public HashMap<String, Set<FileRepositoryEntity>> getFileSetByFileIdLink(ParameterParser parser) throws Exception {
        GlobalTreeMapEntity globalTreeMap = new GlobalTreeMapEntity();
        globalTreeMap.setPdservice_link(Long.valueOf(parser.getLong("fileIdLink")));
        List treeMapListByFileIdLink = this.globalTreeMapService.findAllBy(globalTreeMap);
        TreeSet<FileRepositoryEntity> returnFileSet = new TreeSet<FileRepositoryEntity>(Comparator.comparing(FileRepositoryEntity::getC_id).reversed());
        HashMap<String, Set<FileRepositoryEntity>> returnMap = new HashMap<String, Set<FileRepositoryEntity>>();
        for (GlobalTreeMapEntity row : treeMapListByFileIdLink) {
            if (row.getFilerepository_link() == null) continue;
            this.logger.info("row.getFilerepository_link() = " + row.getFilerepository_link());
            FileRepositoryEntity entity = new FileRepositoryEntity();
            entity.setC_id(row.getFilerepository_link());
            FileRepositoryEntity returnEntity = (FileRepositoryEntity)this.getNode((TreeSearchEntity)entity);
            if (returnEntity == null) continue;
            returnFileSet.add(returnEntity);
        }
        returnMap.put("files", returnFileSet);
        return returnMap;
    }

    public HashMap<String, Set<FileRepositoryEntity>> getFileSetByFileIdLinkWithGlobalContentsMap(ParameterParser parser) throws Exception {
        GlobalContentsTreeMapEntity globalContentsTreeMapEntity = new GlobalContentsTreeMapEntity();
        globalContentsTreeMapEntity.setPdservicedetail_link(Long.valueOf(parser.getLong("fileIdLink")));
        List treeMapListByFileIdLink = this.globalContentsTreeMapService.findAllBy(globalContentsTreeMapEntity);
        TreeSet<FileRepositoryEntity> returnFileSet = new TreeSet<FileRepositoryEntity>(Comparator.comparing(FileRepositoryEntity::getC_id).reversed());
        HashMap<String, Set<FileRepositoryEntity>> returnMap = new HashMap<String, Set<FileRepositoryEntity>>();
        for (GlobalContentsTreeMapEntity row : treeMapListByFileIdLink) {
            if (row.getFilerepository_link() == null) continue;
            this.logger.info("row.getFilerepository_link() = " + row.getFilerepository_link());
            FileRepositoryEntity entity = new FileRepositoryEntity();
            entity.setC_id(row.getFilerepository_link());
            FileRepositoryEntity returnEntity = (FileRepositoryEntity)this.getNode((TreeSearchEntity)entity);
            if (returnEntity == null) continue;
            returnFileSet.add(returnEntity);
        }
        returnMap.put("files", returnFileSet);
        return returnMap;
    }
}

