/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.util.dynamicscheduler.service;

import com.arms.api.globaltreemap.model.GlobalTreeMapEntity;
import com.arms.api.globaltreemap.service.GlobalTreeMapService;
import com.arms.api.jira.jiraproject.service.JiraProject;
import com.arms.api.jira.jiraproject_pure.model.JiraProjectPureEntity;
import com.arms.api.jira.jiraproject_pure.service.JiraProjectPure;
import com.arms.api.jira.jiraserver.model.JiraServerEntity;
import com.arms.api.jira.jiraserver.service.JiraServer;
import com.arms.api.jira.jiraserver_pure.model.JiraServerPureEntity;
import com.arms.api.jira.jiraserver_pure.service.JiraServerPure;
import com.arms.api.product_service.pdservice_pure.model.PdServicePureEntity;
import com.arms.api.product_service.pdservice_pure.service.PdServicePure;
import com.arms.api.product_service.pdserviceversion.model.PdServiceVersionEntity;
import com.arms.api.product_service.pdserviceversion.service.PdServiceVersion;
import com.arms.api.requirement.reqstate.service.ReqState;
import com.arms.api.requirement.reqstate_category.service.ReqStateCategory;
import com.arms.api.requirement.reqstatus.model.CRUDType;
import com.arms.api.requirement.reqstatus.model.ReqStatusDTO;
import com.arms.api.requirement.reqstatus.model.ReqStatusEntity;
import com.arms.api.requirement.reqstatus.service.ReqStatus;
import com.arms.api.util.TreeServiceUtils;
import com.arms.api.util.UUIDUtil;
import com.arms.api.util.aspect.DwrSendAlarm;
import com.arms.api.util.aspect.MailSendAlarm;
import com.arms.api.util.aspect.SlackSendAlarm;
import com.arms.api.util.communicate.external.EngineService;
import com.arms.api.util.communicate.external.request.\uc99d\ubd84\uc774\uc288\uc218\uc9d1RequestDTO;
import com.arms.api.util.communicate.external.response.jira.AlmIssue;
import com.arms.api.util.communicate.external.response.jira.CReqProperty;
import com.arms.api.util.communicate.internal.InternalService;
import com.arms.api.util.dynamicscheduler.model.SchedulerType;
import com.arms.api.util.dynamicscheduler.service.SchedulerService;
import com.arms.egovframework.javaservice.treeframework.model.TreeSearchEntity;
import com.arms.egovframework.javaservice.treeframework.remote.Chat;
import com.arms.egovframework.javaservice.treeframework.service.TreeService;
import com.arms.egovframework.javaservice.treeframework.service.TreeServiceImpl;
import com.arms.egovframework.javaservice.treeframework.util.StringUtils;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.modelmapper.ModelMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service(value="\uc2a4\ucf00\uc974\ub7ec")
public class SchedulerServiceImpl
extends TreeServiceImpl
implements SchedulerService {
    private static final Logger log = LoggerFactory.getLogger(SchedulerServiceImpl.class);
    private final PdServicePure pdServicePure;
    private final ReqStatus reqStatus;
    private final JiraServerPure jiraServerPure;
    private final JiraServer jiraServer;
    private final EngineService engineService;
    private final InternalService internalService;
    private final JiraProject jiraProject;
    private final JiraProjectPure jiraProjectPure;
    private final ReqState reqState;
    private final ReqStateCategory reqStateCategory;
    private final DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    protected final Chat chat;
    protected final ModelMapper modelMapper;
    private final GlobalTreeMapService globalTreeMapService;
    private final PdServiceVersion pdServiceVersion;

    @Async
    @DwrSendAlarm(messageOnStart="\uc804\uccb4 \uc774\uc288 \uc218\uc9d1 \uc694\uccad")
    @SlackSendAlarm(messageOnStart="\uc804\uccb4 \uc774\uc288 \uc218\uc9d1 \uc694\uccad\uc744 \ud558\uc600\uc2b5\ub2c8\ub2e4.")
    public void discoverByFullDateRange(SchedulerType schedulerEnum) throws Exception {
        String logMessagePrefix = "[ SchedulerServiceImpl :: executeSequentialSchedules ]";
        String shortUUID = UUIDUtil.createShortUUID();
        LocalDateTime startTime = LocalDateTime.now();
        log.info("[{}] :: {} :: {} :: started at {}", new Object[]{shortUUID, logMessagePrefix, schedulerEnum.getType(), startTime.format(this.timeFormatter)});
        String yesterday = LocalDate.now().minusDays(1L).format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        this.incrementSchedulesWithRange(schedulerEnum, null, yesterday);
        LocalDateTime endTime = LocalDateTime.now();
        Duration elapsed = Duration.between(startTime, endTime);
        log.info("[{}] :: {} :: {} :: finished at {} (completed in {} ms)", new Object[]{shortUUID, logMessagePrefix, schedulerEnum.getType(), endTime.format(this.timeFormatter), elapsed.toMillis()});
    }

    @Async
    @DwrSendAlarm(messageOnStart="\uc791\uc77c \uc774\uc288 \uc218\uc9d1 \uc694\uccad")
    @SlackSendAlarm(messageOnStart="\uc791\uc77c \uc774\uc288 \uc218\uc9d1 \uc694\uccad\uc744 \ud558\uc600\uc2b5\ub2c8\ub2e4.")
    public void discoverByPreviousDay(SchedulerType schedulerEnum) throws Exception {
        String yesterday = LocalDate.now().minusDays(1L).format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        String logMessagePrefix = "[ SchedulerServiceImpl :: discoverByPreviousDay ]";
        String shortUUID = UUIDUtil.createShortUUID();
        LocalDateTime startTime = LocalDateTime.now();
        log.info("[{}] :: {} :: {} :: started at {}", new Object[]{shortUUID, logMessagePrefix, schedulerEnum.getType(), startTime.format(this.timeFormatter)});
        this.incrementSchedulesWithRange(schedulerEnum, yesterday, yesterday);
        LocalDateTime endTime = LocalDateTime.now();
        Duration elapsed = Duration.between(startTime, endTime);
        log.info("[{}] :: {} :: {} :: finished at {} (completed in {} ms)", new Object[]{shortUUID, logMessagePrefix, schedulerEnum.getType(), endTime.format(this.timeFormatter), elapsed.toMillis()});
    }

    @Async
    @DwrSendAlarm(messageOnStart="\uae30\uac04\ubcc4 \uc774\uc288 \uc218\uc9d1 \uc694\uccad")
    @SlackSendAlarm(messageOnStart="\uae30\uac04\ubcc4 \uc774\uc288 \uc218\uc9d1 \uc694\uccad\uc744 \ud558\uc600\uc2b5\ub2c8\ub2e4.")
    public void discoverByDateRange(SchedulerType schedulerEnum, String startDate, String endDate) throws Exception {
        String logMessagePrefix = "[ SchedulerServiceImpl :: discoverByDateRange ]";
        String shortUUID = UUIDUtil.createShortUUID();
        LocalDateTime startTime = LocalDateTime.now();
        log.info("[{}] :: {} :: {} :: started at {}", new Object[]{shortUUID, logMessagePrefix, schedulerEnum.getType(), startTime.format(this.timeFormatter)});
        this.incrementSchedulesWithRange(schedulerEnum, startDate, endDate);
        LocalDateTime endTime = LocalDateTime.now();
        Duration elapsed = Duration.between(startTime, endTime);
        log.info("[{}] :: {} :: {} :: finished at {} (completed in {} ms)", new Object[]{shortUUID, logMessagePrefix, schedulerEnum.getType(), endTime.format(this.timeFormatter), elapsed.toMillis()});
    }

    private List<PdServicePureEntity> reqStatus_\uc5d4\uc9c4\uc5d0_\ub3d9\uae30\ud654_\uadf8\ub9ac\uace0_pdService\ubaa9\ub85d\ub9ac\ud134(String logMessagePrefix) throws Exception {
        List pdServicePureEntities = this.pdServicePure.getNodesWithoutRoot((TreeSearchEntity)new PdServicePureEntity());
        for (PdServicePureEntity pdServicePureEntity : pdServicePureEntities) {
            Long pdServiceEntityCId = pdServicePureEntity.getC_id();
            List searchReqStatusEntities = this.internalService.\uc81c\ud488\ubcc4_\uc694\uad6c\uc0ac\ud56d_\uc0c1\ud669_\uc870\ud68c("T_ARMS_REQSTATUS_" + pdServiceEntityCId, new ReqStatusDTO());
            if (searchReqStatusEntities == null || searchReqStatusEntities.isEmpty()) {
                log.info("{} :: {} \uc81c\ud488\uc758 \uc694\uad6c\uc0ac\ud56d\uc774 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.", (Object)logMessagePrefix, (Object)pdServicePureEntity.getC_title());
                continue;
            }
            for (ReqStatusEntity reqStatusEntity : searchReqStatusEntities) {
                if (CRUDType.\uc18c\ud504\ud2b8_\uc0ad\uc81c.getType().equals(reqStatusEntity.getC_etc())) continue;
                Optional optionalJiraServerPureEntity = TreeServiceUtils.getNodeOptional((TreeService)this.jiraServerPure, (Long)reqStatusEntity.getC_jira_server_link(), JiraServerPureEntity.class);
                optionalJiraServerPureEntity.ifPresentOrElse(jiraServerPureEntity -> {
                    if (this.isValidReqStatus(reqStatusEntity, jiraServerPureEntity, logMessagePrefix)) {
                        this.engineService.saveRequirementIssueKeyOnlyFirst(jiraServerPureEntity.getC_jira_server_etc(), reqStatusEntity.getC_title(), reqStatusEntity.getC_id(), reqStatusEntity.getC_issue_key(), reqStatusEntity.getC_pdservice_link(), this.convertVersionToArray(reqStatusEntity.getC_req_pdservice_versionset_link()), reqStatusEntity.getC_req_link(), reqStatusEntity.getC_jira_project_key(), CReqProperty.of((ReqStatusEntity)reqStatusEntity));
                    }
                }, () -> log.info("{} :: \uc9c0\ub77c\uc11c\ubc84\uac00 \uc870\ud68c\ub418\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4. C_ID = {}", (Object)logMessagePrefix, (Object)reqStatusEntity.getC_jira_server_link()));
            }
        }
        return pdServicePureEntities;
    }

    private void incrementSchedulesWithRange(SchedulerType schedulerEnum, String startDate, String endDate) throws Exception {
        String logMessagePrefix = "[ SchedulerServiceImpl :: saveReqStatusToElasticsearch ]";
        String shortUUID = UUIDUtil.createShortUUID();
        LocalDateTime startTime = LocalDateTime.now();
        log.info("[{}] :: {} :: {} :: started at {}", new Object[]{shortUUID, logMessagePrefix, schedulerEnum.getType(), startTime.format(this.timeFormatter)});
        List nodesWithoutRoot = this.jiraServerPure.getNodesWithoutRoot(new JiraServerPureEntity());
        List serverIds = nodesWithoutRoot.stream().map(JiraServerPureEntity::getC_jira_server_etc).collect(Collectors.toList());
        Map jiraProjectsByJiraServerIds = this.jiraProjectsByJiraServerId();
        this.reqStatus_\uc5d4\uc9c4\uc5d0_\ub3d9\uae30\ud654_\uadf8\ub9ac\uace0_pdService\ubaa9\ub85d\ub9ac\ud134(logMessagePrefix);
        List serverProjectInfos = serverIds.stream().filter(serverId -> jiraProjectsByJiraServerIds.get(serverId) != null).flatMap(serverId -> ((List)jiraProjectsByJiraServerIds.get(serverId)).stream().map(projectKey -> \uc99d\ubd84\uc774\uc288\uc218\uc9d1RequestDTO.ServerProjectInfo.builder().serverId(serverId).projectKey(projectKey).build())).collect(Collectors.toList());
        \uc99d\ubd84\uc774\uc288\uc218\uc9d1RequestDTO requestDTO = \uc99d\ubd84\uc774\uc288\uc218\uc9d1RequestDTO.builder().serverProjectInfos(serverProjectInfos).startDate(startDate).endDate(endDate).build();
        this.engineService.\uc99d\ubd84\uc774\uc288\uc218\uc9d1(requestDTO);
    }

    private Map<String, List<String>> jiraProjectsByJiraServerId() throws Exception {
        List nodesWithoutRoot = this.pdServiceVersion.getNodesWithoutRoot((TreeSearchEntity)new PdServiceVersionEntity());
        List collect = nodesWithoutRoot.stream().map(PdServiceVersionEntity::getC_id).collect(Collectors.toList());
        List jiraProjectLinkByPdServiceVersionLink = this.globalTreeMapService.findAllByIds(collect, "pdserviceversion_link").stream().map(GlobalTreeMapEntity::getJiraproject_link).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        return this.globalTreeMapService.findAllByIds(jiraProjectLinkByPdServiceVersionLink, "jiraproject_link").stream().filter(a -> a.getJiraserver_link() != null).collect(Collectors.groupingBy(a -> {
            JiraServerPureEntity jiraServerPureEntity = new JiraServerPureEntity();
            jiraServerPureEntity.setC_id(a.getJiraserver_link());
            try {
                return ((JiraServerPureEntity)this.jiraServerPure.getNode((TreeSearchEntity)jiraServerPureEntity)).getC_jira_server_etc();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }, Collectors.mapping(a -> {
            JiraProjectPureEntity jiraProjectPureEntity = new JiraProjectPureEntity();
            jiraProjectPureEntity.setC_id(a.getJiraproject_link());
            try {
                return ((JiraProjectPureEntity)this.jiraProjectPure.getNode((TreeSearchEntity)jiraProjectPureEntity)).getC_jira_key();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }, Collectors.toList())));
    }

    @Async
    @DwrSendAlarm(messageOnStart="\uac01 \uc81c\ud488\uc11c\ube44\uc2a4 \ubcc4 \uc694\uad6c\uc0ac\ud56d Status \uc5c5\ub370\uc774\ud2b8")
    @SlackSendAlarm(messageOnStart="\uac01 \uc81c\ud488\uc11c\ube44\uc2a4 \ubcc4 \uc694\uad6c\uc0ac\ud56d Status \uc5c5\ub370\uc774\ud2b8\uac00 \uc2dc\uc791 \ub418\uc5c8\uc2b5\ub2c8\ub2e4.", messageOnEnd="\uac01 \uc81c\ud488\uc11c\ube44\uc2a4 \ubcc4 \uc694\uad6c\uc0ac\ud56d Status \uc5c5\ub370\uc774\ud2b8\uac00 \uc644\ub8cc \ub418\uc5c8\uc2b5\ub2c8\ub2e4.")
    @MailSendAlarm(subject="\uac01 \uc81c\ud488\uc11c\ube44\uc2a4 \ubcc4 \uc694\uad6c\uc0ac\ud56d Status \uc5c5\ub370\uc774\ud2b8 \uc644\ub8cc.", content="\uac01 \uc81c\ud488\uc11c\ube44\uc2a4 \ubcc4 \uc694\uad6c\uc0ac\ud56d Status \uc5c5\ub370\uc774\ud2b8 \uc644\ub8cc.")
    public void updateReqStatusFromElasticsearch(SchedulerType schedulerEnum) throws Exception {
        String logMessagePrefix = "[ SchedulerServiceImpl :: updateReqStatusFromElasticsearch ]";
        String shortUUID = UUIDUtil.createShortUUID();
        LocalDateTime startTime = LocalDateTime.now();
        log.info("[{}] :: {} :: {} :: started at {}", new Object[]{shortUUID, logMessagePrefix, schedulerEnum.getType(), startTime.format(this.timeFormatter)});
        List pdServicePureEntities = this.pdServicePure.getNodesWithoutRoot((TreeSearchEntity)new PdServicePureEntity());
        for (PdServicePureEntity pdServicePureEntity : pdServicePureEntities) {
            Long pdServiceEntityCId = pdServicePureEntity.getC_id();
            List searchReqStatusEntities = this.internalService.\uc81c\ud488\ubcc4_\uc694\uad6c\uc0ac\ud56d_\uc0c1\ud669_\uc870\ud68c("T_ARMS_REQSTATUS_" + pdServiceEntityCId, new ReqStatusDTO());
            if (searchReqStatusEntities == null || searchReqStatusEntities.isEmpty()) {
                log.info("{} :: {} \uc81c\ud488\uc758 \uc694\uad6c\uc0ac\ud56d\uc774 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.", (Object)logMessagePrefix, (Object)pdServicePureEntity.getC_title());
                continue;
            }
            for (ReqStatusEntity reqStatusEntity : searchReqStatusEntities) {
                Optional optionalJiraServerPureEntity = TreeServiceUtils.getNodeOptional((TreeService)this.jiraServerPure, (Long)reqStatusEntity.getC_jira_server_link(), JiraServerPureEntity.class);
                optionalJiraServerPureEntity.ifPresentOrElse(jiraServerPureEntity -> {
                    AlmIssue jiraIssue;
                    if (this.isValidReqStatus(reqStatusEntity, jiraServerPureEntity, logMessagePrefix) && this.isValidJiraIssue(jiraIssue = this.engineService.\uc694\uad6c\uc0ac\ud56d\uc774\uc288_\uc870\ud68c(Long.valueOf(Long.parseLong(jiraServerPureEntity.getC_jira_server_etc())), reqStatusEntity.getC_jira_project_key(), reqStatusEntity.getC_issue_key()), reqStatusEntity, logMessagePrefix)) {
                        log.info("{} :: jiraIssue :: id = {} :: key = {} ", new Object[]{logMessagePrefix, jiraIssue.getRecentId(), jiraIssue.getKey()});
                        this.updateReqStatusFromJiraIssue(jiraIssue, reqStatusEntity, logMessagePrefix);
                        ReqStatusDTO statusDTO = (ReqStatusDTO)this.modelMapper.map((Object)reqStatusEntity, ReqStatusDTO.class);
                        ResponseEntity reqStatusUpdateResponse = this.internalService.\uc694\uad6c\uc0ac\ud56d_\uc0c1\ud669_\uc218\uc815\ud558\uae30("T_ARMS_REQSTATUS_" + pdServiceEntityCId, statusDTO);
                        if (reqStatusUpdateResponse.getStatusCode().is2xxSuccessful()) {
                            String message = " [ " + statusDTO.getC_jira_server_name() + " :: " + statusDTO.getC_jira_project_name() + " ] :: " + statusDTO.getC_issue_key() + " ALM \uc694\uad6c\uc0ac\ud56d \uc774\uc288\uc758 \ub370\uc774\ud130\uc640 \ub3d9\uae30\ud654\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
                            this.chat.sendMessageByEngine(message);
                        } else {
                            log.error("T_ARMS_REQSTATUS_" + pdServiceEntityCId + " :: \uc218\uc815 \uc624\ub958 :: " + statusDTO.toString());
                        }
                    }
                }, () -> log.info("{} :: \uc9c0\ub77c\uc11c\ubc84\uac00 \uc870\ud68c\ub418\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4. C_ID = {}", (Object)logMessagePrefix, (Object)reqStatusEntity.getC_jira_server_link()));
            }
        }
        LocalDateTime endTime = LocalDateTime.now();
        Duration elapsed = Duration.between(startTime, endTime);
        log.info("[{}] :: {} :: {} :: finished at {} (completed in {} ms)", new Object[]{shortUUID, logMessagePrefix, schedulerEnum.getType(), endTime.format(this.timeFormatter), elapsed.toMillis()});
    }

    @Async
    @DwrSendAlarm(messageOnStart="\uc774\uc288\uc0dd\uc131 \uc2e4\ud328 \ud56d\ubaa9 \uc7ac\uc2dc\ub3c4")
    @SlackSendAlarm(messageOnStart="\uc774\uc288\uc0dd\uc131 \uc2e4\ud328 \ud56d\ubaa9 \uc7ac\uc0dd\uc131\uc774 \uc2dc\uc791 \ub418\uc5c8\uc2b5\ub2c8\ub2e4.", messageOnEnd="\uc774\uc288\uc0dd\uc131 \uc2e4\ud328 \ud56d\ubaa9 \uc7ac\uc0dd\uc131\uc774 \uc644\ub8cc \ub418\uc5c8\uc2b5\ub2c8\ub2e4.")
    @MailSendAlarm(subject="\uc774\uc288\uc0dd\uc131 \uc2e4\ud328 \ud56d\ubaa9 \uc7ac\uc0dd\uc131", content="\uc774\uc288\uc0dd\uc131 \uc2e4\ud328 \ud56d\ubaa9 \uc7ac\uc0dd\uc131 \uc644\ub8cc")
    public void retryFailedReqStatusCreationToElasticsearch(SchedulerType schedulerEnum) throws Exception {
        String logMessagePrefix = "[ SchedulerServiceImpl :: retryFailedReqStatusCreationToElasticsearch ]";
        String shortUUID = UUIDUtil.createShortUUID();
        LocalDateTime startTime = LocalDateTime.now();
        log.info("[{}] :: {} :: {} :: started at {}", new Object[]{shortUUID, logMessagePrefix, schedulerEnum.getType(), startTime.format(this.timeFormatter)});
        List pdServicePureEntities = this.pdServicePure.getNodesWithoutRoot((TreeSearchEntity)new PdServicePureEntity());
        for (PdServicePureEntity pdServicePureEntity : pdServicePureEntities) {
            Long pdServiceEntityCId = pdServicePureEntity.getC_id();
            List searchReqStatusEntities = this.internalService.\uc81c\ud488\ubcc4_\uc694\uad6c\uc0ac\ud56d_\uc0c1\ud669_\uc870\ud68c("T_ARMS_REQSTATUS_" + pdServiceEntityCId, new ReqStatusDTO());
            if (searchReqStatusEntities == null || searchReqStatusEntities.isEmpty()) {
                log.info("{} :: {} \uc81c\ud488\uc758 \uc694\uad6c\uc0ac\ud56d\uc774 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.", (Object)logMessagePrefix, (Object)pdServicePureEntity.getC_title());
                continue;
            }
            List<ReqStatusEntity> filteredIssues = Optional.ofNullable(searchReqStatusEntities).orElse(Collections.emptyList()).stream().filter(\uc694\uad6c\uc0ac\ud56d_\uc774\uc288 -> \uc694\uad6c\uc0ac\ud56d_\uc774\uc288.getC_issue_delete_date() == null).filter(\uc694\uad6c\uc0ac\ud56d_\uc774\uc288 -> \uc694\uad6c\uc0ac\ud56d_\uc774\uc288.getC_etc() != null && !StringUtils.equals((String)CRUDType.\uc644\ub8cc.getType(), (String)\uc694\uad6c\uc0ac\ud56d_\uc774\uc288.getC_etc())).collect(Collectors.toList());
            filteredIssues.forEach(\uc694\uad6c\uc0ac\ud56d_\uc774\uc288 -> this.reqStatus.ALM\uc11c\ubc84_\uc694\uad6c\uc0ac\ud56d_\ucc98\ub9ac_\ubc0f_REQSTATUS_\uc5c5\ub370\uc774\ud2b8(\uc694\uad6c\uc0ac\ud56d_\uc774\uc288, pdServiceEntityCId));
        }
        LocalDateTime endTime = LocalDateTime.now();
        Duration elapsed = Duration.between(startTime, endTime);
        log.info("[{}] :: {} :: {} :: finished at {} (completed in {} ms)", new Object[]{shortUUID, logMessagePrefix, schedulerEnum.getType(), endTime.format(this.timeFormatter), elapsed.toMillis()});
    }

    @Async
    @DwrSendAlarm(messageOnStart="StatusMapping \ub370\uc774\ud130 \uce90\uc2f1")
    @SlackSendAlarm(messageOnStart="StatusMapping \ub370\uc774\ud130 \uce90\uc2f1\uc774 \uc2dc\uc791 \ub418\uc5c8\uc2b5\ub2c8\ub2e4.", messageOnEnd="StatusMapping \ub370\uc774\ud130 \uce90\uc2f1\uc774 \uc644\ub8cc \ub418\uc5c8\uc2b5\ub2c8\ub2e4.")
    @MailSendAlarm(subject="StatusMapping \ub370\uc774\ud130 \uce90\uc2f1", content="StatusMapping \ub370\uc774\ud130 \uce90\uc2f1 \uc644\ub8cc")
    public String cacheStatusMappingData() throws Exception {
        String logMessagePrefix = "[ SchedulerServiceImpl :: cacheStatusMappingData ]";
        String shortUUID = UUIDUtil.createShortUUID();
        LocalDateTime startTime = LocalDateTime.now();
        log.info("[{}] :: {} :: started at {}", new Object[]{shortUUID, logMessagePrefix, startTime.format(this.timeFormatter)});
        this.jiraServer.cacheStatusMappingData(new JiraServerEntity());
        this.reqState.cacheArmsStateData();
        this.reqStateCategory.cacheArmsStateCategoryData();
        LocalDateTime endTime = LocalDateTime.now();
        Duration elapsed = Duration.between(startTime, endTime);
        log.info("[{}] :: {} :: finished at {} (completed in {} ms)", new Object[]{shortUUID, logMessagePrefix, endTime.format(this.timeFormatter), elapsed.toMillis()});
        return "success";
    }

    private boolean isValidReqStatus(ReqStatusEntity reqStatusEntity, JiraServerPureEntity jiraServerPureEntity, String logMessagePrefix) {
        if (this.isIssueKeyNull(reqStatusEntity, logMessagePrefix)) {
            return false;
        }
        if (this.isIssueDeleted(reqStatusEntity, logMessagePrefix)) {
            return false;
        }
        return !this.isVersionSetLinkMissing(reqStatusEntity, jiraServerPureEntity, logMessagePrefix);
    }

    private boolean isIssueKeyNull(ReqStatusEntity reqStatusEntity, String logMessagePrefix) {
        if (reqStatusEntity.getC_issue_key() == null) {
            log.info("{} :: \ud574\ub2f9 \uc694\uad6c\uc0ac\ud56d\uc740 ALM \uc11c\ubc84\uc5d0 \uc0dd\uc131\ub418\uc9c0 \uc54a\uc740 \uc694\uad6c\uc0ac\ud56d\uc785\ub2c8\ub2e4. \ud655\uc778\uc774 \ud544\uc694\ud569\ub2c8\ub2e4. C_ID = {}", (Object)logMessagePrefix, (Object)reqStatusEntity.getC_id());
            return true;
        }
        return false;
    }

    private boolean isIssueDeleted(ReqStatusEntity reqStatusEntity, String logMessagePrefix) {
        if (reqStatusEntity.getC_issue_delete_date() != null) {
            log.info("{} :: \ud574\ub2f9 \uc694\uad6c\uc0ac\ud56d\uc740 A-RMS \uc5d0\uc11c \uc0ad\uc81c\ub41c \uc694\uad6c\uc0ac\ud56d\uc785\ub2c8\ub2e4. C_ID = {}", (Object)logMessagePrefix, (Object)reqStatusEntity.getC_id());
            return true;
        }
        return false;
    }

    private boolean isVersionSetLinkMissing(ReqStatusEntity reqStatusEntity, JiraServerPureEntity jiraServerPureEntity, String logMessagePrefix) {
        if (reqStatusEntity.getC_req_pdservice_versionset_link() == null || reqStatusEntity.getC_req_pdservice_versionset_link().isEmpty()) {
            log.info("{} :: \ud574\ub2f9 \uc694\uad6c\uc0ac\ud56d\uc740 \ubc84\uc804 \ub370\uc774\ud130\ub97c \uac00\uc9c0\uace0 \uc788\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4. C_ID = {}, name = {}, issue_key = {}", new Object[]{logMessagePrefix, reqStatusEntity.getC_id(), jiraServerPureEntity.getC_jira_server_name(), reqStatusEntity.getC_issue_key()});
            return true;
        }
        return false;
    }

    private void updateReqStatusFromJiraIssue(AlmIssue jiraIssue, ReqStatusEntity reqStatusEntity, String logMessagePrefix) {
        log.info("{} :: jiraIssue :: id = {} :: key = {} ", new Object[]{logMessagePrefix, jiraIssue.getRecentId(), jiraIssue.getKey()});
        if (jiraIssue.getAssignee() != null && jiraIssue.getAssignee().getDisplayName() != null) {
            log.info("{} :: jiraIssue \ub2f4\ub2f9\uc790 \uc774\ub984 = {}", (Object)logMessagePrefix, (Object)jiraIssue.getAssignee().getDisplayName());
            reqStatusEntity.setC_issue_assignee(jiraIssue.getAssignee().getDisplayName());
        }
        if (jiraIssue.getPriority() != null && jiraIssue.getPriority().getName() != null) {
            log.info("{} :: jiraIssue \uc6b0\uc120\uc21c\uc704 = {}", (Object)logMessagePrefix, (Object)jiraIssue.getPriority().getName());
            reqStatusEntity.setC_issue_priority_link(Long.valueOf(jiraIssue.getPriority().getId()));
            reqStatusEntity.setC_issue_priority_name(jiraIssue.getPriority().getName());
        }
        if (jiraIssue.getReporter() != null && jiraIssue.getReporter().getDisplayName() != null) {
            log.info("{} :: jiraIssue \ubcf4\uace0\uc790 = {}", (Object)logMessagePrefix, (Object)jiraIssue.getReporter().getDisplayName());
            reqStatusEntity.setC_issue_reporter(jiraIssue.getReporter().getDisplayName());
        }
        if (jiraIssue.getResolution() != null && jiraIssue.getResolution().getName() != null) {
            log.info("{} :: jiraIssue \ud574\uacb0\ucc45 = {}", (Object)logMessagePrefix, (Object)jiraIssue.getResolution().getName());
            reqStatusEntity.setC_issue_resolution_name(jiraIssue.getResolution().getName());
        }
        if (jiraIssue.getStatus() != null && jiraIssue.getStatus().getName() != null) {
            log.info("{} :: jiraIssue \uc0c1\ud0dc = {}", (Object)logMessagePrefix, (Object)jiraIssue.getStatus().getName());
            reqStatusEntity.setC_issue_status_link(Long.valueOf(jiraIssue.getStatus().getId()));
            reqStatusEntity.setC_issue_status_name(jiraIssue.getStatus().getName());
        }
    }

    private boolean isValidJiraIssue(AlmIssue jiraIssue, ReqStatusEntity reqStatusEntity, String logMessagePrefix) {
        if (this.isJiraIssueNull(jiraIssue, reqStatusEntity, logMessagePrefix)) {
            return false;
        }
        if (this.isJiraIssueKeyNull(jiraIssue, logMessagePrefix)) {
            return false;
        }
        return !this.isJiraIssueNotAvailable(jiraIssue, logMessagePrefix);
    }

    private boolean isJiraIssueNull(AlmIssue jiraIssue, ReqStatusEntity reqStatusEntity, String logMessagePrefix) {
        if (jiraIssue == null) {
            log.info("{} :: \uc9c0\ub77c\uc774\uc288\uac00 \uc870\ud68c\ub418\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4. \uc870\ud68c\ud0a4 = {}", (Object)logMessagePrefix, (Object)reqStatusEntity.getC_issue_key());
            return true;
        }
        return false;
    }

    private boolean isJiraIssueKeyNull(AlmIssue jiraIssue, String logMessagePrefix) {
        if (jiraIssue.getKey() == null) {
            log.info("{} :: jiraIssue = null \uc774\uba70, \ud655\uc778\uc774 \ud544\uc694\ud569\ub2c8\ub2e4.", (Object)logMessagePrefix);
            return true;
        }
        return false;
    }

    private boolean isJiraIssueNotAvailable(AlmIssue jiraIssue, String logMessagePrefix) {
        AlmIssue.\uc0c1\ud0dc status = jiraIssue.getStatus();
        if (status == null || StringUtils.equals((String)status.getName(), (String)"\ud574\ub2f9 \uc694\uad6c\uc0ac\ud56d\uc740 \uc9c0\ub77c\uc11c\ubc84\uc5d0\uc11c \uc870\ud68c\uac00 \ub418\uc9c0 \uc54a\ub294 \uc0c1\ud0dc\uc785\ub2c8\ub2e4.")) {
            log.info("{} :: \ud574\ub2f9 \uc694\uad6c\uc0ac\ud56d\uc740 \uc9c0\ub77c\uc11c\ubc84\uc5d0\uc11c \uc870\ud68c\uac00 \ub418\uc9c0 \uc54a\ub294 \uc0c1\ud0dc\uc785\ub2c8\ub2e4. jiraIssue = {}", (Object)logMessagePrefix, (Object)jiraIssue.getKey());
            return true;
        }
        return false;
    }

    private Long[] convertVersionToArray(String versionList) {
        return (Long[])Arrays.stream(versionList.split("[\\[\\],\"]")).filter(s -> !s.isEmpty()).map(Long::valueOf).toArray(Long[]::new);
    }

    public SchedulerServiceImpl(PdServicePure pdServicePure, ReqStatus reqStatus, JiraServerPure jiraServerPure, JiraServer jiraServer, EngineService engineService, InternalService internalService, JiraProject jiraProject, JiraProjectPure jiraProjectPure, ReqState reqState, ReqStateCategory reqStateCategory, Chat chat, ModelMapper modelMapper, GlobalTreeMapService globalTreeMapService, PdServiceVersion pdServiceVersion) {
        this.pdServicePure = pdServicePure;
        this.reqStatus = reqStatus;
        this.jiraServerPure = jiraServerPure;
        this.jiraServer = jiraServer;
        this.engineService = engineService;
        this.internalService = internalService;
        this.jiraProject = jiraProject;
        this.jiraProjectPure = jiraProjectPure;
        this.reqState = reqState;
        this.reqStateCategory = reqStateCategory;
        this.chat = chat;
        this.modelMapper = modelMapper;
        this.globalTreeMapService = globalTreeMapService;
        this.pdServiceVersion = pdServiceVersion;
    }
}

