/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.util.dynamicscheduler.controller;

import com.arms.api.util.dynamicscheduler.model.SchedulerType;
import com.arms.api.util.dynamicscheduler.service.SchedulerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/arms/scheduler"})
public class SchedulerController {
    private static final Logger log = LoggerFactory.getLogger(SchedulerController.class);
    private final SchedulerService schedulerService;

    @GetMapping(value={"/pdservice/reqstatus/executeSequentialSchedules/storeToES"})
    public void executeSequentialSchedules() throws Exception {
        log.info("[ SchedulerController :: executeSequentialSchedules ] :: \uc804\uccb4 \uc774\uc288 \uc218\uc9d1 \uc694\uccad");
        this.schedulerService.discoverByFullDateRange(SchedulerType.REQUIREMENT_ISSUE_BULK_SAVE);
    }

    @GetMapping(value={"/pdservice/reqstatus/increment/executeSequentialSchedules/storeToES"})
    public void executeIncrementalIssueSequentialSchedules() throws Exception {
        log.info("[ SchedulerController :: executeIncrementalIssueSequentialSchedules ] :: \uc774\uc288 \uc99d\ubd84 \uc218\uc9d1 \uc694\uccad");
        this.schedulerService.discoverByPreviousDay(SchedulerType.INCREMENTAL_ISSUE_BULK_SAVE);
    }

    @GetMapping(value={"/pdservice/reqstatus/increment/executeSequentialSchedules/storeToES/withDateRange"})
    public void executeIncrementalIssueWithDateRangeSequentialSchedules(@RequestParam(value="startDate", required=false) String startDate, @RequestParam(value="endDate", required=false) String endDate) throws Exception {
        log.info("[ SchedulerController :: executeIncrementalIssueWithDateRangeSequentialSchedules ] :: \uc774\uc288 \uae30\ubc18\ubcc4 \uc99d\ubd84 \uc218\uc9d1 \uc694\uccad");
        this.schedulerService.discoverByDateRange(SchedulerType.INCREMENTAL_ISSUE_BULK_SAVE_WITH_DATE_RANGE, startDate, endDate);
    }

    @GetMapping(value={"/pdservice/reqstatus/updateFromES"})
    public void updateReqStatusFromElasticsearch() throws Exception {
        log.info("[ SchedulerController :: updateReqStatusFromElasticsearch ] :: FROM_\uac80\uc0c9\uc5d4\uc9c4_\uc774\uc288\ub370\uc774\ud130_TO_\uc694\uad6c\uc0ac\ud56d_REQSTATUS_\ub3d9\uae30\ud654");
        this.schedulerService.updateReqStatusFromElasticsearch(SchedulerType.SYNC_REQ_STATUS_FROM_ES);
    }

    @GetMapping(value={"/pdservice/reqstatus/recreateFailedReqIssue"})
    public void retryFailedReqStatusCreationToElasticsearch() throws Exception {
        log.info("[ SchedulerController :: retryFailedReqStatusCreationToElasticsearch ] :: \uac01_\uc81c\ud488\uc11c\ube44\uc2a4_\ubcc4_\uc0dd\uc131\uc2e4\ud328\ud55c_ALM_\uc694\uad6c\uc0ac\ud56d_\uc774\uc288_\uc7ac\uc0dd\uc131");
        this.schedulerService.retryFailedReqStatusCreationToElasticsearch(SchedulerType.RECREATE_FAILED_ISSUE);
    }

    @PutMapping(value={"/cacheStatusMappingData"})
    public String cacheStatusMappingData() throws Exception {
        log.info("[ SchedulerController :: setStatusMappingData ] :: \uc0c1\ud0dc \ub9e4\ud551 \ub370\uc774\ud130 Redis \uce90\uc2f1");
        return this.schedulerService.cacheStatusMappingData();
    }

    public SchedulerController(SchedulerService schedulerService) {
        this.schedulerService = schedulerService;
    }
}

