/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.util.aspect;

import com.arms.api.report.mail.modal.EmailSendResult;
import com.arms.api.report.mail.modal.entity.sender.SenderEntity;
import com.arms.api.report.mail.service.mail.MailService;
import com.arms.api.util.aspect.MailContent;
import com.arms.api.util.aspect.MailSendAlarm;
import com.arms.api.util.aspect.MailSubject;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class MailSendAdvice {
    private static final Logger log = LoggerFactory.getLogger(MailSendAdvice.class);
    private final MailService mailService;
    private final Environment environment;

    private EmailSendResult sendEmail(String subject, String content) throws Exception {
        SenderEntity senderEntity = this.mailService.getSenderConfig();
        String cSenderEmail = senderEntity.getC_sender_email();
        JavaMailSenderImpl mailSender = this.mailService.createMailSender(senderEntity);
        EmailSendResult result = new EmailSendResult(cSenderEmail, true, null);
        try {
            SimpleMailMessage message = new SimpleMailMessage();
            message.setFrom(senderEntity.getC_sender_email());
            message.setTo(senderEntity.getC_sender_email());
            message.setSubject(subject);
            message.setText(content);
            mailSender.send(message);
        }
        catch (Exception e) {
            result.setSuccess(false);
            result.setErrorMessage(e.getMessage());
            log.error("\uba54\uc77c \uc804\uc1a1 \uc2e4\ud328: " + e.getMessage());
        }
        return result;
    }

    @AfterReturning(value="@annotation(mailSendAlarm)")
    public void afterReturning(JoinPoint joinPoint, MailSendAlarm mailSendAlarm) {
        try {
            if (this.isStageOrLiveProfile()) {
                Object[] args = joinPoint.getArgs();
                String prefixSubject = null;
                String prefixContent = null;
                for (Object arg : args) {
                    if (arg == null) continue;
                    for (Field field : this.getAllFields(arg.getClass())) {
                        field.setAccessible(true);
                        if (field.isAnnotationPresent(MailSubject.class)) {
                            Object oSubject = field.get(arg);
                            prefixSubject = Optional.ofNullable(oSubject).map(String::valueOf).orElse(null);
                        }
                        if (!field.isAnnotationPresent(MailContent.class)) continue;
                        Object oContent = field.get(arg);
                        prefixContent = Optional.ofNullable(oContent).map(String::valueOf).orElse(null);
                    }
                    if (prefixSubject != null && prefixContent != null) break;
                }
                String subject = Optional.ofNullable(prefixSubject).map(a -> a + " " + mailSendAlarm.subject()).orElseGet(() -> ((MailSendAlarm)mailSendAlarm).subject());
                String content = Optional.ofNullable(prefixContent).map(a -> a + " " + mailSendAlarm.content()).orElseGet(() -> ((MailSendAlarm)mailSendAlarm).content());
                this.sendEmail(subject, content);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private List<Field> getAllFields(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        while (clazz != null) {
            fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
            clazz = clazz.getSuperclass();
        }
        return fields;
    }

    @AfterThrowing(value="@annotation(mailSendAlarm)", throwing="e")
    public void afterThrowing(JoinPoint joinPoint, MailSendAlarm mailSendAlarm, Exception e) {
        try {
            if (this.isStageOrLiveProfile()) {
                String connectUrl = Optional.ofNullable(System.getenv("ARMS_DETAIL_CONNECT_URL")).orElse("");
                String profile = Optional.of(this.environment.getActiveProfiles()).filter(a -> ((String[])a).length > 0).map(a -> a[0]).orElse("");
                StringBuilder sb = new StringBuilder();
                if (!profile.isEmpty()) {
                    sb.append("[").append(profile).append("]");
                }
                if (!connectUrl.isEmpty()) {
                    sb.append("[").append(connectUrl).append("]");
                }
                sb.append(" ").append("\uc5d0\ub7ec\ubc1c\uc0dd");
                this.sendEmail(String.valueOf(sb), this.getStackTraceAsString((Throwable)e));
            }
        }
        catch (Exception ex) {
            log.error(ex.getMessage());
        }
    }

    private String getStackTraceAsString(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    private boolean isStageOrLiveProfile() {
        List<String> allowedProfiles = Arrays.asList("stg", "live");
        return Arrays.stream(this.environment.getActiveProfiles()).anyMatch(allowedProfiles::contains);
    }

    public MailSendAdvice(MailService mailService, Environment environment) {
        this.mailService = mailService;
        this.environment = environment;
    }
}

