/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionUtil {
    private static final Logger log = LoggerFactory.getLogger(VersionUtil.class);

    public static Long[] stringToLongArray(String input) {
        if (input == null || input.isEmpty()) {
            return new Long[0];
        }
        String[] stringArray = input.substring(1, input.length() - 1).split(",");
        if (stringArray.length == 0) {
            throw new IllegalArgumentException("[\ubc84\uc804\uc720\ud2f8 :: convertToLongArray] :: stringArray\uc758 \uc785\ub825\uc774 \uc62c\ubc14\ub978 \ud615\uc2dd\uc774 \uc544\ub2d9\ub2c8\ub2e4.");
        }
        Long[] longArray = new Long[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                longArray[i] = Long.parseLong(stringArray[i].replaceAll("\"", "").trim());
                continue;
            }
            catch (NumberFormatException e) {
                longArray[i] = null;
                continue;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                log.error("[\ubc84\uc804\uc720\ud2f8 :: convertToLongArray] :: longArray[{}]\uc5d0\uc11c \ubc30\uc5f4 \uc778\ub371\uc2a4\uac00 \ubc94\uc704\ub97c \ubc97\uc5b4\ub0ac\uc2b5\ub2c8\ub2e4.", (Object)i);
                continue;
            }
            catch (Exception e) {
                log.error("[\ubc84\uc804\uc720\ud2f8 :: convertToLongArray] :: longArray[{}]\uc5d0\uc11c \uc608\uc0c1\uce58 \ubabb\ud55c \uc608\uc678\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4 => {}", (Object)i, (Object)e.getMessage());
            }
        }
        return longArray;
    }
}

