/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.requirement.reqstatus_calendar.service;

import com.arms.api.jira.jiraproject_pure.model.JiraProjectPureEntity;
import com.arms.api.jira.jiraproject_pure.service.JiraProjectPure;
import com.arms.api.product_service.pdservice.model.PdServiceAndVersionListDTO;
import com.arms.api.product_service.pdserviceversion.model.PdServiceVersionEntity;
import com.arms.api.requirement.reqstatus_calendar.model.CalendarDataDTO;
import com.arms.api.requirement.reqstatus_calendar.model.ReqStatusCalendarRequestDTO;
import com.arms.api.requirement.reqstatus_calendar.model.ReqStatusCalendarResponseDTO;
import com.arms.api.requirement.reqstatus_calendar.service.ReqStatusCalendarService;
import com.arms.api.util.communicate.external.EngineService;
import com.arms.api.util.communicate.external.response.jira.AlmIssue;
import com.arms.api.util.communicate.internal.InternalService;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class ReqStatusCalendarServiceImpl
implements ReqStatusCalendarService {
    private static final Logger log = LoggerFactory.getLogger(ReqStatusCalendarServiceImpl.class);
    private final EngineService engineService;
    private final InternalService internalService;
    private final JiraProjectPure jiraProjectPure;
    private static final List<DateTimeFormatter> DATE_TIME_FORMATTERS = Arrays.asList(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ"), DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSXXX"), DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssZ"), DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssXXX"));
    private static final DateTimeFormatter OUTPUT_DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public List<CalendarDataDTO> getCalendarData(ReqStatusCalendarRequestDTO request) throws Exception {
        Function<ReqStatusCalendarRequestDTO, ResponseEntity> fetchAndDeduplicate = dto -> {
            ResponseEntity responseEntity = this.engineService.\uc774\uc288\ubaa9\ub85d_\uac00\uc838\uc624\uae30_calendar(dto);
            return responseEntity;
        };
        return this.processCalendarDataMapping(request, fetchAndDeduplicate);
    }

    private List<CalendarDataDTO> processCalendarDataMapping(ReqStatusCalendarRequestDTO request, Function<ReqStatusCalendarRequestDTO, ResponseEntity<ReqStatusCalendarResponseDTO>> function) throws Exception {
        ResponseEntity internalResponse = this.internalService.getPdServiceEntityAndVersionList();
        if (internalResponse.getBody() == null) {
            log.error("Product service and version information is null.");
            return Collections.emptyList();
        }
        HashMap pdServiceMap = new HashMap();
        HashMap versionMap = new HashMap();
        this.extractProductAndVersionInfo((List)internalResponse.getBody(), pdServiceMap, versionMap);
        this.prepareAlmProjectUrls(request);
        ResponseEntity<ReqStatusCalendarResponseDTO> calendarDataFromEngine = function.apply(request);
        if (calendarDataFromEngine.getBody() == null || ((ReqStatusCalendarResponseDTO)calendarDataFromEngine.getBody()).getIssueEntityList().isEmpty()) {
            log.info("Issue list from engine is empty.");
            return Collections.emptyList();
        }
        List allIssues = ((ReqStatusCalendarResponseDTO)calendarDataFromEngine.getBody()).getIssueEntityList();
        Map<String, List<AlmIssue>> issuesByParent = allIssues.stream().filter(issue -> issue.getParentReqKey() != null).collect(Collectors.groupingBy(AlmIssue::getParentReqKey));
        List requirementIssues = this.filterAndSortRequirementIssues(allIssues);
        ArrayList<CalendarDataDTO> result = new ArrayList<CalendarDataDTO>();
        for (AlmIssue reqIssue : requirementIssues) {
            result.add(this.mapToCalendarData(pdServiceMap, versionMap, reqIssue));
            List subAndLinkedIssues = issuesByParent.getOrDefault(reqIssue.getKey(), Collections.emptyList());
            Set linkedIssueIds = Optional.ofNullable(reqIssue.getLinkedIssues()).map(Arrays::stream).map(stream -> stream.collect(Collectors.toSet())).orElse(Collections.emptySet());
            for (AlmIssue subOrLinkedIssue : subAndLinkedIssues) {
                if (linkedIssueIds.contains(subOrLinkedIssue.getRecentId())) {
                    result.add(this.mapToLinkedIssueCalendarData(pdServiceMap, versionMap, subOrLinkedIssue, reqIssue));
                    continue;
                }
                result.add(this.mapToSubIssueCalendarData(pdServiceMap, versionMap, subOrLinkedIssue, reqIssue));
            }
        }
        return result.stream().collect(Collectors.toMap(dto -> dto.getKey() + "::" + dto.getUpdatedDate(), Function.identity(), (existing, newer) -> newer)).values().stream().collect(Collectors.toList());
    }

    private void extractProductAndVersionInfo(List<PdServiceAndVersionListDTO> serviceAndVersionList, Map<Long, String> pdServiceMap, Map<Long, String> versionMap) {
        for (PdServiceAndVersionListDTO dto : serviceAndVersionList) {
            pdServiceMap.put(dto.getC_id(), dto.getC_title());
            versionMap.putAll(this.buildVersionIdNameMap(dto.getPdServiceVersionEntityList()));
        }
    }

    private void prepareAlmProjectUrls(ReqStatusCalendarRequestDTO request) throws Exception {
        List almProjectIds = Optional.ofNullable(request.getAlmProjectIds()).orElse(Collections.emptyList());
        if (!almProjectIds.isEmpty()) {
            List almProjects = this.jiraProjectPure.getJiraProjects(almProjectIds);
            List almProjectUrls = almProjects.stream().map(JiraProjectPureEntity::getC_jira_url).collect(Collectors.toList());
            request.setAlmProjectUrls(almProjectUrls);
            log.info("ALM Project URLs set: {}", almProjectUrls);
        }
    }

    private List<AlmIssue> filterAndSortRequirementIssues(List<AlmIssue> issues) {
        return issues.stream().filter(issue -> Boolean.TRUE.equals(issue.getIsReq())).peek(arg_0 -> this.formatIssueDates(arg_0)).sorted(Comparator.comparing(AlmIssue::getUpdated, Comparator.nullsLast(Comparator.reverseOrder()))).collect(Collectors.toList());
    }

    private void formatIssueDates(AlmIssue issue) {
        issue.setCreated(this.formatDate(issue.getCreated()));
        issue.setUpdated(this.formatDate(issue.getUpdated()));
        issue.setResolutiondate(this.formatDate(issue.getResolutiondate()));
    }

    private String formatDate(String inputDate) {
        if (inputDate == null || inputDate.isEmpty()) {
            return "";
        }
        for (DateTimeFormatter formatter : DATE_TIME_FORMATTERS) {
            try {
                return ZonedDateTime.parse(inputDate, formatter).format(OUTPUT_DATE_FORMATTER);
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        }
        try {
            LocalDateTime.parse(inputDate, OUTPUT_DATE_FORMATTER);
            return inputDate;
        }
        catch (DateTimeParseException dateTimeParseException) {
            log.error("Unsupported date format: {}", (Object)inputDate);
            return inputDate;
        }
    }

    private CalendarDataDTO mapToCalendarData(Map<Long, String> pdServiceMap, Map<Long, String> versionMap, AlmIssue issue) {
        CalendarDataDTO baseCalendarData = this.createBaseCalendarDataBuild(pdServiceMap, versionMap, issue);
        if (Boolean.TRUE.equals(issue.getIsReq())) {
            baseCalendarData.setIsReq(Boolean.TRUE);
            baseCalendarData.setReqTitle(issue.getSummary());
            baseCalendarData.setReqState(Optional.ofNullable(issue.getCReqProperty()).map(AlmIssue.\uc554\uc2a4_\uc694\uad6c\uc0ac\ud56d_\uc18d\uc131::getCReqStateName).orElse(""));
            baseCalendarData.setCreateDate(Optional.ofNullable(issue.getCreated()).orElse("\uc0dd\uc131\uc77c \uc815\ubcf4 \uc5c6\uc74c"));
            baseCalendarData.setUpdatedDate(Optional.ofNullable(issue.getUpdated()).orElse("\uc218\uc815\uc77c \uc815\ubcf4 \uc5c6\uc74c"));
            baseCalendarData.setResolutionDate(Optional.ofNullable(issue.getResolutiondate()).orElse(""));
        }
        return baseCalendarData;
    }

    private CalendarDataDTO mapToLinkedIssueCalendarData(Map<Long, String> pdServiceMap, Map<Long, String> versionMap, AlmIssue linkedIssue, AlmIssue parentReq) {
        this.formatIssueDates(linkedIssue);
        AlmIssue issueAsLinked = linkedIssue.create\uc5f0\uacb0\uc774\uc288();
        String etcContent = parentReq.getKey() + "\uc758 \uc5f0\uacb0\uc774\uc288";
        issueAsLinked.setEtc((Object)etcContent);
        CalendarDataDTO baseCalendarData = this.createBaseCalendarDataBuild(pdServiceMap, versionMap, issueAsLinked);
        baseCalendarData.setIsReq(Boolean.FALSE);
        baseCalendarData.setReqTitle(parentReq.getSummary());
        baseCalendarData.setReqState(Optional.ofNullable(parentReq.getCReqProperty()).map(AlmIssue.\uc554\uc2a4_\uc694\uad6c\uc0ac\ud56d_\uc18d\uc131::getCReqStateName).orElse(""));
        baseCalendarData.setCreateDate(Optional.ofNullable(issueAsLinked.getCreated()).orElse("\uc0dd\uc131\uc77c \uc815\ubcf4 \uc5c6\uc74c"));
        baseCalendarData.setUpdatedDate(Optional.ofNullable(issueAsLinked.getUpdated()).orElse("\uc218\uc815\uc77c \uc815\ubcf4 \uc5c6\uc74c"));
        baseCalendarData.setResolutionDate(Optional.ofNullable(issueAsLinked.getResolutiondate()).orElse(""));
        baseCalendarData.setEtc(etcContent);
        return baseCalendarData;
    }

    private CalendarDataDTO mapToSubIssueCalendarData(Map<Long, String> pdServiceMap, Map<Long, String> versionMap, AlmIssue subIssue, AlmIssue parentReq) {
        this.formatIssueDates(subIssue);
        String isReqName = this.determineSubIssueName(subIssue);
        CalendarDataDTO baseCalendarData = this.createBaseCalendarDataBuild(pdServiceMap, versionMap, subIssue);
        baseCalendarData.setIsReq(Boolean.FALSE);
        baseCalendarData.setReqTitle(parentReq.getSummary());
        baseCalendarData.setReqState(Optional.ofNullable(parentReq.getCReqProperty()).map(AlmIssue.\uc554\uc2a4_\uc694\uad6c\uc0ac\ud56d_\uc18d\uc131::getCReqStateName).orElse(""));
        baseCalendarData.setCreateDate(Optional.ofNullable(subIssue.getCreated()).orElse("\uc0dd\uc131\uc77c \uc815\ubcf4 \uc5c6\uc74c"));
        baseCalendarData.setUpdatedDate(Optional.ofNullable(subIssue.getUpdated()).orElse("\uc218\uc815\uc77c \uc815\ubcf4 \uc5c6\uc74c"));
        baseCalendarData.setResolutionDate(Optional.ofNullable(subIssue.getResolutiondate()).orElse(""));
        return baseCalendarData;
    }

    private CalendarDataDTO createBaseCalendarDataBuild(Map<Long, String> pdServiceMap, Map<Long, String> versionMap, AlmIssue issue) {
        String versionNames = Optional.ofNullable(issue.getPdServiceVersions()).map(versions -> Arrays.stream(versions).map(versionMap::get).filter(Objects::nonNull).collect(Collectors.joining(","))).filter(s -> !s.isEmpty()).orElse("\ubc84\uc804 \uc815\ubcf4 \uc5c6\uc74c");
        return CalendarDataDTO.builder().pdServiceId(issue.getPdServiceId()).pdServiceName(Optional.ofNullable(pdServiceMap.get(issue.getPdServiceId())).orElse("\uc81c\ud488(\uc11c\ube44\uc2a4) \uc815\ubcf4 \uc5c6\uc74c")).pdServiceVersionNames(versionNames).cReqLink(issue.getCReqLink()).upperKey(issue.getUpperKey()).parentReqKey(issue.getParentReqKey()).almProjectName(issue.projectName()).key(issue.getKey()).issueID(issue.getIssueID()).docId(issue.getRecentId()).issueTitle(issue.getSummary()).issueStatus(issue.statusName()).assigneeName(Optional.ofNullable(issue.getAssignee()).map(AlmIssue.\ub2f4\ub2f9\uc790::getDisplayName).orElse("\ub2f4\ub2f9\uc790 \uc815\ubcf4 \uc5c6\uc74c")).assigneeEmail(Optional.ofNullable(issue.getAssignee()).map(AlmIssue.\ub2f4\ub2f9\uc790::getEmailAddress).orElse("\ub2f4\ub2f9\uc790 \uba54\uc77c \uc5c6\uc74c")).build();
    }

    private String determineSubIssueName(AlmIssue issue) {
        if (!Objects.equals(issue.getParentReqKey(), issue.getUpperKey()) && issue.getUpperKey() != null) {
            return issue.getUpperKey() + "\uc758 \ud558\uc704\uc774\uc288";
        }
        return issue.getParentReqKey() + "\uc758 \ud558\uc704\uc774\uc288";
    }

    private Map<Long, String> buildVersionIdNameMap(List<PdServiceVersionEntity> versionEntities) {
        DateTimeFormatter inputFormatter = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm");
        DateTimeFormatter outputFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        return versionEntities.stream().collect(Collectors.toMap(PdServiceVersionEntity::getC_id, entity -> {
            LocalDateTime startDateTime = LocalDateTime.parse(entity.getC_pds_version_start_date(), inputFormatter);
            LocalDateTime endDateTime = LocalDateTime.parse(entity.getC_pds_version_end_date(), inputFormatter);
            String startDate = startDateTime.format(outputFormatter);
            String endDate = endDateTime.format(outputFormatter);
            return entity.getC_title() + " (" + startDate + " ~ " + endDate + ")";
        }, (existingValue, newValue) -> newValue));
    }

    public ReqStatusCalendarServiceImpl(EngineService engineService, InternalService internalService, JiraProjectPure jiraProjectPure) {
        this.engineService = engineService;
        this.internalService = internalService;
        this.jiraProjectPure = jiraProjectPure;
    }
}

