/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.requirement.reqstatus.controller;

import com.arms.api.jira.jiraissuepriority.service.JiraIssuePriority;
import com.arms.api.jira.jiraissuestatus.service.JiraIssueStatus;
import com.arms.api.jira.jiraserver.service.JiraServer;
import com.arms.api.jira.jiraserver_pure.model.JiraServerPureEntity;
import com.arms.api.requirement.reqadd.model.dto.RequirementDTO;
import com.arms.api.requirement.reqstatus.model.HierarchicalAlmIssue;
import com.arms.api.requirement.reqstatus.model.IssueListVO;
import com.arms.api.requirement.reqstatus.model.ReqStatusDTO;
import com.arms.api.requirement.reqstatus.model.ReqStatusDashboardVO;
import com.arms.api.requirement.reqstatus.model.ReqStatusEntity;
import com.arms.api.requirement.reqstatus.model.SubtaskAndLinkedIssuesRequestDTO;
import com.arms.api.requirement.reqstatus.service.ReqStatus;
import com.arms.api.util.communicate.external.AggregationService;
import com.arms.api.util.communicate.external.EngineService;
import com.arms.api.util.communicate.external.response.jira.AlmIssue;
import com.arms.egovframework.javaservice.treeframework.controller.CommonResponse;
import com.arms.egovframework.javaservice.treeframework.controller.TreeAbstractController;
import com.arms.egovframework.javaservice.treeframework.interceptor.SessionUtil;
import com.arms.egovframework.javaservice.treeframework.model.TreeSearchEntity;
import com.arms.egovframework.javaservice.treeframework.service.TreeService;
import com.arms.egovframework.javaservice.treeframework.util.ParameterParser;
import com.arms.egovframework.javaservice.treeframework.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.LogicalExpression;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/arms/reqStatus"})
public class ReqStatusController
extends TreeAbstractController<ReqStatus, ReqStatusDTO, ReqStatusEntity> {
    private static final Logger log = LoggerFactory.getLogger(ReqStatusController.class);
    @Autowired
    @Qualifier(value="reqStatus")
    private ReqStatus reqStatus;
    @Autowired
    @Qualifier(value="jiraServer")
    private JiraServer jiraServer;
    @Autowired
    @Qualifier(value="jiraIssuePriority")
    private JiraIssuePriority jiraIssuePriority;
    @Autowired
    @Qualifier(value="jiraIssueStatus")
    private JiraIssueStatus jiraIssueStatus;
    @Autowired
    private AggregationService aggregationService;
    @Autowired
    private EngineService engineService;
    static final long dummy_jira_server = 0L;

    @PostConstruct
    public void initialize() {
        this.setTreeService((TreeService)this.reqStatus);
        this.setTreeEntity(ReqStatusEntity.class);
    }

    @ResponseBody
    @RequestMapping(value={"/{changeReqTableName}/addStatusNode.do"}, method={RequestMethod.POST})
    public ResponseEntity<?> \uc694\uad6c\uc0ac\ud56d_\uc0c1\ud0dc_\uc815\ubcf4_\uc800\uc7a5\ud558\uae30(@PathVariable(value="changeReqTableName") String changeReqTableName, @RequestBody ReqStatusDTO reqStatusDTO) throws Exception {
        log.info("ReqStatusController :: addStatusNode");
        ReqStatusEntity reqStatusEntity = (ReqStatusEntity)this.modelMapper.map((Object)reqStatusDTO, ReqStatusEntity.class);
        SessionUtil.setAttribute((String)"addStatusNode", (Object)changeReqTableName);
        ReqStatusEntity savedNode = (ReqStatusEntity)this.reqStatus.addNode((TreeSearchEntity)reqStatusEntity);
        SessionUtil.removeAttribute((String)"addStatusNode");
        log.info("ReqStatusController :: addStatusNode");
        return ResponseEntity.ok((Object)CommonResponse.success((Object)savedNode));
    }

    @ResponseBody
    @RequestMapping(value={"/{changeReqTableName}/getStatusMonitor.do"}, method={RequestMethod.GET})
    public ModelAndView getStatusMonitor(@PathVariable(value="changeReqTableName") String changeReqTableName, ReqStatusDTO reqStatusDTO, ModelMap model, HttpServletRequest request) throws Exception {
        log.info("ReqStatusController :: getStatusMonitor");
        ReqStatusEntity statusEntity = (ReqStatusEntity)this.modelMapper.map((Object)reqStatusDTO, ReqStatusEntity.class);
        SessionUtil.setAttribute((String)"getStatusMonitor", (Object)changeReqTableName);
        statusEntity.setOrder(Order.asc((String)"c_id"));
        List list = this.reqStatus.getNodesWithoutRoot((TreeSearchEntity)statusEntity);
        SessionUtil.removeAttribute((String)"getStatusMonitor");
        ModelAndView modelAndView = new ModelAndView("jsonView");
        modelAndView.addObject("result", (Object)list);
        return modelAndView;
    }

    @GetMapping(value={"/{changeReqTableName}/reqAndInvolvedIssueList"})
    public ResponseEntity<CommonResponse.ApiResult<List<IssueListVO>>> getReqAndInvolvedIssueList(@PathVariable(value="changeReqTableName") String changeReqTableName, @RequestParam(value="pdServiceVersionLinks") List<Long> pdServiceVersionLinks) throws Exception {
        log.info("[ ReqStatusController :: getReqAndInvolvedIssueList ] :: changeReqTableName => {}", (Object)changeReqTableName);
        Long pdServiceLink = Long.valueOf(StringUtils.replace((String)changeReqTableName, (String)"T_ARMS_REQSTATUS_", (String)""));
        List result = this.reqStatus.reqStatusIssueList(pdServiceLink, pdServiceVersionLinks);
        return ResponseEntity.ok((Object)CommonResponse.success((Object)result));
    }

    @GetMapping(value={"/{changeReqTableName}/deletedIssueList"})
    public ResponseEntity<CommonResponse.ApiResult<List<AlmIssue>>> getDeletedIssueList(@PathVariable(value="changeReqTableName") String changeReqTableName, @RequestParam(value="pdServiceVersionLinks") List<Long> pdServiceVersionLinks) throws Exception {
        log.info("ReqStatusController :: \uc81c\ud488_\ubc84\uc804\ubcc4_\uc0ad\uc81c\ub41c_\uc774\uc288\uc870\ud68c");
        String pdServiceLink = StringUtils.replace((String)changeReqTableName, (String)"T_ARMS_REQSTATUS_", (String)"");
        List result = (List)this.engineService.getDeletedIssueList(Long.valueOf(pdServiceLink), pdServiceVersionLinks).getBody();
        return ResponseEntity.ok((Object)CommonResponse.success((Object)result));
    }

    @ResponseBody
    @RequestMapping(value={"/deleteWithdrawal.do"}, method={RequestMethod.PUT})
    public ResponseEntity<?> \uc774\uc288\uc0ad\uc81c_\ucca0\ud68c(@RequestBody List<AlmIssue> AlmIssue2) throws Exception {
        log.info("[ ReqStatusController :: \uc694\uad6c\uc0ac\ud56d_\ud558\uc704\uc774\uc288_\uc5f0\uacb0\uc774\uc288_\uc870\ud68c ] :: \uc774\uc288\uc0ad\uc81c_\ucca0\ud68c {}", AlmIssue2);
        return ResponseEntity.ok((Object)CommonResponse.success((Object)this.engineService.\uc774\uc288\uc0ad\uc81c_\ucca0\ud68c(AlmIssue2)));
    }

    @ResponseBody
    @RequestMapping(value={"/{changeReqTableName}/updateStatusNode.do"}, method={RequestMethod.PUT})
    public ResponseEntity<?> \uc694\uad6c\uc0ac\ud56d_\uc0c1\ud669_\uc218\uc815\ud558\uae30(@PathVariable(value="changeReqTableName") String changeReqTableName, @RequestBody ReqStatusDTO reqStatusDTO) throws Exception {
        log.info("ReqStatusController :: updateStatusNode");
        ReqStatusEntity statusEntity = (ReqStatusEntity)this.modelMapper.map((Object)reqStatusDTO, ReqStatusEntity.class);
        SessionUtil.setAttribute((String)"updateStatusNode", (Object)changeReqTableName);
        int \uacb0\uacfc = this.reqStatus.updateNode((TreeSearchEntity)statusEntity);
        SessionUtil.removeAttribute((String)"updateStatusNode");
        return ResponseEntity.ok((Object)CommonResponse.success((Object)\uacb0\uacfc));
    }

    @ResponseBody
    @RequestMapping(value={"/{changeReqTableName}/getStatistics.do"}, method={RequestMethod.GET})
    public ModelAndView getStatistics(@PathVariable(value="changeReqTableName") String changeReqTableName, ReqStatusDTO reqStatusDTO, ModelMap model, HttpServletRequest request) throws Exception {
        log.info("ReqStatusController :: getStatistics");
        ReqStatusEntity statusEntity = (ReqStatusEntity)this.modelMapper.map((Object)reqStatusDTO, ReqStatusEntity.class);
        SessionUtil.setAttribute((String)"getStatistics", (Object)changeReqTableName);
        statusEntity.setOrder(Order.asc((String)"c_left"));
        List list = this.reqStatus.getNodesWithoutRoot((TreeSearchEntity)statusEntity);
        List versionList = list.stream().map(ReqStatusEntity::getC_req_pdservice_versionset_link).distinct().collect(Collectors.toList());
        List jiraServerList = list.stream().map(ReqStatusEntity::getC_jira_server_link).distinct().collect(Collectors.toList());
        List jiraProjectList = list.stream().map(ReqStatusEntity::getC_jira_project_link).distinct().collect(Collectors.toList());
        List reqList = list.stream().map(ReqStatusEntity::getC_req_link).distinct().collect(Collectors.toList());
        List issueList = list.stream().map(ReqStatusEntity::getC_issue_key).distinct().collect(Collectors.toList());
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        result.put("version", versionList.size());
        result.put("jiraServer", jiraServerList.size());
        result.put("jiraProject", jiraProjectList.size());
        result.put("req", reqList.size());
        result.put("issue", issueList.size());
        SessionUtil.removeAttribute((String)"getStatistics");
        ModelAndView modelAndView = new ModelAndView("jsonView");
        modelAndView.addObject("result", result);
        return modelAndView;
    }

    @ResponseBody
    @RequestMapping(value={"/{changeReqTableName}/reqIssues-created-together.do"}, method={RequestMethod.GET})
    public ResponseEntity<?> \uc694\uad6c\uc0ac\ud56d_\uc774\uc288_\ubb36\uc74c_\uc870\ud68c(@PathVariable(value="changeReqTableName") String changeReqTableName, ReqStatusDTO reqStatusDTO, HttpServletRequest request) {
        ReqStatusEntity statusEntity = (ReqStatusEntity)this.modelMapper.map((Object)reqStatusDTO, ReqStatusEntity.class);
        statusEntity.setOrder(Order.asc((String)"c_left"));
        ParameterParser parser = new ParameterParser((ServletRequest)request);
        String \uc81c\ud488\uc11c\ube44\uc2a4_\uc544\uc774\ub514 = StringUtils.replace((String)changeReqTableName, (String)"T_ARMS_REQSTATUS_", (String)"");
        String pds_version = parser.get("pdServiceVersions");
        Long[] \uc81c\ud488\uc11c\ube44\uc2a4_\ubc84\uc804 = (Long[])Arrays.stream(pds_version.split(",")).map(Long::valueOf).toArray(Long[]::new);
        String \uc694\uad6c\uc0ac\ud56d_\uc544\uc774\ub514 = parser.get("cReqLink");
        log.info("[ ReqStatusController :: \uc694\uad6c\uc0ac\ud56d_\uc774\uc288_\ubb36\uc74c_\uc870\ud68c reqIssues-created-together.do ] :: pdServiceId => {}, pds_versions => {}, cReqLink => {}", new Object[]{\uc81c\ud488\uc11c\ube44\uc2a4_\uc544\uc774\ub514, \uc81c\ud488\uc11c\ube44\uc2a4_\ubc84\uc804, \uc694\uad6c\uc0ac\ud56d_\uc544\uc774\ub514});
        ResponseEntity \uc694\uad6c\uc0ac\ud56d_\uc774\uc288_\ubb36\uc74c_\uc870\ud68c = this.engineService.\uc694\uad6c\uc0ac\ud56d_\ubb36\uc74c_\uc870\ud68c(Long.valueOf(\uc81c\ud488\uc11c\ube44\uc2a4_\uc544\uc774\ub514), \uc81c\ud488\uc11c\ube44\uc2a4_\ubc84\uc804, Long.valueOf(\uc694\uad6c\uc0ac\ud56d_\uc544\uc774\ub514));
        List \uc694\uad6c\uc0ac\ud56d_\uc774\uc288_\ubaa9\ub85d = Optional.ofNullable((List)\uc694\uad6c\uc0ac\ud56d_\uc774\uc288_\ubb36\uc74c_\uc870\ud68c.getBody()).orElse(new ArrayList());
        log.info("[ ReqStatusController :: \uc694\uad6c\uc0ac\ud56d\uc774\uc288_\ubb36\uc74c_\uc870\ud68c reqIssues-created-together.do ] :: \uc870\ud68c\ub41c \uc694\uad6c\uc0ac\ud56d \uc774\uc288\uc758 \uc218 => {} ", (Object)\uc694\uad6c\uc0ac\ud56d_\uc774\uc288_\ubaa9\ub85d.size());
        return ResponseEntity.ok((Object)CommonResponse.success((Object)\uc694\uad6c\uc0ac\ud56d_\uc774\uc288_\ubaa9\ub85d));
    }

    @ResponseBody
    @RequestMapping(value={"/{changeReqTableName}/getReqAndReqIssueAndLinkedIssue.do"}, method={RequestMethod.GET})
    public ModelAndView getReqAndReqIssueAndLinkedIssue(@PathVariable(value="changeReqTableName") String changeReqTableName, ReqStatusDTO reqStatusDTO, HttpServletRequest request) throws Exception {
        ReqStatusEntity statusEntity = (ReqStatusEntity)this.modelMapper.map((Object)reqStatusDTO, ReqStatusEntity.class);
        statusEntity.setOrder(Order.asc((String)"c_req_link"));
        ReqStatusEntity \uac80\uc0c9_\uc804\uc6a9 = new ReqStatusEntity();
        \uac80\uc0c9_\uc804\uc6a9.setC_pdservice_link(statusEntity.getC_pdservice_link());
        \uac80\uc0c9_\uc804\uc6a9.setWhereIn("c_pds_version_link", (Object[])request.getParameterValues("pdServiceLinks"));
        \uac80\uc0c9_\uc804\uc6a9.setOrder(Order.asc((String)"c_req_link"));
        List \uc694\uad6c\uc0ac\ud56d_\uc5f0\uacb0\uc774\uc288_\uac80\uc0c9_\uacb0\uacfc = this.reqStatus.getChildNode((TreeSearchEntity)\uac80\uc0c9_\uc804\uc6a9);
        ModelAndView modelAndView = new ModelAndView("jsonView");
        return modelAndView;
    }

    @ResponseBody
    @RequestMapping(value={"/{changeReqTableName}/getPdReqStats.do"}, method={RequestMethod.GET})
    public ModelAndView getPdReqStats(@PathVariable(value="changeReqTableName") String changeReqTableName, HttpServletRequest request) {
        log.info("ReqStatusController :: getPdReqStats");
        Long \uc81c\ud488\uc11c\ube44\uc2a4_\uc544\uc774\ub514 = Long.parseLong(StringUtils.replace((String)changeReqTableName, (String)"T_ARMS_REQSTATUS_", (String)""));
        String \ub2f4\ub2f9\uc790_\uc774\uba54\uc77c = request.getParameter("assigneeEmail");
        ModelAndView modelAndView = new ModelAndView("jsonView");
        modelAndView.addObject("result", (Object)this.engineService.\uc81c\ud488\uc11c\ube44\uc2a4\ubcc4_\ub2f4\ub2f9\uc790_\uc694\uad6c\uc0ac\ud56d_\ud1b5\uacc4(Long.valueOf(0L), \uc81c\ud488\uc11c\ube44\uc2a4_\uc544\uc774\ub514, \ub2f4\ub2f9\uc790_\uc774\uba54\uc77c));
        return modelAndView;
    }

    @ResponseBody
    @RequestMapping(value={"/{changeReqTableName}/getPdRelatedReqStats.do"}, method={RequestMethod.GET})
    public ModelAndView getPdRelatedReqStats(@PathVariable(value="changeReqTableName") String changeReqTableName, ReqStatusDTO reqStatusDTO, HttpServletRequest request) throws Exception {
        log.info("ReqStatusController :: getPdRelatedReqStats");
        Long \uc81c\ud488\uc11c\ube44\uc2a4_\uc544\uc774\ub514 = Long.parseLong(StringUtils.replace((String)changeReqTableName, (String)"T_ARMS_REQSTATUS_", (String)""));
        JiraServerPureEntity \uac80\uc0c9\uc6a9_\uc9c0\ub77c\uc11c\ubc84 = new JiraServerPureEntity();
        \uac80\uc0c9\uc6a9_\uc9c0\ub77c\uc11c\ubc84.setC_id(reqStatusDTO.getC_jira_server_link());
        JiraServerPureEntity \uac80\uc0c9\uacb0\uacfc_\uc9c0\ub77c\uc11c\ubc84 = (JiraServerPureEntity)this.jiraServer.getNode((TreeSearchEntity)\uac80\uc0c9\uc6a9_\uc9c0\ub77c\uc11c\ubc84);
        ReqStatusEntity reqStatusEntity = (ReqStatusEntity)this.modelMapper.map((Object)reqStatusDTO, ReqStatusEntity.class);
        SessionUtil.setAttribute((String)"getPdRelatedReqStats", (Object)changeReqTableName);
        SimpleExpression searchService = Restrictions.eq((String)"c_pdservice_link", (Object)\uc81c\ud488\uc11c\ube44\uc2a4_\uc544\uc774\ub514);
        SimpleExpression searchReq = Restrictions.eq((String)"c_req_link", (Object)reqStatusDTO.getC_req_link());
        LogicalExpression criterion = Restrictions.and((Criterion)searchService, (Criterion)searchReq);
        reqStatusEntity.getCriterions().add(criterion);
        ReqStatusEntity \uac80\uc0c9\uacb0\uacfc_\uc694\uad6c\uc0ac\ud56d = (ReqStatusEntity)this.reqStatus.getNode((TreeSearchEntity)reqStatusEntity);
        Long \uc9c0\ub77c\uc11c\ubc84_\uc544\uc774\ub514 = Long.parseLong(\uac80\uc0c9\uacb0\uacfc_\uc9c0\ub77c\uc11c\ubc84.getC_jira_server_etc());
        String \uc774\uc288\ud0a4 = \uac80\uc0c9\uacb0\uacfc_\uc694\uad6c\uc0ac\ud56d.getC_issue_key();
        String \ub2f4\ub2f9\uc790_\uc774\uba54\uc77c = request.getParameter("assigneeEmail");
        log.info("\uc9c0\ub77c\uc11c\ubc84_\uc544\uc774\ub514: {}", (Object)\uc9c0\ub77c\uc11c\ubc84_\uc544\uc774\ub514);
        log.info("\uc81c\ud488\uc11c\ube44\uc2a4_\uc544\uc774\ub514: {}", (Object)\uc81c\ud488\uc11c\ube44\uc2a4_\uc544\uc774\ub514);
        log.info("\uc774\uc288\ud0a4: {}", (Object)\uc774\uc288\ud0a4);
        log.info("\ub2f4\ub2f9\uc790_\uc774\uba54\uc77c: {}", (Object)\ub2f4\ub2f9\uc790_\uc774\uba54\uc77c);
        SessionUtil.removeAttribute((String)"getPdRelatedReqStats");
        ModelAndView modelAndView = new ModelAndView("jsonView");
        modelAndView.addObject("result", (Object)this.engineService.\uc81c\ud488\uc11c\ube44\uc2a4\ubcc4_\ub2f4\ub2f9\uc790_\uc5f0\uad00\ub41c_\uc694\uad6c\uc0ac\ud56d_\ud1b5\uacc4(\uc9c0\ub77c\uc11c\ubc84_\uc544\uc774\ub514, \uc81c\ud488\uc11c\ube44\uc2a4_\uc544\uc774\ub514, \uc774\uc288\ud0a4, \ub2f4\ub2f9\uc790_\uc774\uba54\uc77c));
        return modelAndView;
    }

    @ResponseBody
    @RequestMapping(value={"/{changeReqTableName}/getReqStatusListByCReqLink.do"}, method={RequestMethod.GET})
    public ResponseEntity<List<ReqStatusEntity>> getReqStatusListByCReqLink(@PathVariable(value="changeReqTableName") String changeReqTableName, ReqStatusDTO reqStatusDTO, ModelMap model, HttpServletRequest request) throws Exception {
        log.info("ReqStatusController :: getReqStatusListByCReqLink");
        ReqStatusEntity reqStatusEntity = (ReqStatusEntity)this.modelMapper.map((Object)reqStatusDTO, ReqStatusEntity.class);
        SessionUtil.setAttribute((String)"getReqStatusListByCReqLink", (Object)changeReqTableName);
        Long cReqLink = reqStatusEntity.getC_req_link();
        reqStatusEntity.getCriterions().add(Restrictions.eq((String)"c_req_link", (Object)cReqLink));
        reqStatusEntity.setOrder(Order.asc((String)"c_id"));
        List list = this.reqStatus.getChildNode((TreeSearchEntity)reqStatusEntity);
        SessionUtil.removeAttribute((String)"getReqStatusListByCReqLink");
        return ResponseEntity.ok((Object)list);
    }

    @ResponseBody
    @RequestMapping(value={"/{changeReqTableName}/getStatusNode.do"}, method={RequestMethod.GET})
    public ResponseEntity<List<ReqStatusEntity>> getStatusNode(@PathVariable(value="changeReqTableName") String changeReqTableName, ReqStatusDTO reqStatusDTO, ModelMap model, HttpServletRequest request) throws Exception {
        log.info("ReqStatusController :: getStatusNode");
        ReqStatusEntity reqStatusEntity = (ReqStatusEntity)this.modelMapper.map((Object)reqStatusDTO, ReqStatusEntity.class);
        SessionUtil.setAttribute((String)"getStatusNode", (Object)changeReqTableName);
        reqStatusEntity.getCriterions().add(Restrictions.eq((String)"c_id", (Object)reqStatusDTO.getC_id()));
        reqStatusEntity.setOrder(Order.asc((String)"c_id"));
        List list = this.reqStatus.getChildNode((TreeSearchEntity)reqStatusEntity);
        SessionUtil.removeAttribute((String)"getStatusNode");
        return ResponseEntity.ok((Object)list);
    }

    @ResponseBody
    @RequestMapping(value={"/{changeReqTableName}/reqStatusCheckAfterAlmProcess.do"}, method={RequestMethod.POST})
    public ResponseEntity<?> \uc694\uad6c\uc0ac\ud56d_\uc0c1\ud0dc_\ud655\uc778\ud6c4_ALM\ucc98\ub9ac_\ubc0f_REQSTATUS_\uc5c5\ub370\uc774\ud2b8(@PathVariable(value="changeReqTableName") String changeReqTableName, @RequestBody ReqStatusDTO reqStatusDTO) throws Exception {
        log.info("ReqStatusController :: \uc694\uad6c\uc0ac\ud56d_\uc0c1\ud0dc_\ud655\uc778\ud6c4_ALM\ucc98\ub9ac_\ubc0f_REQSTATUS_\uc5c5\ub370\uc774\ud2b8 \uc2dc\uc791");
        SessionUtil.setAttribute((String)"reqStatusCheckAfterAlmProcess", (Object)changeReqTableName);
        String pdServiceStr = StringUtils.replace((String)changeReqTableName, (String)"T_ARMS_REQSTATUS_", (String)"");
        Long \uc81c\ud488\uc11c\ube44\uc2a4_\uc544\uc774\ub514 = Long.parseLong(pdServiceStr);
        this.reqStatus.reqStatusCheckAfterAlmProcess(reqStatusDTO, \uc81c\ud488\uc11c\ube44\uc2a4_\uc544\uc774\ub514);
        SessionUtil.removeAttribute((String)"reqStatusCheckAfterAlmProcess");
        log.info("ReqStatusController :: \uc694\uad6c\uc0ac\ud56d_\uc0c1\ud0dc_\ud655\uc778\ud6c4_ALM\ucc98\ub9ac_\ubc0f_REQSTATUS_\uc5c5\ub370\uc774\ud2b8 \uc885\ub8cc");
        return ResponseEntity.ok((Object)CommonResponse.success((Object)"200 ok"));
    }

    @ResponseBody
    @RequestMapping(value={"/{changeReqTableName}/removeNode.do"}, method={RequestMethod.DELETE})
    public ResponseEntity<?> removeReqStatusNode(@PathVariable(value="changeReqTableName") String changeReqTableName, @RequestBody ReqStatusDTO reqStatusDTO) throws Exception {
        SessionUtil.setAttribute((String)"removeNode", (Object)changeReqTableName);
        ReqStatusEntity reqStatusEntity = (ReqStatusEntity)this.modelMapper.map((Object)reqStatusDTO, ReqStatusEntity.class);
        int result = this.reqStatus.removeNode((TreeSearchEntity)reqStatusEntity);
        SessionUtil.removeAttribute((String)"removeNode");
        return ResponseEntity.ok((Object)CommonResponse.success((Object)result));
    }

    @GetMapping(value={"/issueListByUpdatedDate"})
    public ResponseEntity<List<AlmIssue>> issueListByUpdatedDate(RequirementDTO requirementDTO) {
        return ResponseEntity.ok((Object)((List)this.engineService.issueListByUpdatedDate(requirementDTO).getBody()));
    }

    @GetMapping(value={"/issue-list-by-updated-2nd"})
    public ResponseEntity<List<AlmIssue>> issueListByUpdated2ndTab(RequirementDTO requirementDTO) {
        return ResponseEntity.ok((Object)((List)this.engineService.issueListByUpdated2ndTab(requirementDTO).getBody()));
    }

    @GetMapping(value={"/{changeReqTableName}/issue-list-by-updated"})
    public ResponseEntity<CommonResponse.ApiResult<List<HierarchicalAlmIssue>>> issueListByUpdated(@PathVariable(value="changeReqTableName") String changeReqTableName, @RequestParam(value="pdServiceVersionLinks") List<Long> pdServiceVersionLinks) throws Exception {
        log.info("[ ReqStatusController :: issueListByUpdated ] :: changeReqTableName => {}", (Object)changeReqTableName);
        Long pdServiceLink = Long.valueOf(StringUtils.replace((String)changeReqTableName, (String)"T_ARMS_REQSTATUS_", (String)""));
        return ResponseEntity.ok((Object)CommonResponse.success((Object)this.reqStatus.getHierarchicalAlmIssuesByAdvancedDiscovery(pdServiceLink, pdServiceVersionLinks)));
    }

    @PostMapping(value={"/subtasks-and-linked-issues"})
    public ResponseEntity<CommonResponse.ApiResult<List<HierarchicalAlmIssue>>> subtasksAndLinkedIssues(@RequestBody SubtaskAndLinkedIssuesRequestDTO requestDTO) throws Exception {
        return ResponseEntity.ok((Object)CommonResponse.success((Object)this.reqStatus.getSubtasksAndLinkedIssues(requestDTO)));
    }

    @GetMapping(value={"/issueListByOverallUpdatedDate"})
    public ResponseEntity<List<AlmIssue>> issueListByOverallUpdatedDate(RequirementDTO requirementDTO) {
        return ResponseEntity.ok((Object)((List)this.engineService.issueListByOverallUpdatedDate(requirementDTO).getBody()));
    }

    @ResponseBody
    @RequestMapping(value={"/{changeReqTableName}/reqStatus-dashboard"}, method={RequestMethod.GET})
    public ResponseEntity<ReqStatusDashboardVO> getReqStatusDashboard(@PathVariable(value="changeReqTableName") String changeReqTableName, RequirementDTO requirementDTO) throws Exception {
        String pdServiceStr = StringUtils.replace((String)changeReqTableName, (String)"T_ARMS_REQSTATUS_", (String)"");
        Long pdServiceId = Long.parseLong(pdServiceStr);
        List pdServiceVersionIds = requirementDTO.getPdServiceAndIsReq().getPdServiceVersionLinks();
        return ResponseEntity.ok((Object)this.reqStatus.reqStatusDashboard(pdServiceId, pdServiceVersionIds));
    }
}

