/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.requirement.reqcomment.controller;

import com.arms.api.requirement.reqcomment.model.ReqCommentDTO;
import com.arms.api.requirement.reqcomment.model.ReqCommentEntity;
import com.arms.api.requirement.reqcomment.service.ReqComment;
import com.arms.egovframework.javaservice.treeframework.controller.CommonResponse;
import com.arms.egovframework.javaservice.treeframework.controller.TreeAbstractController;
import com.arms.egovframework.javaservice.treeframework.dao.TreeDao;
import com.arms.egovframework.javaservice.treeframework.model.TreeSearchEntity;
import com.arms.egovframework.javaservice.treeframework.service.TreeService;
import com.arms.egovframework.javaservice.treeframework.util.Util_TitleChecker;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.LogicalExpression;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/arms/reqComment"})
public class ReqCommentController
extends TreeAbstractController<ReqComment, ReqCommentDTO, ReqCommentEntity> {
    private static final Logger log = LoggerFactory.getLogger(ReqCommentController.class);
    @Autowired
    @Qualifier(value="reqComment")
    private ReqComment reqComment;
    @Resource(name="treeDao")
    private TreeDao treeDao;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @PostConstruct
    public void initialize() {
        this.setTreeService((TreeService)this.reqComment);
        this.setTreeEntity(ReqCommentEntity.class);
    }

    @ResponseBody
    @RequestMapping(value={"/getReqCommentList.do"}, method={RequestMethod.GET})
    public ResponseEntity<?> getReqCommentList(ReqCommentDTO reqCommentDTO, ModelMap model, HttpServletRequest request) throws Exception {
        log.info("ReqCommentController :: getReqCommentList");
        ReqCommentEntity reqCommentEntity = (ReqCommentEntity)this.modelMapper.map((Object)reqCommentDTO, ReqCommentEntity.class);
        List reqCommentEntities = this.reqComment.getNodesWithoutRoot((TreeSearchEntity)reqCommentEntity);
        List result = reqCommentEntities.stream().filter(data -> data.getC_pdservice_link().equals(reqCommentDTO.getC_pdservice_link()) && data.getC_req_link().equals(reqCommentDTO.getC_req_link())).collect(Collectors.toList());
        return ResponseEntity.ok((Object)CommonResponse.success(result));
    }

    @ResponseBody
    @RequestMapping(value={"/getUserReqCommentList.do"}, method={RequestMethod.GET})
    public ResponseEntity<?> getUserReqCommentList(ReqCommentDTO reqCommentDTO, ModelMap model, HttpServletRequest request) throws Exception {
        log.info("ReqCommentController :: getReqCommentList");
        ReqCommentEntity reqCommentEntity = (ReqCommentEntity)this.modelMapper.map((Object)reqCommentDTO, ReqCommentEntity.class);
        List reqCommentEntities = this.reqComment.getNodesWithoutRoot((TreeSearchEntity)reqCommentEntity);
        List result = reqCommentEntities.stream().filter(data -> data.getC_req_comment_sender().equals(reqCommentDTO.getC_req_comment_sender())).collect(Collectors.toList());
        return ResponseEntity.ok((Object)CommonResponse.success(result));
    }

    @ResponseBody
    @RequestMapping(value={"/getReqCommentChildNode.do"}, method={RequestMethod.GET})
    public ResponseEntity<?> getReqCommentChildNode(ReqCommentDTO reqCommentDTO, ModelMap model, HttpServletRequest request) throws Exception {
        log.info("ReqCommentController :: getReqCommentChildNode");
        ReqCommentEntity reqCommentEntity = (ReqCommentEntity)this.modelMapper.map((Object)reqCommentDTO, ReqCommentEntity.class);
        SimpleExpression criterion1 = Restrictions.eq((String)"c_pdservice_link", (Object)reqCommentDTO.getC_pdservice_link());
        SimpleExpression criterion2 = Restrictions.eq((String)"c_req_link", (Object)reqCommentDTO.getC_req_link());
        LogicalExpression criterion = Restrictions.and((Criterion)criterion1, (Criterion)criterion2);
        reqCommentEntity.getCriterions().add(criterion);
        reqCommentEntity.getOrder().add(Order.desc((String)"c_req_comment_date"));
        List list = this.reqComment.getChildNode((TreeSearchEntity)reqCommentEntity);
        return ResponseEntity.ok((Object)CommonResponse.success((Object)list));
    }

    @Transactional
    @ResponseBody
    @RequestMapping(value={"/getReqCommentPagingByPdService.do"}, method={RequestMethod.GET})
    public ResponseEntity<?> getReqCommentPagingByPdService(ReqCommentDTO reqCommentDTO, ModelMap model, HttpServletRequest request, @RequestParam int pageIndex, @RequestParam int pageUnit) throws Exception {
        log.info("ReqCommentController :: getReqCommentPagingByPdService");
        ReqCommentEntity reqCommentEntity = (ReqCommentEntity)this.modelMapper.map((Object)reqCommentDTO, ReqCommentEntity.class);
        SimpleExpression search_pdservice = Restrictions.eq((String)"c_pdservice_link", (Object)reqCommentDTO.getC_pdservice_link());
        SimpleExpression search_req = Restrictions.eq((String)"c_req_link", (Object)reqCommentDTO.getC_req_link());
        LogicalExpression search_criteria = Restrictions.and((Criterion)search_pdservice, (Criterion)search_req);
        reqCommentEntity.getCriterions().add(search_criteria);
        reqCommentEntity.getOrder().add(Order.desc((String)"c_req_comment_date"));
        reqCommentEntity.setPageIndex(pageIndex);
        reqCommentEntity.setPageUnit(pageUnit);
        List list = this.reqComment.getPaginatedChildNode((TreeSearchEntity)reqCommentEntity);
        return ResponseEntity.ok((Object)CommonResponse.success((Object)list));
    }

    @ResponseBody
    @RequestMapping(value={"/getTotalCountReqComment.do"}, method={RequestMethod.GET})
    public ResponseEntity<?> getTotalCountReqComment(ReqCommentDTO reqCommentDTO, ModelMap model, HttpServletRequest request) throws Exception {
        log.info("ReqCommentController :: getTotalCountReqComment");
        ReqCommentEntity reqCommentEntity = (ReqCommentEntity)this.modelMapper.map((Object)reqCommentDTO, ReqCommentEntity.class);
        SimpleExpression search_pdservice = Restrictions.eq((String)"c_pdservice_link", (Object)reqCommentDTO.getC_pdservice_link());
        SimpleExpression search_req = Restrictions.eq((String)"c_req_link", (Object)reqCommentDTO.getC_req_link());
        LogicalExpression search_criteria = Restrictions.and((Criterion)search_pdservice, (Criterion)search_req);
        reqCommentEntity.getCriterions().add(search_criteria);
        this.treeDao.setClazz(reqCommentEntity.getClass());
        int totalCount = this.treeDao.getCount((TreeSearchEntity)reqCommentEntity);
        return ResponseEntity.ok((Object)CommonResponse.success((Object)totalCount));
    }

    @ResponseBody
    @RequestMapping(value={"/addReqComment.do"}, method={RequestMethod.POST})
    public ResponseEntity<?> addReqComment(ReqCommentDTO reqCommentDTO, ModelMap model, HttpServletRequest request) throws Exception {
        log.info("ReqCommentController :: addReqComment");
        ReqCommentEntity reqCommentEntity = (ReqCommentEntity)this.modelMapper.map((Object)reqCommentDTO, ReqCommentEntity.class);
        reqCommentEntity.setC_title(Util_TitleChecker.StringReplace((String)reqCommentEntity.getC_title()));
        reqCommentEntity.setC_req_comment_date(new Date());
        ModelAndView modelAndView = new ModelAndView("jsonView");
        modelAndView.addObject("result", (Object)this.reqComment.addNode((TreeSearchEntity)reqCommentEntity));
        return ResponseEntity.ok((Object)CommonResponse.success((Object)modelAndView));
    }
}

