/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.report.mail.service.mailreport;

import com.arms.api.product_service.pdservice.model.PdServiceAndVersionListDTO;
import com.arms.api.product_service.pdserviceversion.model.PdServiceVersionEntity;
import com.arms.api.report.fulldata.model.FullDataRequestDTO;
import com.arms.api.report.fulldata.model.FullDataResponseDTO;
import com.arms.api.report.mail.modal.vo.AssigneeIssueCountVO;
import com.arms.api.report.mail.modal.vo.TopMenuResourceVO;
import com.arms.api.report.mail.modal.vo.TopMenuScopeVO;
import com.arms.api.report.mail.modal.vo.TopMenuTimeVO;
import com.arms.api.report.mail.service.mailreport.MailReportService;
import com.arms.api.util.communicate.external.EngineService;
import com.arms.api.util.communicate.external.response.jira.AlmIssue;
import com.arms.api.util.communicate.internal.InternalService;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="mailReportService")
public class MailReportServiceImpl
implements MailReportService {
    private static final Logger log = LoggerFactory.getLogger(MailReportServiceImpl.class);
    private final InternalService internalService;
    private final EngineService engineService;

    public TopMenuTimeVO getTopMenuTime() {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm");
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        List pdServices = (List)this.internalService.getPdServiceEntityAndVersionList().getBody();
        if (pdServices == null) {
            String errorLog = "[MailReportServiceImpl :: getTopMenuTime] :: internalService.PdServiceEntityAndVersionList is null.";
            log.error(errorLog);
            throw new RuntimeException(errorLog);
        }
        int total = 0;
        int ongoing = 0;
        int completed = 0;
        int upcoming = 0;
        LocalDateTime now = LocalDateTime.now();
        LocalDate earliestStartDate = null;
        LocalDate latestEndDate = null;
        for (PdServiceAndVersionListDTO pdService : pdServices) {
            List versions = pdService.getPdServiceVersionEntityList();
            for (PdServiceVersionEntity version : versions) {
                ++total;
                LocalDateTime startDateTime = LocalDateTime.parse(version.getC_pds_version_start_date(), formatter);
                LocalDateTime endDateTime = LocalDateTime.parse(version.getC_pds_version_end_date(), formatter);
                LocalDate startDate = startDateTime.toLocalDate();
                LocalDate endDate = endDateTime.toLocalDate();
                if (now.isBefore(startDateTime)) {
                    ++upcoming;
                    continue;
                }
                if (now.isAfter(endDateTime)) {
                    ++completed;
                    continue;
                }
                ++ongoing;
                if (earliestStartDate == null || startDate.isBefore(earliestStartDate)) {
                    earliestStartDate = startDate;
                }
                if (latestEndDate != null && !endDate.isAfter(latestEndDate)) continue;
                latestEndDate = endDate;
            }
        }
        long daysElapsed = 0L;
        int elapsedPercentage = 0;
        if (earliestStartDate != null && latestEndDate != null) {
            daysElapsed = Duration.between(earliestStartDate.atStartOfDay(), now).toDays();
            long totalDuration = Duration.between(earliestStartDate.atStartOfDay(), latestEndDate.atStartOfDay()).toMillis();
            long elapsedDuration = Duration.between(earliestStartDate.atStartOfDay(), now).toMillis();
            elapsedPercentage = (int)(elapsedDuration * 100L / totalDuration);
        }
        String earliestStart = earliestStartDate != null ? earliestStartDate.format(dateFormatter) : null;
        String latestEnd = latestEndDate != null ? latestEndDate.format(dateFormatter) : null;
        return new TopMenuTimeVO(total, ongoing, completed, upcoming, daysElapsed, elapsedPercentage, earliestStart, latestEnd);
    }

    public TopMenuScopeVO getTopMenuScope() throws Exception {
        try {
            List services = this.getOngoingPdServiceAndVersionList();
            FullDataRequestDTO requestDTO = this.setFullDataRequestDTO(services);
            FullDataResponseDTO responseDTO = (FullDataResponseDTO)this.engineService.getReqIssueList(requestDTO).getBody();
            if (responseDTO == null) {
                String errorLog = "[MailReportServiceImpl :: getTopMenuScope] :: engineService.getReqIssueList(requestDTO).getBody() is null.";
                log.error(errorLog);
                throw new RuntimeException(errorLog);
            }
            Long reqTotalCount = responseDTO.getTotalHits();
            List reqList = responseDTO.getIssueEntityList();
            Map stateMap = this.countByCReqStateLink(reqList);
            Long createdReqCount = this.countIssuesCreatedThisWeek(reqList);
            return new TopMenuScopeVO(reqTotalCount, stateMap.getOrDefault("\uc5f4\ub9bc", 0L), stateMap.getOrDefault("\uc9c4\ud589\uc911", 0L), stateMap.getOrDefault("\ud574\uacb0\ub428", 0L), stateMap.getOrDefault("\ub2eb\ud798", 0L), createdReqCount, 0);
        }
        catch (Exception e) {
            throw new Exception("\uba54\uc77c \ub9ac\ud3ec\ud2b8 \ud0d1\uba54\ub274 \uc2a4\ucf65 \uc870\ud68c\uc2dc \uc624\ub958 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4." + e.getMessage());
        }
    }

    public TopMenuResourceVO getTopMenuResource() throws Exception {
        try {
            List services = this.getOngoingPdServiceAndVersionList();
            FullDataRequestDTO requestDTO = this.setFullDataRequestDTO(services);
            AssigneeIssueCountVO responseDTO = (AssigneeIssueCountVO)this.engineService.getAssigneeAggregationList(requestDTO).getBody();
            if (responseDTO == null) {
                String errorLog = "[MailReportServiceImpl :: getTopMenuResource] :: engineService.getAssigneeAggregationList(requestDTO).getBody() is null.";
                log.error(errorLog);
                throw new RuntimeException(errorLog);
            }
            return new TopMenuResourceVO(responseDTO.getTotalIssueCount(), responseDTO.getTotalAssigneeCount(), responseDTO.getAvgIssuesPerAssignee(), responseDTO.getMaxIssues(), responseDTO.getMinIssues());
        }
        catch (Exception e) {
            throw new Exception("\uba54\uc77c \ub9ac\ud3ec\ud2b8 \ud0d1\uba54\ub274 \ub9ac\uc18c\uc2a4 \uc870\ud68c\uc2dc \uc624\ub958 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4." + e.getMessage());
        }
    }

    public long countIssuesCreatedThisWeek(List<AlmIssue> issues) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(7, 2);
        Date weekStartDate = calendar.getTime();
        calendar.add(5, 6);
        Date weekEndDate = calendar.getTime();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        return issues.stream().filter(issue -> {
            try {
                Date createdDate = dateFormat.parse(issue.getCreated());
                return !createdDate.before(weekStartDate) && !createdDate.after(weekEndDate);
            }
            catch (Exception e) {
                return false;
            }
        }).count();
    }

    private FullDataRequestDTO setFullDataRequestDTO(List<PdServiceAndVersionListDTO> services) {
        List pdServiceCids = services.stream().map(PdServiceAndVersionListDTO::getC_id).collect(Collectors.toList());
        List pdServiceVersionIds = services.stream().flatMap(service -> service.getPdServiceVersionEntityList().stream()).map(PdServiceVersionEntity::getC_id).collect(Collectors.toList());
        FullDataRequestDTO fullDataRequestDTO = new FullDataRequestDTO();
        fullDataRequestDTO.setPdServiceIds(pdServiceCids);
        fullDataRequestDTO.setPdServiceVersionIds(pdServiceVersionIds);
        return fullDataRequestDTO;
    }

    public Map<String, Long> countByCReqStateLink(List<AlmIssue> reqList) {
        return reqList.stream().map(AlmIssue::getCReqProperty).filter(Objects::nonNull).map(AlmIssue.\uc554\uc2a4_\uc694\uad6c\uc0ac\ud56d_\uc18d\uc131::getCReqStateName).filter(Objects::nonNull).collect(Collectors.groupingBy(stateLink -> stateLink, Collectors.counting()));
    }

    private List<PdServiceAndVersionListDTO> getOngoingPdServiceAndVersionList() {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm");
        LocalDateTime now = LocalDateTime.now();
        List pdServices = (List)this.internalService.getPdServiceEntityAndVersionList().getBody();
        if (pdServices == null) {
            String errorLog = "[MailReportServiceImpl :: getOngoingPdServiceAndVersionList] :: internalService.getPdServiceEntityAndVersionList().getBody() is null.";
            log.error(errorLog);
            throw new RuntimeException(errorLog);
        }
        return pdServices.stream().map(pdService -> {
            List ongoingVersions = pdService.getPdServiceVersionEntityList().stream().filter(version -> {
                LocalDateTime startDate = LocalDateTime.parse(version.getC_pds_version_start_date(), formatter);
                LocalDateTime endDate = LocalDateTime.parse(version.getC_pds_version_end_date(), formatter);
                return now.isAfter(startDate) && now.isBefore(endDate);
            }).collect(Collectors.toList());
            if (!ongoingVersions.isEmpty()) {
                pdService.setPdServiceVersionEntityList(ongoingVersions);
                return pdService;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public MailReportServiceImpl(InternalService internalService, EngineService engineService) {
        this.internalService = internalService;
        this.engineService = engineService;
    }
}

