/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.report.mail.service.mail;

import com.arms.api.report.mail.modal.EmailSendResult;
import com.arms.api.report.mail.modal.dto.sender.SenderDTO;
import com.arms.api.report.mail.modal.entity.receiver.ReceiverEntity;
import com.arms.api.report.mail.modal.entity.sender.SenderEntity;
import com.arms.api.report.mail.modal.vo.TopMenuResourceVO;
import com.arms.api.report.mail.modal.vo.TopMenuScopeVO;
import com.arms.api.report.mail.modal.vo.TopMenuTimeVO;
import com.arms.api.report.mail.service.mail.MailService;
import com.arms.api.report.mail.service.mailreport.MailReportService;
import com.arms.api.report.mail.service.receiver.ReceiverService;
import com.arms.api.report.mail.service.sender.SenderService;
import com.arms.egovframework.javaservice.treeframework.model.TreeSearchEntity;
import com.arms.egovframework.javaservice.treeframework.service.TreeServiceImpl;
import io.github.bonigarcia.wdm.WebDriverManager;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.function.Function;
import javax.mail.internet.MimeMessage;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Service;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.templateresolver.ClassLoaderTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;

@Service(value="mailService")
public class MailServiceImpl
extends TreeServiceImpl
implements MailService {
    private static final Logger log = LoggerFactory.getLogger(MailServiceImpl.class);
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final SenderService senderService;
    private final ReceiverService receiverService;
    private MailReportService mailReportService;

    public EmailSendResult validateSmtpConfig(SenderDTO senderDTO) throws Exception {
        JavaMailSenderImpl mailSender = new JavaMailSenderImpl();
        mailSender.setHost(senderDTO.getC_smtp_server());
        mailSender.setPort(senderDTO.getC_smtp_port().intValue());
        mailSender.setUsername(senderDTO.getC_sender_email());
        mailSender.setPassword(senderDTO.getC_sender_password());
        Properties props = mailSender.getJavaMailProperties();
        props.put("mail.smtp.auth", "true");
        props.put("mail.smtp.starttls.enable", "true");
        props.put("mail.smtp.starttls.required", "true");
        props.put("mail.smtp.ssl.enable", "true");
        props.put("mail.smtp.ssl.protocols", "TLSv1.2");
        EmailSendResult result = new EmailSendResult(null, true, null);
        try {
            mailSender.testConnection();
            result.setSuccess(true);
            return result;
        }
        catch (Exception e) {
            this.logger.error("SMTP \uc124\uc815 \uac80\uc99d \uc2e4\ud328: " + e.getMessage());
            result.setSuccess(false);
            result.setErrorMessage(e.getMessage());
            return result;
        }
    }

    public List<EmailSendResult> sendTestEmailsToAllUsers() throws Exception {
        SenderEntity smtpConfig = this.getSenderConfig();
        List receiverList = this.getReceiverList();
        JavaMailSenderImpl mailSender = this.createMailSender(smtpConfig);
        ArrayList<EmailSendResult> sendResults = new ArrayList<EmailSendResult>();
        for (ReceiverEntity receiver : receiverList) {
            EmailSendResult result = new EmailSendResult(receiver.getC_receiver_email(), true, null);
            try {
                SimpleMailMessage message = new SimpleMailMessage();
                message.setTo(receiver.getC_receiver_email());
                message.setFrom(smtpConfig.getC_sender_email());
                message.setSubject("A-RMS \ud14c\uc2a4\ud2b8 \uc774\uba54\uc77c");
                message.setText("\uc774\uba54\uc77c \ubc1c\uc1a1 \ud14c\uc2a4\ud2b8\uc785\ub2c8\ub2e4.");
                mailSender.send(message);
                this.logger.info("\ud14c\uc2a4\ud2b8 \uba54\uc77c\uc744 " + receiver.getC_receiver_email() + "\uc5d0\uac8c \uc804\uc1a1\ud558\uc600\uc2b5\ub2c8\ub2e4.");
            }
            catch (Exception e) {
                result.setSuccess(false);
                result.setErrorMessage(e.getMessage());
                this.logger.error("\ud14c\uc2a4\ud2b8 \uba54\uc77c \uc804\uc1a1 \uc2e4\ud328: " + e.getMessage());
            }
            sendResults.add(result);
        }
        return sendResults;
    }

    public EmailSendResult sendTestEmail(String userEmail) throws Exception {
        SenderEntity smtpConfig = this.getSenderConfig();
        JavaMailSenderImpl mailSender = this.createMailSender(smtpConfig);
        EmailSendResult result = new EmailSendResult(userEmail, true, null);
        try {
            SimpleMailMessage message = new SimpleMailMessage();
            message.setTo(userEmail);
            message.setFrom(smtpConfig.getC_sender_email());
            message.setSubject("A-RMS \ud14c\uc2a4\ud2b8 \uc774\uba54\uc77c");
            String dateTime = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm"));
            message.setText("\uc774\uba54\uc77c \ubc1c\uc1a1 \ud14c\uc2a4\ud2b8\uc785\ub2c8\ub2e4.\n\n\ubc1c\uc1a1 \uc2dc\uac01: " + dateTime);
            mailSender.send(message);
            this.logger.info("\ud14c\uc2a4\ud2b8 \uba54\uc77c\uc744 " + userEmail + "\uc5d0\uac8c \uc804\uc1a1\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        catch (Exception e) {
            result.setSuccess(false);
            result.setErrorMessage(e.getMessage());
            this.logger.error("\ud14c\uc2a4\ud2b8 \uba54\uc77c \uc804\uc1a1 \uc2e4\ud328: " + e.getMessage());
        }
        return result;
    }

    public List<EmailSendResult> sendEmailsToAllUsers() throws Exception {
        LocalTime now;
        SenderEntity smtpConfig = this.getSenderConfig();
        LocalTime sendTime = smtpConfig.getC_send_time();
        if (!sendTime.equals(now = LocalTime.now())) {
            log.info(" \ud604\uc7ac \uc2dc\uac04\uc774 \ubc1c\uc1a1 \uc2dc\uac04\uacfc \uc77c\uce58\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4. \uc774\uba54\uc77c \ubc1c\uc1a1\uc744 \uc911\ub2e8\ud569\ub2c8\ub2e4. ");
            return Collections.emptyList();
        }
        List receiverList = this.getReceiverList();
        JavaMailSenderImpl mailSender = this.createMailSender(smtpConfig);
        String htmlContent = this.fetchHtmlData();
        ArrayList<EmailSendResult> sendResults = new ArrayList<EmailSendResult>();
        for (ReceiverEntity receiver : receiverList) {
            String receiverActivate = receiver.getC_receiver_activate();
            boolean isActivated = receiverActivate != null && Boolean.parseBoolean(receiverActivate);
            if (!isActivated) continue;
            sendResults.add(this.sendHtmlEmail(mailSender, receiver.getC_receiver_email(), smtpConfig.getC_sender_email(), smtpConfig.getC_email_subject(), htmlContent));
        }
        return sendResults;
    }

    public SenderEntity getSenderConfig() throws Exception {
        List senderInfo = this.senderService.getNodesWithoutRoot((TreeSearchEntity)new SenderEntity());
        if (senderInfo == null || senderInfo.isEmpty()) {
            throw new RuntimeException("SMTP \uc124\uc815\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
        }
        return (SenderEntity)senderInfo.get(0);
    }

    private List<ReceiverEntity> getReceiverList() throws Exception {
        List receiverList = this.receiverService.getNodesWithoutRoot((TreeSearchEntity)new ReceiverEntity());
        if (receiverList == null || receiverList.isEmpty()) {
            throw new RuntimeException("\uc218\uc2e0\uc790 \uc774\uba54\uc77c\uc774 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
        }
        return receiverList;
    }

    public JavaMailSenderImpl createMailSender(SenderEntity smtpConfig) {
        JavaMailSenderImpl mailSender = new JavaMailSenderImpl();
        mailSender.setHost(smtpConfig.getC_smtp_server());
        mailSender.setPort(smtpConfig.getC_smtp_port().intValue());
        mailSender.setUsername(smtpConfig.getC_sender_email());
        mailSender.setPassword(smtpConfig.getC_sender_password());
        Properties props = mailSender.getJavaMailProperties();
        props.put("mail.smtp.auth", "true");
        props.put("mail.smtp.ssl.enable", "true");
        props.put("mail.smtp.starttls.enable", "false");
        props.put("mail.smtp.ssl.protocols", "TLSv1.2");
        return mailSender;
    }

    private EmailSendResult sendHtmlEmail(JavaMailSenderImpl mailSender, String toEmail, String fromEmail, String subject, String htmlContent) {
        EmailSendResult result = new EmailSendResult(toEmail, true, null);
        try {
            MimeMessage mimeMessage = mailSender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(mimeMessage, true, "UTF-8");
            helper.setTo(toEmail);
            helper.setFrom(fromEmail);
            helper.setSubject(subject);
            helper.setText(htmlContent, true);
            ClassPathResource imageResource = new ClassPathResource("static/313_logo_large_drop.png");
            helper.addInline("logoImage", (Resource)imageResource);
            mailSender.send(mimeMessage);
            this.logger.info("HTML \uba54\uc77c\uc744 " + toEmail + "\uc5d0\uac8c \uc804\uc1a1\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        catch (Exception e) {
            result.setSuccess(false);
            result.setErrorMessage(e.getMessage());
            this.logger.error("HTML \uba54\uc77c \uc804\uc1a1 \uc2e4\ud328: " + e.getMessage());
        }
        return result;
    }

    public String fetchHtmlData() throws Exception {
        TopMenuTimeVO timeData = this.mailReportService.getTopMenuTime();
        TopMenuScopeVO scopeData = this.mailReportService.getTopMenuScope();
        TopMenuResourceVO resourceData = this.mailReportService.getTopMenuResource();
        LocalDate now = LocalDate.now();
        LocalDate previousMonday = now.minusWeeks(1L).with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY));
        LocalDate previousSunday = previousMonday.with(TemporalAdjusters.nextOrSame(DayOfWeek.SUNDAY));
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy\ub144 MM\uc6d4 dd\uc77c");
        String formattedStartDate = previousMonday.format(formatter);
        String formattedEndDate = previousSunday.format(formatter);
        ClassLoaderTemplateResolver templateResolver = new ClassLoaderTemplateResolver();
        templateResolver.setPrefix("/templates/");
        templateResolver.setSuffix(".html");
        templateResolver.setTemplateMode("HTML");
        templateResolver.setCharacterEncoding("UTF-8");
        TemplateEngine templateEngine = new TemplateEngine();
        templateEngine.setTemplateResolver((ITemplateResolver)templateResolver);
        Context context = new Context();
        context.setVariable("startDate", (Object)formattedStartDate);
        context.setVariable("endDate", (Object)formattedEndDate);
        context.setVariable("timeData", (Object)timeData);
        context.setVariable("scopeData", (Object)scopeData);
        context.setVariable("resourceData", (Object)resourceData);
        try {
            return templateEngine.process("mail", (IContext)context);
        }
        catch (Exception e) {
            this.logger.error("mail.html \ud15c\ud50c\ub9bf \ucc98\ub9ac \uc911 \uc624\ub958 \ubc1c\uc0dd: " + e.getMessage());
            throw new Exception("mail.html \ud15c\ud50c\ub9bf \ucc98\ub9ac \uc911 \uc624\ub958 \ubc1c\uc0dd.", e);
        }
    }

    public String generateChartImage() throws Exception {
        WebDriverManager.chromedriver().setup();
        ChromeOptions options = new ChromeOptions();
        options.addArguments(new String[]{"--headless", "--disable-gpu", "--window-size=1920,1080"});
        ChromeDriver driver = new ChromeDriver(options);
        try {
            driver.get("http://localhost:31313/html/mail/chart.html");
            WebDriverWait wait = new WebDriverWait((WebDriver)driver, 10L);
            wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.id((String)"progress-overview-chart")));
            String string = "success";
            return string;
        }
        catch (Exception e) {
            throw new Exception("Failed to trigger", e);
        }
        finally {
            driver.quit();
        }
    }

    public MailServiceImpl(SenderService senderService, ReceiverService receiverService, MailReportService mailReportService) {
        this.senderService = senderService;
        this.receiverService = receiverService;
        this.mailReportService = mailReportService;
    }
}

