/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.report.mail.controller;

import com.arms.api.report.mail.modal.EmailSendResult;
import com.arms.api.report.mail.modal.dto.sender.SenderDTO;
import com.arms.api.report.mail.service.mail.MailService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/arms/mail"})
public class MailController {
    private static final Logger log = LoggerFactory.getLogger(MailController.class);
    @Autowired
    @Qualifier(value="mailService")
    private MailService mailService;

    @PostMapping(value={"/send-all-test"})
    public ResponseEntity<List<EmailSendResult>> sendAllEmailTest() throws Exception {
        log.info("MailController :: sendAllEmailTest");
        List results = this.mailService.sendTestEmailsToAllUsers();
        return ResponseEntity.ok((Object)results);
    }

    @PostMapping(value={"/send-test"})
    public ResponseEntity<EmailSendResult> sendTestEmail(@RequestParam String userEmail) throws Exception {
        log.info("MailController :: sendTestEmail");
        EmailSendResult results = this.mailService.sendTestEmail(userEmail);
        return ResponseEntity.ok((Object)results);
    }

    @GetMapping(value={"/fetch-html-test"})
    public ResponseEntity<String> fetchHtmlData() throws Exception {
        log.info("MailController :: fetchHtmlData");
        String results = this.mailService.fetchHtmlData();
        return ResponseEntity.ok((Object)results);
    }

    @PostMapping(value={"/validate"})
    public ResponseEntity<EmailSendResult> validateSmtpConfig(@RequestBody SenderDTO senderDTO) throws Exception {
        log.info("MailController :: validateSmtpConfig");
        EmailSendResult result = this.mailService.validateSmtpConfig(senderDTO);
        return ResponseEntity.ok((Object)result);
    }

    @GetMapping(value={"/send-to-registered-users"})
    public ResponseEntity<List<EmailSendResult>> sendEmailsToAllUsers() throws Exception {
        log.info("MailController :: sendEmailsToAllUsers");
        List results = this.mailService.sendEmailsToAllUsers();
        return ResponseEntity.ok((Object)results);
    }

    @GetMapping(value={"/save-chart-image"})
    public ResponseEntity<String> saveChartImage() throws Exception {
        log.info("MailController :: saveChartImage");
        String results = this.mailService.generateChartImage();
        return ResponseEntity.ok((Object)results);
    }
}

