/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.report.export_service.generator;

import com.arms.api.report.export_service.config.ReportConfig;
import com.arms.api.report.export_service.exception.ReportExportException;
import com.arms.api.report.export_service.generator.ChartImageGenerator;
import com.arms.api.report.export_service.generator.PptGenerator;
import com.arms.api.report.export_service.model.ChartData;
import com.arms.api.report.export_service.model.ReportData;
import com.arms.api.report.export_service.model.ReportSection;
import com.arms.api.report.export_service.model.TableData;
import com.arms.api.report.export_service.template.PlaceholderResolver;
import com.arms.api.report.export_service.template.TemplateLoader;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.apache.poi.sl.usermodel.PictureData;
import org.apache.poi.xslf.usermodel.SlideLayout;
import org.apache.poi.xslf.usermodel.XMLSlideShow;
import org.apache.poi.xslf.usermodel.XSLFPictureData;
import org.apache.poi.xslf.usermodel.XSLFPictureShape;
import org.apache.poi.xslf.usermodel.XSLFSlide;
import org.apache.poi.xslf.usermodel.XSLFSlideLayout;
import org.apache.poi.xslf.usermodel.XSLFSlideMaster;
import org.apache.poi.xslf.usermodel.XSLFTable;
import org.apache.poi.xslf.usermodel.XSLFTableCell;
import org.apache.poi.xslf.usermodel.XSLFTableRow;
import org.apache.poi.xslf.usermodel.XSLFTextBox;
import org.apache.poi.xslf.usermodel.XSLFTextParagraph;
import org.apache.poi.xslf.usermodel.XSLFTextRun;
import org.apache.poi.xslf.usermodel.XSLFTextShape;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PptGenerator {
    private static final Logger log = LoggerFactory.getLogger(PptGenerator.class);
    private final TemplateLoader templateLoader;
    private final PlaceholderResolver placeholderResolver;
    private final ReportConfig reportConfig;
    private final ChartImageGenerator chartImageGenerator;

    public byte[] generate(ReportData data) {
        try {
            XMLSlideShow ppt = this.loadOrCreatePresentation(data);
            Map placeholders = data.buildDefaultPlaceholders();
            this.placeholderResolver.resolveAllSlides(ppt, placeholders);
            for (ReportSection section : data.getSections()) {
                this.addSectionSlide(ppt, section, data);
            }
            for (TableData table : data.getTables()) {
                this.addTableSlide(ppt, table);
            }
            for (ChartData chart : data.getCharts()) {
                this.addChartSlide(ppt, chart);
            }
            return this.writeToByteArray(ppt);
        }
        catch (IOException e) {
            log.error("Failed to generate PPT", (Throwable)e);
            throw new ReportExportException("PPT_GENERATION_ERROR", "Failed to generate PPT", (Throwable)e);
        }
    }

    private XMLSlideShow loadOrCreatePresentation(ReportData data) {
        if (data.getTemplateName() != null && this.templateLoader.templateExists(data.getTemplateName())) {
            log.info("Loading template: {}", (Object)data.getTemplateName());
            return this.templateLoader.loadPptTemplate(data.getTemplateName());
        }
        log.info("Creating default presentation (no template)");
        return this.createDefaultPresentation(data);
    }

    private XMLSlideShow createDefaultPresentation(ReportData data) {
        XSLFTextShape subtitle;
        XMLSlideShow ppt = new XMLSlideShow();
        XSLFSlideMaster master = (XSLFSlideMaster)ppt.getSlideMasters().get(0);
        XSLFSlideLayout titleLayout = master.getLayout(SlideLayout.TITLE);
        XSLFSlide titleSlide = ppt.createSlide(titleLayout);
        XSLFTextShape title = titleSlide.getPlaceholder(0);
        if (title != null) {
            title.setText(data.getTitle());
            this.setTextStyle(title, this.reportConfig.getPpt().getTitleFontSize(), true);
        }
        if ((subtitle = titleSlide.getPlaceholder(1)) != null && data.getSubtitle() != null) {
            subtitle.setText(data.getSubtitle());
        }
        return ppt;
    }

    private void addSectionSlide(XMLSlideShow ppt, ReportSection section, ReportData data) {
        XSLFTextShape content;
        XSLFSlideMaster master = (XSLFSlideMaster)ppt.getSlideMasters().get(0);
        XSLFSlideLayout contentLayout = master.getLayout(SlideLayout.TITLE_AND_CONTENT);
        XSLFSlide slide = ppt.createSlide(contentLayout);
        XSLFTextShape title = slide.getPlaceholder(0);
        if (title != null) {
            title.setText(section.getTitle());
        }
        if ((content = slide.getPlaceholder(1)) != null) {
            content.clearText();
            switch (1.$SwitchMap$com$arms$api$report$export_service$model$ReportSection$SectionType[section.getType().ordinal()]) {
                case 1: {
                    this.addBulletPoints(content, section.getBulletPoints());
                    break;
                }
                case 2: {
                    this.addTextContent(content, section.getContent());
                    break;
                }
                case 3: {
                    this.addTableReference(slide, section, data);
                    break;
                }
                case 4: {
                    this.addChartReference(slide, section, data);
                    break;
                }
                default: {
                    this.addTextContent(content, section.getContent());
                }
            }
        }
        if (section.hasImage()) {
            this.addImageToSlide(ppt, slide, section.getImage(), section.getImageCaption());
        }
    }

    private void addBulletPoints(XSLFTextShape textShape, List<String> bulletPoints) {
        if (bulletPoints == null || bulletPoints.isEmpty()) {
            return;
        }
        for (int i = 0; i < bulletPoints.size(); ++i) {
            List paragraphs = textShape.getTextParagraphs();
            XSLFTextParagraph paragraph = i == 0 && !paragraphs.isEmpty() ? (XSLFTextParagraph)paragraphs.get(0) : textShape.addNewTextParagraph();
            paragraph.setBullet(true);
            XSLFTextRun run = paragraph.addNewTextRun();
            run.setText(bulletPoints.get(i));
            run.setFontSize(Double.valueOf(this.reportConfig.getPpt().getBodyFontSize()));
        }
    }

    private void addTextContent(XSLFTextShape textShape, String content) {
        if (content == null) {
            return;
        }
        List paragraphs = textShape.getTextParagraphs();
        XSLFTextParagraph paragraph = paragraphs.isEmpty() ? textShape.addNewTextParagraph() : (XSLFTextParagraph)paragraphs.get(0);
        paragraph.setBullet(false);
        XSLFTextRun run = paragraph.addNewTextRun();
        run.setText(content);
        run.setFontSize(Double.valueOf(this.reportConfig.getPpt().getBodyFontSize()));
    }

    private void addTableSlide(XMLSlideShow ppt, TableData tableData) {
        XSLFSlideMaster master = (XSLFSlideMaster)ppt.getSlideMasters().get(0);
        XSLFSlideLayout blankLayout = master.getLayout(SlideLayout.BLANK);
        XSLFSlide slide = ppt.createSlide(blankLayout);
        if (tableData.getTableName() != null) {
            XSLFTextBox titleBox = slide.createTextBox();
            titleBox.setAnchor((Rectangle2D)new Rectangle2D.Double(50.0, 30.0, 620.0, 40.0));
            XSLFTextParagraph p = titleBox.addNewTextParagraph();
            XSLFTextRun r = p.addNewTextRun();
            r.setText(tableData.getTableName());
            r.setFontSize(Double.valueOf(20.0));
            r.setBold(true);
        }
        int numRows = tableData.getRowCount() + 1;
        int numCols = tableData.getColumnCount();
        if (numCols == 0) {
            log.warn("Table has no columns, skipping");
            return;
        }
        XSLFTable table = slide.createTable(numRows, numCols);
        table.setAnchor((Rectangle2D)new Rectangle2D.Double(50.0, 80.0, 620.0, 400.0));
        double colWidth = 620.0 / (double)numCols;
        for (int i = 0; i < numCols; ++i) {
            table.setColumnWidth(i, colWidth);
        }
        XSLFTableRow headerRow = (XSLFTableRow)table.getRows().get(0);
        for (int col = 0; col < numCols; ++col) {
            XSLFTableCell cell = (XSLFTableCell)headerRow.getCells().get(col);
            cell.setText((String)tableData.getHeaders().get(col));
            cell.setFillColor(Color.decode(tableData.getStyle().getHeaderBackgroundColor()));
            this.setCellTextStyle(cell, true, Color.WHITE);
        }
        for (int row = 0; row < tableData.getRowCount(); ++row) {
            XSLFTableRow dataRow = (XSLFTableRow)table.getRows().get(row + 1);
            List rowData = (List)tableData.getRows().get(row);
            for (int col = 0; col < numCols; ++col) {
                XSLFTableCell cell = (XSLFTableCell)dataRow.getCells().get(col);
                String cellText = col < rowData.size() ? (String)rowData.get(col) : "";
                cell.setText(cellText);
                if (tableData.getStyle().isHasAlternateRowColor() && row % 2 == 1) {
                    cell.setFillColor(Color.decode(tableData.getStyle().getAlternateRowColor()));
                }
                this.setCellTextStyle(cell, false, Color.BLACK);
            }
        }
    }

    private void addChartSlide(XMLSlideShow ppt, ChartData chartData) throws IOException {
        XSLFSlideMaster master = (XSLFSlideMaster)ppt.getSlideMasters().get(0);
        XSLFSlideLayout blankLayout = master.getLayout(SlideLayout.BLANK);
        XSLFSlide slide = ppt.createSlide(blankLayout);
        if (chartData.getTitle() != null) {
            XSLFTextBox titleBox = slide.createTextBox();
            titleBox.setAnchor((Rectangle2D)new Rectangle2D.Double(50.0, 30.0, 620.0, 40.0));
            XSLFTextParagraph p = titleBox.addNewTextParagraph();
            XSLFTextRun r = p.addNewTextRun();
            r.setText(chartData.getTitle());
            r.setFontSize(Double.valueOf(20.0));
            r.setBold(true);
        }
        byte[] chartImage = chartData.hasRenderedImage() ? chartData.getRenderedImage() : this.chartImageGenerator.generateChartImage(chartData);
        this.addImageToSlide(ppt, slide, chartImage, null, 60.0, 80.0, 600.0, 420.0);
    }

    private void addImageToSlide(XMLSlideShow ppt, XSLFSlide slide, byte[] imageData, String caption) {
        this.addImageToSlide(ppt, slide, imageData, caption, 150.0, 150.0, 420.0, 300.0);
    }

    private void addImageToSlide(XMLSlideShow ppt, XSLFSlide slide, byte[] imageData, String caption, double x, double y, double width, double height) {
        try {
            XSLFPictureData pictureData = ppt.addPicture(imageData, PictureData.PictureType.PNG);
            XSLFPictureShape picture = slide.createPicture((PictureData)pictureData);
            picture.setAnchor((Rectangle2D)new Rectangle2D.Double(x, y, width, height));
            if (caption != null && !caption.isEmpty()) {
                XSLFTextBox captionBox = slide.createTextBox();
                captionBox.setAnchor((Rectangle2D)new Rectangle2D.Double(x, y + height + 10.0, width, 30.0));
                XSLFTextParagraph p = captionBox.addNewTextParagraph();
                XSLFTextRun r = p.addNewTextRun();
                r.setText(caption);
                r.setFontSize(Double.valueOf(10.0));
                r.setItalic(true);
            }
        }
        catch (Exception e) {
            log.error("Failed to add image to slide", (Throwable)e);
        }
    }

    private void addTableReference(XSLFSlide slide, ReportSection section, ReportData data) {
        for (TableData table : data.getTables()) {
            if (table.getTableId() == null || !table.getTableId().equals(section.getTableRef())) continue;
            XSLFTextShape content = slide.getPlaceholder(1);
            if (content == null) break;
            content.setText("See table: " + table.getTableName());
            break;
        }
    }

    private void addChartReference(XSLFSlide slide, ReportSection section, ReportData data) {
        for (ChartData chart : data.getCharts()) {
            if (chart.getChartId() == null || !chart.getChartId().equals(section.getChartRef())) continue;
            XSLFTextShape content = slide.getPlaceholder(1);
            if (content == null) break;
            content.setText("See chart: " + chart.getTitle());
            break;
        }
    }

    private void setTextStyle(XSLFTextShape textShape, int fontSize, boolean bold) {
        for (XSLFTextParagraph p : textShape.getTextParagraphs()) {
            for (XSLFTextRun r : p.getTextRuns()) {
                r.setFontSize(Double.valueOf(fontSize));
                r.setBold(bold);
            }
        }
    }

    private void setCellTextStyle(XSLFTableCell cell, boolean bold, Color fontColor) {
        for (XSLFTextParagraph p : cell.getTextParagraphs()) {
            for (XSLFTextRun r : p.getTextRuns()) {
                r.setFontSize(Double.valueOf(this.reportConfig.getPpt().getTableFontSize()));
                r.setBold(bold);
                r.setFontColor(fontColor);
            }
        }
    }

    private byte[] writeToByteArray(XMLSlideShow ppt) throws IOException {
        try {
            byte[] byArray;
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                ppt.write((OutputStream)out);
                byArray = out.toByteArray();
            }
            return byArray;
        }
        finally {
            ppt.close();
        }
    }

    public PptGenerator(TemplateLoader templateLoader, PlaceholderResolver placeholderResolver, ReportConfig reportConfig, ChartImageGenerator chartImageGenerator) {
        this.templateLoader = templateLoader;
        this.placeholderResolver = placeholderResolver;
        this.reportConfig = reportConfig;
        this.chartImageGenerator = chartImageGenerator;
    }
}

