/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.report.export_service.generator;

import com.arms.api.report.export_service.generator.ChartImageGenerator;
import com.arms.api.report.export_service.model.ChartData;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ChartImageGenerator {
    private static final Logger log = LoggerFactory.getLogger(ChartImageGenerator.class);
    private static final Color[] DEFAULT_COLORS = new Color[]{new Color(66, 133, 244), new Color(234, 67, 53), new Color(251, 188, 5), new Color(52, 168, 83), new Color(155, 89, 182), new Color(52, 73, 94), new Color(230, 126, 34), new Color(26, 188, 156)};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] generateChartImage(ChartData chartData) {
        int width = chartData.getOptions().getWidth();
        int height = chartData.getOptions().getHeight();
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D g2d = image.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setColor(Color.WHITE);
        g2d.fillRect(0, 0, width, height);
        try {
            switch (1.$SwitchMap$com$arms$api$report$export_service$model$ChartData$ChartType[chartData.getType().ordinal()]) {
                case 1: {
                    this.drawBarChart(g2d, chartData, width, height);
                    break;
                }
                case 2: {
                    this.drawLineChart(g2d, chartData, width, height);
                    break;
                }
                case 3: {
                    this.drawPieChart(g2d, chartData, width, height);
                    break;
                }
                default: {
                    this.drawBarChart(g2d, chartData, width, height);
                }
            }
            if (chartData.getOptions().isShowLegend()) {
                this.drawLegend(g2d, chartData, width, height);
            }
            byte[] byArray = this.toByteArray(image);
            return byArray;
        }
        catch (Exception e) {
            log.error("Failed to generate chart image", (Throwable)e);
            byte[] byArray = this.createErrorImage(width, height);
            return byArray;
        }
        finally {
            g2d.dispose();
        }
    }

    private void drawBarChart(Graphics2D g2d, ChartData chartData, int width, int height) {
        int margin = 60;
        int chartWidth = width - margin * 2;
        int chartHeight = height - margin * 2 - 30;
        List labels = chartData.getLabels();
        List seriesList = chartData.getSeries();
        if (labels.isEmpty() || seriesList.isEmpty()) {
            return;
        }
        double maxValue = seriesList.stream().flatMap(s -> s.getValues().stream()).max(Double::compareTo).orElse(100.0);
        int numBars = labels.size();
        int numSeries = seriesList.size();
        int groupWidth = chartWidth / numBars;
        int barWidth = (groupWidth - 10) / numSeries;
        g2d.setColor(Color.BLACK);
        g2d.drawLine(margin, margin, margin, margin + chartHeight);
        g2d.drawLine(margin, margin + chartHeight, margin + chartWidth, margin + chartHeight);
        for (int i = 0; i < numBars; ++i) {
            int groupX = margin + i * groupWidth + 5;
            for (int s2 = 0; s2 < numSeries; ++s2) {
                ChartData.DataSeries series = (ChartData.DataSeries)seriesList.get(s2);
                double value = i < series.getValues().size() ? (Double)series.getValues().get(i) : 0.0;
                int barHeight = (int)(value / maxValue * (double)chartHeight);
                int barX = groupX + s2 * barWidth;
                int barY = margin + chartHeight - barHeight;
                g2d.setColor(this.getSeriesColor(s2, series.getColor()));
                g2d.fillRect(barX, barY, barWidth - 2, barHeight);
                if (!chartData.getOptions().isShowValues()) continue;
                g2d.setColor(Color.BLACK);
                g2d.setFont(new Font("SansSerif", 0, 10));
                g2d.drawString(String.format("%.0f", value), barX + barWidth / 4, barY - 5);
            }
            g2d.setColor(Color.BLACK);
            g2d.setFont(new Font("SansSerif", 0, 11));
            String label = (String)labels.get(i);
            int labelWidth = g2d.getFontMetrics().stringWidth(label);
            g2d.drawString(label, groupX + groupWidth / 2 - labelWidth / 2 - 5, margin + chartHeight + 20);
        }
    }

    private void drawLineChart(Graphics2D g2d, ChartData chartData, int width, int height) {
        int margin = 60;
        int chartWidth = width - margin * 2;
        int chartHeight = height - margin * 2 - 30;
        List labels = chartData.getLabels();
        List seriesList = chartData.getSeries();
        if (labels.isEmpty() || seriesList.isEmpty()) {
            return;
        }
        double maxValue = seriesList.stream().flatMap(s -> s.getValues().stream()).max(Double::compareTo).orElse(100.0);
        int numPoints = labels.size();
        int pointGap = numPoints > 1 ? chartWidth / (numPoints - 1) : chartWidth;
        g2d.setColor(Color.BLACK);
        g2d.drawLine(margin, margin, margin, margin + chartHeight);
        g2d.drawLine(margin, margin + chartHeight, margin + chartWidth, margin + chartHeight);
        for (int s2 = 0; s2 < seriesList.size(); ++s2) {
            int i;
            ChartData.DataSeries series = (ChartData.DataSeries)seriesList.get(s2);
            g2d.setColor(this.getSeriesColor(s2, series.getColor()));
            g2d.setStroke(new BasicStroke(2.0f));
            int[] xPoints = new int[numPoints];
            int[] yPoints = new int[numPoints];
            for (i = 0; i < numPoints; ++i) {
                double value = i < series.getValues().size() ? (Double)series.getValues().get(i) : 0.0;
                xPoints[i] = margin + i * pointGap;
                yPoints[i] = margin + chartHeight - (int)(value / maxValue * (double)chartHeight);
            }
            g2d.drawPolyline(xPoints, yPoints, numPoints);
            for (i = 0; i < numPoints; ++i) {
                g2d.fillOval(xPoints[i] - 4, yPoints[i] - 4, 8, 8);
            }
        }
        g2d.setColor(Color.BLACK);
        g2d.setFont(new Font("SansSerif", 0, 11));
        for (int i = 0; i < numPoints; ++i) {
            String label = (String)labels.get(i);
            int labelWidth = g2d.getFontMetrics().stringWidth(label);
            g2d.drawString(label, margin + i * pointGap - labelWidth / 2, margin + chartHeight + 20);
        }
    }

    private void drawPieChart(Graphics2D g2d, ChartData chartData, int width, int height) {
        int centerX = width / 2;
        int centerY = height / 2;
        int radius = Math.min(width, height) / 3;
        List seriesList = chartData.getSeries();
        if (seriesList.isEmpty() || ((ChartData.DataSeries)seriesList.get(0)).getValues().isEmpty()) {
            return;
        }
        List values = ((ChartData.DataSeries)seriesList.get(0)).getValues();
        double total = values.stream().mapToDouble(Double::doubleValue).sum();
        int startAngle = 0;
        for (int i = 0; i < values.size(); ++i) {
            double value = (Double)values.get(i);
            int arcAngle = (int)Math.round(value / total * 360.0);
            g2d.setColor(this.getSeriesColor(i, null));
            g2d.fillArc(centerX - radius, centerY - radius, radius * 2, radius * 2, startAngle, arcAngle);
            startAngle += arcAngle;
        }
        g2d.setColor(Color.WHITE);
        g2d.setStroke(new BasicStroke(2.0f));
        startAngle = 0;
        for (Double value : values) {
            int arcAngle = (int)Math.round(value / total * 360.0);
            g2d.drawArc(centerX - radius, centerY - radius, radius * 2, radius * 2, startAngle, arcAngle);
            startAngle += arcAngle;
        }
    }

    private void drawLegend(Graphics2D g2d, ChartData chartData, int width, int height) {
        List seriesList = chartData.getSeries();
        if (seriesList.isEmpty()) {
            return;
        }
        int legendX = width - 150;
        int legendY = 20;
        int itemHeight = 20;
        for (int i = 0; i < seriesList.size(); ++i) {
            ChartData.DataSeries series = (ChartData.DataSeries)seriesList.get(i);
            g2d.setColor(this.getSeriesColor(i, series.getColor()));
            g2d.fillRect(legendX, legendY + i * itemHeight, 15, 15);
            g2d.setColor(Color.BLACK);
            g2d.setFont(new Font("SansSerif", 0, 11));
            String name = series.getName() != null ? series.getName() : "Series " + (i + 1);
            g2d.drawString(name, legendX + 20, legendY + i * itemHeight + 12);
        }
    }

    private Color getSeriesColor(int index, String colorHex) {
        if (colorHex != null && !colorHex.isEmpty()) {
            try {
                return Color.decode(colorHex);
            }
            catch (NumberFormatException e) {
                log.warn("Invalid color hex: {}", (Object)colorHex);
            }
        }
        return DEFAULT_COLORS[index % DEFAULT_COLORS.length];
    }

    private byte[] toByteArray(BufferedImage image) {
        byte[] byArray;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "PNG", out);
            byArray = out.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to convert image to byte array", e);
            }
        }
        out.close();
        return byArray;
    }

    private byte[] createErrorImage(int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D g2d = image.createGraphics();
        g2d.setColor(Color.LIGHT_GRAY);
        g2d.fillRect(0, 0, width, height);
        g2d.setColor(Color.RED);
        g2d.setFont(new Font("SansSerif", 1, 14));
        g2d.drawString("Chart generation failed", width / 4, height / 2);
        g2d.dispose();
        return this.toByteArray(image);
    }
}

