/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.report.export_service.exception;

import com.arms.api.report.export_service.dto.ReportExportResponse;
import com.arms.api.report.export_service.exception.ReportExportException;
import com.arms.api.report.export_service.exception.TemplateNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice(basePackages={"com.arms.api.report.export_service"})
public class ReportExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(ReportExceptionHandler.class);

    @ExceptionHandler(value={TemplateNotFoundException.class})
    public ResponseEntity<ReportExportResponse> handleTemplateNotFound(TemplateNotFoundException e) {
        log.error("Template not found: {}", (Object)e.getTemplateName(), (Object)e);
        return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body((Object)ReportExportResponse.failure((String)e.getErrorCode(), (String)e.getDetail()));
    }

    @ExceptionHandler(value={ReportExportException.class})
    public ResponseEntity<ReportExportResponse> handleReportExportException(ReportExportException e) {
        log.error("Report export error: {}", (Object)e.getMessage(), (Object)e);
        return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)ReportExportResponse.failure((String)e.getErrorCode(), (String)e.getDetail()));
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResponseEntity<ReportExportResponse> handleValidationException(MethodArgumentNotValidException e) {
        log.error("Validation error: {}", (Object)e.getMessage());
        String errorMessage = e.getBindingResult().getFieldErrors().stream().findFirst().map(error -> error.getField() + ": " + error.getDefaultMessage()).orElse("Validation failed");
        return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)ReportExportResponse.failure((String)"VALIDATION_ERROR", (String)errorMessage));
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<ReportExportResponse> handleGenericException(Exception e) {
        log.error("Unexpected error during report export", (Throwable)e);
        return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)ReportExportResponse.failure((String)"UNEXPECTED_ERROR", (String)e.getMessage()));
    }
}

