/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.report.export_service.dto;

import com.arms.api.report.export_service.dto.ReportExportRequest;
import com.arms.api.report.export_service.model.ChartData;
import com.arms.api.report.export_service.model.ReportData;
import com.arms.api.report.export_service.model.ReportSection;
import com.arms.api.report.export_service.model.TableData;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotBlank;

public class ReportExportRequest {
    @NotBlank(message="Title is required")
    private @NotBlank(message="Title is required") String title;
    private String subtitle;
    private String description;
    private String author;
    private String department;
    private String templateName;
    private List<SectionRequest> sections;
    private List<TableRequest> tables;
    private List<ChartRequest> charts;
    private Map<String, String> customPlaceholders;

    public ReportData toReportData() {
        ReportData.ReportDataBuilder builder = ReportData.builder().title(this.title).subtitle(this.subtitle).description(this.description).author(this.author).department(this.department).templateName(this.templateName).reportDate(LocalDateTime.now());
        if (this.sections != null && !this.sections.isEmpty()) {
            ArrayList<ReportSection> reportSections = new ArrayList<ReportSection>();
            for (SectionRequest section : this.sections) {
                reportSections.add(this.convertSection(section));
            }
            builder.sections(reportSections);
        }
        if (this.tables != null && !this.tables.isEmpty()) {
            ArrayList<TableData> tableDataList = new ArrayList<TableData>();
            for (TableRequest table : this.tables) {
                tableDataList.add(this.convertTable(table));
            }
            builder.tables(tableDataList);
        }
        if (this.charts != null && !this.charts.isEmpty()) {
            ArrayList<ChartData> chartDataList = new ArrayList<ChartData>();
            for (ChartRequest chart : this.charts) {
                chartDataList.add(this.convertChart(chart));
            }
            builder.charts(chartDataList);
        }
        if (this.customPlaceholders != null) {
            builder.placeholders(this.customPlaceholders);
        }
        return builder.build();
    }

    private ReportSection convertSection(SectionRequest request) {
        ReportSection.SectionType sectionType = ReportSection.SectionType.TEXT;
        if (request.getType() != null && !request.getType().isEmpty()) {
            try {
                sectionType = ReportSection.SectionType.valueOf((String)request.getType().toUpperCase());
            }
            catch (IllegalArgumentException e) {
                sectionType = ReportSection.SectionType.TEXT;
            }
        }
        return ReportSection.builder().title(request.getTitle()).content(request.getContent()).type(sectionType).order(request.getOrder()).bulletPoints(request.getBulletPoints() != null ? request.getBulletPoints() : new ArrayList()).tableRef(request.getTableRef()).chartRef(request.getChartRef()).build();
    }

    private TableData convertTable(TableRequest request) {
        return TableData.builder().tableId(request.getTableId()).tableName(request.getTableName()).caption(request.getCaption()).headers(request.getHeaders() != null ? request.getHeaders() : new ArrayList()).rows(request.getRows() != null ? request.getRows() : new ArrayList()).build();
    }

    private ChartData convertChart(ChartRequest request) {
        ChartData.ChartType chartType = ChartData.ChartType.BAR;
        if (request.getType() != null && !request.getType().isEmpty()) {
            try {
                chartType = ChartData.ChartType.valueOf((String)request.getType().toUpperCase());
            }
            catch (IllegalArgumentException e) {
                chartType = ChartData.ChartType.BAR;
            }
        }
        ChartData.ChartDataBuilder builder = ChartData.builder().chartId(request.getChartId()).title(request.getTitle()).type(chartType).labels(request.getLabels() != null ? request.getLabels() : new ArrayList());
        if (request.getSeries() != null) {
            ArrayList<ChartData.DataSeries> seriesList = new ArrayList<ChartData.DataSeries>();
            for (SeriesRequest s : request.getSeries()) {
                seriesList.add(ChartData.DataSeries.builder().name(s.getName()).values(s.getValues() != null ? s.getValues() : new ArrayList()).color(s.getColor()).build());
            }
            builder.series(seriesList);
        }
        return builder.build();
    }

    public static ReportExportRequestBuilder builder() {
        return new ReportExportRequestBuilder();
    }

    public String getTitle() {
        return this.title;
    }

    public String getSubtitle() {
        return this.subtitle;
    }

    public String getDescription() {
        return this.description;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getDepartment() {
        return this.department;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public List<SectionRequest> getSections() {
        return this.sections;
    }

    public List<TableRequest> getTables() {
        return this.tables;
    }

    public List<ChartRequest> getCharts() {
        return this.charts;
    }

    public Map<String, String> getCustomPlaceholders() {
        return this.customPlaceholders;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setSubtitle(String subtitle) {
        this.subtitle = subtitle;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setDepartment(String department) {
        this.department = department;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public void setSections(List<SectionRequest> sections) {
        this.sections = sections;
    }

    public void setTables(List<TableRequest> tables) {
        this.tables = tables;
    }

    public void setCharts(List<ChartRequest> charts) {
        this.charts = charts;
    }

    public void setCustomPlaceholders(Map<String, String> customPlaceholders) {
        this.customPlaceholders = customPlaceholders;
    }

    public ReportExportRequest() {
    }

    public ReportExportRequest(String title, String subtitle, String description, String author, String department, String templateName, List<SectionRequest> sections, List<TableRequest> tables, List<ChartRequest> charts, Map<String, String> customPlaceholders) {
        this.title = title;
        this.subtitle = subtitle;
        this.description = description;
        this.author = author;
        this.department = department;
        this.templateName = templateName;
        this.sections = sections;
        this.tables = tables;
        this.charts = charts;
        this.customPlaceholders = customPlaceholders;
    }
}

