/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.report.export_service.config;

import com.arms.api.report.export_service.config.ReportConfig;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

@Configuration
@ConfigurationProperties(prefix="report")
public class ReportConfig {
    private static final Logger log = LoggerFactory.getLogger(ReportConfig.class);
    private final ResourceLoader resourceLoader;
    private String templatePath = "classpath:templates/report/";
    private String fontPath = "classpath:fonts/";
    private String defaultFont = "NanumGothic.ttf";
    private String boldFont = "NanumGothicBold.ttf";
    private String companyName = "313DEVGRP";
    private String companyLogo = "classpath:static/313_logo_large_drop.png";
    private PptConfig ppt = new PptConfig();
    private PdfConfig pdf = new PdfConfig();
    private Map<String, String> templates = new HashMap();

    @PostConstruct
    public void init() {
        log.info("Initializing ReportConfig...");
        if (this.templates.isEmpty()) {
            this.templates.put("default", "default-template.pptx");
            this.templates.put("analysis", "analysis-template.pptx");
            this.templates.put("summary", "summary-template.pptx");
            log.info("Default templates registered: {}", this.templates.keySet());
        }
        log.info("ReportConfig initialized - templatePath: {}, fontPath: {}", (Object)this.templatePath, (Object)this.fontPath);
    }

    public Resource getTemplateResource(String templateName) {
        String templateFile = this.templates.getOrDefault(templateName, this.ppt.getDefaultTemplate());
        String fullPath = this.templatePath + templateFile;
        log.debug("Loading template: {} -> {}", (Object)templateName, (Object)fullPath);
        return this.resourceLoader.getResource(fullPath);
    }

    public Resource getFontResource(String fontName) {
        return this.resourceLoader.getResource(this.fontPath + fontName);
    }

    public Resource getDefaultFontResource() {
        return this.resourceLoader.getResource(this.fontPath + this.defaultFont);
    }

    public Resource getBoldFontResource() {
        return this.resourceLoader.getResource(this.fontPath + this.boldFont);
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public String getTemplatePath() {
        return this.templatePath;
    }

    public String getFontPath() {
        return this.fontPath;
    }

    public String getDefaultFont() {
        return this.defaultFont;
    }

    public String getBoldFont() {
        return this.boldFont;
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public String getCompanyLogo() {
        return this.companyLogo;
    }

    public PptConfig getPpt() {
        return this.ppt;
    }

    public PdfConfig getPdf() {
        return this.pdf;
    }

    public Map<String, String> getTemplates() {
        return this.templates;
    }

    public void setTemplatePath(String templatePath) {
        this.templatePath = templatePath;
    }

    public void setFontPath(String fontPath) {
        this.fontPath = fontPath;
    }

    public void setDefaultFont(String defaultFont) {
        this.defaultFont = defaultFont;
    }

    public void setBoldFont(String boldFont) {
        this.boldFont = boldFont;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public void setCompanyLogo(String companyLogo) {
        this.companyLogo = companyLogo;
    }

    public void setPpt(PptConfig ppt) {
        this.ppt = ppt;
    }

    public void setPdf(PdfConfig pdf) {
        this.pdf = pdf;
    }

    public void setTemplates(Map<String, String> templates) {
        this.templates = templates;
    }

    public ReportConfig(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }
}

