/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.product_service.pdservice_pure.controller;

import com.arms.api.product_service.pdservice_detail.service.PdServiceDetail;
import com.arms.api.product_service.pdservice_pure.model.PdServicePureDTO;
import com.arms.api.product_service.pdservice_pure.model.PdServicePureEntity;
import com.arms.api.product_service.pdservice_pure.model.PdServicePureVO;
import com.arms.api.product_service.pdservice_pure.model.PdServiceWithDetailDTO;
import com.arms.api.product_service.pdservice_pure.service.PdServicePure;
import com.arms.egovframework.javaservice.treeframework.controller.CommonResponse;
import com.arms.egovframework.javaservice.treeframework.controller.TreeAbstractController;
import com.arms.egovframework.javaservice.treeframework.model.TreeSearchEntity;
import com.arms.egovframework.javaservice.treeframework.service.TreeService;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/arms/pdServicePure"})
public class PdServicePureController
extends TreeAbstractController<PdServicePure, PdServicePureDTO, PdServicePureEntity> {
    private static final Logger log = LoggerFactory.getLogger(PdServicePureController.class);
    private final PdServicePure pdServicePure;
    private final PdServiceDetail pdServiceDetail;

    @PostConstruct
    public void initialize() {
        this.setTreeService((TreeService)this.pdServicePure);
        this.setTreeEntity(PdServicePureEntity.class);
    }

    @GetMapping(value={"getPdServiceMonitor.do"})
    public ResponseEntity<?> getPdServiceMonitor(PdServicePureDTO pdServicePureDTO) throws Exception {
        log.info("[ PdServicePureController :: getPdServiceMonitor ]");
        PdServicePureEntity pdServicePureEntity = (PdServicePureEntity)this.modelMapper.map((Object)pdServicePureDTO, PdServicePureEntity.class);
        return ResponseEntity.ok((Object)CommonResponse.success((Object)this.pdServicePure.getNodesWithoutRoot((TreeSearchEntity)pdServicePureEntity)));
    }

    @GetMapping
    public ResponseEntity<?> findAll() throws Exception {
        log.info("[ PdServicePureController :: findAll ]");
        PdServicePureEntity pdServicePureEntity = (PdServicePureEntity)this.modelMapper.map((Object)new PdServicePureDTO(), PdServicePureEntity.class);
        List nodesWithoutRoot = this.pdServicePure.getNodesWithoutRoot((TreeSearchEntity)pdServicePureEntity);
        List response = nodesWithoutRoot.stream().map(PdServicePureEntity::toVO).sorted(Comparator.comparing(PdServicePureVO::getC_id).reversed()).collect(Collectors.toList());
        return ResponseEntity.ok((Object)CommonResponse.success(response));
    }

    @GetMapping(value={"/get-test-a"})
    public ResponseEntity<String> GetTestA() {
        log.info("[ PdServicePureController :: GetTestA ]");
        return ResponseEntity.ok((Object)"TestA");
    }

    @PostMapping(value={"/post-test-a"})
    public ResponseEntity<String> PostTestA() {
        log.info("[ PdServicePureController :: PostTest-a ]");
        return ResponseEntity.ok((Object)"PostTest-a");
    }

    @GetMapping(value={"getPdServiceWithDetail.do"})
    public ResponseEntity<?> getPdServiceWithDetail(PdServicePureDTO pdServicePureDTO) throws Exception {
        log.info("PdServicePureController :: getPdServiceWithDetail ]");
        PdServicePureEntity pureEntity = (PdServicePureEntity)this.modelMapper.map((Object)pdServicePureDTO, PdServicePureEntity.class);
        PdServicePureEntity pdServicePureEntity = (PdServicePureEntity)this.pdServicePure.getNode((TreeSearchEntity)pureEntity);
        List pdServiceDetailEntities = this.pdServiceDetail.getNodesByPdService(pdServicePureEntity.getC_id());
        PdServiceWithDetailDTO pdServiceWithDetailDTO = PdServiceWithDetailDTO.builder().pdServicePure(pdServicePureEntity).pdServiceDetails(pdServiceDetailEntities).build();
        return ResponseEntity.ok((Object)CommonResponse.success((Object)pdServiceWithDetailDTO));
    }

    public PdServicePureController(PdServicePure pdServicePure, PdServiceDetail pdServiceDetail) {
        this.pdServicePure = pdServicePure;
        this.pdServiceDetail = pdServiceDetail;
    }
}

