/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.product_service.pdservice_detail.service;

import com.arms.api.globaltreemap.model.GlobalContentsTreeMapEntity;
import com.arms.api.globaltreemap.service.GlobalContentsTreeMapService;
import com.arms.api.product_service.pdservice_detail.model.PdServiceDetailEntity;
import com.arms.api.product_service.pdservice_detail.service.PdServiceDetail;
import com.arms.api.util.filerepository.model.FileRepositoryEntity;
import com.arms.api.util.filerepository.service.FileRepository;
import com.arms.egovframework.javaservice.treeframework.TreeConstant;
import com.arms.egovframework.javaservice.treeframework.model.TreeSearchEntity;
import com.arms.egovframework.javaservice.treeframework.service.TreeServiceImpl;
import com.arms.egovframework.javaservice.treeframework.util.EgovFileUploadUtil;
import com.arms.egovframework.javaservice.treeframework.util.EgovFormBasedFileVo;
import com.arms.egovframework.javaservice.treeframework.util.PropertiesReader;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="pdServiceDetail")
public class PdServiceDetailImpl
extends TreeServiceImpl
implements PdServiceDetail {
    private static final Logger log = LoggerFactory.getLogger(PdServiceDetailImpl.class);
    private final FileRepository fileRepository;
    private final GlobalContentsTreeMapService globalContentsTreeMapService;

    public List<PdServiceDetailEntity> getNodesByPdService(Long pdServiceId) throws Exception {
        List globalContentsTreeMapEntityList = this.globalContentsTreeMapService.findAllByIds(List.of(pdServiceId), "pdservice_link");
        List pdServiceDetailIds = globalContentsTreeMapEntityList.stream().map(GlobalContentsTreeMapEntity::getPdservicedetail_link).collect(Collectors.toList());
        PdServiceDetailEntity pdServiceDetailEntity = new PdServiceDetailEntity();
        Criterion criterion = Restrictions.in((String)"c_id", pdServiceDetailIds);
        pdServiceDetailEntity.getCriterions().add(criterion);
        return this.getChildNode((TreeSearchEntity)pdServiceDetailEntity);
    }

    @Transactional
    public PdServiceDetailEntity addNodeWithGlobalContentsTreeMap(Long pdServiceId, PdServiceDetailEntity pdServiceDetailEntity) throws Exception {
        PdServiceDetailEntity result = (PdServiceDetailEntity)this.addNode((TreeSearchEntity)pdServiceDetailEntity);
        GlobalContentsTreeMapEntity globalContentsTreeMapEntity = new GlobalContentsTreeMapEntity();
        globalContentsTreeMapEntity.setPdservice_link(pdServiceId);
        globalContentsTreeMapEntity.setPdservicedetail_link(result.getC_id());
        this.globalContentsTreeMapService.saveOne(globalContentsTreeMapEntity);
        return result;
    }

    @Transactional
    public Set<FileRepositoryEntity> uploadFileForPdServiceNode(Long pdServiceDetailId, MultipartHttpServletRequest multiRequest) throws Exception {
        Set fileEntitySet = this.upload(multiRequest, this.fileRepository);
        HashSet<Long> fileSet = new HashSet<Long>();
        for (FileRepositoryEntity file : fileEntitySet) {
            GlobalContentsTreeMapEntity globalContentsTreeMapEntity = new GlobalContentsTreeMapEntity();
            globalContentsTreeMapEntity.setPdservicedetail_link(pdServiceDetailId);
            globalContentsTreeMapEntity.setFilerepository_link(file.getC_id());
            List searchList = this.globalContentsTreeMapService.findAllBy(globalContentsTreeMapEntity);
            if (searchList == null || searchList.isEmpty()) {
                GlobalContentsTreeMapEntity savedMap = this.globalContentsTreeMapService.saveOne(globalContentsTreeMapEntity);
                fileSet.add(savedMap.getFilerepository_link());
                continue;
            }
            log.info("[ PdServiceDetailImpl :: uploadFileForPdServiceNode ] :: \uc774\ubbf8 \uc874\uc7ac\ud558\ub294 PdServiceBoard = {} & FileRepo = {}", (Object)pdServiceDetailId, (Object)globalContentsTreeMapEntity.getFilerepository_link());
            fileSet.add(globalContentsTreeMapEntity.getFilerepository_link());
        }
        HashSet<FileRepositoryEntity> returnSet = new HashSet<FileRepositoryEntity>();
        for (Long fileCid : fileSet) {
            FileRepositoryEntity entity = new FileRepositoryEntity();
            entity.setC_id(fileCid);
            returnSet.add((FileRepositoryEntity)this.fileRepository.getNode((TreeSearchEntity)entity));
        }
        return returnSet;
    }

    public Set<FileRepositoryEntity> upload(MultipartHttpServletRequest multiRequest, FileRepository fileRepository) throws Exception {
        PropertiesReader propertiesReader = new PropertiesReader("com/arms/egovframework/property/globals.properties");
        String uploadDir = propertiesReader.getProperty("Globals.fileStorePath");
        long maxFileSize = TreeConstant.MAX_UPLOAD_FILESIZE;
        List list = EgovFileUploadUtil.uploadFiles((HttpServletRequest)multiRequest, (String)uploadDir, (long)maxFileSize);
        HashSet<FileRepositoryEntity> fileRepositoryEntities = new HashSet<FileRepositoryEntity>();
        for (EgovFormBasedFileVo egovFormBasedFileVo : list) {
            FileRepositoryEntity fileRepositoryEntity = new FileRepositoryEntity();
            fileRepositoryEntity.setFileName(egovFormBasedFileVo.getFileName());
            fileRepositoryEntity.setContentType(egovFormBasedFileVo.getContentType());
            fileRepositoryEntity.setServerSubPath(egovFormBasedFileVo.getServerSubPath());
            fileRepositoryEntity.setPhysicalName(egovFormBasedFileVo.getPhysicalName());
            fileRepositoryEntity.setSize(Long.valueOf(egovFormBasedFileVo.getSize()));
            fileRepositoryEntity.setName(egovFormBasedFileVo.getName());
            fileRepositoryEntity.setUrl(egovFormBasedFileVo.getUrl());
            fileRepositoryEntity.setThumbnailUrl(egovFormBasedFileVo.getThumbnailUrl());
            fileRepositoryEntity.setDelete_url(egovFormBasedFileVo.getDelete_url());
            fileRepositoryEntity.setDelete_type(egovFormBasedFileVo.getDelete_type());
            fileRepositoryEntity.setRef(TreeConstant.First_Node_CID.longValue());
            fileRepositoryEntity.setC_title("for PdServiceDetail");
            fileRepositoryEntity.setC_type("default");
            FileRepositoryEntity returnFileRepositoryEntity = (FileRepositoryEntity)fileRepository.addNode((TreeSearchEntity)fileRepositoryEntity);
            fileRepositoryEntity.setUrl("/auth-user/api/arms/fileRepository/downloadFileByNode/" + returnFileRepositoryEntity.getId());
            fileRepositoryEntity.setThumbnailUrl("/auth-user/api/arms/fileRepository/thumbnailUrlFileToNode/" + returnFileRepositoryEntity.getId());
            fileRepositoryEntity.setDelete_url("/auth-user/api/arms/pdServiceDetail/deleteFileNode.do/" + returnFileRepositoryEntity.getId());
            fileRepository.updateNode((TreeSearchEntity)fileRepositoryEntity);
            fileRepositoryEntities.add(fileRepositoryEntity);
        }
        return fileRepositoryEntities;
    }

    @Transactional
    public int deleteFile(Long fileId) throws Exception {
        FileRepositoryEntity fileRepositoryEntity = new FileRepositoryEntity();
        fileRepositoryEntity.setC_id(fileId);
        this.fileRepository.removeNode((TreeSearchEntity)fileRepositoryEntity);
        this.globalContentsTreeMapService.deleteByColumnValue("filerepository_link", fileId);
        return 1;
    }

    @Transactional
    public int deleteAll(Long pdServiceDetailId) throws Exception {
        List fileLinks = this.globalContentsTreeMapService.findAllByIds(List.of(pdServiceDetailId), "pdservicedetail_link").stream().filter(globalContentsTreeMapEntity -> globalContentsTreeMapEntity.getFilerepository_link() != null).map(GlobalContentsTreeMapEntity::getFilerepository_link).collect(Collectors.toList());
        for (Long fileLink : fileLinks) {
            FileRepositoryEntity fileRepositoryEntity = new FileRepositoryEntity();
            fileRepositoryEntity.setC_id(fileLink);
            this.fileRepository.removeNode((TreeSearchEntity)fileRepositoryEntity);
        }
        PdServiceDetailEntity pdServiceDetailEntity = new PdServiceDetailEntity();
        pdServiceDetailEntity.setC_id(pdServiceDetailId);
        this.removeNode((TreeSearchEntity)pdServiceDetailEntity);
        this.globalContentsTreeMapService.deleteByColumnValue("pdservicedetail_link", pdServiceDetailId);
        return 1;
    }

    public PdServiceDetailImpl(FileRepository fileRepository, GlobalContentsTreeMapService globalContentsTreeMapService) {
        this.fileRepository = fileRepository;
        this.globalContentsTreeMapService = globalContentsTreeMapService;
    }
}

