/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.product_service.pdservice.service;

import com.arms.api.globaltreemap.model.GlobalContentsTreeMapEntity;
import com.arms.api.globaltreemap.model.GlobalTreeMapEntity;
import com.arms.api.globaltreemap.service.GlobalContentsTreeMapService;
import com.arms.api.globaltreemap.service.GlobalTreeMapService;
import com.arms.api.jira.jiraproject_pure.model.JiraProjectPureEntity;
import com.arms.api.jira.jiraproject_pure.service.JiraProjectPure;
import com.arms.api.jira.jiraserver_pure.model.JiraServerPureEntity;
import com.arms.api.jira.jiraserver_pure.service.JiraServerPure;
import com.arms.api.product_service.pdservice.model.PdServiceAndVersionListDTO;
import com.arms.api.product_service.pdservice.model.PdServiceD3Chart;
import com.arms.api.product_service.pdservice.model.PdServiceEntity;
import com.arms.api.product_service.pdservice.service.PdService;
import com.arms.api.product_service.pdservice_detail.service.PdServiceDetail;
import com.arms.api.product_service.pdserviceversion.model.PdServiceVersionEntity;
import com.arms.api.product_service.pdserviceversion.model.PdServiceVersionVO;
import com.arms.api.product_service.pdserviceversion.service.PdServiceVersion;
import com.arms.api.util.dynamicdbmaker.service.DynamicDBMaker;
import com.arms.api.util.filerepository.model.FileRepositoryEntity;
import com.arms.api.util.filerepository.service.FileRepository;
import com.arms.egovframework.javaservice.treeframework.TreeConstant;
import com.arms.egovframework.javaservice.treeframework.model.TreeSearchEntity;
import com.arms.egovframework.javaservice.treeframework.remote.Global;
import com.arms.egovframework.javaservice.treeframework.service.TreeServiceImpl;
import com.arms.egovframework.javaservice.treeframework.util.DateUtils;
import com.arms.egovframework.javaservice.treeframework.util.EgovFileUploadUtil;
import com.arms.egovframework.javaservice.treeframework.util.EgovFormBasedFileVo;
import com.arms.egovframework.javaservice.treeframework.util.PropertiesReader;
import com.arms.egovframework.javaservice.treeframework.util.StringUtils;
import com.arms.egovframework.javaservice.treeframework.util.Util_TitleChecker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="pdService")
public class PdServiceImpl
extends TreeServiceImpl
implements PdService {
    private static final Logger log = LoggerFactory.getLogger(PdServiceImpl.class);
    private final FileRepository fileRepository;
    private final PdServiceVersion pdServiceVersion;
    private final PdServiceDetail pdServiceDetail;
    private final DynamicDBMaker dynamicDBMaker;
    private final GlobalTreeMapService globalTreeMapService;
    private final GlobalContentsTreeMapService globalContentsTreeMapService;
    private final JiraProjectPure jiraProjectPure;
    private final JiraServerPure jiraServerPure;

    public PdServiceEntity getNodeWithVersionOrderByCidDesc(PdServiceEntity pdServiceEntity) throws Exception {
        PdServiceEntity pdServiceNode = (PdServiceEntity)this.getNode((TreeSearchEntity)pdServiceEntity);
        TreeSet<PdServiceVersionEntity> sortedSet = new TreeSet<PdServiceVersionEntity>(Comparator.comparing(PdServiceVersionEntity::getC_id).reversed());
        sortedSet.addAll(pdServiceNode.getPdServiceVersionEntities());
        pdServiceNode.setPdServiceVersionEntities(sortedSet);
        return pdServiceNode;
    }

    public List<PdServiceVersionVO> versionListByCId(PdServiceEntity pdServiceEntity) throws Exception {
        Set pdServiceVersionEntities = ((PdServiceEntity)this.getNode((TreeSearchEntity)pdServiceEntity)).getPdServiceVersionEntities();
        if (ObjectUtils.isEmpty((Object)pdServiceVersionEntities)) {
            return Collections.emptyList();
        }
        List<PdServiceVersionVO> pdServiceVersionVOList = pdServiceVersionEntities.stream().map(PdServiceVersionVO::toVO).sorted(Comparator.comparing(PdServiceVersionVO::getC_id).reversed()).collect(Collectors.toList());
        return pdServiceVersionVOList;
    }

    public List<PdServiceVersionVO> versionListWithDateByCId(PdServiceEntity pdServiceEntity) throws Exception {
        Set pdServiceVersionEntities = ((PdServiceEntity)this.getNode((TreeSearchEntity)pdServiceEntity)).getPdServiceVersionEntities();
        if (ObjectUtils.isEmpty((Object)pdServiceVersionEntities)) {
            return Collections.emptyList();
        }
        List<PdServiceVersionVO> pdServiceVersionVOList = pdServiceVersionEntities.stream().map(PdServiceVersionVO::toVOWithDate).sorted(Comparator.comparing(PdServiceVersionVO::getC_id).reversed()).collect(Collectors.toList());
        return pdServiceVersionVOList;
    }

    @Transactional
    public PdServiceEntity addPdServiceAndVersion(PdServiceEntity pdServiceEntity) throws Exception {
        pdServiceEntity.setC_title(Util_TitleChecker.StringReplace((String)pdServiceEntity.getC_title()));
        PdServiceVersionEntity baseVerNode = new PdServiceVersionEntity();
        baseVerNode.setRef(TreeConstant.First_Node_CID.longValue());
        baseVerNode.setC_title("BaseVersion");
        baseVerNode.setC_type("default");
        Date date = new Date();
        baseVerNode.setC_pds_version_start_date(DateUtils.format((String)"yyyy/MM/dd HH:mm", (Date)DateUtils.getStartOfDate((Date)date)));
        baseVerNode.setC_pds_version_end_date(DateUtils.format((String)"yyyy/MM/dd HH:mm", (Date)DateUtils.getEndOfDate((Date)date)));
        baseVerNode.setC_pds_version_contents("contents");
        baseVerNode.setC_pds_version_etc("etc");
        PdServiceVersionEntity baseNode = (PdServiceVersionEntity)this.pdServiceVersion.addNode((TreeSearchEntity)baseVerNode);
        HashSet<PdServiceVersionEntity> treeset = new HashSet<PdServiceVersionEntity>();
        treeset.add(baseNode);
        pdServiceEntity.setPdServiceVersionEntities(treeset);
        PdServiceEntity addedNode = (PdServiceEntity)this.addNode((TreeSearchEntity)pdServiceEntity);
        this.dynamicDBMaker.createSchema(addedNode.getC_id().toString());
        addedNode.setC_pdservice_etc("T_ARMS_REQADD_" + addedNode.getC_id().toString());
        this.updateNode((TreeSearchEntity)addedNode);
        return addedNode;
    }

    @Transactional
    public PdServiceEntity updatePdServiceVersion(Long pdservice_link, PdServiceVersionEntity pdServiceVersionEntity) throws Exception {
        PdServiceEntity searchNode = new PdServiceEntity();
        searchNode.setC_id(pdservice_link);
        PdServiceEntity savedNode = (PdServiceEntity)this.getNode((TreeSearchEntity)searchNode);
        Set versionEntityList = savedNode.getPdServiceVersionEntities();
        for (PdServiceVersionEntity versionEntity : versionEntityList) {
            if (!versionEntity.getC_id().equals(pdServiceVersionEntity.getC_id())) continue;
            versionEntity.setC_title(pdServiceVersionEntity.getC_title());
            versionEntity.setC_pds_version_start_date(pdServiceVersionEntity.getC_pds_version_start_date());
            versionEntity.setC_pds_version_end_date(pdServiceVersionEntity.getC_pds_version_end_date());
            versionEntity.setC_pds_version_etc(pdServiceVersionEntity.getC_pds_version_etc());
            versionEntity.setC_pds_version_contents(pdServiceVersionEntity.getC_pds_version_contents());
            this.pdServiceVersion.updateNode((TreeSearchEntity)versionEntity);
        }
        return savedNode;
    }

    @Transactional
    public PdServiceEntity addPdServiceVersion(PdServiceEntity pdServiceEntity) throws Exception {
        PdServiceEntity pdServiceNode = (PdServiceEntity)this.getNode((TreeSearchEntity)pdServiceEntity);
        Set \ub514\ube44_\ubc84\uc804\ub4e4 = pdServiceNode.getPdServiceVersionEntities();
        Set \uc694\uccad\ubc1b\uc740_\ubc84\uc804\ub4e4 = pdServiceEntity.getPdServiceVersionEntities();
        for (PdServiceVersionEntity \uc694\uccad\ubc84\uc804 : \uc694\uccad\ubc1b\uc740_\ubc84\uc804\ub4e4) {
            PdServiceVersionEntity \ubc84\ud0b7_\uc9d1\uacc4_\uacb0\uacfc = \ub514\ube44_\ubc84\uc804\ub4e4.stream().filter(\ub514\ube44\ubc84\uc804 -> StringUtils.equalsIgnoreCase((String)\uc694\uccad\ubc84\uc804.getC_title(), (String)\ub514\ube44\ubc84\uc804.getC_title())).findAny().orElse(null);
            if (\ubc84\ud0b7_\uc9d1\uacc4_\uacb0\uacfc == null) {
                PdServiceVersionEntity \ucd94\uac00\ub41c\ubc84\uc804 = (PdServiceVersionEntity)this.pdServiceVersion.addNode((TreeSearchEntity)\uc694\uccad\ubc84\uc804);
                \ub514\ube44_\ubc84\uc804\ub4e4.add(\ucd94\uac00\ub41c\ubc84\uc804);
                continue;
            }
            log.info("[ PdServiceImpl :: addPdServiceVersion ] :: \uc774\ubbf8 \uc874\uc7ac\ud558\ub294 \ubc84\uc804 = {}", (Object)\uc694\uccad\ubc84\uc804);
        }
        pdServiceNode.setPdServiceVersionEntities(\ub514\ube44_\ubc84\uc804\ub4e4);
        this.updateNode((TreeSearchEntity)pdServiceNode);
        return pdServiceNode;
    }

    @Transactional
    public Set<FileRepositoryEntity> uploadFileForPdServiceNode(Long pdservice_link, MultipartHttpServletRequest multiRequest) throws Exception {
        Set fileEntitySet = this.upload(multiRequest, this.fileRepository);
        HashSet<Long> fileCids = new HashSet<Long>();
        for (FileRepositoryEntity file : fileEntitySet) {
            GlobalTreeMapEntity globalTreeMap = new GlobalTreeMapEntity();
            globalTreeMap.setPdservice_link(pdservice_link);
            globalTreeMap.setFilerepository_link(file.getC_id());
            List searchList = this.globalTreeMapService.findAllBy(globalTreeMap);
            if (searchList == null || searchList.isEmpty()) {
                GlobalTreeMapEntity savedMap = this.globalTreeMapService.saveOne(globalTreeMap);
                fileCids.add(savedMap.getFilerepository_link());
                continue;
            }
            log.info("[ PdServiceImpl :: uploadFileForPdServiceNode ] :: already registered PdService = {} & FileRepo = {}", (Object)pdservice_link, (Object)globalTreeMap.getFilerepository_link());
            fileCids.add(globalTreeMap.getFilerepository_link());
        }
        HashSet<FileRepositoryEntity> returnSet = new HashSet<FileRepositoryEntity>();
        for (Long fileCid : fileCids) {
            FileRepositoryEntity entity = new FileRepositoryEntity();
            entity.setC_id(fileCid);
            returnSet.add((FileRepositoryEntity)this.fileRepository.getNode((TreeSearchEntity)entity));
        }
        return returnSet;
    }

    public Set<FileRepositoryEntity> upload(MultipartHttpServletRequest multiRequest, FileRepository fileRepository) throws Exception {
        PropertiesReader propertiesReader = new PropertiesReader("com/arms/egovframework/property/globals.properties");
        String uploadDir = propertiesReader.getProperty("Globals.fileStorePath");
        long maxFileSize = TreeConstant.MAX_UPLOAD_FILESIZE;
        List list = EgovFileUploadUtil.uploadFiles((HttpServletRequest)multiRequest, (String)uploadDir, (long)maxFileSize);
        HashSet<FileRepositoryEntity> fileRepositoryEntities = new HashSet<FileRepositoryEntity>();
        for (EgovFormBasedFileVo egovFormBasedFileVo : list) {
            FileRepositoryEntity fileRepositoryEntity = new FileRepositoryEntity();
            fileRepositoryEntity.setFileName(egovFormBasedFileVo.getFileName());
            fileRepositoryEntity.setContentType(egovFormBasedFileVo.getContentType());
            fileRepositoryEntity.setServerSubPath(egovFormBasedFileVo.getServerSubPath());
            fileRepositoryEntity.setPhysicalName(egovFormBasedFileVo.getPhysicalName());
            fileRepositoryEntity.setSize(Long.valueOf(egovFormBasedFileVo.getSize()));
            fileRepositoryEntity.setName(egovFormBasedFileVo.getName());
            fileRepositoryEntity.setUrl(egovFormBasedFileVo.getUrl());
            fileRepositoryEntity.setThumbnailUrl(egovFormBasedFileVo.getThumbnailUrl());
            fileRepositoryEntity.setDelete_url(egovFormBasedFileVo.getDelete_url());
            fileRepositoryEntity.setDelete_type(egovFormBasedFileVo.getDelete_type());
            fileRepositoryEntity.setRef(TreeConstant.First_Node_CID.longValue());
            fileRepositoryEntity.setC_title("for PdService");
            fileRepositoryEntity.setC_type("default");
            FileRepositoryEntity returnFileRepositoryEntity = (FileRepositoryEntity)fileRepository.addNode((TreeSearchEntity)fileRepositoryEntity);
            fileRepositoryEntity.setUrl("/auth-user/api/arms/fileRepository/downloadFileByNode/" + returnFileRepositoryEntity.getId());
            fileRepositoryEntity.setThumbnailUrl("/auth-user/api/arms/fileRepository/thumbnailUrlFileToNode/" + returnFileRepositoryEntity.getId());
            fileRepositoryEntity.setDelete_url("/auth-user/api/arms/fileRepository/deleteFileByNode/" + returnFileRepositoryEntity.getId());
            fileRepository.updateNode((TreeSearchEntity)fileRepositoryEntity);
            fileRepositoryEntities.add(fileRepositoryEntity);
        }
        return fileRepositoryEntities;
    }

    @Transactional
    public PdServiceEntity removeVersionNode(Long pdServiceID, Long versionID) throws Exception {
        PdServiceEntity pdService = new PdServiceEntity();
        pdService.setC_id(pdServiceID);
        PdServiceEntity savedPdServiceNode = (PdServiceEntity)this.getNode((TreeSearchEntity)pdService);
        Set versionSet = savedPdServiceNode.getPdServiceVersionEntities();
        PdServiceVersionEntity \uc9c0\uc6b8_\ubc84\uc804\uc5d4\ud2f0\ud2f0 = versionSet.stream().filter(entity -> entity.getC_id().equals(versionID)).findFirst().orElse(null);
        String \uc9c0\uc6b8_\ubc84\uc804_\uc774\ub984 = "";
        if (\uc9c0\uc6b8_\ubc84\uc804\uc5d4\ud2f0\ud2f0 != null) {
            \uc9c0\uc6b8_\ubc84\uc804_\uc774\ub984 = \uc9c0\uc6b8_\ubc84\uc804\uc5d4\ud2f0\ud2f0.getC_title();
            versionSet.remove(\uc9c0\uc6b8_\ubc84\uc804\uc5d4\ud2f0\ud2f0);
        }
        this.updateNode((TreeSearchEntity)pdService);
        PdServiceVersionEntity \uc0ad\uc81c\ub300\uc0c1\ubc84\uc804 = new PdServiceVersionEntity();
        \uc0ad\uc81c\ub300\uc0c1\ubc84\uc804.setC_id(versionID);
        this.pdServiceVersion.removeNode((TreeSearchEntity)\uc0ad\uc81c\ub300\uc0c1\ubc84\uc804);
        if (StringUtils.isNotEmpty((String)\uc9c0\uc6b8_\ubc84\uc804_\uc774\ub984)) {
            Global.chat.sendMessageByEngine(savedPdServiceNode.getC_title() + "\uc758 \ubc84\uc804 " + \uc9c0\uc6b8_\ubc84\uc804_\uc774\ub984 + "\uc774(\uac00) \uc0ad\uc81c\ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
        }
        return pdService;
    }

    public PdServiceD3Chart getD3ChartData() throws Exception {
        List \uc11c\ube44\uc2a4_\ub9ac\uc2a4\ud2b8 = this.getNodesWithoutRoot((TreeSearchEntity)new PdServiceEntity());
        if (\uc11c\ube44\uc2a4_\ub9ac\uc2a4\ud2b8.isEmpty()) {
            return null;
        }
        List \ubc84\uc804\uc544\uc774\ub514_\ubaa9\ub85d = this.\ubc84\uc804_\uc544\uc774\ub514_\ubaa9\ub85d_\ucd94\ucd9c(\uc11c\ube44\uc2a4_\ub9ac\uc2a4\ud2b8);
        Map \ubc84\uc804_alm\ud504\ub85c\uc81d\ud2b8\uba85_\ub9f5 = this.\ubc84\uc804_ALM\ud504\ub85c\uc81d\ud2b8\uba85_\ub9f5(\ubc84\uc804\uc544\uc774\ub514_\ubaa9\ub85d);
        List \ub808\ubca82_\uc11c\ube44\uc2a4_\ub9ac\uc2a4\ud2b8 = \uc11c\ube44\uc2a4_\ub9ac\uc2a4\ud2b8.parallelStream().map(\uc11c\ube44\uc2a4 -> {
            Set \uc11c\ube44\uc2a4_\ubc84\uc804_\ub9ac\uc2a4\ud2b8 = \uc11c\ube44\uc2a4.getPdServiceVersionEntities();
            List \ub808\ubca83_\ubc84\uc804_\ub9ac\uc2a4\ud2b8 = \uc11c\ube44\uc2a4_\ubc84\uc804_\ub9ac\uc2a4\ud2b8.stream().map(\ubc84\uc804 -> {
                List \ud574\ub2f9\ubc84\uc804_ALM\uc11c\ubc84_\ud504\ub85c\uc81d\ud2b8_\uba85_\ubaa9\ub85d = (List)\ubc84\uc804_alm\ud504\ub85c\uc81d\ud2b8\uba85_\ub9f5.get(\ubc84\uc804.getC_id());
                ArrayList<PdServiceD3Chart> \ub808\ubca84_\uc9c0\ub77c\ud504\ub85c\uc81d\ud2b8_\ubaa9\ub85d = new ArrayList<PdServiceD3Chart>();
                for (String ALM\uc11c\ubc84_\ud504\ub85c\uc81d\ud2b8_\uba85 : \ud574\ub2f9\ubc84\uc804_ALM\uc11c\ubc84_\ud504\ub85c\uc81d\ud2b8_\uba85_\ubaa9\ub85d) {
                    \ub808\ubca84_\uc9c0\ub77c\ud504\ub85c\uc81d\ud2b8_\ubaa9\ub85d.add(PdServiceD3Chart.builder().type("ALM").name(ALM\uc11c\ubc84_\ud504\ub85c\uc81d\ud2b8_\uba85).build());
                }
                return PdServiceD3Chart.builder().type("Version").name(\ubc84\uc804.getC_title()).children(\ub808\ubca84_\uc9c0\ub77c\ud504\ub85c\uc81d\ud2b8_\ubaa9\ub85d).build();
            }).collect(Collectors.toList());
            return PdServiceD3Chart.builder().type("PdService").name(\uc11c\ube44\uc2a4.getC_title()).children(\ub808\ubca83_\ubc84\uc804_\ub9ac\uc2a4\ud2b8).build();
        }).collect(Collectors.toList());
        return PdServiceD3Chart.builder().name("a-RMS").children(\ub808\ubca82_\uc11c\ube44\uc2a4_\ub9ac\uc2a4\ud2b8).build();
    }

    @Transactional
    public int removeAll(Long pdServiceId) throws Exception {
        PdServiceEntity pdServiceEntity = new PdServiceEntity();
        pdServiceEntity.setC_id(pdServiceId);
        this.removeNode((TreeSearchEntity)pdServiceEntity);
        List pdServiceDetailLinks = this.globalContentsTreeMapService.findAllByIds(List.of(pdServiceId), "pdservice_link").stream().filter(globalContentsTreeMapEntity -> globalContentsTreeMapEntity.getPdservicedetail_link() != null).map(GlobalContentsTreeMapEntity::getPdservicedetail_link).collect(Collectors.toList());
        for (Long pdServiceDetailLink : pdServiceDetailLinks) {
            this.pdServiceDetail.deleteAll(pdServiceDetailLink);
        }
        return 1;
    }

    private List<Long> \ubc84\uc804_\uc544\uc774\ub514_\ubaa9\ub85d_\ucd94\ucd9c(List<PdServiceEntity> \uc81c\ud488\uc11c\ube44\uc2a4_\ubaa9\ub85d) {
        ArrayList<Long> \ubc84\uc804_\uc544\uc774\ub514_\ubaa9\ub85d = new ArrayList<Long>();
        for (PdServiceEntity \uc81c\ud488\uc11c\ube44\uc2a4 : \uc81c\ud488\uc11c\ube44\uc2a4_\ubaa9\ub85d) {
            Set \ubc84\uc804\uc5d4\ud2f0\ud2f0_\uc138\ud2b8 = \uc81c\ud488\uc11c\ube44\uc2a4.getPdServiceVersionEntities();
            \ubc84\uc804_\uc544\uc774\ub514_\ubaa9\ub85d.addAll(\ubc84\uc804\uc5d4\ud2f0\ud2f0_\uc138\ud2b8.stream().map(\ubc84\uc804 -> \ubc84\uc804.getC_id()).collect(Collectors.toList()));
        }
        return \ubc84\uc804_\uc544\uc774\ub514_\ubaa9\ub85d;
    }

    private Map<Long, List<String>> \ubc84\uc804_ALM\ud504\ub85c\uc81d\ud2b8\uba85_\ub9f5(List<Long> \ubc84\uc804\uc544\uc774\ub514_\ubaa9\ub85d) throws Exception {
        List \ubc84\uc804_\uc911\uc2ec_\uae00\ub85c\ubc8c\ud2b8\ub9ac\ub9f5\uc5d4\ud2f0\ud2f0_\ubaa9\ub85d = this.globalTreeMapService.findAllByIds(\ubc84\uc804\uc544\uc774\ub514_\ubaa9\ub85d, "pdserviceversion_link");
        List \uc5f0\uad00_\uc9c0\ub77c\ud504\ub85c\uc81d\ud2b8_\uc544\uc774\ub514_\ubaa9\ub85d = \ubc84\uc804_\uc911\uc2ec_\uae00\ub85c\ubc8c\ud2b8\ub9ac\ub9f5\uc5d4\ud2f0\ud2f0_\ubaa9\ub85d.stream().map(GlobalTreeMapEntity::getJiraproject_link).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<Long, Long> almProjectId_almServerId_map = this.globalTreeMapService.findAllByIds(\uc5f0\uad00_\uc9c0\ub77c\ud504\ub85c\uc81d\ud2b8_\uc544\uc774\ub514_\ubaa9\ub85d, "jiraproject_link").stream().filter(\uc5d4\ud2f0\ud2f0 -> \uc5d4\ud2f0\ud2f0.getJiraserver_link() != null).collect(Collectors.toMap(GlobalTreeMapEntity::getJiraproject_link, GlobalTreeMapEntity::getJiraserver_link));
        JiraProjectPureEntity \ud504\ub85c\uc81d\ud2b8_\ud4e8\uc5b4_\uac80\uc0c9 = new JiraProjectPureEntity();
        \ud504\ub85c\uc81d\ud2b8_\ud4e8\uc5b4_\uac80\uc0c9.getCriterions().add(Restrictions.in((String)"c_id", \uc5f0\uad00_\uc9c0\ub77c\ud504\ub85c\uc81d\ud2b8_\uc544\uc774\ub514_\ubaa9\ub85d));
        Map<Long, String> projectId_projectName_map = this.jiraProjectPure.getChildNode((TreeSearchEntity)\ud504\ub85c\uc81d\ud2b8_\ud4e8\uc5b4_\uac80\uc0c9).stream().collect(Collectors.toMap(JiraProjectPureEntity::getC_id, JiraProjectPureEntity::getC_jira_name));
        Map<Long, String> serverId_serverName_map = this.jiraServerPure.getNodesWithoutRoot(new JiraServerPureEntity()).stream().collect(Collectors.toMap(JiraServerPureEntity::getC_id, JiraServerPureEntity::getC_jira_server_name));
        Map<Long, String> projectId_serverNameProjectName_map = \uc5f0\uad00_\uc9c0\ub77c\ud504\ub85c\uc81d\ud2b8_\uc544\uc774\ub514_\ubaa9\ub85d.stream().collect(Collectors.toMap(projectId -> projectId, projectId -> {
            String serverName = Optional.ofNullable((Long)almProjectId_almServerId_map.get(projectId)).map(serverId_serverName_map::get).orElse("Unknown Server");
            String projectName = projectId_projectName_map.getOrDefault(projectId, "Unknown Project");
            return "[" + serverName + "]" + projectName;
        }));
        Map versionProjectMap = \ubc84\uc804_\uc911\uc2ec_\uae00\ub85c\ubc8c\ud2b8\ub9ac\ub9f5\uc5d4\ud2f0\ud2f0_\ubaa9\ub85d.stream().filter(\uc5d4\ud2f0\ud2f0 -> \uc5d4\ud2f0\ud2f0.getJiraproject_link() != null).collect(Collectors.groupingBy(GlobalTreeMapEntity::getPdserviceversion_link, Collectors.mapping(GlobalTreeMapEntity::getJiraproject_link, Collectors.toList())));
        return \ubc84\uc804\uc544\uc774\ub514_\ubaa9\ub85d.stream().collect(Collectors.toMap(versionId -> versionId, versionId -> Optional.ofNullable((List)versionProjectMap.get(versionId)).orElse(Collections.emptyList()).stream().map(projectId_serverNameProjectName_map::get).collect(Collectors.toList())));
    }

    public List<PdServiceAndVersionListDTO> getPdServiceEntityAndVersionList(PdServiceEntity pdServiceEntity) throws Exception {
        List list = this.getNodesWithoutRoot((TreeSearchEntity)pdServiceEntity);
        ArrayList<PdServiceAndVersionListDTO> result = new ArrayList<PdServiceAndVersionListDTO>();
        for (PdServiceEntity entity : list) {
            PdServiceAndVersionListDTO dto = PdServiceAndVersionListDTO.builder().c_id(entity.getC_id()).c_title(entity.getC_title()).pdServiceVersionEntityList(new ArrayList(entity.getPdServiceVersionEntities())).build();
            result.add(dto);
        }
        return result;
    }

    public PdServiceImpl(FileRepository fileRepository, PdServiceVersion pdServiceVersion, PdServiceDetail pdServiceDetail, DynamicDBMaker dynamicDBMaker, GlobalTreeMapService globalTreeMapService, GlobalContentsTreeMapService globalContentsTreeMapService, JiraProjectPure jiraProjectPure, JiraServerPure jiraServerPure) {
        this.fileRepository = fileRepository;
        this.pdServiceVersion = pdServiceVersion;
        this.pdServiceDetail = pdServiceDetail;
        this.dynamicDBMaker = dynamicDBMaker;
        this.globalTreeMapService = globalTreeMapService;
        this.globalContentsTreeMapService = globalContentsTreeMapService;
        this.jiraProjectPure = jiraProjectPure;
        this.jiraServerPure = jiraServerPure;
    }
}

