/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.product_service.pdservice.model;

import com.arms.api.product_service.pdservice.model.PdServiceEntity;
import com.arms.api.product_service.pdserviceversion.model.PdServiceVersionEntity;
import com.arms.egovframework.javaservice.treeframework.model.TreeBaseEntity;
import com.arms.egovframework.javaservice.treeframework.model.TreeSearchEntity;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.LazyCollection;
import org.hibernate.annotations.LazyCollectionOption;
import org.hibernate.annotations.SelectBeforeUpdate;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.WhereJoinTable;

@Entity
@Table(name="T_ARMS_PDSERVICE")
@SelectBeforeUpdate(value=true)
@DynamicInsert(value=true)
@DynamicUpdate(value=true)
@Cache(usage=CacheConcurrencyStrategy.NONE)
public class PdServiceEntity
extends TreeSearchEntity
implements Serializable {
    @Column(name="c_pdservice_owner")
    @Type(type="text")
    private String c_pdservice_owner;
    @Column(name="c_pdservice_reviewer01")
    @Type(type="text")
    private String c_pdservice_reviewer01;
    @Column(name="c_pdservice_reviewer02")
    @Type(type="text")
    private String c_pdservice_reviewer02;
    @Column(name="c_pdservice_reviewer03")
    @Type(type="text")
    private String c_pdservice_reviewer03;
    @Column(name="c_pdservice_reviewer04")
    @Type(type="text")
    private String c_pdservice_reviewer04;
    @Column(name="c_pdservice_reviewer05")
    private String c_pdservice_reviewer05;
    @Column(name="c_pdservice_writer")
    @Type(type="text")
    private String c_pdservice_writer;
    @Lob
    @Column(name="c_pdservice_contents")
    private String c_pdservice_contents;
    @Type(type="text")
    @Column(name="c_pdservice_desc")
    private String c_pdservice_desc;
    @Column(name="c_pdservice_etc")
    private String c_pdservice_etc;
    private Set<PdServiceVersionEntity> pdServiceVersionEntities;
    @JsonIgnore
    private Boolean copyBooleanValue;

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="c_id")
    public Long getC_id() {
        return super.getC_id();
    }

    @LazyCollection(value=LazyCollectionOption.FALSE)
    @JsonManagedReference
    @OneToMany(cascade={CascadeType.ALL})
    @JoinTable(name="GLOBAL_TREE_MAP", joinColumns={@JoinColumn(name="pdservice_link")}, inverseJoinColumns={@JoinColumn(name="pdserviceversion_link")})
    @WhereJoinTable(clause="filerepository_link IS NULL and jiraserver_link IS NULL and jiraproject_link IS NULL and jiraissuepriority_link IS NULL and jiraissueresolution_link IS NULL and jiraissuestatus_link IS NULL and jiraissuetype_link IS NULL")
    public Set<PdServiceVersionEntity> getPdServiceVersionEntities() {
        return this.pdServiceVersionEntities;
    }

    public Map<Long, String> versionNameMap() {
        return this.pdServiceVersionEntities.stream().collect(Collectors.toMap(PdServiceVersionEntity::getC_id, TreeBaseEntity::getC_title));
    }

    public void setPdServiceVersionEntities(Set<PdServiceVersionEntity> pdServiceVersionEntities) {
        this.pdServiceVersionEntities = pdServiceVersionEntities;
    }

    public List<PdServiceVersionEntity> versionList(List<Long> versionLinks) {
        return this.pdServiceVersionEntities.stream().filter(pdServiceVersionEntity -> versionLinks.contains(pdServiceVersionEntity.getC_id())).sorted(Comparator.comparing(PdServiceVersionEntity::getC_id)).collect(Collectors.toList());
    }

    @Transient
    @ApiModelProperty(hidden=true)
    public Boolean getCopyBooleanValue() {
        this.copyBooleanValue = false;
        this.copyBooleanValue = this.getCopy() == 0L ? Boolean.valueOf(false) : Boolean.valueOf(true);
        return this.copyBooleanValue;
    }

    public void setCopyBooleanValue(Boolean copyBooleanValue) {
        this.copyBooleanValue = copyBooleanValue;
    }

    public <T extends TreeSearchEntity> void setFieldFromNewInstance(T paramInstance) {
        if (paramInstance instanceof TreeBaseEntity && paramInstance.isCopied()) {
            this.setC_title("copy_" + this.getC_title());
        }
    }

    public static PdServiceEntityBuilder builder() {
        return new PdServiceEntityBuilder();
    }

    public String getC_pdservice_owner() {
        return this.c_pdservice_owner;
    }

    public String getC_pdservice_reviewer01() {
        return this.c_pdservice_reviewer01;
    }

    public String getC_pdservice_reviewer02() {
        return this.c_pdservice_reviewer02;
    }

    public String getC_pdservice_reviewer03() {
        return this.c_pdservice_reviewer03;
    }

    public String getC_pdservice_reviewer04() {
        return this.c_pdservice_reviewer04;
    }

    public String getC_pdservice_reviewer05() {
        return this.c_pdservice_reviewer05;
    }

    public String getC_pdservice_writer() {
        return this.c_pdservice_writer;
    }

    public String getC_pdservice_contents() {
        return this.c_pdservice_contents;
    }

    public String getC_pdservice_desc() {
        return this.c_pdservice_desc;
    }

    public String getC_pdservice_etc() {
        return this.c_pdservice_etc;
    }

    public void setC_pdservice_owner(String c_pdservice_owner) {
        this.c_pdservice_owner = c_pdservice_owner;
    }

    public void setC_pdservice_reviewer01(String c_pdservice_reviewer01) {
        this.c_pdservice_reviewer01 = c_pdservice_reviewer01;
    }

    public void setC_pdservice_reviewer02(String c_pdservice_reviewer02) {
        this.c_pdservice_reviewer02 = c_pdservice_reviewer02;
    }

    public void setC_pdservice_reviewer03(String c_pdservice_reviewer03) {
        this.c_pdservice_reviewer03 = c_pdservice_reviewer03;
    }

    public void setC_pdservice_reviewer04(String c_pdservice_reviewer04) {
        this.c_pdservice_reviewer04 = c_pdservice_reviewer04;
    }

    public void setC_pdservice_reviewer05(String c_pdservice_reviewer05) {
        this.c_pdservice_reviewer05 = c_pdservice_reviewer05;
    }

    public void setC_pdservice_writer(String c_pdservice_writer) {
        this.c_pdservice_writer = c_pdservice_writer;
    }

    public void setC_pdservice_contents(String c_pdservice_contents) {
        this.c_pdservice_contents = c_pdservice_contents;
    }

    public void setC_pdservice_desc(String c_pdservice_desc) {
        this.c_pdservice_desc = c_pdservice_desc;
    }

    public void setC_pdservice_etc(String c_pdservice_etc) {
        this.c_pdservice_etc = c_pdservice_etc;
    }

    public PdServiceEntity() {
    }

    public PdServiceEntity(String c_pdservice_owner, String c_pdservice_reviewer01, String c_pdservice_reviewer02, String c_pdservice_reviewer03, String c_pdservice_reviewer04, String c_pdservice_reviewer05, String c_pdservice_writer, String c_pdservice_contents, String c_pdservice_desc, String c_pdservice_etc, Set<PdServiceVersionEntity> pdServiceVersionEntities, Boolean copyBooleanValue) {
        this.c_pdservice_owner = c_pdservice_owner;
        this.c_pdservice_reviewer01 = c_pdservice_reviewer01;
        this.c_pdservice_reviewer02 = c_pdservice_reviewer02;
        this.c_pdservice_reviewer03 = c_pdservice_reviewer03;
        this.c_pdservice_reviewer04 = c_pdservice_reviewer04;
        this.c_pdservice_reviewer05 = c_pdservice_reviewer05;
        this.c_pdservice_writer = c_pdservice_writer;
        this.c_pdservice_contents = c_pdservice_contents;
        this.c_pdservice_desc = c_pdservice_desc;
        this.c_pdservice_etc = c_pdservice_etc;
        this.pdServiceVersionEntities = pdServiceVersionEntities;
        this.copyBooleanValue = copyBooleanValue;
    }
}

