/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.poc.service;

import com.arms.api.poc.model.PocDTO;
import com.arms.api.poc.model.PocEntity;
import com.arms.api.poc.model.vo.PocVO;
import com.arms.api.poc.service.PocService;
import com.arms.api.report.mail.modal.entity.sender.SenderEntity;
import com.arms.api.report.mail.service.sender.SenderService;
import com.arms.api.util.communicate.external.EngineService;
import com.arms.api.util.slack.SlackNotificationService;
import com.arms.api.util.slack.SlackProperty;
import com.arms.egovframework.javaservice.treeframework.controller.CommonResponse;
import com.arms.egovframework.javaservice.treeframework.model.TreeSearchEntity;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.spring5.SpringTemplateEngine;

@Service(value="pocService")
public class PocServiceImpl
implements PocService {
    private static final Logger log = LoggerFactory.getLogger(PocServiceImpl.class);
    private final SenderService senderService;
    private final SpringTemplateEngine templateEngine;
    private final SlackNotificationService slackNotificationService;
    private final EngineService engineService;
    private static final Set<String> LAST_NAME_FIRST_COUNTRIES = Set.of("KR", "JP", "CN");

    public PocEntity addPoc(PocDTO pocDTO) throws Exception {
        pocDTO.setC_poc_full_name(this.formatFullName(pocDTO));
        pocDTO.setC_poc_status(pocDTO.getC_poc_status() != null ? pocDTO.getC_poc_status() : "PENDING");
        pocDTO.setC_poc_assignee_id(null);
        ResponseEntity response = this.engineService.createPoc(pocDTO);
        String pocId = (String)((CommonResponse.ApiResult)response.getBody()).getResponse();
        PocEntity savedEntity = (PocEntity)((CommonResponse.ApiResult)this.engineService.getPoc(pocId).getBody()).getResponse();
        this.sendPocEmailNotification(savedEntity);
        this.sendPocSuccessEmailToApplicant(savedEntity);
        this.sendPocSlackNotification(savedEntity);
        return savedEntity;
    }

    public PocEntity getPoc(String id) throws Exception {
        ResponseEntity response = this.engineService.getPoc(id);
        return (PocEntity)((CommonResponse.ApiResult)response.getBody()).getResponse();
    }

    public PocVO getPocList(PocDTO pocDTO) throws Exception {
        ResponseEntity response = this.engineService.getPocList(pocDTO);
        return (PocVO)((CommonResponse.ApiResult)response.getBody()).getResponse();
    }

    public int updatePoc(PocDTO pocDTO) throws Exception {
        if (pocDTO.getId() == null) {
            throw new IllegalArgumentException("PoC ID \ub204\ub77d");
        }
        ResponseEntity response = this.engineService.updatePoc(pocDTO.getId(), pocDTO);
        PocEntity pocEntity = (PocEntity)((CommonResponse.ApiResult)this.engineService.getPoc(pocDTO.getId()).getBody()).getResponse();
        this.sendPocSuccessEmailToAssignee(pocEntity);
        this.sendPocSlackToAssignee(pocEntity);
        return ((CommonResponse.ApiResult)response.getBody()).getResponse() != null ? 1 : 0;
    }

    public int removePoc(String id) throws Exception {
        ResponseEntity response = this.engineService.deletePoc(id);
        return ((CommonResponse.ApiResult)response.getBody()).getResponse() != null ? 1 : 0;
    }

    private String formatFullName(PocDTO pocDTO) {
        String lastName;
        String firstName = pocDTO.getC_poc_first_name() != null ? pocDTO.getC_poc_first_name() : "";
        String string = lastName = pocDTO.getC_poc_last_name() != null ? pocDTO.getC_poc_last_name() : "";
        if (LAST_NAME_FIRST_COUNTRIES.contains(pocDTO.getC_poc_country())) {
            return lastName + " " + firstName;
        }
        return firstName + " " + lastName;
    }

    @Async(value="taskExecutor-arms")
    private void sendPocEmailNotification(PocEntity pocEntity) throws Exception {
        SenderEntity smtpConfig = this.getSenderConfig();
        JavaMailSenderImpl mailSender = this.createMailSender(smtpConfig);
        Context context = new Context();
        context.setVariable("pocEntity", (Object)pocEntity);
        String htmlContent = this.templateEngine.process("poc/poc-notification-mail", (IContext)context);
        MimeMessage mimeMessage = mailSender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(mimeMessage, true, "UTF-8");
        helper.setTo("313@313.co.kr");
        helper.setFrom(smtpConfig.getC_sender_email());
        helper.setSubject("[A-RMS] \uc0c8\ub85c\uc6b4 POC \uc2e0\uccad - " + pocEntity.getC_poc_company_name());
        helper.setText(htmlContent, true);
        mailSender.send(mimeMessage);
    }

    @Async(value="taskExecutor-arms")
    private void sendPocSuccessEmailToAssignee(PocEntity pocEntity) throws Exception {
        SenderEntity smtpConfig = this.getSenderConfig();
        JavaMailSenderImpl mailSender = this.createMailSender(smtpConfig);
        Context context = new Context();
        context.setVariable("pocEntity", (Object)pocEntity);
        String htmlContent = this.templateEngine.process("poc/poc-assignee-mail", (IContext)context);
        MimeMessage mimeMessage = mailSender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(mimeMessage, true, "UTF-8");
        String assigneeEmail = pocEntity.getC_poc_assignee_email();
        if (assigneeEmail == null || assigneeEmail.trim().isEmpty()) {
            assigneeEmail = "313@313.co.kr";
        }
        helper.setTo(assigneeEmail);
        helper.setFrom(smtpConfig.getC_sender_email());
        helper.setSubject("[A-RMS] \uc0c8\ub85c\uc6b4 POC \uc2e0\uccad - " + pocEntity.getC_poc_company_name());
        helper.setText(htmlContent, true);
        mailSender.send(mimeMessage);
    }

    @Async(value="taskExecutor-arms")
    private void sendPocSuccessEmailToApplicant(PocEntity pocEntity) throws Exception {
        SenderEntity smtpConfig = this.getSenderConfig();
        JavaMailSenderImpl mailSender = this.createMailSender(smtpConfig);
        Context context = new Context();
        context.setVariable("pocEntity", (Object)pocEntity);
        context.setVariable("recipientName", (Object)pocEntity.getC_poc_full_name());
        context.setVariable("recipientCompany", (Object)pocEntity.getC_poc_company_name());
        context.setVariable("recipientEmail", (Object)pocEntity.getC_poc_email_address());
        String htmlContent = this.templateEngine.process("poc/poc-success-mail", (IContext)context);
        MimeMessage mimeMessage = mailSender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(mimeMessage, true, "UTF-8");
        helper.setTo(pocEntity.getC_poc_email_address());
        helper.setFrom(smtpConfig.getC_sender_email());
        helper.setSubject("[A-RMS] POC \uc2e0\uccad\uc774 \uc811\uc218\ub418\uc5c8\uc2b5\ub2c8\ub2e4");
        helper.setText(htmlContent, true);
        mailSender.send(mimeMessage);
    }

    @Async(value="taskExecutor-arms")
    private void sendPocSlackNotification(PocEntity pocEntity) throws Exception {
        Context context = new Context();
        context.setVariable("pocEntity", (Object)pocEntity);
        String slackMessage = this.templateEngine.process("poc/poc-notification-slack", (IContext)context);
        this.slackNotificationService.sendMessageToChannel(SlackProperty.Channel.backend, slackMessage);
    }

    @Async(value="taskExecutor-arms")
    private void sendPocSlackToAssignee(PocEntity pocEntity) throws Exception {
        Context context = new Context();
        context.setVariable("pocEntity", (Object)pocEntity);
        String slackMessage = this.templateEngine.process("poc/poc-assignee-slack", (IContext)context);
        this.slackNotificationService.sendMessageToChannel(SlackProperty.Channel.backend, slackMessage);
    }

    private SenderEntity getSenderConfig() throws Exception {
        List senderInfo = this.senderService.getNodesWithoutRoot((TreeSearchEntity)new SenderEntity());
        if (senderInfo == null || senderInfo.isEmpty()) {
            throw new RuntimeException("SMTP \uc124\uc815\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
        }
        return (SenderEntity)senderInfo.get(0);
    }

    private JavaMailSenderImpl createMailSender(SenderEntity smtpConfig) {
        JavaMailSenderImpl mailSender = new JavaMailSenderImpl();
        mailSender.setHost(smtpConfig.getC_smtp_server());
        mailSender.setPort(smtpConfig.getC_smtp_port().intValue());
        mailSender.setUsername(smtpConfig.getC_sender_email());
        mailSender.setPassword(smtpConfig.getC_sender_password());
        Properties props = mailSender.getJavaMailProperties();
        props.put("mail.smtp.auth", "true");
        props.put("mail.smtp.ssl.enable", "true");
        props.put("mail.smtp.starttls.enable", "false");
        props.put("mail.smtp.ssl.protocols", "TLSv1.2");
        return mailSender;
    }

    public PocServiceImpl(SenderService senderService, SpringTemplateEngine templateEngine, SlackNotificationService slackNotificationService, EngineService engineService) {
        this.senderService = senderService;
        this.templateEngine = templateEngine;
        this.slackNotificationService = slackNotificationService;
        this.engineService = engineService;
    }
}

