/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.poc.controller;

import com.arms.api.poc.model.PocDTO;
import com.arms.api.poc.model.vo.PocVO;
import com.arms.api.poc.service.PocService;
import com.arms.egovframework.javaservice.treeframework.controller.CommonResponse;
import com.arms.egovframework.javaservice.treeframework.validation.group.AddNode;
import com.arms.egovframework.javaservice.treeframework.validation.group.UpdateNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/anonymous/arms/poc"})
public class PocController {
    private static final Logger log = LoggerFactory.getLogger(PocController.class);
    private final PocService pocService;

    @PostMapping(value={"/addPoc.do"})
    public ResponseEntity<?> addPoc(@Validated(value={AddNode.class}) PocDTO pocDTO) throws Exception {
        return ResponseEntity.ok((Object)CommonResponse.success((Object)this.pocService.addPoc(pocDTO)));
    }

    @GetMapping(value={"/getPoc.do/{pocId}"})
    public ResponseEntity<?> getPoc(@PathVariable(value="pocId") String pocId) throws Exception {
        return ResponseEntity.ok((Object)CommonResponse.success((Object)this.pocService.getPoc(pocId)));
    }

    @GetMapping(value={"/getPocList.do"})
    public ResponseEntity<CommonResponse.ApiResult<PocVO>> getPocList(PocDTO pocDTO) throws Exception {
        return ResponseEntity.ok((Object)CommonResponse.success((Object)this.pocService.getPocList(pocDTO)));
    }

    @PutMapping(value={"/updatePoc.do"})
    public ResponseEntity<CommonResponse.ApiResult<Integer>> updatePoc(@Validated(value={UpdateNode.class}) PocDTO pocDTO) throws Exception {
        return ResponseEntity.ok((Object)CommonResponse.success((Object)this.pocService.updatePoc(pocDTO)));
    }

    @DeleteMapping(value={"/removePoc.do/{pocId}"})
    public ResponseEntity<CommonResponse.ApiResult<Integer>> removePoc(@PathVariable(value="pocId") String pocId) throws Exception {
        return ResponseEntity.ok((Object)CommonResponse.success((Object)this.pocService.removePoc(pocId)));
    }

    public PocController(PocService pocService) {
        this.pocService = pocService;
    }
}

