/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.patchnote.controller;

import com.arms.api.patchnote.model.PatchnoteDTO;
import com.arms.api.patchnote.model.PatchnoteEntity;
import com.arms.api.patchnote.service.PatchnoteService;
import com.arms.egovframework.javaservice.treeframework.TreeConstant;
import com.arms.egovframework.javaservice.treeframework.controller.TreeAbstractController;
import com.arms.egovframework.javaservice.treeframework.model.TreeSearchEntity;
import com.arms.egovframework.javaservice.treeframework.service.TreeService;
import com.google.common.collect.Maps;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RestController
@RequestMapping(value={"/anonymous/arms/patchnote"})
public class PatchnoteController
extends TreeAbstractController<PatchnoteService, PatchnoteDTO, PatchnoteEntity> {
    private static final Logger log = LoggerFactory.getLogger(PatchnoteController.class);
    private final PatchnoteService patchnoteService;

    @PostConstruct
    public void initialize() {
        this.setTreeService((TreeService)this.patchnoteService);
        this.setTreeEntity(PatchnoteEntity.class);
    }

    @ResponseBody
    @GetMapping(value={"/getPatchnoteList.do"})
    public ModelAndView getPatchnoteList(PatchnoteDTO patchnoteDTO, @RequestParam(defaultValue="1") int pageIndex, @RequestParam(defaultValue="3") int pageUnit) throws Exception {
        PatchnoteEntity patchnoteEntity = (PatchnoteEntity)this.modelMapper.map((Object)patchnoteDTO, PatchnoteEntity.class);
        patchnoteEntity.setPageIndex(pageIndex);
        patchnoteEntity.setPageUnit(pageUnit);
        patchnoteEntity.getCriterions().add(Restrictions.not((Criterion)Restrictions.in((String)"c_id", (Object[])new Object[]{TreeConstant.ROOT_CID, TreeConstant.First_Node_CID})));
        patchnoteEntity.getOrder().add(Order.desc((String)"c_patchnote_created"));
        ModelAndView modelAndView = new ModelAndView("jsonView");
        HashMap resultMap = Maps.newHashMap();
        resultMap.put("paginationInfo", patchnoteEntity.getPaginationInfo());
        resultMap.put("data", this.patchnoteService.getPaginatedChildNode((TreeSearchEntity)patchnoteEntity));
        modelAndView.addObject("result", (Object)resultMap);
        return modelAndView;
    }

    public PatchnoteController(PatchnoteService patchnoteService) {
        this.patchnoteService = patchnoteService;
    }
}

