/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.jira.jiraserver.controller;

import com.arms.api.jira.jiraserver.model.JiraServerDTO;
import com.arms.api.jira.jiraserver.model.JiraServerEntity;
import com.arms.api.jira.jiraserver.model.enums.EntityType;
import com.arms.api.jira.jiraserver.service.JiraServer;
import com.arms.api.util.aes.AES256Encryption;
import com.arms.egovframework.javaservice.treeframework.controller.CommonResponse;
import com.arms.egovframework.javaservice.treeframework.controller.TreeAbstractController;
import com.arms.egovframework.javaservice.treeframework.model.TreeSearchEntity;
import com.arms.egovframework.javaservice.treeframework.service.TreeService;
import com.arms.egovframework.javaservice.treeframework.util.ParameterParser;
import com.arms.egovframework.javaservice.treeframework.validation.group.AddNode;
import com.arms.egovframework.javaservice.treeframework.validation.group.UpdateNode;
import java.util.concurrent.CompletableFuture;
import javax.annotation.PostConstruct;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/arms/jiraServer"})
public class JiraServerController
extends TreeAbstractController<JiraServer, JiraServerDTO, JiraServerEntity> {
    private static final Logger log = LoggerFactory.getLogger(JiraServerController.class);
    @Autowired
    @Qualifier(value="jiraServer")
    private JiraServer jiraServer;
    @Autowired
    private AES256Encryption aes256Encryption;

    @PostConstruct
    public void initialize() {
        this.setTreeService((TreeService)this.jiraServer);
        this.setTreeEntity(JiraServerEntity.class);
    }

    @ResponseBody
    @RequestMapping(value={"/addJiraServerNode.do"}, method={RequestMethod.POST})
    public ResponseEntity<?> addJiraServerNode(@Validated(value={AddNode.class}) JiraServerDTO jiraServerDTO, BindingResult bindingResult, ModelMap model) throws Exception {
        JiraServerEntity jiraServerEntity = (JiraServerEntity)this.modelMapper.map((Object)jiraServerDTO, JiraServerEntity.class);
        JiraServerEntity result = this.jiraServer.addJiraServer(jiraServerEntity);
        CompletableFuture future = this.jiraServer.refreshALMServer(result);
        future.thenAccept(process -> {
            try {
                this.jiraServer.cacheStatusMappingData(jiraServerEntity);
            }
            catch (Exception e) {
                log.error(e.getMessage());
                this.chat.sendMessageByEngine("\uce90\uc26c \uc11c\ubc84 \uc5c5\ub370\uc774\ud2b8 \uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4. :: " + e.getMessage());
            }
        });
        return ResponseEntity.ok((Object)CommonResponse.success((Object)result));
    }

    @ResponseBody
    @RequestMapping(value={"/getNodeWithEncryption.do"}, method={RequestMethod.GET})
    public ResponseEntity<String> getNodeWithEncryption(JiraServerDTO jiraServerDTO) throws Exception {
        JiraServerEntity jiraServerEntity = (JiraServerEntity)this.jiraServer.getNode((TreeSearchEntity)((JiraServerEntity)this.modelMapper.map((Object)jiraServerDTO, JiraServerEntity.class)));
        String encryptedAlmConnPw = this.aes256Encryption.encrypt(jiraServerEntity.getC_jira_server_connect_pw());
        return ResponseEntity.ok((Object)encryptedAlmConnPw);
    }

    @ResponseBody
    @RequestMapping(value={"{refreshTarget}/renewNode.do"}, method={RequestMethod.PUT})
    public ResponseEntity<?> refreshALMServerByTarget(@PathVariable String refreshTarget, String projectCId, JiraServerDTO jiraServerDTO) throws Exception {
        log.info("JiraServerController :: refreshALMServerByTarget refreshTarget=> {}", (Object)refreshTarget);
        JiraServerEntity jiraServerEntity = (JiraServerEntity)this.modelMapper.map((Object)jiraServerDTO, JiraServerEntity.class);
        EntityType entityType = EntityType.fromString((String)refreshTarget);
        JiraServerEntity result = this.jiraServer.\uc11c\ubc84_\uc5d4\ud2f0\ud2f0_\ud56d\ubaa9\ubcc4_\uac31\uc2e0(entityType, projectCId, jiraServerEntity);
        if (entityType == EntityType.\uc774\uc288\uc0c1\ud0dc) {
            this.jiraServer.cacheStatusMappingData(result);
        }
        return ResponseEntity.ok((Object)CommonResponse.success((Object)result));
    }

    @ResponseBody
    @RequestMapping(value={"/getJiraProjectPure.do"}, method={RequestMethod.GET})
    public ResponseEntity<?> getJiraProjectPure(JiraServerDTO jiraServerDTO, HttpServletRequest request) throws Exception {
        log.info("JiraServerController :: getJiraProjectPure");
        ParameterParser parser = new ParameterParser((ServletRequest)request);
        if (parser.getInt("c_id") <= 0) {
            throw new RuntimeException("c_id is minus value");
        }
        JiraServerEntity jiraServerEntity = (JiraServerEntity)this.modelMapper.map((Object)jiraServerDTO, JiraServerEntity.class);
        return ResponseEntity.ok((Object)CommonResponse.success((Object)this.jiraServer.getProjectPureList(jiraServerEntity)));
    }

    @ResponseBody
    @RequestMapping(value={"/getJiraIssueType.do"}, method={RequestMethod.GET})
    public ResponseEntity<?> getJiraIssueTypeList(JiraServerDTO jiraServerDTO, HttpServletRequest request) throws Exception {
        log.info("JiraServerController :: getJiraIssueTypeList");
        ParameterParser parser = new ParameterParser((ServletRequest)request);
        if (parser.getInt("c_id") <= 0) {
            throw new RuntimeException("c_id is minus value");
        }
        JiraServerEntity jiraServerEntity = (JiraServerEntity)this.modelMapper.map((Object)jiraServerDTO, JiraServerEntity.class);
        return ResponseEntity.ok((Object)CommonResponse.success((Object)this.jiraServer.getIssueTypeOnlyList(jiraServerEntity)));
    }

    @ResponseBody
    @RequestMapping(value={"/getIssueStatusList"}, method={RequestMethod.GET})
    public ResponseEntity<?> getIssueStatusList(JiraServerDTO jiraServerDTO, HttpServletRequest request) throws Exception {
        log.info("JiraServerController :: getIssueStatusList");
        ParameterParser parser = new ParameterParser((ServletRequest)request);
        if (parser.getInt("c_id") <= 0) {
            throw new RuntimeException("c_id is minus value");
        }
        JiraServerEntity jiraServerEntity = (JiraServerEntity)this.modelMapper.map((Object)jiraServerDTO, JiraServerEntity.class);
        return ResponseEntity.ok((Object)CommonResponse.success((Object)this.jiraServer.getServerIssueStatusOnlyList(jiraServerEntity)));
    }

    @ResponseBody
    @RequestMapping(value={"/getJiraIssuePriority.do"}, method={RequestMethod.GET})
    public ResponseEntity<?> getJiraIssuePriorityList(JiraServerDTO jiraServerDTO, HttpServletRequest request) throws Exception {
        log.info("JiraServerController :: getJiraIssuePriorityList");
        ParameterParser parser = new ParameterParser((ServletRequest)request);
        if (parser.getInt("c_id") <= 0) {
            throw new RuntimeException("c_id is minus value");
        }
        JiraServerEntity jiraServerEntity = (JiraServerEntity)this.modelMapper.map((Object)jiraServerDTO, JiraServerEntity.class);
        return ResponseEntity.ok((Object)CommonResponse.success((Object)this.jiraServer.getServerIssuePriorityOnlyList(jiraServerEntity)));
    }

    @ResponseBody
    @RequestMapping(value={"/getJiraIssueResolution.do"}, method={RequestMethod.GET})
    public ResponseEntity<?> getJiraIssueResolutionList(JiraServerDTO jiraServerDTO, HttpServletRequest request) throws Exception {
        log.info("JiraServerController :: getJiraIssueResolutionList");
        ParameterParser parser = new ParameterParser((ServletRequest)request);
        if (parser.getInt("c_id") <= 0) {
            throw new RuntimeException("c_id is minus value");
        }
        JiraServerEntity jiraServerEntity = (JiraServerEntity)this.modelMapper.map((Object)jiraServerDTO, JiraServerEntity.class);
        return ResponseEntity.ok((Object)CommonResponse.success((Object)this.jiraServer.getServerIssueResolutionList(jiraServerEntity)));
    }

    @ResponseBody
    @RequestMapping(value={"/{defaultTarget}/makeDefault.do"}, method={RequestMethod.PUT})
    public ResponseEntity<?> setDefaultValueForTarget(@PathVariable(name="defaultTarget") String targetEntity, @RequestParam(name="targetCId") Long targetCId, JiraServerDTO jiraServerDTO, HttpServletRequest request) throws Exception {
        log.info("JiraServerController :: setDefaultValueForTarget, \uc124\uc815\ud560_\ud56d\ubaa9 : {}, \ud56d\ubaa9_c_id : {}", (Object)targetEntity, (Object)targetCId);
        ParameterParser parser = new ParameterParser((ServletRequest)request);
        if (parser.getInt("c_id") <= 0) {
            throw new RuntimeException("c_id is minus value");
        }
        if (parser.getInt("targetCId") <= 0) {
            throw new RuntimeException("targetCId is minus value");
        }
        EntityType entityType = EntityType.fromString((String)targetEntity);
        JiraServerEntity jiraServerEntity = (JiraServerEntity)this.modelMapper.map((Object)jiraServerDTO, JiraServerEntity.class);
        return ResponseEntity.ok((Object)CommonResponse.success((Object)this.jiraServer.setDefaultValueForTarget(entityType, targetCId, jiraServerEntity)));
    }

    @ResponseBody
    @RequestMapping(value={"/updateNodeAndEngineServerInfoUpdate.do"}, method={RequestMethod.PUT})
    public ModelAndView updateArmsAndEngineServerData(@Validated(value={UpdateNode.class}) JiraServerDTO JiraServerDTO2, BindingResult bindingResult, HttpServletRequest request, ModelMap model) throws Exception {
        log.info("JiraServerController :: updateArmsAndEngineServerData");
        JiraServerEntity treeSearchEntity = (JiraServerEntity)this.modelMapper.map((Object)JiraServerDTO2, JiraServerEntity.class);
        ModelAndView modelAndView = new ModelAndView("jsonView");
        modelAndView.addObject("result", (Object)this.jiraServer.updateArmsAndEngineServerData(treeSearchEntity));
        return modelAndView;
    }

    @ResponseBody
    @RequestMapping(value={"/refresh.do"}, method={RequestMethod.PUT})
    public ResponseEntity<?> refreshALMServer(JiraServerDTO jiraServerDTO) throws Exception {
        JiraServerEntity jiraServerEntity = (JiraServerEntity)this.modelMapper.map((Object)jiraServerDTO, JiraServerEntity.class);
        CompletableFuture future = this.jiraServer.refreshALMServer(jiraServerEntity);
        future.thenAccept(process -> {
            try {
                this.jiraServer.cacheStatusMappingData(jiraServerEntity);
            }
            catch (Exception e) {
                log.error(e.getMessage());
                this.chat.sendMessageByEngine("\uce90\uc26c \uc11c\ubc84 \uc5c5\ub370\uc774\ud2b8 \uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4. :: " + e.getMessage());
            }
        });
        return ResponseEntity.ok((Object)jiraServerEntity);
    }

    @ResponseBody
    @RequestMapping(value={"/getRuleSet.do"}, method={RequestMethod.GET})
    public ResponseEntity<?> getStatusRuleSet(JiraServerDTO jiraServerDTO, HttpServletRequest request) throws Exception {
        log.info("JiraServerController :: getStatusRuleSet");
        ParameterParser parser = new ParameterParser((ServletRequest)request);
        if (parser.getInt("c_id") <= 0) {
            throw new RuntimeException("c_id is minus value");
        }
        JiraServerEntity jiraServerEntity = (JiraServerEntity)this.modelMapper.map((Object)jiraServerDTO, JiraServerEntity.class);
        return ResponseEntity.ok((Object)this.jiraServer.getStatusRuleSet(jiraServerEntity));
    }

    @ResponseBody
    @RequestMapping(value={"/preSetIssueStatusMapping.do"}, method={RequestMethod.POST})
    public ResponseEntity<?> preSetIssueStatusMapping(String projectCId, JiraServerDTO jiraServerDTO) throws Exception {
        log.info("JiraServerController :: preSetIssueStatusMapping \ud504\ub9ac\uc14b \ub300\uc0c1 \ud504\ub85c\uc81d\ud2b8 \uc544\uc774\ub514: {}, \ub300\uc0c1 \uc11c\ubc84 \uc544\uc774\ub514: {}", (Object)projectCId, (Object)jiraServerDTO.getC_id());
        JiraServerEntity jiraServerEntity = (JiraServerEntity)this.modelMapper.map((Object)jiraServerDTO, JiraServerEntity.class);
        this.jiraServer.preSetIssueStatusMapping(projectCId, jiraServerEntity);
        return ResponseEntity.ok((Object)jiraServerEntity);
    }
}

