/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.globaltreemap.service;

import com.arms.api.globaltreemap.dao.GlobalTreeMapRepository;
import com.arms.api.globaltreemap.model.GlobalTreeMapEntity;
import com.arms.api.globaltreemap.service.GlobalTreeMapService;
import com.arms.egovframework.javaservice.treeframework.errors.exception.DuplicateFoundException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.unitils.util.ReflectionUtils;

@Service
public class GlobalTreeMapServiceImpl
implements GlobalTreeMapService {
    private final GlobalTreeMapRepository globalTreeMapRepository;

    @Transactional
    public List<GlobalTreeMapEntity> saveAll(List<GlobalTreeMapEntity> globalTreeMapEntities) {
        globalTreeMapEntities.stream().filter(entity -> ObjectUtils.isEmpty((Object)entity.getMap_key())).forEach(entity -> {
            if (this.findAllBy(entity).size() > 0) {
                throw new DuplicateFoundException("\ub9e4\ud551\uac12\uc774 \uc874\uc7ac\ud569\ub2c8\ub2e4.[" + String.valueOf(entity) + "]");
            }
        });
        return this.globalTreeMapRepository.saveAll(globalTreeMapEntities);
    }

    @Transactional(transactionManager="transactionJpaManager")
    public GlobalTreeMapEntity update(GlobalTreeMapEntity globalTreeMapEntity) {
        return this.globalTreeMapRepository.save(globalTreeMapEntity);
    }

    @Transactional(transactionManager="transactionJpaManager")
    public Long delete(GlobalTreeMapEntity globalTreeMapEntity) {
        this.globalTreeMapRepository.delete(globalTreeMapEntity.getMap_key());
        return globalTreeMapEntity.getMap_key();
    }

    @Transactional
    public GlobalTreeMapEntity saveOne(GlobalTreeMapEntity globalTreeMapEntity) {
        if (this.findAllBy(globalTreeMapEntity).size() > 0) {
            throw new DuplicateFoundException("\ub9e4\ud551\uac12\uc774 \uc874\uc7ac\ud569\ub2c8\ub2e4.[" + String.valueOf(globalTreeMapEntity) + "]");
        }
        return this.globalTreeMapRepository.save(globalTreeMapEntity);
    }

    @Transactional(transactionManager="transactionJpaManager")
    public void delete(Long map_key) {
        this.globalTreeMapRepository.delete(map_key);
    }

    @Transactional(transactionManager="transactionJpaManager")
    public void deleteAllByMapKey(List<Long> map_keys) {
        this.globalTreeMapRepository.deleteAll(map_keys.stream().map(map_key -> {
            GlobalTreeMapEntity globalTreeMapEntity = new GlobalTreeMapEntity();
            globalTreeMapEntity.setMap_key(map_key);
            return globalTreeMapEntity;
        }).collect(Collectors.toList()));
    }

    public List<GlobalTreeMapEntity> findAllBy(GlobalTreeMapEntity globalTreeMapEntity) {
        Specification & Serializable searchWith = (Specification & Serializable)(root, query, builder) -> builder.and((Predicate[])ReflectionUtils.getAllFields(globalTreeMapEntity.getClass()).stream().filter(field -> {
            try {
                field.setAccessible(true);
                return !ObjectUtils.isEmpty((Object)field.get(globalTreeMapEntity)) && !"map_key".equals(field.getName());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }).map(field -> {
            try {
                field.setAccessible(true);
                return builder.equal((Expression)root.get(field.getName()), field.get(globalTreeMapEntity));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }).toArray(Predicate[]::new));
        return this.globalTreeMapRepository.findAllBy((Specification)searchWith).stream().collect(Collectors.toUnmodifiableList());
    }

    public Map<String, List<Long>> findAllMapBy(GlobalTreeMapEntity globalTreeMapEntity) {
        return this.listToMap(this.findAllBy(globalTreeMapEntity));
    }

    public List<GlobalTreeMapEntity> findAllByIds(List<Long> ids, String name) {
        Specification & Serializable searchWith = (Specification & Serializable)(root, query, builder) -> builder.and(new Predicate[]{builder.in((Expression)root.get(name)).value((Object)ids)});
        return this.globalTreeMapRepository.findAllBy((Specification)searchWith).stream().collect(Collectors.toUnmodifiableList());
    }

    public Map<String, List<Long>> findAllMapByIds(List<Long> ids, String name) {
        return this.listToMap(this.findAllByIds(ids, name));
    }

    private Map<String, List<Long>> listToMap(List<GlobalTreeMapEntity> list) {
        HashMap<String, List<Long>> resultMap = new HashMap<String, List<Long>>();
        for (GlobalTreeMapEntity globalTreeMapEntity : list) {
            Field[] fields;
            for (Field field : fields = globalTreeMapEntity.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                String fieldName = field.getName();
                try {
                    Long value = (Long)field.get(globalTreeMapEntity);
                    if (value == null) continue;
                    resultMap.putIfAbsent(fieldName, new ArrayList());
                    List values = (List)resultMap.get(fieldName);
                    if (values.contains(value)) continue;
                    values.add(value);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return resultMap;
    }

    public GlobalTreeMapEntity findById(Long map_key) {
        return this.globalTreeMapRepository.findById(map_key);
    }

    public GlobalTreeMapServiceImpl(GlobalTreeMapRepository globalTreeMapRepository) {
        this.globalTreeMapRepository = globalTreeMapRepository;
    }
}

