/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.globaltreemap.controller;

import com.arms.api.globaltreemap.controller.TreeMapAbstractController;
import com.arms.api.globaltreemap.model.GlobalTreeMapDTO;
import com.arms.api.globaltreemap.model.GlobalTreeMapEntity;
import com.arms.egovframework.javaservice.treeframework.controller.CommonResponse;
import com.arms.egovframework.javaservice.treeframework.remote.Global;
import com.arms.egovframework.javaservice.treeframework.util.ParameterParser;
import com.arms.egovframework.javaservice.treeframework.util.StringUtils;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/arms/globaltreemap"})
@RestController
public class GlobalTreeMapController
extends TreeMapAbstractController {
    private static final Logger log = LoggerFactory.getLogger(GlobalTreeMapController.class);

    @ResponseBody
    @RequestMapping(value={"/getConnectInfo/pdService/pdServiceVersion/jiraProject.do"}, method={RequestMethod.GET})
    public ResponseEntity<?> getConnectInfo_pdService_pdServiceVersion_jiraProject(GlobalTreeMapDTO globalTreeMapDTO, ModelMap model, HttpServletRequest request) throws Exception {
        log.info("GlobalTreeMapController :: getConnectInfo_pdService_pdServiceVersion_jiraProject");
        GlobalTreeMapEntity globalTreeMapEntity = (GlobalTreeMapEntity)this.modelMapper.map((Object)globalTreeMapDTO, GlobalTreeMapEntity.class);
        List savedList = this.globalTreeMapService.findAllBy(globalTreeMapEntity);
        List filteredList = savedList.stream().filter(savedData -> savedData.getPdserviceversion_link() != null && savedData.getJiraproject_link() != null).collect(Collectors.toList());
        return ResponseEntity.ok((Object)CommonResponse.success(filteredList));
    }

    @ResponseBody
    @RequestMapping(value={"/setConnectInfo/pdService/pdServiceVersion/jiraProject.do"}, method={RequestMethod.POST})
    public ResponseEntity<?> setConnectInfo_pdService_pdServiceVersion_jiraProject(GlobalTreeMapDTO globalTreeMapDTO, ModelMap model, HttpServletRequest request) throws Exception {
        log.info("GlobalTreeMapController :: setConnectInfo_pdService_pdServiceVersion_jiraProject");
        GlobalTreeMapEntity globalTreeMapEntity = (GlobalTreeMapEntity)this.modelMapper.map((Object)globalTreeMapDTO, GlobalTreeMapEntity.class);
        ParameterParser parser = new ParameterParser((ServletRequest)request);
        String[] paramList = StringUtils.jsonStringifyConvert((String)parser.get("c_pdservice_jira_ids"));
        List jiraProjectList = Arrays.stream(paramList).collect(Collectors.toList());
        GlobalTreeMapEntity searchObj = new GlobalTreeMapEntity();
        searchObj.setPdserviceversion_link(globalTreeMapEntity.getPdserviceversion_link());
        List searchedObjList = this.globalTreeMapService.findAllBy(searchObj);
        List \ud2b8\ub9ac\ub9f5_\uc81c\ud488_\uc9c0\ub77c\ud504\ub85c\uc81d\ud2b8_\uc5f0\uacb0\uc815\ubcf4 = searchedObjList.stream().filter(data -> data.getPdserviceversion_link() != null && data.getJiraproject_link() != null).collect(Collectors.toList());
        for (GlobalTreeMapEntity data2 : \ud2b8\ub9ac\ub9f5_\uc81c\ud488_\uc9c0\ub77c\ud504\ub85c\uc81d\ud2b8_\uc5f0\uacb0\uc815\ubcf4) {
            Long jiraProjectLink = data2.getJiraproject_link();
            boolean alreadyRegist = jiraProjectList.stream().anyMatch(dataObj -> jiraProjectLink == NumberUtils.toLong((String)dataObj));
            if (alreadyRegist) {
                log.info("already registered : getPdserviceversion_link" + data2.getPdserviceversion_link());
                log.info("already registered : getJiraproject_link" + data2.getJiraproject_link());
                continue;
            }
            this.globalTreeMapService.delete(data2);
        }
        for (String jiraProject : jiraProjectList) {
            GlobalTreeMapEntity saveTarget = new GlobalTreeMapEntity();
            saveTarget.setPdserviceversion_link(globalTreeMapEntity.getPdserviceversion_link());
            saveTarget.setJiraproject_link(Long.valueOf(Long.parseLong(jiraProject)));
            List checkList = this.globalTreeMapService.findAllBy(saveTarget);
            List checkDuplicate = checkList.stream().filter(data -> data.getPdserviceversion_link().equals(saveTarget.getPdserviceversion_link()) && data.getJiraproject_link().equals(saveTarget.getJiraproject_link())).collect(Collectors.toList());
            if (checkDuplicate == null || checkDuplicate.isEmpty()) {
                this.globalTreeMapService.saveOne(saveTarget);
                continue;
            }
            log.info(globalTreeMapEntity.toString());
        }
        Global.chat.sendMessageByEngine("\uc9c0\ub77c \ud504\ub85c\uc81d\ud2b8\uac00 \uc5f0\uacb0\ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
        return ResponseEntity.ok((Object)CommonResponse.success((Object)"test"));
    }
}

