/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.dwralarm.controller;

import com.arms.egovframework.javaservice.treeframework.controller.CommonResponse;
import com.arms.egovframework.javaservice.treeframework.remote.Chat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/arms/alarm"})
public class AlarmController {
    private static final Logger log = LoggerFactory.getLogger(AlarmController.class);
    private final Chat chat;

    @PostMapping(value={"/send-message"})
    public ResponseEntity<CommonResponse.ApiResult<String>> sendMessage(@RequestParam(value="message") String message) {
        try {
            this.chat.sendMessageByEngine(message);
        }
        catch (Exception e) {
            log.warn("dwr session is null");
        }
        return ResponseEntity.ok((Object)CommonResponse.success((Object)"OK"));
    }

    @PostMapping(value={"/send-message/server"})
    public ResponseEntity<CommonResponse.ApiResult<String>> sendMessageByServer(@RequestParam(value="message") String message) {
        this.chat.sendMessageByServer(message);
        return ResponseEntity.ok((Object)CommonResponse.success((Object)"OK"));
    }

    public AlarmController(Chat chat) {
        this.chat = chat;
    }
}

