/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.clientcase.service;

import com.arms.api.clientcase.model.ClientCaseDTO;
import com.arms.api.clientcase.model.ClientCaseEntity;
import com.arms.api.clientcase.service.ClientCaseService;
import com.arms.api.util.communicate.external.EngineService;
import com.arms.egovframework.javaservice.treeframework.TreeConstant;
import com.arms.egovframework.javaservice.treeframework.model.TreeSearchEntity;
import com.arms.egovframework.javaservice.treeframework.service.TreeServiceImpl;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityNotFoundException;
import javax.transaction.Transactional;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.modelmapper.ModelMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="clientCaseService")
public class ClientCaseServiceImpl
extends TreeServiceImpl
implements ClientCaseService {
    private static final Logger log = LoggerFactory.getLogger(ClientCaseServiceImpl.class);
    private final ModelMapper modelMapper;
    private final EngineService engineService;

    @Transactional
    public ClientCaseEntity addClientCase(ClientCaseEntity clientCaseEntity) throws Exception {
        String contentsBackup = clientCaseEntity.getC_clientcase_contents();
        String thumbnailBackup = clientCaseEntity.getC_clientcase_thumbnail_image();
        clientCaseEntity.setC_title(clientCaseEntity.getC_clientcase_title());
        clientCaseEntity.setRef(TreeConstant.First_Node_CID.longValue());
        clientCaseEntity.setC_type("default");
        clientCaseEntity.setC_clientcase_created(LocalDateTime.now());
        clientCaseEntity.setC_clientcase_contents(null);
        clientCaseEntity.setC_clientcase_thumbnail_image(null);
        ClientCaseEntity createdEntity = (ClientCaseEntity)this.addNode((TreeSearchEntity)clientCaseEntity);
        HashMap<String, String> esData = new HashMap<String, String>();
        esData.put("c_id", String.valueOf(createdEntity.getC_id()));
        esData.put("c_clientcase_contents", contentsBackup);
        esData.put("c_clientcase_thumbnail_image", thumbnailBackup);
        this.engineService.addClientCase(esData);
        return createdEntity;
    }

    @Transactional
    public ClientCaseEntity getClientCase(Long clientCaseId) throws Exception {
        ClientCaseEntity clientCaseEntity = new ClientCaseEntity();
        clientCaseEntity.setC_id(clientCaseId);
        ClientCaseEntity existingClientCase = (ClientCaseEntity)this.getNode((TreeSearchEntity)clientCaseEntity);
        ClientCaseDTO dtoFromEngine = (ClientCaseDTO)this.engineService.getClientCase(clientCaseId.toString()).getBody();
        if (dtoFromEngine != null) {
            existingClientCase.setC_clientcase_contents(dtoFromEngine.getC_clientcase_contents());
            existingClientCase.setC_clientcase_thumbnail_image(dtoFromEngine.getC_clientcase_thumbnail_image());
        }
        return existingClientCase;
    }

    @Transactional
    public ClientCaseEntity updateClientCase(ClientCaseEntity clientCaseEntity) throws Exception {
        ClientCaseEntity preClientCase = (ClientCaseEntity)this.getNode((TreeSearchEntity)clientCaseEntity);
        String contentsBackup = clientCaseEntity.getC_clientcase_contents();
        String thumbnailBackup = clientCaseEntity.getC_clientcase_thumbnail_image();
        clientCaseEntity.setC_clientcase_contents(null);
        clientCaseEntity.setC_clientcase_thumbnail_image(null);
        clientCaseEntity.setC_clientcase_updated(LocalDateTime.now());
        int result = this.updateNode((TreeSearchEntity)clientCaseEntity);
        HashMap<String, String> esData = new HashMap<String, String>();
        esData.put("c_id", String.valueOf(clientCaseEntity.getC_id()));
        esData.put("c_clientcase_contents", contentsBackup);
        esData.put("c_clientcase_thumbnail_image", thumbnailBackup);
        this.engineService.updateClientCase(esData);
        if (result == 1) {
            return (ClientCaseEntity)this.getNode((TreeSearchEntity)clientCaseEntity);
        }
        return preClientCase;
    }

    @Transactional
    public ClientCaseEntity removeClientCase(Long clientCaseId) throws Exception {
        ClientCaseEntity key = new ClientCaseEntity();
        key.setC_id(clientCaseId);
        ClientCaseEntity pre = (ClientCaseEntity)this.getNode((TreeSearchEntity)key);
        if (pre == null) {
            throw new EntityNotFoundException("\ud574\ub2f9 \uc544\uc774\ub514\uc758 ClientCase\ub97c \ucc3e\uc9c0 \ubabb\ud558\uc600\uc74c : " + clientCaseId);
        }
        this.engineService.deleteClientCase(clientCaseId.toString());
        int result = this.removeNode((TreeSearchEntity)pre);
        if (result != 0) {
            throw new IllegalStateException("\uc0ad\uc81c \uc2e4\ud328: id=" + clientCaseId + ", result=" + result);
        }
        return pre;
    }

    @Transactional
    public Map<String, Object> getPaginatedClientCaseList(ClientCaseDTO clientCaseDTO, int pageIndex, int pageUnit) throws Exception {
        ClientCaseEntity clientCaseEntity = (ClientCaseEntity)this.modelMapper.map((Object)clientCaseDTO, ClientCaseEntity.class);
        this.ignoreRootAndFirstNode(clientCaseEntity);
        this.orderByCreatedDesc(clientCaseEntity);
        this.updatePageInfo(clientCaseEntity, pageIndex, pageUnit);
        List clientCaseList = this.getPaginatedChildNode((TreeSearchEntity)clientCaseEntity);
        ArrayList<ClientCaseDTO> clientCaseDTOList = new ArrayList<ClientCaseDTO>();
        if (clientCaseList != null && !clientCaseList.isEmpty()) {
            for (ClientCaseEntity entity : clientCaseList) {
                ClientCaseDTO dto = (ClientCaseDTO)this.modelMapper.map((Object)entity, ClientCaseDTO.class);
                try {
                    ClientCaseDTO dtoFromEngine = (ClientCaseDTO)this.engineService.getClientCase(entity.getC_id().toString()).getBody();
                    if (dtoFromEngine != null && dtoFromEngine.getC_clientcase_thumbnail_image() != null) {
                        dto.setC_clientcase_thumbnail_image(dtoFromEngine.getC_clientcase_thumbnail_image());
                    }
                }
                catch (Exception e) {
                    log.warn("[ClientCase-LIST] c_id: {} - Elasticsearch\uc5d0\uc11c thumbnail \uc870\ud68c \uc2e4\ud328: {}", (Object)entity.getC_id(), (Object)e.getMessage());
                }
                clientCaseDTOList.add(dto);
            }
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (clientCaseList != null && !clientCaseList.isEmpty()) {
            resultMap.put("paginationInfo", clientCaseEntity.getPaginationInfo());
        } else {
            resultMap.put("paginationInfo", Map.of("totalRecordCount", 0, "lastPageNo", 0));
        }
        resultMap.put("data", clientCaseDTOList);
        return resultMap;
    }

    private void ignoreRootAndFirstNode(ClientCaseEntity clientCaseEntity) {
        clientCaseEntity.getCriterions().add(Restrictions.not((Criterion)Restrictions.in((String)"c_id", (Object[])new Object[]{TreeConstant.ROOT_CID, TreeConstant.First_Node_CID})));
    }

    private void orderByCreatedDesc(ClientCaseEntity clientCaseEntity) {
        clientCaseEntity.getOrder().add(Order.desc((String)"c_clientcase_created"));
    }

    private void updatePageInfo(ClientCaseEntity clientCaseEntity, int pageIndex, int pageUnit) {
        clientCaseEntity.setPageIndex(pageIndex);
        clientCaseEntity.setPageUnit(pageUnit);
    }

    public ClientCaseServiceImpl(ModelMapper modelMapper, EngineService engineService) {
        this.modelMapper = modelMapper;
        this.engineService = engineService;
    }
}

