/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.analysis.topmenu.model.vo;

import com.arms.api.analysis.topmenu.model.CategoryStatus;
import com.arms.api.analysis.topmenu.model.vo.ReqStatusCountVO;
import com.arms.api.requirement.reqadd.model.entity.ReqAddEntity;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ReqStatusCountVO {
    private final Long openCount;
    private final Long inProgressCount;
    private final Long resolvedCount;
    private final Long closedCount;
    private final Long etcCount;
    private final Long nullCount;
    private final Long folderCount;
    private final Long totalCount;

    public ReqStatusCountVO(List<ReqAddEntity> list) {
        Map<CategoryStatus, Long> map = list.stream().collect(Collectors.groupingBy(entity -> entity.\uce74\ud14c\uace0\ub9ac_\uc0c1\ud0dc(), Collectors.counting()));
        this.openCount = map.getOrDefault(CategoryStatus.OPEN, 0L);
        this.inProgressCount = map.getOrDefault(CategoryStatus.IN_PROGRESS, 0L);
        this.resolvedCount = map.getOrDefault(CategoryStatus.RESOLVED, 0L);
        this.closedCount = map.getOrDefault(CategoryStatus.CLOSED, 0L);
        this.etcCount = map.getOrDefault(CategoryStatus.ETC, 0L);
        this.nullCount = map.getOrDefault(CategoryStatus.NULL, 0L);
        this.folderCount = map.getOrDefault(CategoryStatus.FOLDER, 0L);
        this.totalCount = (long)list.size() - map.getOrDefault(CategoryStatus.FOLDER, 0L);
    }

    public static ReqStatusCountVOBuilder builder() {
        return new ReqStatusCountVOBuilder();
    }

    public ReqStatusCountVO(Long openCount, Long inProgressCount, Long resolvedCount, Long closedCount, Long etcCount, Long nullCount, Long folderCount, Long totalCount) {
        this.openCount = openCount;
        this.inProgressCount = inProgressCount;
        this.resolvedCount = resolvedCount;
        this.closedCount = closedCount;
        this.etcCount = etcCount;
        this.nullCount = nullCount;
        this.folderCount = folderCount;
        this.totalCount = totalCount;
    }

    public Long getOpenCount() {
        return this.openCount;
    }

    public Long getInProgressCount() {
        return this.inProgressCount;
    }

    public Long getResolvedCount() {
        return this.resolvedCount;
    }

    public Long getClosedCount() {
        return this.closedCount;
    }

    public Long getEtcCount() {
        return this.etcCount;
    }

    public Long getNullCount() {
        return this.nullCount;
    }

    public Long getFolderCount() {
        return this.folderCount;
    }

    public Long getTotalCount() {
        return this.totalCount;
    }
}

