/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.analysis.time.controller;

import com.arms.api.analysis.time.model.RidgeLineVO;
import com.arms.api.analysis.time.model.dto.TimeDTO;
import com.arms.api.analysis.time.model.vo.HeatMapVO;
import com.arms.api.analysis.time.service.TimeService;
import com.arms.egovframework.javaservice.treeframework.controller.CommonResponse;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/admin/arms/analysis/time"})
public class TimeController {
    private static final Logger log = LoggerFactory.getLogger(TimeController.class);
    private final TimeService timeService;

    @PostMapping(value={"/heatmap-data"})
    public ModelAndView getHeatMapDataForYear(@RequestBody TimeDTO timeDTO) {
        HeatMapVO result = this.timeService.getHeatMapDataByUpdated(timeDTO);
        ModelAndView modelAndView = new ModelAndView("jsonView");
        modelAndView.addObject("result", (Object)result);
        return modelAndView;
    }

    @PostMapping(value={"/scatter-data"})
    public ModelAndView getScatterChartData(@RequestBody TimeDTO timeDTO) {
        List result = this.timeService.getScatterChartData(timeDTO);
        ModelAndView modelAndView = new ModelAndView("jsonView");
        modelAndView.addObject("result", (Object)result);
        return modelAndView;
    }

    @PostMapping(value={"/updated-issue/multi-combination-data"})
    public ModelAndView getMultiCombinationChartData(@RequestBody TimeDTO timeDTO) {
        List result = this.timeService.getMultiCombinationChartData(timeDTO);
        ModelAndView modelAndView = new ModelAndView("jsonView");
        modelAndView.addObject("result", (Object)result);
        return modelAndView;
    }

    @PostMapping(value={"/updated-timeline"})
    public ModelAndView getUpdatedPdServiceVersionAlmIssueByDate(@RequestBody TimeDTO timeDTO) {
        List versionGroupedResult = this.timeService.getUpdatedPdServiceVersionAlmIssueByDate(timeDTO);
        ModelAndView modelAndView = new ModelAndView("jsonView");
        modelAndView.addObject("result", (Object)versionGroupedResult);
        return modelAndView;
    }

    @PostMapping(value={"/updated-ridgeline"})
    public ResponseEntity<CommonResponse.ApiResult<List<RidgeLineVO>>> getRidgeLineData(@RequestBody TimeDTO timeDTO) throws Exception {
        return ResponseEntity.ok((Object)CommonResponse.success((Object)this.timeService.getRidgeLineData(timeDTO)));
    }

    public TimeController(TimeService timeService) {
        this.timeService = timeService;
    }
}

