/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.analysis.resource.service;

import com.arms.api.analysis.resource.model.dto.ResourceDTO;
import com.arms.api.analysis.resource.model.dto.ResourceWithVersionIdNamesDTO;
import com.arms.api.analysis.resource.model.dto.VersionIdNameDTO;
import com.arms.api.analysis.resource.model.vo.StackedHorizontalBarChartVO;
import com.arms.api.analysis.resource.model.vo.UniqueAssigneeIssueStatusVO;
import com.arms.api.analysis.resource.model.vo.UniqueAssigneeVO;
import com.arms.api.analysis.resource.model.vo.WordCloudVO;
import com.arms.api.analysis.resource.model.vo.horizontalbar.HorizontalBarChartYAxisAndSeriesVO;
import com.arms.api.analysis.resource.model.vo.horizontalbar.ReqAndNotReqHorizontalBarChartVO;
import com.arms.api.analysis.resource.model.vo.pie.ReqAndNotReqPieChartVO;
import com.arms.api.analysis.resource.model.vo.pie.TotalIssueAndPieChartVO;
import com.arms.api.analysis.resource.model.vo.sankey.SankeyChartBaseVO;
import com.arms.api.analysis.resource.model.vo.sankey.VersionAssigneeSummaryVO;
import com.arms.api.analysis.resource.model.vo.treemap.TreeMapWorkerVO;
import com.arms.api.analysis.resource.model.vo.treemap.TreemapExcelVO;
import com.arms.api.analysis.resource.model.vo.wordcloud.WordCloudExcelVO;
import com.arms.api.analysis.resource.service.ResourceService;
import com.arms.api.dashboard.model.SankeyData;
import com.arms.api.product_service.pdservice.model.PdServiceEntity;
import com.arms.api.product_service.pdservice.service.PdService;
import com.arms.api.product_service.pdserviceversion.model.PdServiceVersionEntity;
import com.arms.api.product_service.pdserviceversion.service.PdServiceVersion;
import com.arms.api.util.communicate.external.AggregationService;
import com.arms.api.util.model.dto.PdServiceAndIsReqDTO;
import com.arms.egovframework.javaservice.treeframework.model.TreeSearchEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class ResourceServiceImpl
implements ResourceService {
    private static final Logger log = LoggerFactory.getLogger(ResourceServiceImpl.class);
    private final AggregationService aggregationService;
    private final PdService pdService;
    private final PdServiceVersion pdServiceVersion;

    public List<UniqueAssigneeIssueStatusVO> issueStatusDataByAssignee(ResourceDTO resourceDTO) {
        return Optional.ofNullable(this.aggregationService.issueStatusDataByAssignee(resourceDTO)).orElse(Collections.emptyList());
    }

    public SankeyData sankeyChartAPIWithTopN(ResourceDTO resourceDTO, Integer topN) throws Exception {
        Object aggregationData;
        Long pdServiceLink = resourceDTO.pdServiceLink();
        List pdServiceVersionLinks = resourceDTO.pdServiceVersionLinks();
        PdServiceEntity pdServiceEntity = new PdServiceEntity();
        pdServiceEntity.setC_id(pdServiceLink);
        PdServiceEntity savedPdService = (PdServiceEntity)this.pdService.getNode((TreeSearchEntity)pdServiceEntity);
        if (pdServiceVersionLinks.isEmpty()) {
            return new SankeyData(Collections.emptyList(), Collections.emptyList());
        }
        ArrayList<SankeyData.SankeyNode> nodeList = new ArrayList<SankeyData.SankeyNode>();
        ArrayList<SankeyData.SankeyLink> linkList = new ArrayList<SankeyData.SankeyLink>();
        String pdServiceId = savedPdService.getC_id() + "-product";
        nodeList.add(new SankeyData.SankeyNode(pdServiceId, savedPdService.getC_title(), "\uc81c\ud488", ""));
        Set versionIds = savedPdService.getPdServiceVersionEntities().stream().filter(version -> pdServiceVersionLinks.contains(version.getC_id())).sorted(Comparator.comparing(PdServiceVersionEntity::getC_id)).map(version -> {
            String versionId = version.getC_id() + "-version";
            nodeList.add(new SankeyData.SankeyNode(versionId, version.getC_title(), "\ubc84\uc804", ""));
            linkList.add(new SankeyData.SankeyLink(pdServiceId, versionId));
            return version.getC_id();
        }).collect(Collectors.toSet());
        HashMap<String, SankeyData.SankeyNode> workerNodeMap = new HashMap<String, SankeyData.SankeyNode>();
        List sankeyChartBaseVOList = this.aggregationService.findVersionAssigneeSummaryData(resourceDTO);
        if (ObjectUtils.isEmpty((Object)sankeyChartBaseVOList)) {
            log.info("[ ResourceServiceImpl :: sankeyChartAPI ] :: result of aggregationService.findVersionAssigneeSummaryData(resourceDTO) is null");
            return new SankeyData(Collections.emptyList(), Collections.emptyList());
        }
        Set<Object> topNAccountIdSet = new HashSet();
        if (!ObjectUtils.isEmpty((Object)topN) && (aggregationData = this.aggregateAndSortByAccountId(sankeyChartBaseVOList)).size() > topN) {
            int limit = Math.min(topN, aggregationData.size());
            ArrayList topNList = new ArrayList(aggregationData.subList(0, limit));
            topNAccountIdSet = topNList.stream().map(VersionAssigneeSummaryVO::getAccountId).collect(Collectors.toSet());
        }
        for (SankeyChartBaseVO chartBaseVO : sankeyChartBaseVOList) {
            if (!versionIds.contains(chartBaseVO.getVersionId())) continue;
            String versionId = String.valueOf(chartBaseVO.getVersionId());
            List versionAssigneeSummaryVOList = chartBaseVO.getVersionAssigneeSummaryVOList();
            for (VersionAssigneeSummaryVO summaryVO : versionAssigneeSummaryVOList) {
                SankeyData.SankeyNode workerNode2;
                String accountId = summaryVO.getAccountId();
                String assigneeName = summaryVO.getName();
                if (!topNAccountIdSet.isEmpty() && !topNAccountIdSet.contains(accountId)) continue;
                if (workerNodeMap.containsKey(accountId)) {
                    workerNode2 = (SankeyData.SankeyNode)workerNodeMap.get(accountId);
                    String parent = workerNode2.getParent();
                    workerNode2.setParent(parent + "," + versionId);
                } else {
                    workerNode2 = new SankeyData.SankeyNode(accountId, assigneeName, "\uc791\uc5c5\uc790", versionId);
                    nodeList.add(workerNode2);
                    workerNodeMap.put(accountId, workerNode2);
                }
                linkList.add(new SankeyData.SankeyLink(versionId + "-version", accountId));
                versionIds.remove(chartBaseVO.getVersionId());
            }
        }
        boolean isWorkerNodeExist = false;
        List versionNodes = nodeList.stream().filter(node -> node.getType().equals("\ubc84\uc804")).collect(Collectors.toList());
        for (SankeyData.SankeyNode versionNode : versionNodes) {
            if (!nodeList.stream().noneMatch(workerNode -> workerNode.getParent().contains(versionNode.getId().split("-")[0]))) continue;
            isWorkerNodeExist = true;
            linkList.add(new SankeyData.SankeyLink(versionNode.getId(), "No-Worker"));
        }
        if (isWorkerNodeExist) {
            nodeList.add(new SankeyData.SankeyNode("No-Worker", "No-Worker", "No-Worker", ""));
        }
        return new SankeyData(nodeList, linkList);
    }

    public List<TreeMapWorkerVO> findTreeMapChartDataV3(ResourceWithVersionIdNamesDTO resourceWithVersionIdNamesDTO) throws Exception {
        PdServiceAndIsReqDTO pdServiceAndIsReq = resourceWithVersionIdNamesDTO.getPdServiceAndIsReq();
        List versionIdNames = this.pdServiceVersion.getVersionListByCids(pdServiceAndIsReq.getPdServiceVersionLinks()).stream().map(entity -> {
            VersionIdNameDTO dto = new VersionIdNameDTO();
            dto.setC_id(String.valueOf(entity.getC_id()));
            dto.setC_title(entity.getC_title());
            return dto;
        }).collect(Collectors.toList());
        resourceWithVersionIdNamesDTO.setVersionIdNames(versionIdNames);
        return Optional.ofNullable((List)this.aggregationService.findTreeMapChartDataV3(resourceWithVersionIdNamesDTO).getBody()).orElse(Collections.emptyList());
    }

    public List<TreemapExcelVO> assigneeRequirementInvolvementDetailData(ResourceWithVersionIdNamesDTO resourceWithVersionIdNamesDTO) throws Exception {
        PdServiceAndIsReqDTO pdServiceAndIsReq = resourceWithVersionIdNamesDTO.getPdServiceAndIsReq();
        List versionIdNames = this.pdServiceVersion.getVersionListByCids(pdServiceAndIsReq.getPdServiceVersionLinks()).stream().map(entity -> {
            VersionIdNameDTO dto = new VersionIdNameDTO();
            dto.setC_id(String.valueOf(entity.getC_id()));
            dto.setC_title(entity.getC_title());
            return dto;
        }).collect(Collectors.toList());
        resourceWithVersionIdNamesDTO.setVersionIdNames(versionIdNames);
        return Optional.ofNullable((List)this.aggregationService.findAssigneeRequirementInvolvementData(resourceWithVersionIdNamesDTO).getBody()).orElse(Collections.emptyList());
    }

    public List<UniqueAssigneeVO> findAssigneesInfoData(ResourceDTO resourceDTO) throws Exception {
        return Optional.ofNullable((List)this.aggregationService.findAssigneesInfo(resourceDTO).getBody()).orElse(new ArrayList());
    }

    public List<WordCloudVO> findWordCloudData(ResourceDTO resourceDTO) {
        List wordCloudExcelVOS = this.aggregationService.wordCloudData(resourceDTO);
        if (!ObjectUtils.isEmpty((Object)wordCloudExcelVOS)) {
            return this.convertWordCloudExcelVOtoWordCloudVO(wordCloudExcelVOS);
        }
        return Collections.emptyList();
    }

    private List<WordCloudVO> convertWordCloudExcelVOtoWordCloudVO(List<WordCloudExcelVO> wordCloudExcelVOs) {
        return wordCloudExcelVOs.stream().map(excelVO -> WordCloudVO.builder().text(excelVO.getName()).weight(excelVO.getIssueTotal()).build()).collect(Collectors.toList());
    }

    public StackedHorizontalBarChartVO issueStatusStackedBarChartData(ResourceDTO resourceDTO) {
        return this.aggregationService.issueStatusStackedBarChartData(resourceDTO);
    }

    public TotalIssueAndPieChartVO findPieChartDataExpand(ResourceDTO resourceDTO) {
        return this.aggregationService.findPieChartDataExpand(resourceDTO);
    }

    public ReqAndNotReqPieChartVO findPieChartData(ResourceDTO resourceDTO) {
        ReqAndNotReqPieChartVO pieChartData = this.aggregationService.findPieChartData(resourceDTO);
        int numSize = resourceDTO.getNumSize();
        TotalIssueAndPieChartVO reqPieChartVO = pieChartData.getReqPieChartVO();
        reqPieChartVO.getAssigneeAndIssueCounts().sort((vo1, vo2) -> vo2.getValue().compareTo(vo1.getValue()));
        TotalIssueAndPieChartVO notReqPieChartVO = pieChartData.getNotReqPieChartVO();
        notReqPieChartVO.getAssigneeAndIssueCounts().sort((vo1, vo2) -> vo2.getValue().compareTo(vo1.getValue()));
        if (numSize != 0 && numSize > 0) {
            return ReqAndNotReqPieChartVO.builder().reqPieChartVO(this.filteredPieChartDataByNumSize(reqPieChartVO, numSize)).notReqPieChartVO(this.filteredPieChartDataByNumSize(notReqPieChartVO, numSize)).build();
        }
        return pieChartData;
    }

    public List<HorizontalBarChartYAxisAndSeriesVO> findHorizontalBarChartData(ResourceDTO resourceDTO) {
        return this.aggregationService.findHorizontalBarChartData(resourceDTO);
    }

    private TotalIssueAndPieChartVO filteredPieChartDataByNumSize(TotalIssueAndPieChartVO pieChartVO, int numSize) {
        return TotalIssueAndPieChartVO.builder().totalIssueCount(pieChartVO.getTotalIssueCount()).assigneeAndIssueCounts(pieChartVO.getAssigneeAndIssueCounts().stream().limit(numSize).collect(Collectors.toList())).build();
    }

    public ReqAndNotReqHorizontalBarChartVO findHorizontalBarChartDataBySameAccounts(ResourceDTO resourceDTO) {
        return this.aggregationService.findHorizontalBarChartDataBySameAccounts(resourceDTO);
    }

    private List<VersionAssigneeSummaryVO> aggregateAndSortByAccountId(List<SankeyChartBaseVO> baseList) {
        HashMap aggregatedMap = new HashMap();
        baseList.forEach(sankeyChart -> sankeyChart.getVersionAssigneeSummaryVOList().forEach(summaryVO -> {
            String accountId = summaryVO.getAccountId();
            aggregatedMap.merge(accountId, summaryVO, (existing, newValue) -> VersionAssigneeSummaryVO.builder().accountId(accountId).name(existing.getName()).emailAddress(existing.getEmailAddress()).totalIssue(Long.valueOf(existing.getTotalIssue() + newValue.getTotalIssue())).reqIssueCount(Long.valueOf(existing.getReqIssueCount() + newValue.getReqIssueCount())).notReqIssueCount(Long.valueOf(existing.getNotReqIssueCount() + newValue.getNotReqIssueCount())).build());
        }));
        return aggregatedMap.values().stream().sorted(Comparator.comparing(VersionAssigneeSummaryVO::getTotalIssue).reversed()).collect(Collectors.toList());
    }

    public ResourceServiceImpl(AggregationService aggregationService, PdService pdService, PdServiceVersion pdServiceVersion) {
        this.aggregationService = aggregationService;
        this.pdService = pdService;
        this.pdServiceVersion = pdServiceVersion;
    }
}

