/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.analysis.resource.controller;

import com.arms.api.analysis.resource.model.dto.ResourceDTO;
import com.arms.api.analysis.resource.model.dto.ResourceWithVersionIdNamesDTO;
import com.arms.api.analysis.resource.model.vo.StackedHorizontalBarChartVO;
import com.arms.api.analysis.resource.model.vo.UniqueAssigneeIssueStatusVO;
import com.arms.api.analysis.resource.model.vo.UniqueAssigneeVO;
import com.arms.api.analysis.resource.model.vo.WordCloudVO;
import com.arms.api.analysis.resource.model.vo.horizontalbar.HorizontalBarChartYAxisAndSeriesVO;
import com.arms.api.analysis.resource.model.vo.horizontalbar.ReqAndNotReqHorizontalBarChartVO;
import com.arms.api.analysis.resource.model.vo.pie.ReqAndNotReqPieChartVO;
import com.arms.api.analysis.resource.model.vo.pie.TotalIssueAndPieChartVO;
import com.arms.api.analysis.resource.model.vo.treemap.TreeMapWorkerVO;
import com.arms.api.analysis.resource.model.vo.treemap.TreemapExcelVO;
import com.arms.api.analysis.resource.service.ResourceService;
import com.arms.api.dashboard.model.SankeyData;
import com.arms.egovframework.javaservice.treeframework.controller.CommonResponse;
import com.arms.egovframework.javaservice.treeframework.excel.ExcelUtilsBase;
import com.arms.egovframework.javaservice.treeframework.excel.ExcelUtilsFactory;
import feign.Param;
import java.io.OutputStream;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin/arms/analysis/resource"})
public class ResourceController {
    private static final Logger log = LoggerFactory.getLogger(ResourceController.class);
    private final ResourceService resourceService;

    @GetMapping(value={"/issue-status-by-assignee"})
    public ResponseEntity<List<UniqueAssigneeIssueStatusVO>> issueStatusDataByAssignee(ResourceDTO resourceDTO) throws Exception {
        log.info("[ResourceController :: issueStatusDataByAssignee] :: pdServiceId ==> {}, pdServiceVersionLinks ==> {}", (Object)resourceDTO.pdServiceLink(), (Object)resourceDTO.pdServiceVersionLinks());
        return ResponseEntity.ok((Object)this.resourceService.issueStatusDataByAssignee(resourceDTO));
    }

    @GetMapping(value={"/version-assignee-summary"}, name="resource-version-assignee-summary")
    public ResponseEntity<CommonResponse.ApiResult<SankeyData>> versionAssigneeIssueSummary(ResourceDTO resourceDTO, @RequestParam(required=false) Integer topN) throws Exception {
        log.info("[ResourceController :: versionAssigneeIssueSummary] :: pdServiceId ==> {}, pdServiceVersionLinks ==> {}, topN ==> {}", new Object[]{resourceDTO.pdServiceLink(), resourceDTO.pdServiceVersionLinks(), Optional.ofNullable(topN).orElse(0)});
        return ResponseEntity.ok((Object)CommonResponse.success((Object)this.resourceService.sankeyChartAPIWithTopN(resourceDTO, topN)));
    }

    @GetMapping(value={"/assignees-info"})
    public ResponseEntity<List<UniqueAssigneeVO>> findAssigneesInfoData(ResourceDTO resourceDTO) throws Exception {
        log.info("[ResourceController :: findAssigneesInfoData] :: pdServiceId ==> {}, pdServiceVersionLinks ==> {}", (Object)resourceDTO.pdServiceLink(), (Object)resourceDTO.pdServiceVersionLinks());
        List assigneesInfoData = this.resourceService.findAssigneesInfoData(resourceDTO);
        return ResponseEntity.ok((Object)assigneesInfoData);
    }

    @GetMapping(value={"/top-contributors/pie-expand"})
    public ResponseEntity<TotalIssueAndPieChartVO> findPieChartDataExpand(ResourceDTO resourceDTO) {
        log.info("[ResourceController :: findPieChartDataExpand] :: pdServiceId => {}, pdServiceVersionLinks => {}, IsReq => {}", new Object[]{resourceDTO.pdServiceLink(), resourceDTO.pdServiceVersionLinks(), resourceDTO.req()});
        return ResponseEntity.ok((Object)this.resourceService.findPieChartDataExpand(resourceDTO));
    }

    @GetMapping(value={"/top-contributors/pie"})
    public ResponseEntity<ReqAndNotReqPieChartVO> findPieChartData(ResourceDTO resourceDTO) {
        log.info("[ResourceController :: findPieChartData] :: pdServiceId => {}, pdServiceVersionLinks => {}, IsReq => {}, size => {}", new Object[]{resourceDTO.pdServiceLink(), resourceDTO.pdServiceVersionLinks(), resourceDTO.req(), resourceDTO.getNumSize()});
        return ResponseEntity.ok((Object)this.resourceService.findPieChartData(resourceDTO));
    }

    @PostMapping(value={"/top-contributors/horizontal-bar"})
    public ResponseEntity<List<HorizontalBarChartYAxisAndSeriesVO>> findHorizontalBarChartData(@RequestBody ResourceDTO resourceDTO) {
        log.info("[ResourceController :: findHorizontalBarChartData] :: pdServiceId => {}, pdServiceVersionLinks => {}, IsReq => {}", new Object[]{resourceDTO.pdServiceLink(), resourceDTO.pdServiceVersionLinks(), resourceDTO.req()});
        return ResponseEntity.ok((Object)this.resourceService.findHorizontalBarChartData(resourceDTO));
    }

    @PostMapping(value={"/top-contributors/horizontal-bar-at-once"})
    public ResponseEntity<ReqAndNotReqHorizontalBarChartVO> findHorizontalBarChartDataAtOnce(@RequestBody ResourceDTO resourceDTO) {
        log.info("[ResourceController :: findHorizontalBarChartDataAtOnce] :: pdServiceId => {}, pdServiceVersionLinks => {}, accounts.size => {}", new Object[]{resourceDTO.pdServiceLink(), resourceDTO.pdServiceVersionLinks(), resourceDTO.getAccounts().size()});
        return ResponseEntity.ok((Object)this.resourceService.findHorizontalBarChartDataBySameAccounts(resourceDTO));
    }

    @GetMapping(value={"/assignees-requirements-involvements-v3"}, name="resource-treemap-v3")
    public ResponseEntity<CommonResponse.ApiResult<List<TreeMapWorkerVO>>> findTreeMapChartDataV3(ResourceWithVersionIdNamesDTO resourceWithVersionIdNamesDTO) throws Exception {
        return ResponseEntity.ok((Object)CommonResponse.success((Object)this.resourceService.findTreeMapChartDataV3(resourceWithVersionIdNamesDTO)));
    }

    @GetMapping(value={"/findAssigneeRequirementInvolvementData"})
    public ResponseEntity<CommonResponse.ApiResult<List<TreemapExcelVO>>> assigneeRequirementInvolvementDetailData(ResourceWithVersionIdNamesDTO resourceWithVersionIdNamesDTO) throws Exception {
        return ResponseEntity.ok((Object)CommonResponse.success((Object)this.resourceService.assigneeRequirementInvolvementDetailData(resourceWithVersionIdNamesDTO)));
    }

    @GetMapping(value={"/findAssigneeRequirementInvolvementDataDownload"})
    public void findAssigneeRequirementInvolvementDataDownload(ResourceWithVersionIdNamesDTO resourceWithVersionIdNamesDTO, @Param(value="fileName") String fileName, HttpServletResponse httpServletResponse) throws Exception {
        httpServletResponse.addHeader("Content-Disposition", "attachment; filename=" + fileName);
        httpServletResponse.addHeader("Cache-Control", "no-cache, no-store, must-revalidate");
        httpServletResponse.addHeader("Pragma", "no-cache");
        httpServletResponse.addHeader("Expires", "0");
        httpServletResponse.setContentType("application/octet-stream");
        ExcelUtilsBase excelUtilsBase = ExcelUtilsFactory.getInstance((OutputStream)httpServletResponse.getOutputStream());
        excelUtilsBase.create(List.of(this.resourceService.assigneeRequirementInvolvementDetailData(resourceWithVersionIdNamesDTO)));
    }

    @GetMapping(value={"/word-cloud-data"})
    public ResponseEntity<List<WordCloudVO>> findWordCloudData(ResourceDTO resourceDTO) {
        log.info("[ResourceController :: findWordCloudData] :: pdServiceId => {}, pdServiceVersionLinks => {}", (Object)resourceDTO.pdServiceLink(), (Object)resourceDTO.pdServiceVersionLinks());
        return ResponseEntity.ok((Object)this.resourceService.findWordCloudData(resourceDTO));
    }

    @GetMapping(value={"/issue-status-stacked-bar"})
    public ResponseEntity<CommonResponse.ApiResult<StackedHorizontalBarChartVO>> issueStatusStackedBarChartData(ResourceDTO resourceDTO) {
        log.info("[ResourceController :: issueStatusStackedBarChartData] :: pdServiceId => {}, pdServiceVersionLinks => {}", (Object)resourceDTO.pdServiceLink(), (Object)resourceDTO.pdServiceVersionLinks());
        return ResponseEntity.ok((Object)CommonResponse.success((Object)this.resourceService.issueStatusStackedBarChartData(resourceDTO)));
    }

    public ResourceController(ResourceService resourceService) {
        this.resourceService = resourceService;
    }
}

