/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.analysis.cost.controller;

import com.arms.api.analysis.cost.model.dto.CalculationCostDTO;
import com.arms.api.analysis.cost.model.dto.CostDTO;
import com.arms.api.analysis.cost.model.vo.AllAssigneeVO;
import com.arms.api.analysis.cost.model.vo.AssigneeTimeDiffVO;
import com.arms.api.analysis.cost.model.vo.LinkedJiraIssueVO;
import com.arms.api.analysis.cost.model.vo.ProductCostResponseVO;
import com.arms.api.analysis.cost.model.vo.RequirementDifficultyAndPriorityVO;
import com.arms.api.analysis.cost.service.CostService;
import com.arms.egovframework.javaservice.treeframework.interceptor.SessionUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin/arms/analysis/cost"})
public class CostController {
    private static final Logger log = LoggerFactory.getLogger(CostController.class);
    private final CostService costService;

    @PostMapping(value={"/version-req-assignees"})
    public ResponseEntity<AllAssigneeVO> getAssigneeList(@RequestBody CostDTO costDTO) throws Exception {
        return ResponseEntity.ok((Object)this.costService.getAssigneeList(costDTO));
    }

    @PostMapping(value={"/req-linked-issue"})
    public ResponseEntity<LinkedJiraIssueVO> getLinkedJiraIssuesByVersionAndRequirement(@RequestBody CostDTO costDTO) throws Exception {
        Long pdServiceLink = costDTO.pdServiceLink();
        String \uc870\ud68c\ub300\uc0c1_\uc9c0\ub77c\uc774\uc288\uc0c1\ud0dc_\ud14c\uc774\ube14 = "T_ARMS_REQSTATUS_" + pdServiceLink;
        SessionUtil.setAttribute((String)"req-linked-issue", (Object)\uc870\ud68c\ub300\uc0c1_\uc9c0\ub77c\uc774\uc288\uc0c1\ud0dc_\ud14c\uc774\ube14);
        LinkedJiraIssueVO linkedJiraIssuesByVersionAndRequirement = this.costService.getLinkedJiraIssuesByVersionAndRequirement(costDTO);
        SessionUtil.removeAttribute((String)"req-linked-issue");
        return ResponseEntity.ok((Object)linkedJiraIssuesByVersionAndRequirement);
    }

    @PostMapping(value={"/{changeReqTableName}/req-difficulty-priority-list"})
    public ResponseEntity<RequirementDifficultyAndPriorityVO> getRequirementListStats(@PathVariable(value="changeReqTableName") String changeReqTableName, @RequestBody CostDTO costDTO) throws Exception {
        SessionUtil.setAttribute((String)"req-difficulty-priority-list", (Object)changeReqTableName);
        RequirementDifficultyAndPriorityVO result = this.costService.getRequirementListStats(costDTO);
        SessionUtil.removeAttribute((String)"req-difficulty-priority-list");
        return ResponseEntity.ok((Object)result);
    }

    @PostMapping(value={"/product-accumulate-cost-by-month"})
    public ResponseEntity<ProductCostResponseVO> candleStickChartAPI(@RequestBody CostDTO costDTO) throws Exception {
        return ResponseEntity.ok((Object)this.costService.candleStickChartAPI(costDTO));
    }

    @PostMapping(value={"/personal-estimated-period-cost"})
    public ResponseEntity<List<AssigneeTimeDiffVO>> getEstimatedPeriodCostByAccountId(@RequestBody CostDTO costDTO) throws Exception {
        List resultList = this.costService.getEstimatedPeriodCostByAccountId(costDTO);
        return ResponseEntity.ok((Object)resultList);
    }

    @PostMapping(value={"/calculation"})
    public ResponseEntity<?> calculateCost(@RequestBody CostDTO costDTO) throws Exception {
        return ResponseEntity.ok((Object)this.costService.calculateCostAll(costDTO));
    }

    @PostMapping(value={"/version-calculation"})
    public ResponseEntity<?> calculateVersionCost(@RequestBody CostDTO costDTO) throws Exception {
        return ResponseEntity.ok((Object)this.costService.calculateVersionCost(costDTO));
    }

    @PostMapping(value={"/requirement-calculation"})
    public ResponseEntity<?> calculateRequirementCost(@RequestBody CostDTO costDTO) throws Exception {
        return ResponseEntity.ok((Object)this.costService.calculateRequirementCost(costDTO));
    }

    @PostMapping(value={"/assignee-calculation"})
    public ResponseEntity<?> calculateAssigneeCost(@RequestBody CostDTO costDTO) throws Exception {
        return ResponseEntity.ok((Object)this.costService.calculateAssigneeCost(costDTO));
    }

    @PostMapping(value={"/to-be/calculation"})
    public ResponseEntity<?> toBeCalculateCost(@RequestBody CalculationCostDTO calculationCostDTO) throws Exception {
        return ResponseEntity.ok((Object)this.costService.toBeCalculateCost(calculationCostDTO));
    }

    public CostController(CostService costService) {
        this.costService = costService;
    }
}

