/*
 * Decompiled with CFR 0.152.
 */
package com.arms.egovframework.javaservice.treeframework.util;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

public class EgovWildcardReloadableResourceBundleMessageSource
extends ReloadableResourceBundleMessageSource {
    private ResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();

    public void setEgovBasenames(String ... basenames) {
        if (basenames != null) {
            ArrayList<String> baseNames = new ArrayList<String>();
            for (int i = 0; i < basenames.length; ++i) {
                String basename = StringUtils.trimToEmpty((String)basenames[i]);
                if (basename.indexOf("classpath:/") > -1) {
                    baseNames.add(basename);
                    continue;
                }
                if (!StringUtils.isNotBlank((String)basename)) continue;
                try {
                    Resource[] resources = this.resourcePatternResolver.getResources(basename);
                    for (int j = 0; j < resources.length; ++j) {
                        Resource resource = resources[j];
                        String uri = resource.getURI().toString();
                        Object baseName = null;
                        if (uri.indexOf(".properties") == -1) continue;
                        if (resource instanceof FileSystemResource) {
                            baseName = "classpath:" + StringUtils.substringBetween((String)uri, (String)"/classes/", (String)".properties");
                            baseName = ((String)baseName).substring(0, ((String)baseName).indexOf("_"));
                            if (baseNames.indexOf(baseName = ((String)baseName).replaceAll("classpath:", "classpath:/")) > -1) {
                                continue;
                            }
                        } else if (resource instanceof ClassPathResource) {
                            baseName = StringUtils.substringBefore((String)uri, (String)".properties");
                            baseName = ((String)baseName).substring(0, ((String)baseName).indexOf("_"));
                            baseName = ((String)baseName).replaceAll("classpath:", "classpath:/");
                        } else if (resource instanceof UrlResource) {
                            baseName = "classpath:" + StringUtils.substringBetween((String)uri, (String)".jar!/", (String)".properties");
                            baseName = ((String)baseName).substring(0, ((String)baseName).indexOf("_"));
                            baseName = ((String)baseName).replaceAll("classpath:", "classpath:/");
                        }
                        if (baseName == null) continue;
                        String fullName = this.processBasename((String)baseName);
                        baseNames.add(fullName);
                    }
                    continue;
                }
                catch (IOException e) {
                    this.logger.debug((Object)("No message source files found for basename " + basename + "."));
                }
            }
            this.logger.debug((Object)("EgovWildcardReloadableResourceBundleMessageSource>>basenames>[" + String.valueOf(baseNames) + "}"));
            this.setBasenames(baseNames.toArray(new String[baseNames.size()]));
        }
    }

    String processBasename(String baseName) {
        String prefix = StringUtils.substringBeforeLast((String)baseName, (String)"/");
        String name = StringUtils.substringAfterLast((String)baseName, (String)"/");
        while ((name = StringUtils.substringBeforeLast((String)name, (String)"_")).contains("_")) {
        }
        return prefix + "/" + name;
    }
}

